/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  sataos.c: Support functions to predict satellite passes.

  Copyright (C)  2001-2005  Alexandru Csete.

  Authors:   Alexandru Csete <csete@users.sourceforge.net>
             John Magliacane (original author of tracking code).

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#ifndef SATAOS_H
#define SATAOS_H

/* What additional info to show in
   the detailed prediction list.
*/
enum aos_detailed_list_e {
	AOS_LAT   = 1 << 0,       /* lattitude */
	AOS_LON   = 1 << 1,       /* longitude */
	AOS_ALT   = 1 << 2,       /* altitude */
	AOS_RAN   = 1 << 3,       /* range */
	AOS_VEL   = 1 << 4,       /* velocity */ 
	AOS_FOO   = 1 << 5,       /* footprint */
	AOS_PH3   = 1 << 6,       /* 360 deg phase */
	AOS_PH2   = 1 << 7,       /* 256 deg phase */
	AOS_ORB   = 1 << 8,       /* orbit number */
	AOS_DOP   = 1 << 9,       /* doppler shift */
	AOS_VIS   = 1 << 10       /* visibility */
};

typedef enum sat_detailed_list_e sat_detailed_list_t;


gdouble aos_find_aos (sat_t, gdouble);
gdouble aos_find_los (sat_t, gdouble);
gchar **aos_detailed_list (sat_t, guint);
gchar **aos_detailed_list_new (sat_t, guint, gdouble);
gchar **aos_simple_list (sat_t, guint, const gchar *);
gchar **aos_simple_list_new (sat_t, guint, guint, const gchar *);

#endif
