/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*

  satpref-satplot.c: satplot related preferences (widgets and funcs).

  Copyright (C)  2001-2005 Alexandru Csete.

  Authors:  Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#include <gnome.h>
#include <gconf/gconf-client.h>
#include "satdata.h"
#include "satplot.h"
#include "satpref.h"
#include "satpref-satplot.h"

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif


extern GConfClient *client; /* main.c */



static void satpref_satplot_orientation_changed (GtkToggleButton *, gpointer);
static void satpref_satplot_extra_changed       (GtkToggleButton *, gpointer);

gint plotpref;
GtkWidget *showsat,*showtime,*showaos,*showqth,*aacanv;

GtkWidget *satpref_satplot (void)
{
	/* This function creates and returns the widgets that can
	   be used to alter the track plot preferences.
	*/

	GtkWidget *radio1,*radio2,*radio3,*radio4;
	GtkWidget *box,*vbox,*frame1,*frame2,*table,*frame3;
	GtkTooltips *kooltips;

	/* orientation */
	radio1 = gtk_radio_button_new_with_label (NULL, _("N/E/S/W"));
	radio2 = gtk_radio_button_new_with_label_from_widget (GTK_RADIO_BUTTON (radio1),
							      _("N/W/S/E"));
	radio3 = gtk_radio_button_new_with_label_from_widget (GTK_RADIO_BUTTON (radio1),
							      _("S/E/N/W"));
	radio4 = gtk_radio_button_new_with_label_from_widget (GTK_RADIO_BUTTON (radio1),
							      _("S/W/N/E"));
	/* set active button */
	plotpref = gconf_client_get_int (client, SATPLOT_SWAP_PATH, NULL);
	switch (plotpref) {
	case SATPLOT_NESW:
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio1), TRUE);
		break;
	case SATPLOT_NWSE:
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio2), TRUE);
		break;
	case SATPLOT_SENW:
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio3), TRUE);
		break;
	case SATPLOT_SWNE:
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio4), TRUE);
		break;
	default:
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio1), TRUE);
		break;
	}		
	/* connect signals */
	gtk_signal_connect (GTK_OBJECT (radio1), "toggled",
			    GTK_SIGNAL_FUNC (satpref_satplot_orientation_changed),
			    GUINT_TO_POINTER (SATPLOT_NESW));
	gtk_signal_connect (GTK_OBJECT (radio2), "toggled",
			    GTK_SIGNAL_FUNC (satpref_satplot_orientation_changed),
			    GUINT_TO_POINTER (SATPLOT_NWSE));
	gtk_signal_connect (GTK_OBJECT (radio3), "toggled",
			    GTK_SIGNAL_FUNC (satpref_satplot_orientation_changed),
			    GUINT_TO_POINTER (SATPLOT_SENW));
	gtk_signal_connect (GTK_OBJECT (radio4), "toggled",
			    GTK_SIGNAL_FUNC (satpref_satplot_orientation_changed),
			    GUINT_TO_POINTER (SATPLOT_SWNE));

	box = gtk_hbox_new (TRUE, 5);
	gtk_box_pack_start_defaults (GTK_BOX (box), radio1);
	gtk_box_pack_start_defaults (GTK_BOX (box), radio2);
	gtk_box_pack_start_defaults (GTK_BOX (box), radio3);
	gtk_box_pack_start_defaults (GTK_BOX (box), radio4);

	frame1 = gtk_frame_new (_(" Orientation (clockwise)"));
	gtk_container_add (GTK_CONTAINER (frame1), box);

	/* Extra features */
	showsat = gtk_check_button_new_with_label (_("Satellite name"));
	kooltips = gtk_tooltips_new ();
	gtk_tooltips_set_tip (kooltips, showsat,
			      _("Check if you want the satellite name shown on the radial plots."),
			      NULL);
	showtime = gtk_check_button_new_with_label (_("Creation time"));
	kooltips = gtk_tooltips_new ();
	gtk_tooltips_set_tip (kooltips, showtime,
			      _("Check if you want the current time shown on the radial plots."),
			      NULL);
	showaos = gtk_check_button_new_with_label (_("AOS/LOS times"));
	kooltips = gtk_tooltips_new ();
	gtk_tooltips_set_tip (kooltips, showaos,
			      _("Check if you want the AOS and LOS times shown on the radial plots."),
			      NULL);
	showqth = gtk_check_button_new_with_label (_("QTH info"));
	kooltips = gtk_tooltips_new ();
	gtk_tooltips_set_tip (kooltips, showqth,
			      _("Check if you want the ground station info shown on the radial plots."),
			      NULL);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (showsat),
				      gconf_client_get_bool (client, SATPLOT_SHOWSAT_PATH, NULL));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (showtime),
				      gconf_client_get_bool (client, SATPLOT_SHOWTIME_PATH, NULL));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (showqth),
				      gconf_client_get_bool (client, SATPLOT_SHOWQTH_PATH, NULL));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (showaos),
				      gconf_client_get_bool (client, SATPLOT_SHOWAOS_PATH, NULL));
	/* connect signals */
	gtk_signal_connect (GTK_OBJECT (showsat), "toggled",
			    GTK_SIGNAL_FUNC (satpref_satplot_extra_changed), NULL);
	gtk_signal_connect (GTK_OBJECT (showqth), "toggled",
			    GTK_SIGNAL_FUNC (satpref_satplot_extra_changed), NULL);
	gtk_signal_connect (GTK_OBJECT (showtime), "toggled",
			    GTK_SIGNAL_FUNC (satpref_satplot_extra_changed), NULL);
	gtk_signal_connect (GTK_OBJECT (showaos), "toggled",
			    GTK_SIGNAL_FUNC (satpref_satplot_extra_changed), NULL);

	table = gtk_table_new (1, 4, TRUE);
	gtk_table_attach_defaults (GTK_TABLE (table), showsat, 0, 1, 0, 1);
	gtk_table_attach_defaults (GTK_TABLE (table), showqth, 1, 2, 0, 1);
	gtk_table_attach_defaults (GTK_TABLE (table), showtime, 2, 3, 0, 1);
	gtk_table_attach_defaults (GTK_TABLE (table), showaos, 3, 4, 0, 1);

	frame2 = gtk_frame_new (_(" Show "));
	gtk_container_add (GTK_CONTAINER (frame2), table);

	/* Graphics */
	aacanv = gtk_check_button_new_with_label (_("Use anti aliased canvas"));
	kooltips = gtk_tooltips_new ();
	gtk_tooltips_set_tip (kooltips, aacanv,
			      _("Anti aliased canvas gives much better quality at the expense "\
				"of performance. It is recomended for static graphics."),
			      NULL);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (aacanv),
				      !gconf_client_get_bool (client, SATPLOT_NOAACANV_PATH, NULL));
	gtk_signal_connect (GTK_OBJECT (aacanv), "toggled",
			    GTK_SIGNAL_FUNC (satpref_satplot_extra_changed), NULL);
	frame3 = gtk_frame_new (_(" Graphics "));
	gtk_container_add (GTK_CONTAINER (frame3), aacanv);

	vbox = gtk_vbox_new (FALSE, 5);
	gtk_box_pack_start_defaults (GTK_BOX (vbox), frame1);
	gtk_box_pack_start_defaults (GTK_BOX (vbox), frame2);
	gtk_box_pack_start_defaults (GTK_BOX (vbox), frame3);

	return vbox;
}


void satpref_satplot_apply (void)
{
	/* THis function should be called to save the preferences.
	 */

	/* orientation */
	gconf_client_set_int (client, SATPLOT_SWAP_PATH, plotpref, NULL);
	plotpref = -1;
	/* extra features */
	gconf_client_set_bool (client, SATPLOT_SHOWSAT_PATH,
			       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (showsat)),
			       NULL);
	gconf_client_set_bool (client, SATPLOT_SHOWQTH_PATH,
			       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (showqth)),
			       NULL);
	gconf_client_set_bool (client, SATPLOT_SHOWTIME_PATH,
			       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (showtime)),
			       NULL);
	gconf_client_set_bool (client, SATPLOT_SHOWAOS_PATH,
			       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (showaos)),
			       NULL);
	/* graphics */
	gconf_client_set_bool (client, SATPLOT_NOAACANV_PATH,
			       !gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (aacanv)),
			       NULL);
}


static void
satpref_satplot_orientation_changed (GtkToggleButton *button, gpointer data)
{
	/* was the radio button pressed in or released? */
	if (gtk_toggle_button_get_active (button)) {
		plotpref = GPOINTER_TO_UINT (data);
		satpref_changed ();
	}
}


static void
satpref_satplot_extra_changed (GtkToggleButton *button, gpointer data)
{
	satpref_changed ();
}
