/*
 * GooCanvas. Copyright (C) 2005 Damon Chaplin.
 * Released under the GNU LGPL license. See COPYING for details.
 *
 * goocanvastext.h - text item.
 */
#ifndef __GOO_CANVAS_TEXT_H__
#define __GOO_CANVAS_TEXT_H__

#include <gtk/gtk.h>
#include "goocanvasitemsimple.h"

G_BEGIN_DECLS


#define GOO_TYPE_CANVAS_TEXT            (goo_canvas_text_get_type ())
#define GOO_CANVAS_TEXT(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GOO_TYPE_CANVAS_TEXT, GooCanvasText))
#define GOO_CANVAS_TEXT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GOO_TYPE_CANVAS_TEXT, GooCanvasTextClass))
#define GOO_IS_CANVAS_TEXT(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GOO_TYPE_CANVAS_TEXT))
#define GOO_IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GOO_TYPE_CANVAS_TEXT))
#define GOO_CANVAS_TEXT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GOO_TYPE_CANVAS_TEXT, GooCanvasTextClass))


typedef struct _GooCanvasText       GooCanvasText;
typedef struct _GooCanvasTextClass  GooCanvasTextClass;

/**
 * GooCanvasText
 *
 * The #GooCanvasText-struct struct contains private data only.
 */
struct _GooCanvasText
{
  GooCanvasItemSimple parent;

  gchar *text;
  gboolean use_markup;
  PangoFontDescription *font_desc;

  gdouble x, y, width;
  GtkAnchorType anchor;
  PangoAlignment alignment;
};

struct _GooCanvasTextClass
{
  GooCanvasItemSimpleClass parent_class;
};


GType          goo_canvas_text_get_type        (void) G_GNUC_CONST;
GooCanvasItem* goo_canvas_text_new             (GooCanvasItem *parent,
						const char    *string,
						gdouble        x,
						gdouble        y,
						gdouble        width,
						GtkAnchorType  anchor,
						const gchar   *first_property,
						...);


G_END_DECLS

#endif /* __GOO_CANVAS_TEXT_H__ */
