/*
 * GProFTPD - A GTK+ frontend for the ProFTPD standalone server.
 * Copyright (C) 2001, 2002, 2003, 2004, 2005 Magnus-swe <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include "callbacks.h"
#include "dialogs.h"
#include "support.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)


GtkWidget*
create_help_window (void)
{
  gchar *help_text; 
  GtkWidget *help_window, *vbox15, *scrolledwindow16;
  GtkWidget *help_textview, *close_help_button;
  GtkWidget *alignment19, *hbox52, *image19, *label109;

  help_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (help_window, "help_window");
  gtk_widget_set_size_request (help_window, 650, 350);
  gtk_window_set_title (GTK_WINDOW (help_window), _("GProftpd help"));
  gtk_window_set_position (GTK_WINDOW (help_window), GTK_WIN_POS_CENTER);

  vbox15 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox15, "vbox15");
  gtk_widget_show (vbox15);
  gtk_container_add (GTK_CONTAINER (help_window), vbox15);

  scrolledwindow16 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow16, "scrolledwindow16");
  gtk_widget_show (scrolledwindow16);
  gtk_box_pack_start (GTK_BOX (vbox15), scrolledwindow16, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow16), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  help_textview = gtk_text_view_new ();
  gtk_widget_set_name (help_textview, "help_textview");
  gtk_widget_show (help_textview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow16), help_textview);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (help_textview), FALSE);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (help_textview), FALSE);
  gtk_text_view_set_left_margin (GTK_TEXT_VIEW (help_textview), 30);
  gtk_text_view_set_right_margin (GTK_TEXT_VIEW (help_textview), 10);

  help_text = g_strconcat(
  
  _("\nWhen gproftpd is started it checks if you have all required files and that the environment is ok.\n\n"),
  _("If you have just upgraded you should check out the homepage if any additions to the configuration are\n"),
  _("necessary in order to take full advantage of all its features.\n\n"),
  _("Proftpd must be installed and located somewhere in the environments path variable\n\n\n"),
  _("When you add a user you can randomize its name and password or use your own.\n"),
  _("You can also select its login shell and where this user should have its root directory and upload directory.\n"),
  _("If the selected shell is /bin/false, /sbin/nologin etc the user can only login to this ftpserver otherwise\n"),
  _("that user gets a private home directory as well as its ftp directory and can login via ssh etc if that server\n"), 
  _("allows this user to do so.\n\n"),
  _("The upload directory must be located below the users root directory.\n"),
  _("If you dont want that user to have an upload directory you can uncheck the checkbox next to it.\n\n"),
  _("If you want to add directories thats not under the users root directory you can do this:\n\n"),
  _("Linux (as of kernel 2.4.0):\n"),
  _("mount --bind /some/directory/to/share /home/ftp/make_this_directory_first\n\n"),
  _("Alternatively:\nmount -o bind /var/data /home/ftp/bob/data\n\n"),
  _("*BSD (as of 4.4BSD):\nmount_null /var/data /home/ftp/bob/data\n\n"),
  _("Solaris:\nmount -F lofs /var/data /home/ftp/bob/data\n\n"),
  _("If you want automatically generated statistics you can use gprostats with crond\n"),
  _("or press the welcome and html statistics buttons in the files tab to make them once.\n\n"),
  _("With crond and gprostats you can do this to have it automatically update the statistics:\n"),
  _("gprostats -html /path/to/output.html\ngprostats -w welcome.msg\n"),
  _("or both at the same time: gprostats -html /path/to/output.html -w welcome.msg\n"),
  _("Use -c /path/to/proftpd.conf -x /path/to/xferlog if you need to.\n\n"),
  _("If you have made customized welcome messages and dont want them overwritten\n"),
  _("by gprostats you can configure this by doubleclicking a user and unchecking update statistics.\n"),
  _("then pressing the change button, this will also exclude the user from the html output.\n\n"),
  _("Some typical setups:\n\nIf one or more of your users needs to have upload access to a http servers directory:\n\n"),
  _("1. Set the users ftp root directory to the webserver's root directory /var/www/html\n"),
  _("   or /var/www/html/this_users_directory for a private homepage.\n\n"),
  _("2. Take away all text from the upload directory field\n\n"),
  _("3. Make sure the checkbutton next to the upload directory is checked.\n"),
  _("   Press the add button to add this user.\n\n"),
  _("4. You can now login as this user and upload to the html directory.\n\n\n"),
  _("To add anonymous readonly access to a directory you can do this:\n\n"),
  _("1. Type anonymous in the username field. \n"),
  _("    Press the password randomize button or type any password you want.\n"),
  _("    Select the /bin/false shell.\n"),
  _("    Uncheck the upload checkbutton, this is important.\n"),
  _("    Press add to add this anonymous user.\n\n"),
  _("2. Doubleclick that user in the users tab and set require password to off then\n"),
  _("    check that this user isnt banned then press the change button.\n\n"),
  _("4. You can now login as anonymous with no password.\n\n\n"),
  _("This is the default setting, one upload directory and a readonly ftp root directory:\n"),
  _("Root directory: /home/ftp\n"),
  _("Upload directory /home/ftp/upload\n\n"),
  _("The users can then upload files in the upload directory and download from the\n"),
  _("ftp root directory where you can put what you want to share.\n\n"),
  _("You can easily add more servers to run on different interfaces and ports.\n"),
  _("When a user connects to one address and port it gets access according to that servers\n"),
  _("configuration but only if the server is selected to bind to addresses.\n"),
  _("There are two directives used for this:\nBind and SocketBindTight.\n"),
  _("If you want to turn off a server without deleting it you can set its port value to 0\n\n"),
  _("If this Proftpd server is behind a NAT gateway you should specify the gateways\n"),
  _("DNS name or IP address otherwise turn it off.\n\n"),
  _("If you copy or move a file directly to the ftpservers directory you may need to\n"),
  _("chmod it with 644 and chmod directories to 755 so that the directory and file can be accessed.\n\n"),
  _("This is one way of chmodding all files recursively in the directory /home/ftp:\n"),
  _("find /home/ftp -type f -exec chmod 644  -v {} \\;\n\n"),
  _("Upload directories should have a chmod of 777 and this can be used for /home/ftp/upload\n"),
  _("find /home/ftp/upload -type d -exec chmod 777  -v {} \\;\n\n\n"),
  _("For more detailed information about the server and its configuration directives visit:\n"),
  _("http://www.proftpd.org\n"), NULL);
  gtk_text_buffer_set_text (gtk_text_view_get_buffer (GTK_TEXT_VIEW (help_textview)), help_text, -1);

  if( help_text!=NULL )
    g_free(help_text);

  close_help_button = gtk_button_new ();
  gtk_widget_set_name (close_help_button, "close_help_button");
  gtk_widget_show (close_help_button);
  gtk_box_pack_start (GTK_BOX (vbox15), close_help_button, FALSE, FALSE, 0);

  alignment19 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment19, "alignment19");
  gtk_widget_show (alignment19);
  gtk_container_add (GTK_CONTAINER (close_help_button), alignment19);

  hbox52 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox52, "hbox52");
  gtk_widget_show (hbox52);
  gtk_container_add (GTK_CONTAINER (alignment19), hbox52);

  image19 = gtk_image_new_from_stock ("gtk-close", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image19, "image19");
  gtk_widget_show (image19);
  gtk_box_pack_start (GTK_BOX (hbox52), image19, FALSE, FALSE, 0);

  label109 = gtk_label_new_with_mnemonic (_("Close"));
  gtk_widget_set_name (label109, "label109");
  gtk_widget_show (label109);
  gtk_box_pack_start (GTK_BOX (hbox52), label109, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label109), GTK_JUSTIFY_LEFT);

  g_signal_connect_swapped ((gpointer) close_help_button, "clicked",
                            G_CALLBACK (gtk_widget_destroy),
                            GTK_OBJECT (help_window));

  GLADE_HOOKUP_OBJECT_NO_REF (help_window, help_window, "help_window");
  GLADE_HOOKUP_OBJECT (help_window, help_textview, "help_textview");
  GLADE_HOOKUP_OBJECT (help_window, close_help_button, "close_help_button");

  return help_window;
}


GtkWidget*
create_shutdown_window (void)
{
  GtkWidget *shutdown_window, *vbox17, *label141;
  GtkWidget *hseparator35, *hbox134, *label146;
  GtkWidget *real_shutdown_entry, *label251;
  GtkWidget *hbox78, *label142;
  GtkWidget *new_acc_disabled_entry, *label144;
  GtkWidget *hbox79, *label145, *exist_users_dc_entry;
  GtkWidget *label148, *hbox81, *label147;
  GtkWidget *shutdown_msg1_entry, *label152;
  GtkWidget *hseparator49, *label252, *hseparator34;
  GtkWidget *hbuttonbox9, *shutdown_cancel_button;
  GtkWidget *alignment37, *hbox83, *image37;
  GtkWidget *label154, *shutdown_ok_button;
  GtkWidget *alignment36, *hbox82;
  GtkWidget *image36, *label153;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  shutdown_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (shutdown_window, "shutdown_window");
  gtk_container_set_border_width (GTK_CONTAINER (shutdown_window), 5);
  gtk_window_set_title (GTK_WINDOW (shutdown_window), _("Shutdown"));
  gtk_window_set_position (GTK_WINDOW (shutdown_window), GTK_WIN_POS_CENTER);

  vbox17 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox17, "vbox17");
  gtk_widget_show (vbox17);
  gtk_container_add (GTK_CONTAINER (shutdown_window), vbox17);

  label141 = gtk_label_new (_("The server will shut down according to these settings."));
  gtk_widget_set_name (label141, "label141");
  gtk_widget_show (label141);
  gtk_box_pack_start (GTK_BOX (vbox17), label141, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label141), GTK_JUSTIFY_LEFT);

  hseparator35 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator35, "hseparator35");
  gtk_widget_show (hseparator35);
  gtk_box_pack_start (GTK_BOX (vbox17), hseparator35, TRUE, TRUE, 0);
  gtk_widget_set_size_request (hseparator35, -1, 5);

  hbox134 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox134, "hbox134");
  gtk_widget_show (hbox134);
  gtk_box_pack_start (GTK_BOX (vbox17), hbox134, TRUE, TRUE, 0);

  label146 = gtk_label_new (_("Time to real shutdown:"));
  gtk_widget_set_name (label146, "label146");
  gtk_widget_show (label146);
  gtk_box_pack_start (GTK_BOX (hbox134), label146, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label146, 260, -1);
  gtk_label_set_justify (GTK_LABEL (label146), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label146), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label146), 10, 0);

  real_shutdown_entry = gtk_entry_new ();
  gtk_widget_set_name (real_shutdown_entry, "real_shutdown_entry");
  gtk_widget_show (real_shutdown_entry);
  gtk_box_pack_start (GTK_BOX (hbox134), real_shutdown_entry, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, real_shutdown_entry, _("now, +Minutes or HHMM"), NULL);
  gtk_entry_set_max_length (GTK_ENTRY (real_shutdown_entry), 1000);
  gtk_entry_set_text (GTK_ENTRY (real_shutdown_entry), "+30");

  label251 = gtk_label_new ("");
  gtk_widget_set_name (label251, "label251");
  gtk_widget_show (label251);
  gtk_box_pack_start (GTK_BOX (hbox134), label251, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label251, 80, 16);
  gtk_label_set_justify (GTK_LABEL (label251), GTK_JUSTIFY_LEFT);

  hbox78 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox78, "hbox78");
  gtk_widget_show (hbox78);
  gtk_box_pack_start (GTK_BOX (vbox17), hbox78, TRUE, TRUE, 0);

  label142 = gtk_label_new (_("New access disabled:"));
  gtk_widget_set_name (label142, "label142");
  gtk_widget_show (label142);
  gtk_box_pack_start (GTK_BOX (hbox78), label142, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label142, 260, -1);
  gtk_label_set_justify (GTK_LABEL (label142), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label142), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label142), 10, 0);

  new_acc_disabled_entry = gtk_entry_new ();
  gtk_widget_set_name (new_acc_disabled_entry, "new_acc_disabled_entry");
  gtk_widget_show (new_acc_disabled_entry);
  gtk_box_pack_start (GTK_BOX (hbox78), new_acc_disabled_entry, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, new_acc_disabled_entry, _("Minutes before real shutdown."), NULL);
  gtk_entry_set_max_length (GTK_ENTRY (new_acc_disabled_entry), 1000);
  gtk_entry_set_text (GTK_ENTRY (new_acc_disabled_entry), "20");

  label144 = gtk_label_new ("");
  gtk_widget_set_name (label144, "label144");
  gtk_widget_show (label144);
  gtk_box_pack_start (GTK_BOX (hbox78), label144, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label144, 80, 16);
  gtk_label_set_justify (GTK_LABEL (label144), GTK_JUSTIFY_LEFT);

  hbox79 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox79, "hbox79");
  gtk_widget_show (hbox79);
  gtk_box_pack_start (GTK_BOX (vbox17), hbox79, TRUE, TRUE, 0);

  label145 = gtk_label_new (_("Existing users disconnected:"));
  gtk_widget_set_name (label145, "label145");
  gtk_widget_show (label145);
  gtk_box_pack_start (GTK_BOX (hbox79), label145, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label145, 260, -1);
  gtk_label_set_justify (GTK_LABEL (label145), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label145), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label145), 10, 0);

  exist_users_dc_entry = gtk_entry_new ();
  gtk_widget_set_name (exist_users_dc_entry, "exist_users_dc_entry");
  gtk_widget_show (exist_users_dc_entry);
  gtk_box_pack_start (GTK_BOX (hbox79), exist_users_dc_entry, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, exist_users_dc_entry, _("Minutes before real shutdown."), NULL);
  gtk_entry_set_max_length (GTK_ENTRY (exist_users_dc_entry), 1000);
  gtk_entry_set_text (GTK_ENTRY (exist_users_dc_entry), "10");

  label148 = gtk_label_new ("");
  gtk_widget_set_name (label148, "label148");
  gtk_widget_show (label148);
  gtk_box_pack_start (GTK_BOX (hbox79), label148, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label148, 80, 16);
  gtk_label_set_justify (GTK_LABEL (label148), GTK_JUSTIFY_LEFT);

  hbox81 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox81, "hbox81");
  gtk_widget_show (hbox81);
  gtk_box_pack_start (GTK_BOX (vbox17), hbox81, TRUE, TRUE, 0);

  label147 = gtk_label_new (_("Shutdown message:"));
  gtk_widget_set_name (label147, "label147");
  gtk_widget_show (label147);
  gtk_box_pack_start (GTK_BOX (hbox81), label147, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label147, 180, -1);
  gtk_label_set_justify (GTK_LABEL (label147), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label147), 0.01, 0.5);
  gtk_misc_set_padding (GTK_MISC (label147), 10, 0);

  shutdown_msg1_entry = gtk_entry_new ();
  gtk_widget_set_name (shutdown_msg1_entry, "shutdown_msg1_entry");
  gtk_widget_show (shutdown_msg1_entry);
  gtk_box_pack_start (GTK_BOX (hbox81), shutdown_msg1_entry, TRUE, TRUE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (shutdown_msg1_entry), 1000);
  gtk_entry_set_text (GTK_ENTRY (shutdown_msg1_entry), _("%s , Current connections will be dropped: %d"));

  label152 = gtk_label_new ("");
  gtk_widget_set_name (label152, "label152");
  gtk_widget_show (label152);
  gtk_box_pack_start (GTK_BOX (hbox81), label152, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label152, 10, 16);
  gtk_label_set_justify (GTK_LABEL (label152), GTK_JUSTIFY_LEFT);

  hseparator49 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator49, "hseparator49");
  gtk_widget_show (hseparator49);
  gtk_box_pack_start (GTK_BOX (vbox17), hseparator49, TRUE, TRUE, 0);
  gtk_widget_set_size_request (hseparator49, -1, 10);

  label252 = gtk_label_new (_("Pressing the online button will let users login again."));
  gtk_widget_set_name (label252, "label252");
  gtk_widget_show (label252);
  gtk_box_pack_start (GTK_BOX (vbox17), label252, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label252, 297, -1);
  gtk_label_set_justify (GTK_LABEL (label252), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label252), 0.04, 0.5);

  hseparator34 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator34, "hseparator34");
  gtk_widget_show (hseparator34);
  gtk_box_pack_start (GTK_BOX (vbox17), hseparator34, TRUE, TRUE, 0);
  gtk_widget_set_size_request (hseparator34, -1, 10);

  hbuttonbox9 = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbuttonbox9, "hbuttonbox9");
  gtk_widget_show (hbuttonbox9);
  gtk_box_pack_start (GTK_BOX (vbox17), hbuttonbox9, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox9), GTK_BUTTONBOX_SPREAD);

  shutdown_cancel_button = gtk_button_new ();
  gtk_widget_set_name (shutdown_cancel_button, "shutdown_cancel_button");
  gtk_widget_show (shutdown_cancel_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox9), shutdown_cancel_button);
  GTK_WIDGET_SET_FLAGS (shutdown_cancel_button, GTK_CAN_DEFAULT);

  alignment37 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment37, "alignment37");
  gtk_widget_show (alignment37);
  gtk_container_add (GTK_CONTAINER (shutdown_cancel_button), alignment37);

  hbox83 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox83, "hbox83");
  gtk_widget_show (hbox83);
  gtk_container_add (GTK_CONTAINER (alignment37), hbox83);

  image37 = gtk_image_new_from_stock ("gtk-cancel", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image37, "image37");
  gtk_widget_show (image37);
  gtk_box_pack_start (GTK_BOX (hbox83), image37, TRUE, TRUE, 0);

  label154 = gtk_label_new_with_mnemonic (_("Cancel"));
  gtk_widget_set_name (label154, "label154");
  gtk_widget_show (label154);
  gtk_box_pack_start (GTK_BOX (hbox83), label154, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label154), GTK_JUSTIFY_LEFT);

  shutdown_ok_button = gtk_button_new ();
  gtk_widget_set_name (shutdown_ok_button, "shutdown_ok_button");
  gtk_widget_show (shutdown_ok_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox9), shutdown_ok_button);
  GTK_WIDGET_SET_FLAGS (shutdown_ok_button, GTK_CAN_DEFAULT);

  alignment36 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment36, "alignment36");
  gtk_widget_show (alignment36);
  gtk_container_add (GTK_CONTAINER (shutdown_ok_button), alignment36);

  hbox82 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox82, "hbox82");
  gtk_widget_show (hbox82);
  gtk_container_add (GTK_CONTAINER (alignment36), hbox82);

  image36 = gtk_image_new_from_stock ("gtk-apply", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image36, "image36");
  gtk_widget_show (image36);
  gtk_box_pack_start (GTK_BOX (hbox82), image36, TRUE, TRUE, 0);

  label153 = gtk_label_new_with_mnemonic (_("OK"));
  gtk_widget_set_name (label153, "label153");
  gtk_widget_show (label153);
  gtk_box_pack_start (GTK_BOX (hbox82), label153, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label153), GTK_JUSTIFY_LEFT);

  g_signal_connect_swapped ((gpointer) shutdown_cancel_button, "clicked",
                            G_CALLBACK (gtk_widget_destroy),
                            GTK_OBJECT (shutdown_window));
  g_signal_connect ((gpointer) shutdown_ok_button, "clicked",
                    G_CALLBACK (on_shutdown_ok_button_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (shutdown_window, shutdown_window, "shutdown_window");
  GLADE_HOOKUP_OBJECT (shutdown_window, real_shutdown_entry, "real_shutdown_entry");
  GLADE_HOOKUP_OBJECT (shutdown_window, new_acc_disabled_entry, "new_acc_disabled_entry");
  GLADE_HOOKUP_OBJECT (shutdown_window, exist_users_dc_entry, "exist_users_dc_entry");
  GLADE_HOOKUP_OBJECT (shutdown_window, shutdown_msg1_entry, "shutdown_msg1_entry");
  GLADE_HOOKUP_OBJECT (shutdown_window, shutdown_cancel_button, "shutdown_cancel_button");
  GLADE_HOOKUP_OBJECT (shutdown_window, shutdown_ok_button, "shutdown_ok_button");
  GLADE_HOOKUP_OBJECT_NO_REF (shutdown_window, tooltips, "tooltips");

  return shutdown_window;
}


GtkWidget*
create_info_window (void)
{
  GtkWidget *info_window, *scrolledwindow15, *info_textview;

  info_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (info_window, "info_window");
  gtk_widget_set_size_request (info_window, 400, 150);
  gtk_window_set_title (GTK_WINDOW (info_window), _("GProFTPD information"));
  gtk_window_set_position (GTK_WINDOW (info_window), GTK_WIN_POS_CENTER);

  scrolledwindow15 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow15, "scrolledwindow15");
  gtk_widget_show (scrolledwindow15);
  gtk_container_add (GTK_CONTAINER (info_window), scrolledwindow15);
  gtk_widget_set_size_request (scrolledwindow15, 350, 200);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow15), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  info_textview = gtk_text_view_new ();
  gtk_widget_set_name (info_textview, "info_textview");
  gtk_widget_show (info_textview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow15), info_textview);
  gtk_widget_set_size_request (info_textview, 350, 200);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (info_textview), FALSE);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (info_textview), FALSE);
  gtk_text_view_set_left_margin (GTK_TEXT_VIEW (info_textview), 10);

  g_signal_connect ((gpointer) info_window, "map",
                    G_CALLBACK (on_info_window_map),
                    NULL);

  GLADE_HOOKUP_OBJECT_NO_REF (info_window, info_window, "info_window");
  GLADE_HOOKUP_OBJECT (info_window, info_textview, "info_textview");

  return info_window;
}


GtkWidget*
create_user_settings_window (void)
{
  GtkWidget *user_settings_window, *vbox16, *label349;
  GtkWidget *scrolledwindow19, *viewport4, *vbox54;
  GtkWidget *hseparator103, *changer_rootdir_hbox;
  GtkWidget *label350, *vbox55, *label113, *label139;
  GtkWidget *label115, *label233, *label175, *label235;
  GtkWidget *label131, *label117, *label301, *label371;
  GtkWidget *label351, *vbox56, *settings_username_entry;
  GtkWidget *settings_password_entry, *settings_group_entry;
  GtkWidget *combo17;
  GList *combo17_items = NULL;
  GtkWidget *settings_require_password_entry;
  GtkWidget *settings_login_from_entry;
  GtkObject *settings_max_logins_spinbutton_adj;
  GtkWidget *settings_max_logins_spinbutton;
  GtkWidget *settings_max_logins_entry;
  GtkWidget *settings_homedirectory_entry;
  GtkWidget *gplock_checkbutton;
  GtkWidget *banned_checkbutton;
  GtkWidget *label352;
  GtkWidget *changer_rootdir_hseparator;
  GtkWidget *uploaddir_vbox, *hbox248, *label363;
  GtkWidget *label217, *label354;
  GtkWidget *settings_uploaddirectory_entry;
  GtkWidget *label355, *hbox249, *label356, *label244;
  GtkWidget *label357, *hbox250, *label358, *vbox58;
  GtkWidget *hbox251, *vbox60;
  GtkWidget *label222, *label223, *label231, *label224;
  GtkWidget *label226, *label237, *label225, *label230;
  GtkWidget *label364, *label361, *vbox61;
  GtkWidget *uldir_list_checkbutton;
  GtkWidget *uldir_upload_checkbutton;
  GtkWidget *uldir_append_checkbutton;
  GtkWidget *uldir_download_checkbutton;
  GtkWidget *uldir_rename_checkbutton;
  GtkWidget *uldir_delete_checkbutton;
  GtkWidget *uldir_createdir_checkbutton;
  GtkWidget *uldir_removedir_checkbutton;
  GtkWidget *label359, *vbox59, *hbox252;
  GtkWidget *vbox62, *label229, *label239;
  GtkWidget *label241, *label242, *label243;
  GtkWidget *label238, *label247, *label249;
  GtkWidget *label248, *label362, *vbox63;
  GtkWidget *uldir_site_checkbutton;
  GtkWidget *uldir_showdate_checkbutton;
  GtkWidget *uldir_showwd_checkbutton;
  GtkWidget *uldir_showsize_checkbutton;
  GtkWidget *uldir_changewd_checkbutton;
  GtkWidget *uldir_chmod_checkbutton;
  GtkWidget *uldir_chgrp_checkbutton;
  GtkWidget *uldir_cdup_checkbutton;
  GtkWidget *uldir_stat_checkbutton;
  GtkWidget *label360, *hseparator101, *hseparator32;
  GtkWidget *hbuttonbox3, *userdel_button, *alignment29;
  GtkWidget *hbox64, *image29, *label124, *userchange_button;
  GtkWidget *alignment28, *hbox63, *image28, *label123;
  GtkWidget *close_user_settings_button, *alignment26;
  GtkWidget *hbox61, *image26, *label121, *label365;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  user_settings_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (user_settings_window, "user_settings_window");
  gtk_widget_set_size_request (user_settings_window, 550, 409);
  gtk_window_set_title (GTK_WINDOW (user_settings_window), _("User settings"));
  gtk_window_set_position (GTK_WINDOW (user_settings_window), GTK_WIN_POS_CENTER);

  vbox16 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox16, "vbox16");
  gtk_widget_show (vbox16);
  gtk_container_add (GTK_CONTAINER (user_settings_window), vbox16);

  label349 = gtk_label_new (_("These are the settings for this user."));
  gtk_widget_set_name (label349, "label349");
  gtk_widget_show (label349);
  gtk_box_pack_start (GTK_BOX (vbox16), label349, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label349), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label349), 0, 3);

  scrolledwindow19 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow19, "scrolledwindow19");
  gtk_widget_show (scrolledwindow19);
  gtk_box_pack_start (GTK_BOX (vbox16), scrolledwindow19, TRUE, TRUE, 0);

  viewport4 = gtk_viewport_new (NULL, NULL);
  gtk_widget_set_name (viewport4, "viewport4");
  gtk_widget_show (viewport4);
  gtk_container_add (GTK_CONTAINER (scrolledwindow19), viewport4);

  vbox54 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox54, "vbox54");
  gtk_widget_show (vbox54);
  gtk_container_add (GTK_CONTAINER (viewport4), vbox54);

  hseparator103 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator103, "hseparator103");
  gtk_widget_show (hseparator103);
  gtk_box_pack_start (GTK_BOX (vbox54), hseparator103, TRUE, TRUE, 0);
  gtk_widget_set_size_request (hseparator103, -1, 10);

  changer_rootdir_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (changer_rootdir_hbox, "changer_rootdir_hbox");
  gtk_widget_show (changer_rootdir_hbox);
  gtk_box_pack_start (GTK_BOX (vbox54), changer_rootdir_hbox, TRUE, TRUE, 0);

  label350 = gtk_label_new ("");
  gtk_widget_set_name (label350, "label350");
  gtk_widget_show (label350);
  gtk_box_pack_start (GTK_BOX (changer_rootdir_hbox), label350, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label350, 30, -1);
  gtk_label_set_justify (GTK_LABEL (label350), GTK_JUSTIFY_LEFT);

  vbox55 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox55, "vbox55");
  gtk_widget_show (vbox55);
  gtk_box_pack_start (GTK_BOX (changer_rootdir_hbox), vbox55, TRUE, TRUE, 0);

  label113 = gtk_label_new (_("Username:          "));
  gtk_widget_set_name (label113, "label113");
  gtk_widget_show (label113);
  gtk_box_pack_start (GTK_BOX (vbox55), label113, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label113), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label113), 0, 0.5);

  label139 = gtk_label_new (_("Password:          "));
  gtk_widget_set_name (label139, "label139");
  gtk_widget_show (label139);
  gtk_box_pack_start (GTK_BOX (vbox55), label139, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label139), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label139), 0, 0.5);

  label115 = gtk_label_new (_("Group:                 "));
  gtk_widget_set_name (label115, "label115");
  gtk_widget_show (label115);
  gtk_box_pack_start (GTK_BOX (vbox55), label115, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label115), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label115), 0, 0.5);

  label233 = gtk_label_new (_("Require password:"));
  gtk_widget_set_name (label233, "label233");
  gtk_widget_show (label233);
  gtk_box_pack_start (GTK_BOX (vbox55), label233, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label233), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label233), 0, 0.5);

  label175 = gtk_label_new (_("Allow logins from:"));
  gtk_widget_set_name (label175, "label175");
  gtk_widget_show (label175);
  gtk_box_pack_start (GTK_BOX (vbox55), label175, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label175), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label175), 0, 0.5);

  label235 = gtk_label_new (_("Maximum logins:  "));
  gtk_widget_set_name (label235, "label235");
  gtk_widget_show (label235);
  gtk_box_pack_start (GTK_BOX (vbox55), label235, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label235), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label235), 0, 0.5);

  label131 = gtk_label_new (_("Message:            "));
  gtk_widget_set_name (label131, "label131");
  gtk_widget_show (label131);
  gtk_box_pack_start (GTK_BOX (vbox55), label131, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label131), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label131), 0, 0.5);

  label117 = gtk_label_new (_("Root directory:    "));
  gtk_widget_set_name (label117, "label117");
  gtk_widget_show (label117);
  gtk_box_pack_start (GTK_BOX (vbox55), label117, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label117), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label117), 0, 0.5);

  label301 = gtk_label_new (_("Update statistics:"));
  gtk_widget_set_name (label301, "label301");
  gtk_widget_show (label301);
  gtk_box_pack_start (GTK_BOX (vbox55), label301, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label301), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label301), 0, 0.5);

  label371 = gtk_label_new (_("Banned:"));
  gtk_widget_set_name (label371, "label371");
  gtk_widget_show (label371);
  gtk_box_pack_start (GTK_BOX (vbox55), label371, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label371), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label371), 0, 0.5);

  label351 = gtk_label_new ("");
  gtk_widget_set_name (label351, "label351");
  gtk_widget_show (label351);
  gtk_box_pack_start (GTK_BOX (changer_rootdir_hbox), label351, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label351, 30, -1);
  gtk_label_set_justify (GTK_LABEL (label351), GTK_JUSTIFY_LEFT);

  vbox56 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox56, "vbox56");
  gtk_widget_show (vbox56);
  gtk_box_pack_start (GTK_BOX (changer_rootdir_hbox), vbox56, TRUE, TRUE, 0);

  settings_username_entry = gtk_entry_new ();
  gtk_widget_set_name (settings_username_entry, "settings_username_entry");
  gtk_widget_show (settings_username_entry);
  gtk_box_pack_start (GTK_BOX (vbox56), settings_username_entry, TRUE, TRUE, 0);
  gtk_widget_set_sensitive (settings_username_entry, FALSE);
  gtk_entry_set_max_length (GTK_ENTRY (settings_username_entry), 128);
  gtk_editable_set_editable (GTK_EDITABLE (settings_username_entry), FALSE);

  settings_password_entry = gtk_entry_new ();
  gtk_widget_set_name (settings_password_entry, "settings_password_entry");
  gtk_widget_show (settings_password_entry);
  gtk_box_pack_start (GTK_BOX (vbox56), settings_password_entry, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, settings_password_entry, _("Type a password longer then 6 chars to change."), NULL);
  gtk_entry_set_max_length (GTK_ENTRY (settings_password_entry), 128);

  settings_group_entry = gtk_entry_new ();
  gtk_widget_set_name (settings_group_entry, "settings_group_entry");
  gtk_widget_show (settings_group_entry);
  gtk_box_pack_start (GTK_BOX (vbox56), settings_group_entry, TRUE, TRUE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (settings_group_entry), 128);

  combo17 = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (combo17)->popwin),
                     "GladeParentKey", combo17);
  gtk_widget_set_name (combo17, "combo17");
  gtk_widget_show (combo17);
  gtk_box_pack_start (GTK_BOX (vbox56), combo17, FALSE, FALSE, 0);
  gtk_widget_set_size_request (combo17, 88, -1);
  combo17_items = g_list_append (combo17_items, (gpointer) _("yes"));
  combo17_items = g_list_append (combo17_items, (gpointer) _("no"));
  gtk_combo_set_popdown_strings (GTK_COMBO (combo17), combo17_items);
  g_list_free (combo17_items);

  settings_require_password_entry = GTK_COMBO (combo17)->entry;
  gtk_widget_set_name (settings_require_password_entry, "settings_require_password_entry");
  gtk_widget_show (settings_require_password_entry);
  gtk_widget_set_sensitive (settings_require_password_entry, FALSE);

  settings_login_from_entry = gtk_entry_new ();
  gtk_widget_set_name (settings_login_from_entry, "settings_login_from_entry");
  gtk_widget_show (settings_login_from_entry);
  gtk_box_pack_start (GTK_BOX (vbox56), settings_login_from_entry, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, settings_login_from_entry, _("all,none,192.168.0.,host.domain.edu,.trusted-domain.org"), NULL);
  gtk_entry_set_max_length (GTK_ENTRY (settings_login_from_entry), 1000);

  settings_max_logins_spinbutton_adj = gtk_adjustment_new (1, 1, 999999, 1, 10, 10);
  settings_max_logins_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (settings_max_logins_spinbutton_adj), 1, 0);
  gtk_widget_set_name (settings_max_logins_spinbutton, "settings_max_logins_spinbutton");
  gtk_widget_show (settings_max_logins_spinbutton);
  gtk_box_pack_start (GTK_BOX (vbox56), settings_max_logins_spinbutton, TRUE, TRUE, 0);

  settings_max_logins_entry = gtk_entry_new ();
  gtk_widget_set_name (settings_max_logins_entry, "settings_max_logins_entry");
  gtk_widget_show (settings_max_logins_entry);
  gtk_box_pack_start (GTK_BOX (vbox56), settings_max_logins_entry, TRUE, TRUE, 0);

  settings_homedirectory_entry = gtk_entry_new ();
  gtk_widget_set_name (settings_homedirectory_entry, "settings_homedirectory_entry");
  gtk_widget_show (settings_homedirectory_entry);
  gtk_box_pack_start (GTK_BOX (vbox56), settings_homedirectory_entry, TRUE, TRUE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (settings_homedirectory_entry), 1000);

  gplock_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (gplock_checkbutton, "gplock_checkbutton");
  gtk_widget_show (gplock_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox56), gplock_checkbutton, FALSE, FALSE, 0);

  banned_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (banned_checkbutton, "banned_checkbutton");
  gtk_widget_show (banned_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox56), banned_checkbutton, FALSE, FALSE, 0);

  label352 = gtk_label_new ("");
  gtk_widget_set_name (label352, "label352");
  gtk_widget_show (label352);
  gtk_box_pack_start (GTK_BOX (changer_rootdir_hbox), label352, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label352, 30, -1);
  gtk_label_set_justify (GTK_LABEL (label352), GTK_JUSTIFY_LEFT);

  changer_rootdir_hseparator = gtk_hseparator_new ();
  gtk_widget_set_name (changer_rootdir_hseparator, "changer_rootdir_hseparator");
  gtk_widget_show (changer_rootdir_hseparator);
  gtk_box_pack_start (GTK_BOX (vbox54), changer_rootdir_hseparator, FALSE, FALSE, 0);
  gtk_widget_set_size_request (changer_rootdir_hseparator, -1, 10);

  uploaddir_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (uploaddir_vbox, "uploaddir_vbox");
  gtk_widget_show (uploaddir_vbox);
  gtk_box_pack_start (GTK_BOX (vbox54), uploaddir_vbox, TRUE, TRUE, 0);

  hbox248 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox248, "hbox248");
  gtk_widget_show (hbox248);
  gtk_box_pack_start (GTK_BOX (uploaddir_vbox), hbox248, TRUE, TRUE, 0);

  label363 = gtk_label_new ("");
  gtk_widget_set_name (label363, "label363");
  gtk_widget_show (label363);
  gtk_box_pack_start (GTK_BOX (hbox248), label363, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label363, 30, -1);
  gtk_label_set_justify (GTK_LABEL (label363), GTK_JUSTIFY_LEFT);

  label217 = gtk_label_new (_("Upload directory:"));
  gtk_widget_set_name (label217, "label217");
  gtk_widget_show (label217);
  gtk_box_pack_start (GTK_BOX (hbox248), label217, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label217), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label217), 0, 0.5);

  label354 = gtk_label_new ("");
  gtk_widget_set_name (label354, "label354");
  gtk_widget_show (label354);
  gtk_box_pack_start (GTK_BOX (hbox248), label354, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label354, 30, -1);
  gtk_label_set_justify (GTK_LABEL (label354), GTK_JUSTIFY_LEFT);

  settings_uploaddirectory_entry = gtk_entry_new ();
  gtk_widget_set_name (settings_uploaddirectory_entry, "settings_uploaddirectory_entry");
  gtk_widget_show (settings_uploaddirectory_entry);
  gtk_box_pack_start (GTK_BOX (hbox248), settings_uploaddirectory_entry, TRUE, TRUE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (settings_uploaddirectory_entry), 1000);

  label355 = gtk_label_new ("");
  gtk_widget_set_name (label355, "label355");
  gtk_widget_show (label355);
  gtk_box_pack_start (GTK_BOX (hbox248), label355, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label355, 30, -1);
  gtk_label_set_justify (GTK_LABEL (label355), GTK_JUSTIFY_LEFT);

  hbox249 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox249, "hbox249");
  gtk_widget_show (hbox249);
  gtk_box_pack_start (GTK_BOX (uploaddir_vbox), hbox249, TRUE, TRUE, 0);

  label356 = gtk_label_new ("");
  gtk_widget_set_name (label356, "label356");
  gtk_widget_show (label356);
  gtk_box_pack_start (GTK_BOX (hbox249), label356, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label356, 30, -1);
  gtk_label_set_justify (GTK_LABEL (label356), GTK_JUSTIFY_LEFT);

  label244 = gtk_label_new (_("This user is permitted to do the following in this directory:"));
  gtk_widget_set_name (label244, "label244");
  gtk_widget_show (label244);
  gtk_box_pack_start (GTK_BOX (hbox249), label244, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label244), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label244), 0, 0.5);

  label357 = gtk_label_new ("");
  gtk_widget_set_name (label357, "label357");
  gtk_widget_show (label357);
  gtk_box_pack_start (GTK_BOX (hbox249), label357, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label357, 30, -1);
  gtk_label_set_justify (GTK_LABEL (label357), GTK_JUSTIFY_LEFT);

  hbox250 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox250, "hbox250");
  gtk_widget_show (hbox250);
  gtk_box_pack_start (GTK_BOX (uploaddir_vbox), hbox250, TRUE, TRUE, 0);

  label358 = gtk_label_new ("");
  gtk_widget_set_name (label358, "label358");
  gtk_widget_show (label358);
  gtk_box_pack_start (GTK_BOX (hbox250), label358, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label358, 30, -1);
  gtk_label_set_justify (GTK_LABEL (label358), GTK_JUSTIFY_LEFT);

  vbox58 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox58, "vbox58");
  gtk_widget_show (vbox58);
  gtk_box_pack_start (GTK_BOX (hbox250), vbox58, TRUE, TRUE, 0);

  hbox251 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox251, "hbox251");
  gtk_widget_show (hbox251);
  gtk_box_pack_start (GTK_BOX (vbox58), hbox251, TRUE, TRUE, 0);

  vbox60 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox60, "vbox60");
  gtk_widget_show (vbox60);
  gtk_box_pack_start (GTK_BOX (hbox251), vbox60, FALSE, FALSE, 0);

  label222 = gtk_label_new (_("List:"));
  gtk_widget_set_name (label222, "label222");
  gtk_widget_show (label222);
  gtk_box_pack_start (GTK_BOX (vbox60), label222, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label222), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label222), 0, 0.5);

  label223 = gtk_label_new (_("Upload:"));
  gtk_widget_set_name (label223, "label223");
  gtk_widget_show (label223);
  gtk_box_pack_start (GTK_BOX (vbox60), label223, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label223), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label223), 0, 0.5);

  label231 = gtk_label_new (_("Append:"));
  gtk_widget_set_name (label231, "label231");
  gtk_widget_show (label231);
  gtk_box_pack_start (GTK_BOX (vbox60), label231, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label231), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label231), 0, 0.5);

  label224 = gtk_label_new (_("Download:"));
  gtk_widget_set_name (label224, "label224");
  gtk_widget_show (label224);
  gtk_box_pack_start (GTK_BOX (vbox60), label224, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label224), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label224), 0, 0.5);

  label226 = gtk_label_new (_("Rename:"));
  gtk_widget_set_name (label226, "label226");
  gtk_widget_show (label226);
  gtk_box_pack_start (GTK_BOX (vbox60), label226, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label226), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label226), 0, 0.5);

  label237 = gtk_label_new (_("Delete:"));
  gtk_widget_set_name (label237, "label237");
  gtk_widget_show (label237);
  gtk_box_pack_start (GTK_BOX (vbox60), label237, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label237), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label237), 0, 0.5);

  label225 = gtk_label_new (_("Create directory:"));
  gtk_widget_set_name (label225, "label225");
  gtk_widget_show (label225);
  gtk_box_pack_start (GTK_BOX (vbox60), label225, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label225), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label225), 0, 0.5);

  label230 = gtk_label_new (_("Remove directory:"));
  gtk_widget_set_name (label230, "label230");
  gtk_widget_show (label230);
  gtk_box_pack_start (GTK_BOX (vbox60), label230, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label230), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label230), 0, 0.5);

  label364 = gtk_label_new ("");
  gtk_widget_set_name (label364, "label364");
  gtk_widget_show (label364);
  gtk_box_pack_start (GTK_BOX (vbox60), label364, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label364), GTK_JUSTIFY_LEFT);

  label361 = gtk_label_new ("");
  gtk_widget_set_name (label361, "label361");
  gtk_widget_show (label361);
  gtk_box_pack_start (GTK_BOX (hbox251), label361, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label361), GTK_JUSTIFY_LEFT);

  vbox61 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox61, "vbox61");
  gtk_widget_show (vbox61);
  gtk_box_pack_start (GTK_BOX (hbox251), vbox61, TRUE, TRUE, 0);

  uldir_list_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (uldir_list_checkbutton, "uldir_list_checkbutton");
  gtk_widget_show (uldir_list_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox61), uldir_list_checkbutton, FALSE, FALSE, 0);

  uldir_upload_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (uldir_upload_checkbutton, "uldir_upload_checkbutton");
  gtk_widget_show (uldir_upload_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox61), uldir_upload_checkbutton, FALSE, FALSE, 0);

  uldir_append_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (uldir_append_checkbutton, "uldir_append_checkbutton");
  gtk_widget_show (uldir_append_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox61), uldir_append_checkbutton, FALSE, FALSE, 0);

  uldir_download_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (uldir_download_checkbutton, "uldir_download_checkbutton");
  gtk_widget_show (uldir_download_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox61), uldir_download_checkbutton, FALSE, FALSE, 0);

  uldir_rename_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (uldir_rename_checkbutton, "uldir_rename_checkbutton");
  gtk_widget_show (uldir_rename_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox61), uldir_rename_checkbutton, FALSE, FALSE, 0);

  uldir_delete_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (uldir_delete_checkbutton, "uldir_delete_checkbutton");
  gtk_widget_show (uldir_delete_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox61), uldir_delete_checkbutton, FALSE, FALSE, 0);

  uldir_createdir_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (uldir_createdir_checkbutton, "uldir_createdir_checkbutton");
  gtk_widget_show (uldir_createdir_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox61), uldir_createdir_checkbutton, FALSE, FALSE, 0);

  uldir_removedir_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (uldir_removedir_checkbutton, "uldir_removedir_checkbutton");
  gtk_widget_show (uldir_removedir_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox61), uldir_removedir_checkbutton, FALSE, FALSE, 0);

  label359 = gtk_label_new ("");
  gtk_widget_set_name (label359, "label359");
  gtk_widget_show (label359);
  gtk_box_pack_start (GTK_BOX (hbox250), label359, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label359, 30, -1);
  gtk_label_set_justify (GTK_LABEL (label359), GTK_JUSTIFY_LEFT);

  vbox59 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox59, "vbox59");
  gtk_widget_show (vbox59);
  gtk_box_pack_start (GTK_BOX (hbox250), vbox59, TRUE, TRUE, 0);

  hbox252 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox252, "hbox252");
  gtk_widget_show (hbox252);
  gtk_box_pack_start (GTK_BOX (vbox59), hbox252, TRUE, TRUE, 0);

  vbox62 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox62, "vbox62");
  gtk_widget_show (vbox62);
  gtk_box_pack_start (GTK_BOX (hbox252), vbox62, TRUE, TRUE, 0);

  label229 = gtk_label_new (_("Site:"));
  gtk_widget_set_name (label229, "label229");
  gtk_widget_show (label229);
  gtk_box_pack_start (GTK_BOX (vbox62), label229, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label229), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label229), 0, 0.5);

  label239 = gtk_label_new (_("Show dates:"));
  gtk_widget_set_name (label239, "label239");
  gtk_widget_show (label239);
  gtk_box_pack_start (GTK_BOX (vbox62), label239, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label239), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label239), 0, 0.5);

  label241 = gtk_label_new (_("Show current path:"));
  gtk_widget_set_name (label241, "label241");
  gtk_widget_show (label241);
  gtk_box_pack_start (GTK_BOX (vbox62), label241, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label241), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label241), 0, 0.5);

  label242 = gtk_label_new (_("Show filesize:"));
  gtk_widget_set_name (label242, "label242");
  gtk_widget_show (label242);
  gtk_box_pack_start (GTK_BOX (vbox62), label242, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label242), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label242), 0, 0.5);

  label243 = gtk_label_new (_("Change working directory:"));
  gtk_widget_set_name (label243, "label243");
  gtk_widget_show (label243);
  gtk_box_pack_start (GTK_BOX (vbox62), label243, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label243), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label243), 0, 0.5);

  label238 = gtk_label_new (_("Change mode:"));
  gtk_widget_set_name (label238, "label238");
  gtk_widget_show (label238);
  gtk_box_pack_start (GTK_BOX (vbox62), label238, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label238), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label238), 0, 0.5);

  label247 = gtk_label_new (_("Change group:"));
  gtk_widget_set_name (label247, "label247");
  gtk_widget_show (label247);
  gtk_box_pack_start (GTK_BOX (vbox62), label247, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label247), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label247), 0, 0.5);

  label249 = gtk_label_new (_("Cdup:"));
  gtk_widget_set_name (label249, "label249");
  gtk_widget_show (label249);
  gtk_box_pack_start (GTK_BOX (vbox62), label249, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label249), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label249), 0, 0.5);

  label248 = gtk_label_new (_("Show connection settings:"));
  gtk_widget_set_name (label248, "label248");
  gtk_widget_show (label248);
  gtk_box_pack_start (GTK_BOX (vbox62), label248, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label248), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label248), 0, 0.5);

  label362 = gtk_label_new ("");
  gtk_widget_set_name (label362, "label362");
  gtk_widget_show (label362);
  gtk_box_pack_start (GTK_BOX (hbox252), label362, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label362, 30, -1);
  gtk_label_set_justify (GTK_LABEL (label362), GTK_JUSTIFY_LEFT);

  vbox63 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox63, "vbox63");
  gtk_widget_show (vbox63);
  gtk_box_pack_start (GTK_BOX (hbox252), vbox63, TRUE, TRUE, 0);

  uldir_site_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (uldir_site_checkbutton, "uldir_site_checkbutton");
  gtk_widget_show (uldir_site_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox63), uldir_site_checkbutton, TRUE, TRUE, 0);

  uldir_showdate_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (uldir_showdate_checkbutton, "uldir_showdate_checkbutton");
  gtk_widget_show (uldir_showdate_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox63), uldir_showdate_checkbutton, TRUE, TRUE, 0);

  uldir_showwd_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (uldir_showwd_checkbutton, "uldir_showwd_checkbutton");
  gtk_widget_show (uldir_showwd_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox63), uldir_showwd_checkbutton, TRUE, TRUE, 0);

  uldir_showsize_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (uldir_showsize_checkbutton, "uldir_showsize_checkbutton");
  gtk_widget_show (uldir_showsize_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox63), uldir_showsize_checkbutton, TRUE, TRUE, 0);

  uldir_changewd_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (uldir_changewd_checkbutton, "uldir_changewd_checkbutton");
  gtk_widget_show (uldir_changewd_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox63), uldir_changewd_checkbutton, TRUE, TRUE, 0);

  uldir_chmod_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (uldir_chmod_checkbutton, "uldir_chmod_checkbutton");
  gtk_widget_show (uldir_chmod_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox63), uldir_chmod_checkbutton, TRUE, TRUE, 0);

  uldir_chgrp_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (uldir_chgrp_checkbutton, "uldir_chgrp_checkbutton");
  gtk_widget_show (uldir_chgrp_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox63), uldir_chgrp_checkbutton, TRUE, TRUE, 0);

  uldir_cdup_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (uldir_cdup_checkbutton, "uldir_cdup_checkbutton");
  gtk_widget_show (uldir_cdup_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox63), uldir_cdup_checkbutton, TRUE, TRUE, 0);

  uldir_stat_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_set_name (uldir_stat_checkbutton, "uldir_stat_checkbutton");
  gtk_widget_show (uldir_stat_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox63), uldir_stat_checkbutton, TRUE, TRUE, 0);

  label360 = gtk_label_new ("");
  gtk_widget_set_name (label360, "label360");
  gtk_widget_show (label360);
  gtk_box_pack_start (GTK_BOX (hbox250), label360, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label360, 30, -1);
  gtk_label_set_justify (GTK_LABEL (label360), GTK_JUSTIFY_LEFT);

  hseparator101 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator101, "hseparator101");
  gtk_widget_show (hseparator101);
  gtk_box_pack_start (GTK_BOX (uploaddir_vbox), hseparator101, TRUE, TRUE, 0);
  gtk_widget_set_size_request (hseparator101, -1, 10);

  hseparator32 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator32, "hseparator32");
  gtk_widget_show (hseparator32);
  gtk_box_pack_start (GTK_BOX (vbox16), hseparator32, FALSE, FALSE, 0);
  gtk_widget_set_size_request (hseparator32, -1, 20);

  hbuttonbox3 = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbuttonbox3, "hbuttonbox3");
  gtk_widget_show (hbuttonbox3);
  gtk_box_pack_start (GTK_BOX (vbox16), hbuttonbox3, FALSE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox3), GTK_BUTTONBOX_SPREAD);

  userdel_button = gtk_button_new ();
  gtk_widget_set_name (userdel_button, "userdel_button");
  gtk_widget_show (userdel_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox3), userdel_button);
  GTK_WIDGET_SET_FLAGS (userdel_button, GTK_CAN_DEFAULT);

  alignment29 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment29, "alignment29");
  gtk_widget_show (alignment29);
  gtk_container_add (GTK_CONTAINER (userdel_button), alignment29);

  hbox64 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox64, "hbox64");
  gtk_widget_show (hbox64);
  gtk_container_add (GTK_CONTAINER (alignment29), hbox64);

  image29 = gtk_image_new_from_stock ("gtk-remove", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image29, "image29");
  gtk_widget_show (image29);
  gtk_box_pack_start (GTK_BOX (hbox64), image29, TRUE, TRUE, 0);

  label124 = gtk_label_new_with_mnemonic (_("Delete"));
  gtk_widget_set_name (label124, "label124");
  gtk_widget_show (label124);
  gtk_box_pack_start (GTK_BOX (hbox64), label124, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label124), GTK_JUSTIFY_LEFT);

  userchange_button = gtk_button_new ();
  gtk_widget_set_name (userchange_button, "userchange_button");
  gtk_widget_show (userchange_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox3), userchange_button);
  GTK_WIDGET_SET_FLAGS (userchange_button, GTK_CAN_DEFAULT);

  alignment28 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment28, "alignment28");
  gtk_widget_show (alignment28);
  gtk_container_add (GTK_CONTAINER (userchange_button), alignment28);

  hbox63 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox63, "hbox63");
  gtk_widget_show (hbox63);
  gtk_container_add (GTK_CONTAINER (alignment28), hbox63);

  image28 = gtk_image_new_from_stock ("gtk-refresh", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image28, "image28");
  gtk_widget_show (image28);
  gtk_box_pack_start (GTK_BOX (hbox63), image28, TRUE, TRUE, 0);

  label123 = gtk_label_new_with_mnemonic (_("Change"));
  gtk_widget_set_name (label123, "label123");
  gtk_widget_show (label123);
  gtk_box_pack_start (GTK_BOX (hbox63), label123, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label123), GTK_JUSTIFY_LEFT);

  close_user_settings_button = gtk_button_new ();
  gtk_widget_set_name (close_user_settings_button, "close_user_settings_button");
  gtk_widget_show (close_user_settings_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox3), close_user_settings_button);
  GTK_WIDGET_SET_FLAGS (close_user_settings_button, GTK_CAN_DEFAULT);

  alignment26 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment26, "alignment26");
  gtk_widget_show (alignment26);
  gtk_container_add (GTK_CONTAINER (close_user_settings_button), alignment26);

  hbox61 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox61, "hbox61");
  gtk_widget_show (hbox61);
  gtk_container_add (GTK_CONTAINER (alignment26), hbox61);

  image26 = gtk_image_new_from_stock ("gtk-cancel", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image26, "image26");
  gtk_widget_show (image26);
  gtk_box_pack_start (GTK_BOX (hbox61), image26, TRUE, TRUE, 0);

  label121 = gtk_label_new_with_mnemonic (_("Close"));
  gtk_widget_set_name (label121, "label121");
  gtk_widget_show (label121);
  gtk_box_pack_start (GTK_BOX (hbox61), label121, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label121), GTK_JUSTIFY_LEFT);

  label365 = gtk_label_new ("");
  gtk_widget_set_name (label365, "label365");
  gtk_widget_show (label365);
  gtk_box_pack_start (GTK_BOX (vbox16), label365, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label365, -1, 5);
  gtk_label_set_justify (GTK_LABEL (label365), GTK_JUSTIFY_LEFT);

  g_signal_connect ((gpointer) userdel_button, "clicked",
                    G_CALLBACK (on_user_settings_delete_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) userchange_button, "clicked",
                    G_CALLBACK (on_user_settings_change_button_clicked),
                    NULL);
  g_signal_connect_swapped ((gpointer) close_user_settings_button, "clicked",
                            G_CALLBACK (gtk_widget_destroy),
                            GTK_OBJECT (user_settings_window));

  GLADE_HOOKUP_OBJECT_NO_REF (user_settings_window, user_settings_window, "user_settings_window");

  GLADE_HOOKUP_OBJECT (user_settings_window, settings_username_entry, "settings_username_entry");
  GLADE_HOOKUP_OBJECT (user_settings_window, settings_password_entry, "settings_password_entry");
  GLADE_HOOKUP_OBJECT (user_settings_window, settings_group_entry, "settings_group_entry");
  GLADE_HOOKUP_OBJECT (user_settings_window, settings_require_password_entry, "settings_require_password_entry");

  GLADE_HOOKUP_OBJECT (user_settings_window, combo17, "combo17");

  GLADE_HOOKUP_OBJECT (user_settings_window, settings_login_from_entry, "settings_login_from_entry");
  GLADE_HOOKUP_OBJECT (user_settings_window, settings_max_logins_spinbutton, "settings_max_logins_spinbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, settings_max_logins_entry, "settings_max_logins_entry");
  GLADE_HOOKUP_OBJECT (user_settings_window, settings_homedirectory_entry, "settings_homedirectory_entry");
  GLADE_HOOKUP_OBJECT (user_settings_window, gplock_checkbutton, "gplock_checkbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, banned_checkbutton, "banned_checkbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, settings_uploaddirectory_entry, "settings_uploaddirectory_entry");
  GLADE_HOOKUP_OBJECT (user_settings_window, uldir_list_checkbutton, "uldir_list_checkbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, uldir_upload_checkbutton, "uldir_upload_checkbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, uldir_append_checkbutton, "uldir_append_checkbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, uldir_download_checkbutton, "uldir_download_checkbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, uldir_rename_checkbutton, "uldir_rename_checkbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, uldir_delete_checkbutton, "uldir_delete_checkbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, uldir_createdir_checkbutton, "uldir_createdir_checkbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, uldir_removedir_checkbutton, "uldir_removedir_checkbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, uldir_site_checkbutton, "uldir_site_checkbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, uldir_showdate_checkbutton, "uldir_showdate_checkbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, uldir_showwd_checkbutton, "uldir_showwd_checkbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, uldir_showsize_checkbutton, "uldir_showsize_checkbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, uldir_changewd_checkbutton, "uldir_changewd_checkbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, uldir_chmod_checkbutton, "uldir_chmod_checkbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, uldir_chgrp_checkbutton, "uldir_chgrp_checkbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, uldir_cdup_checkbutton, "uldir_cdup_checkbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, uldir_stat_checkbutton, "uldir_stat_checkbutton");
  GLADE_HOOKUP_OBJECT (user_settings_window, userdel_button, "userdel_button");
  GLADE_HOOKUP_OBJECT (user_settings_window, userchange_button, "userchange_button");
  GLADE_HOOKUP_OBJECT (user_settings_window, close_user_settings_button, "close_user_settings_button");
  GLADE_HOOKUP_OBJECT_NO_REF (user_settings_window, tooltips, "tooltips");

  return user_settings_window;
}


GtkWidget*
create_credits_window (void)
{
  gchar *credits;

  GtkWidget *credits_window, *vbox1;
  GtkWidget *scrolledwindow1;
  GtkWidget *credits_textview;
  GtkWidget *close_credits_button;
  GtkWidget *alignment18, *hbox51;
  GtkWidget *image18, *label108;

  credits_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (credits_window, "credits_window");
  gtk_widget_set_size_request (credits_window, 400, 230);
  gtk_window_set_title (GTK_WINDOW (credits_window), _("About"));
  gtk_window_set_position (GTK_WINDOW (credits_window), GTK_WIN_POS_CENTER);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox1, "vbox1");
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (credits_window), vbox1);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow1, "scrolledwindow1");
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_SHADOW_ETCHED_OUT);

  credits_textview = gtk_text_view_new ();
  gtk_widget_set_name (credits_textview, "credits_textview");
  gtk_widget_show (credits_textview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), credits_textview);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (credits_textview), FALSE);
  gtk_text_view_set_justification (GTK_TEXT_VIEW (credits_textview), GTK_JUSTIFY_CENTER);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (credits_textview), FALSE);
  gtk_text_view_set_pixels_above_lines (GTK_TEXT_VIEW (credits_textview), 4);
  gtk_text_view_set_left_margin (GTK_TEXT_VIEW (credits_textview), 29);

  credits = g_strconcat(
  "\n",
  _("Author: "), "Magnus-swe <magnus-swe@telia.com>\n",
  "\n",
  _("I want to thank the following for their contributions:"),
  "\n-------------------------------------------------------------------------\n",
  "Nestor Diaz ", _("for the icons and the weblogo.\n"),
  "Julle ", _("for coding support and testing.\n"),
  _("The people at the GTK+ development lists.\n"),
  "Marcus von Appen <marcus@sysfault.org>\n",
  "Rudolf Kastl <che666@uni.de> ", _("for the RPM spec file."),
  "\n\n",
  _("And all translators:"),
  "\n-------------------------------------------------------------------------\n",
  _("Afrikaans"), " (af) NAME <EMAIL>\n",
  _("Amharic"), " (am) NAME <EMAIL>\n",
  _("Arabic"), " (ar) NAME <EMAIL>\n",
  _("Azerbaijani"), " (az) NAME <EMAIL>\n",
  
  _("Basque"), " (eu) NAME <EMAIL>\n",
  _("Bulgarian"), " (bg) NAME <EMAIL>\n",
  _("Breton"), " (br) NAME <EMAIL>\n",
  _("Brittish-English"), " (en_GB) NAME <EMAIL>\n",
  _("Bosnian"), " (bs) NAME <EMAIL>\n",
  _("Byelorussian"), " (be) NAME <EMAIL>\n",

  _("Catalan"), " (ca) NAME <EMAIL>\n",
  _("Chinese"), " (zh_CN) Stanley Peng <stanleypng@gmail.com>\n",
  _("Chinese-Taiwan"), " (zh_TW) NAME <EMAIL>\n",
  _("Croatian"), " (hr) NAME <EMAIL>\n",
  _("Czech"), " (cs) NAME <EMAIL>\n",

  _("Danish"), " (dk) NAME <EMAIL>\n",
  _("Dutch"), " (nl) NAME <EMAIL>\n",

  _("Esperanto"), " (eo) NAME <EMAIL>\n",
  _("Estonian"), " (et) NAME <EMAIL>\n",

  _("Finnish"), " (fi) NAME <EMAIL>\n",
  _("French"), " (fr) NAME <EMAIL>\n",

  _("Galician"), " (gl) NAME <EMAIL>\n",
  _("German"), " (de) NAME <EMAIL>\n",
  _("Greek"), " (el) NAME <EMAIL>\n",

  _("Hebrew"), " (he) NAME <EMAIL>\n",
  _("Hini"), " (hi) NAME <EMAIL>\n",
  _("Hungarian"), " (hu) NAME <EMAIL>\n",

  _("Icelandic"), " (is) NAME <EMAIL>\n",
  _("Indonesian"), " (id) NAME <EMAIL>\n",
  _("Irish"), " (ga) NAME <EMAIL>\n",
  _("Italian"), " (it) NAME <EMAIL>\n",

  _("Japanese"), " (ja) NAME <EMAIL>\n",
  _("Korean"), " (ko) NAME <EMAIL>\n",
  _("Kurdish"), " (ku) NAME <EMAIL>\n",

  _("Latvian-Lettish"), " (lv) NAME <EMAIL>\n",
  _("Lithuanian"), " (lt) NAME <EMAIL>\n",

  _("Macedonian"), " (mk) NAME <EMAIL>\n",
  _("Maori"), " (mi) NAME <EMAIL>\n",
  _("Macedonian"), " (mk) NAME <EMAIL>\n",
  _("Maltese"), " (mt) NAME <EMAIL>\n",

  _("Norwegian"), " (no) NAME <EMAIL>\n",

  _("Polish"), " (pl) NAME <EMAIL>\n",
  _("Portuguese"), " (pt) NAME <EMAIL>\n",
  _("Portuguese-Brazil"), " (pt_BR) NAME <EMAIL>\n",

  _("Romanian"), " (ro) NAME <EMAIL>\n",
  _("Russian"), " (ru) NAME <EMAIL>\n",

  _("Serbian"), " (sr) NAME <EMAIL>\n",
  _("Slovak"), " (sk) NAME <EMAIL>\n",
  _("Slovenian"), " (sl) NAME <EMAIL>\n",
  _("Spanish"), " (es) Diego Escalante <dieguito@gmail.com>\n",
  _("Swedish"), " (sv) Magnus-swe <magnus-swe@telia.com>\n",

  _("Tamil"), " (ta) NAME <EMAIL>\n",
  _("Thai"), " (th) NAME <EMAIL>\n",
  _("Turkish"), " (tr) NAME <EMAIL>\n",
  _("Traditional Chinese"), " (zh_TW) NAME <EMAIL>\n",

  _("Ukrainian"), " (uk) NAME <EMAIL>\n",

  _("Vietnamese"), " (vi) NAME <EMAIL>\n",
  _("Wallon"), " (wa) NAME <EMAIL>\n",
  _("Welch"), " (cy) NAME <EMAIL>\n",
  "\n",
  _("And a big thanks to the Proftpd team.\n"), NULL); 
  
  gtk_text_buffer_set_text (gtk_text_view_get_buffer (GTK_TEXT_VIEW (credits_textview)), credits, -1);

  if( credits!=NULL )
    g_free(credits);

  close_credits_button = gtk_button_new ();
  gtk_widget_set_name (close_credits_button, "close_credits_button");
  gtk_widget_show (close_credits_button);
  gtk_box_pack_start (GTK_BOX (vbox1), close_credits_button, FALSE, FALSE, 0);

  alignment18 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment18, "alignment18");
  gtk_widget_show (alignment18);
  gtk_container_add (GTK_CONTAINER (close_credits_button), alignment18);

  hbox51 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox51, "hbox51");
  gtk_widget_show (hbox51);
  gtk_container_add (GTK_CONTAINER (alignment18), hbox51);

  image18 = gtk_image_new_from_stock ("gtk-close", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image18, "image18");
  gtk_widget_show (image18);
  gtk_box_pack_start (GTK_BOX (hbox51), image18, FALSE, FALSE, 0);

  label108 = gtk_label_new_with_mnemonic (_("Close"));
  gtk_widget_set_name (label108, "label108");
  gtk_widget_show (label108);
  gtk_box_pack_start (GTK_BOX (hbox51), label108, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label108), GTK_JUSTIFY_LEFT);

  g_signal_connect_swapped ((gpointer) close_credits_button, "clicked",
                            G_CALLBACK (gtk_widget_destroy),
                            GTK_OBJECT (credits_window));

  GLADE_HOOKUP_OBJECT_NO_REF (credits_window, credits_window, "credits_window");
  GLADE_HOOKUP_OBJECT (credits_window, credits_textview, "credits_textview");
  GLADE_HOOKUP_OBJECT (credits_window, close_credits_button, "close_credits_button");

  return credits_window;
}


GtkWidget*
create_userdir_selection (void)
{
  GtkWidget *userdir_selection;
  GtkWidget *userdir_select_ok_button;
  GtkWidget *userdir_select_cancel_button;

  userdir_selection = gtk_file_selection_new (_("Choose the users root directory"));
  gtk_widget_set_name (userdir_selection, "userdir_selection");
  gtk_widget_set_size_request (userdir_selection, 560, 400);
  gtk_container_set_border_width (GTK_CONTAINER (userdir_selection), 10);
  gtk_window_set_position (GTK_WINDOW (userdir_selection), GTK_WIN_POS_CENTER);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (userdir_selection));

  userdir_select_ok_button = GTK_FILE_SELECTION (userdir_selection)->ok_button;
  gtk_widget_set_name (userdir_select_ok_button, "userdir_select_ok_button");
  gtk_widget_show (userdir_select_ok_button);
  GTK_WIDGET_SET_FLAGS (userdir_select_ok_button, GTK_CAN_DEFAULT);

  userdir_select_cancel_button = GTK_FILE_SELECTION (userdir_selection)->cancel_button;
  gtk_widget_set_name (userdir_select_cancel_button, "userdir_select_cancel_button");
  gtk_widget_show (userdir_select_cancel_button);
  GTK_WIDGET_SET_FLAGS (userdir_select_cancel_button, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) userdir_select_ok_button, "clicked",
                    G_CALLBACK (on_userdir_select_ok_button_clicked),
                    NULL);
  g_signal_connect_swapped ((gpointer) userdir_select_cancel_button, "clicked",
                            G_CALLBACK (gtk_widget_destroy),
                            GTK_OBJECT (userdir_selection));

  GLADE_HOOKUP_OBJECT_NO_REF (userdir_selection, userdir_selection, "userdir_selection");
  GLADE_HOOKUP_OBJECT_NO_REF (userdir_selection, userdir_select_ok_button, "userdir_select_ok_button");
  GLADE_HOOKUP_OBJECT_NO_REF (userdir_selection, userdir_select_cancel_button, "userdir_select_cancel_button");

  return userdir_selection;
}


GtkWidget*
create_useradd_incoming_selection (void)
{
  GtkWidget *useradd_incoming_selection;
  GtkWidget *incoming_directory_ok_button;
  GtkWidget *incoming_directory_cancel_button;

  useradd_incoming_selection = gtk_file_selection_new (_("Choose an upload directory (must be below the users directory)"));
  gtk_widget_set_name (useradd_incoming_selection, "useradd_incoming_selection");
  gtk_widget_set_size_request (useradd_incoming_selection, 560, 400);
  gtk_container_set_border_width (GTK_CONTAINER (useradd_incoming_selection), 10);
  gtk_window_set_position (GTK_WINDOW (useradd_incoming_selection), GTK_WIN_POS_CENTER);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (useradd_incoming_selection));

  incoming_directory_ok_button = GTK_FILE_SELECTION (useradd_incoming_selection)->ok_button;
  gtk_widget_set_name (incoming_directory_ok_button, "incoming_directory_ok_button");
  gtk_widget_show (incoming_directory_ok_button);
  GTK_WIDGET_SET_FLAGS (incoming_directory_ok_button, GTK_CAN_DEFAULT);

  incoming_directory_cancel_button = GTK_FILE_SELECTION (useradd_incoming_selection)->cancel_button;
  gtk_widget_set_name (incoming_directory_cancel_button, "incoming_directory_cancel_button");
  gtk_widget_show (incoming_directory_cancel_button);
  GTK_WIDGET_SET_FLAGS (incoming_directory_cancel_button, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) incoming_directory_ok_button, "clicked",
                    G_CALLBACK (on_incoming_directory_ok_button_clicked),
                    NULL);
  g_signal_connect_swapped ((gpointer) incoming_directory_cancel_button, "clicked",
                            G_CALLBACK (gtk_widget_destroy),
                            GTK_OBJECT (useradd_incoming_selection));

  GLADE_HOOKUP_OBJECT_NO_REF (useradd_incoming_selection, useradd_incoming_selection, "useradd_incoming_selection");
  GLADE_HOOKUP_OBJECT_NO_REF (useradd_incoming_selection, incoming_directory_ok_button, "incoming_directory_ok_button");
  GLADE_HOOKUP_OBJECT_NO_REF (useradd_incoming_selection, incoming_directory_cancel_button, "incoming_directory_cancel_button");

  return useradd_incoming_selection;
}


GtkWidget*
create_default_question_window (void)
{
  GtkWidget *default_question_window;
  GtkWidget *vbox18, *label182;
  GtkWidget *scrolledwindow18;
  GtkWidget *default_question_textview;
  GtkWidget *hbuttonbox11;
  GtkWidget *yes_default_question_button;
  GtkWidget *alignment44, *hbox98;
  GtkWidget *image44, *label184;
  GtkWidget *no_default_question_button;
  GtkWidget *alignment45, *hbox99;
  GtkWidget *image45, *label185;

  default_question_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (default_question_window, "default_question_window");
  gtk_widget_set_size_request (default_question_window, 370, 319);
  gtk_window_set_title (GTK_WINDOW (default_question_window), _("GProftpd question"));
  gtk_window_set_position (GTK_WINDOW (default_question_window), GTK_WIN_POS_CENTER);

  vbox18 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox18, "vbox18");
  gtk_widget_show (vbox18);
  gtk_container_add (GTK_CONTAINER (default_question_window), vbox18);

  label182 = gtk_label_new ("");
  gtk_widget_set_name (label182, "label182");
  gtk_widget_show (label182);
  gtk_box_pack_start (GTK_BOX (vbox18), label182, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label182, -1, 20);
  gtk_label_set_justify (GTK_LABEL (label182), GTK_JUSTIFY_LEFT);

  scrolledwindow18 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow18, "scrolledwindow18");
  gtk_widget_show (scrolledwindow18);
  gtk_box_pack_start (GTK_BOX (vbox18), scrolledwindow18, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow18), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  default_question_textview = gtk_text_view_new ();
  gtk_widget_set_name (default_question_textview, "default_question_textview");
  gtk_widget_show (default_question_textview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow18), default_question_textview);
  gtk_widget_set_size_request (default_question_textview, 156, 260);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (default_question_textview), FALSE);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (default_question_textview), FALSE);
  gtk_text_view_set_pixels_above_lines (GTK_TEXT_VIEW (default_question_textview), 3);
  gtk_text_view_set_left_margin (GTK_TEXT_VIEW (default_question_textview), 30);
  gtk_text_buffer_set_text (gtk_text_view_get_buffer (GTK_TEXT_VIEW (default_question_textview)),
	_("GProftpd could not find proftpd.conf or you are using\nthe basic configuration wich doesnt have all features\nthat gproftpd's default configuration has.\n\nIf you use proftpd's default configuration and dont\nwant to see this question again, take away the line:\n# Port 21 is the standard ftp port.\n\nDo you want to overwrite proftpd.conf with GProftpd's\ndefault configuration ?\n\n              (If you dont know then press yes)\n"), -1);

  hbuttonbox11 = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbuttonbox11, "hbuttonbox11");
  gtk_widget_show (hbuttonbox11);
  gtk_box_pack_start (GTK_BOX (vbox18), hbuttonbox11, FALSE, FALSE, 0);
  gtk_widget_set_size_request (hbuttonbox11, -1, 40);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox11), GTK_BUTTONBOX_SPREAD);

  yes_default_question_button = gtk_button_new ();
  gtk_widget_set_name (yes_default_question_button, "yes_default_question_button");
  gtk_widget_show (yes_default_question_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox11), yes_default_question_button);
  GTK_WIDGET_SET_FLAGS (yes_default_question_button, GTK_CAN_DEFAULT);

  alignment44 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment44, "alignment44");
  gtk_widget_show (alignment44);
  gtk_container_add (GTK_CONTAINER (yes_default_question_button), alignment44);

  hbox98 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox98, "hbox98");
  gtk_widget_show (hbox98);
  gtk_container_add (GTK_CONTAINER (alignment44), hbox98);

  image44 = gtk_image_new_from_stock ("gtk-yes", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image44, "image44");
  gtk_widget_show (image44);
  gtk_box_pack_start (GTK_BOX (hbox98), image44, FALSE, FALSE, 0);

  label184 = gtk_label_new_with_mnemonic (_("Yes"));
  gtk_widget_set_name (label184, "label184");
  gtk_widget_show (label184);
  gtk_box_pack_start (GTK_BOX (hbox98), label184, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label184), GTK_JUSTIFY_LEFT);

  no_default_question_button = gtk_button_new ();
  gtk_widget_set_name (no_default_question_button, "no_default_question_button");
  gtk_widget_show (no_default_question_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox11), no_default_question_button);
  GTK_WIDGET_SET_FLAGS (no_default_question_button, GTK_CAN_DEFAULT);

  alignment45 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment45, "alignment45");
  gtk_widget_show (alignment45);
  gtk_container_add (GTK_CONTAINER (no_default_question_button), alignment45);

  hbox99 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox99, "hbox99");
  gtk_widget_show (hbox99);
  gtk_container_add (GTK_CONTAINER (alignment45), hbox99);

  image45 = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image45, "image45");
  gtk_widget_show (image45);
  gtk_box_pack_start (GTK_BOX (hbox99), image45, FALSE, FALSE, 0);

  label185 = gtk_label_new_with_mnemonic (_("No"));
  gtk_widget_set_name (label185, "label185");
  gtk_widget_show (label185);
  gtk_box_pack_start (GTK_BOX (hbox99), label185, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label185), GTK_JUSTIFY_LEFT);

  g_signal_connect ((gpointer) yes_default_question_button, "clicked",
                    G_CALLBACK (on_yes_default_question_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) no_default_question_button, "clicked",
                    G_CALLBACK (on_no_default_question_button_clicked),
                    NULL);

  GLADE_HOOKUP_OBJECT_NO_REF (default_question_window, default_question_window, "default_question_window");
  GLADE_HOOKUP_OBJECT (default_question_window, default_question_textview, "default_question_textview");
  GLADE_HOOKUP_OBJECT (default_question_window, yes_default_question_button, "yes_default_question_button");
  GLADE_HOOKUP_OBJECT (default_question_window, no_default_question_button, "no_default_question_button");

  return default_question_window;
}


GtkWidget*
create_password_question_window (void)
{
  GtkWidget *password_question_window;
  GtkWidget *vbox25, *label284;
  GtkWidget *hbox222, *label285;
  GtkWidget *vbox27, *hbox223;
  GtkWidget *vbox28, *label292;
  GtkWidget *label296, *vbox29;
  GtkWidget *password_change_username_entry;
  GtkWidget *password_change_password_entry;
  GtkWidget *label286, *label289;
  GtkWidget *hbuttonbox12;
  GtkWidget *change_password_button;
  GtkWidget *alignment48, *hbox228;
  GtkWidget *image48, *label303;
  GtkWidget *dont_change_password_button;
  GtkWidget *alignment47, *hbox227;
  GtkWidget *image47, *label302;

  password_question_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (password_question_window, "password_question_window");
  gtk_window_set_title (GTK_WINDOW (password_question_window), _("GProFTPD Password"));
  gtk_window_set_position (GTK_WINDOW (password_question_window), GTK_WIN_POS_CENTER);

  vbox25 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox25, "vbox25");
  gtk_widget_show (vbox25);
  gtk_container_add (GTK_CONTAINER (password_question_window), vbox25);

  label284 = gtk_label_new (_("This user already existed in the system."));
  gtk_widget_set_name (label284, "label284");
  gtk_widget_show (label284);
  gtk_box_pack_start (GTK_BOX (vbox25), label284, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label284, -1, 30);
  gtk_label_set_justify (GTK_LABEL (label284), GTK_JUSTIFY_LEFT);

  hbox222 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox222, "hbox222");
  gtk_widget_show (hbox222);
  gtk_box_pack_start (GTK_BOX (vbox25), hbox222, TRUE, TRUE, 0);

  label285 = gtk_label_new ("");
  gtk_widget_set_name (label285, "label285");
  gtk_widget_show (label285);
  gtk_box_pack_start (GTK_BOX (hbox222), label285, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label285, 30, -1);
  gtk_label_set_justify (GTK_LABEL (label285), GTK_JUSTIFY_LEFT);

  vbox27 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox27, "vbox27");
  gtk_widget_show (vbox27);
  gtk_box_pack_start (GTK_BOX (hbox222), vbox27, TRUE, TRUE, 0);

  hbox223 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox223, "hbox223");
  gtk_widget_show (hbox223);
  gtk_box_pack_start (GTK_BOX (vbox27), hbox223, TRUE, TRUE, 0);

  vbox28 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox28, "vbox28");
  gtk_widget_show (vbox28);
  gtk_box_pack_start (GTK_BOX (hbox223), vbox28, FALSE, FALSE, 0);

  label292 = gtk_label_new (_("Username:"));
  gtk_widget_set_name (label292, "label292");
  gtk_widget_show (label292);
  gtk_box_pack_start (GTK_BOX (vbox28), label292, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label292, -1, 26);
  gtk_label_set_justify (GTK_LABEL (label292), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label292), 0, 0.5);

  label296 = gtk_label_new (_("New password: "));
  gtk_widget_set_name (label296, "label296");
  gtk_widget_show (label296);
  gtk_box_pack_start (GTK_BOX (vbox28), label296, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label296, -1, 26);
  gtk_label_set_justify (GTK_LABEL (label296), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label296), 0, 0.5);

  vbox29 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox29, "vbox29");
  gtk_widget_show (vbox29);
  gtk_box_pack_start (GTK_BOX (hbox223), vbox29, TRUE, TRUE, 0);

  password_change_username_entry = gtk_entry_new ();
  gtk_widget_set_name (password_change_username_entry, "password_change_username_entry");
  gtk_widget_show (password_change_username_entry);
  gtk_box_pack_start (GTK_BOX (vbox29), password_change_username_entry, FALSE, FALSE, 0);
  gtk_widget_set_sensitive (password_change_username_entry, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (password_change_username_entry), FALSE);

  password_change_password_entry = gtk_entry_new ();
  gtk_widget_set_name (password_change_password_entry, "password_change_password_entry");
  gtk_widget_show (password_change_password_entry);
  gtk_box_pack_start (GTK_BOX (vbox29), password_change_password_entry, FALSE, FALSE, 0);

  label286 = gtk_label_new ("");
  gtk_widget_set_name (label286, "label286");
  gtk_widget_show (label286);
  gtk_box_pack_start (GTK_BOX (hbox222), label286, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label286, 90, -1);
  gtk_label_set_justify (GTK_LABEL (label286), GTK_JUSTIFY_LEFT);

  label289 = gtk_label_new (_("Do you want to change the users password ?"));
  gtk_widget_set_name (label289, "label289");
  gtk_widget_show (label289);
  gtk_box_pack_start (GTK_BOX (vbox25), label289, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label289, -1, 30);
  gtk_label_set_justify (GTK_LABEL (label289), GTK_JUSTIFY_LEFT);

  hbuttonbox12 = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbuttonbox12, "hbuttonbox12");
  gtk_widget_show (hbuttonbox12);
  gtk_box_pack_start (GTK_BOX (vbox25), hbuttonbox12, FALSE, FALSE, 0);
  gtk_widget_set_size_request (hbuttonbox12, -1, 50);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox12), GTK_BUTTONBOX_SPREAD);

  change_password_button = gtk_button_new ();
  gtk_widget_set_name (change_password_button, "change_password_button");
  gtk_widget_show (change_password_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox12), change_password_button);
  GTK_WIDGET_SET_FLAGS (change_password_button, GTK_CAN_DEFAULT);

  alignment48 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment48, "alignment48");
  gtk_widget_show (alignment48);
  gtk_container_add (GTK_CONTAINER (change_password_button), alignment48);

  hbox228 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox228, "hbox228");
  gtk_widget_show (hbox228);
  gtk_container_add (GTK_CONTAINER (alignment48), hbox228);

  image48 = gtk_image_new_from_stock ("gtk-yes", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image48, "image48");
  gtk_widget_show (image48);
  gtk_box_pack_start (GTK_BOX (hbox228), image48, FALSE, FALSE, 0);

  label303 = gtk_label_new_with_mnemonic (_("Change"));
  gtk_widget_set_name (label303, "label303");
  gtk_widget_show (label303);
  gtk_box_pack_start (GTK_BOX (hbox228), label303, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label303), GTK_JUSTIFY_LEFT);

  dont_change_password_button = gtk_button_new ();
  gtk_widget_set_name (dont_change_password_button, "dont_change_password_button");
  gtk_widget_show (dont_change_password_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox12), dont_change_password_button);
  GTK_WIDGET_SET_FLAGS (dont_change_password_button, GTK_CAN_DEFAULT);

  alignment47 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment47, "alignment47");
  gtk_widget_show (alignment47);
  gtk_container_add (GTK_CONTAINER (dont_change_password_button), alignment47);

  hbox227 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox227, "hbox227");
  gtk_widget_show (hbox227);
  gtk_container_add (GTK_CONTAINER (alignment47), hbox227);

  image47 = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image47, "image47");
  gtk_widget_show (image47);
  gtk_box_pack_start (GTK_BOX (hbox227), image47, FALSE, FALSE, 0);

  label302 = gtk_label_new_with_mnemonic (_("Dont change"));
  gtk_widget_set_name (label302, "label302");
  gtk_widget_show (label302);
  gtk_box_pack_start (GTK_BOX (hbox227), label302, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label302), GTK_JUSTIFY_LEFT);

  g_signal_connect ((gpointer) change_password_button, "clicked",
                    G_CALLBACK (on_change_password_button_clicked),
                    NULL);
  g_signal_connect_swapped ((gpointer) dont_change_password_button, "clicked",
                            G_CALLBACK (gtk_widget_destroy),
                            GTK_OBJECT (password_question_window));

  GLADE_HOOKUP_OBJECT_NO_REF (password_question_window, password_question_window, "password_question_window");
  GLADE_HOOKUP_OBJECT (password_question_window, password_change_username_entry, "password_change_username_entry");
  GLADE_HOOKUP_OBJECT (password_question_window, password_change_password_entry, "password_change_password_entry");
  GLADE_HOOKUP_OBJECT (password_question_window, change_password_button, "change_password_button");
  GLADE_HOOKUP_OBJECT (password_question_window, dont_change_password_button, "dont_change_password_button");

  return password_question_window;
}


GtkWidget*
create_userdel_question_window (void)
{
  GtkWidget *userdel_question_window;
  GtkWidget *vbox31, *label297, *hbox225;
  GtkWidget *label298, *label299;
  GtkWidget *userdel_question_entry;
  GtkWidget *label300, *hbuttonbox13;
  GtkWidget *question_userdel_cancel_button;
  GtkWidget *alignment49, *hbox229;
  GtkWidget *image49, *label304;
  GtkWidget *question_userdel_delete_button;
  GtkWidget *alignment50, *hbox230, *image50, *label305;

  userdel_question_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (userdel_question_window, "userdel_question_window");
  gtk_window_set_title (GTK_WINDOW (userdel_question_window), _("Delete the system user ?"));
  gtk_window_set_position (GTK_WINDOW (userdel_question_window), GTK_WIN_POS_CENTER);

  vbox31 = gtk_vbox_new (TRUE, 0);
  gtk_widget_set_name (vbox31, "vbox31");
  gtk_widget_show (vbox31);
  gtk_container_add (GTK_CONTAINER (userdel_question_window), vbox31);

  label297 = gtk_label_new (_("Do you also want to delete the system user ?"));
  gtk_widget_set_name (label297, "label297");
  gtk_widget_show (label297);
  gtk_box_pack_start (GTK_BOX (vbox31), label297, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label297), GTK_JUSTIFY_LEFT);

  hbox225 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox225, "hbox225");
  gtk_widget_show (hbox225);
  gtk_box_pack_start (GTK_BOX (vbox31), hbox225, FALSE, FALSE, 0);

  label298 = gtk_label_new ("");
  gtk_widget_set_name (label298, "label298");
  gtk_widget_show (label298);
  gtk_box_pack_start (GTK_BOX (hbox225), label298, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label298, 30, -1);
  gtk_label_set_justify (GTK_LABEL (label298), GTK_JUSTIFY_LEFT);

  label299 = gtk_label_new (_("Username: "));
  gtk_widget_set_name (label299, "label299");
  gtk_widget_show (label299);
  gtk_box_pack_start (GTK_BOX (hbox225), label299, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label299), GTK_JUSTIFY_LEFT);

  userdel_question_entry = gtk_entry_new ();
  gtk_widget_set_name (userdel_question_entry, "userdel_question_entry");
  gtk_widget_show (userdel_question_entry);
  gtk_box_pack_start (GTK_BOX (hbox225), userdel_question_entry, TRUE, TRUE, 0);
  gtk_widget_set_sensitive (userdel_question_entry, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (userdel_question_entry), FALSE);

  label300 = gtk_label_new ("");
  gtk_widget_set_name (label300, "label300");
  gtk_widget_show (label300);
  gtk_box_pack_start (GTK_BOX (hbox225), label300, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label300, 90, -1);
  gtk_label_set_justify (GTK_LABEL (label300), GTK_JUSTIFY_LEFT);

  hbuttonbox13 = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbuttonbox13, "hbuttonbox13");
  gtk_widget_show (hbuttonbox13);
  gtk_box_pack_start (GTK_BOX (vbox31), hbuttonbox13, FALSE, FALSE, 0);
  gtk_widget_set_size_request (hbuttonbox13, -1, 40);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox13), GTK_BUTTONBOX_SPREAD);

  question_userdel_cancel_button = gtk_button_new ();
  gtk_widget_set_name (question_userdel_cancel_button, "question_userdel_cancel_button");
  gtk_widget_show (question_userdel_cancel_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox13), question_userdel_cancel_button);
  GTK_WIDGET_SET_FLAGS (question_userdel_cancel_button, GTK_CAN_DEFAULT);

  alignment49 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment49, "alignment49");
  gtk_widget_show (alignment49);
  gtk_container_add (GTK_CONTAINER (question_userdel_cancel_button), alignment49);

  hbox229 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox229, "hbox229");
  gtk_widget_show (hbox229);
  gtk_container_add (GTK_CONTAINER (alignment49), hbox229);

  image49 = gtk_image_new_from_stock ("gtk-cancel", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image49, "image49");
  gtk_widget_show (image49);
  gtk_box_pack_start (GTK_BOX (hbox229), image49, FALSE, FALSE, 0);

  label304 = gtk_label_new_with_mnemonic (_("No"));
  gtk_widget_set_name (label304, "label304");
  gtk_widget_show (label304);
  gtk_box_pack_start (GTK_BOX (hbox229), label304, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label304), GTK_JUSTIFY_LEFT);

  question_userdel_delete_button = gtk_button_new ();
  gtk_widget_set_name (question_userdel_delete_button, "question_userdel_delete_button");
  gtk_widget_show (question_userdel_delete_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox13), question_userdel_delete_button);
  GTK_WIDGET_SET_FLAGS (question_userdel_delete_button, GTK_CAN_DEFAULT);

  alignment50 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment50, "alignment50");
  gtk_widget_show (alignment50);
  gtk_container_add (GTK_CONTAINER (question_userdel_delete_button), alignment50);

  hbox230 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox230, "hbox230");
  gtk_widget_show (hbox230);
  gtk_container_add (GTK_CONTAINER (alignment50), hbox230);

  image50 = gtk_image_new_from_stock ("gtk-remove", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image50, "image50");
  gtk_widget_show (image50);
  gtk_box_pack_start (GTK_BOX (hbox230), image50, FALSE, FALSE, 0);

  label305 = gtk_label_new_with_mnemonic (_("Delete"));
  gtk_widget_set_name (label305, "label305");
  gtk_widget_show (label305);
  gtk_box_pack_start (GTK_BOX (hbox230), label305, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label305), GTK_JUSTIFY_LEFT);

  g_signal_connect_swapped ((gpointer) question_userdel_cancel_button, "clicked",
                            G_CALLBACK (gtk_widget_destroy),
                            GTK_OBJECT (userdel_question_window));
  g_signal_connect ((gpointer) question_userdel_delete_button, "clicked",
                    G_CALLBACK (on_question_userdel_delete_button_clicked),
                    NULL);

  GLADE_HOOKUP_OBJECT_NO_REF (userdel_question_window, userdel_question_window, "userdel_question_window");
  GLADE_HOOKUP_OBJECT (userdel_question_window, userdel_question_entry, "userdel_question_entry");
  GLADE_HOOKUP_OBJECT (userdel_question_window, question_userdel_cancel_button, "question_userdel_cancel_button");
  GLADE_HOOKUP_OBJECT (userdel_question_window, question_userdel_delete_button, "question_userdel_delete_button");

  return userdel_question_window;
}


GtkWidget*
create_add_systemuser_question_window (void)
{
  GtkWidget *add_systemuser_question_window;
  GtkWidget *vbox64, *label374;
  GtkWidget *hbox253, *label375;
  GtkWidget *add_systemuser_entry;
  GtkWidget *label376, *label380;
  GtkWidget *hbuttonbox14;
  GtkWidget *add_systemuser_no_button;
  GtkWidget *alignment51, *hbox254;
  GtkWidget *image51, *label378;
  GtkWidget *add_systemuser_yes_button;
  GtkWidget *alignment52, *hbox255;
  GtkWidget *image52, *label379;

  add_systemuser_question_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (add_systemuser_question_window, "add_systemuser_question_window");
  gtk_window_set_title (GTK_WINDOW (add_systemuser_question_window), _("Add this needed master ftpuser ?"));
  gtk_window_set_position (GTK_WINDOW (add_systemuser_question_window), GTK_WIN_POS_CENTER);

  vbox64 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox64, "vbox64");
  gtk_widget_show (vbox64);
  gtk_container_add (GTK_CONTAINER (add_systemuser_question_window), vbox64);

  label374 = gtk_label_new (_("GProftpd needs to add the user and group the server will runs as."));
  gtk_widget_set_name (label374, "label374");
  gtk_widget_show (label374);
  gtk_box_pack_start (GTK_BOX (vbox64), label374, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label374, 422, -1);
  gtk_label_set_justify (GTK_LABEL (label374), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label374), 0, 10);

  hbox253 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox253, "hbox253");
  gtk_widget_show (hbox253);
  gtk_box_pack_start (GTK_BOX (vbox64), hbox253, TRUE, TRUE, 0);

  label375 = gtk_label_new (_("User and groupname:"));
  gtk_widget_set_name (label375, "label375");
  gtk_widget_show (label375);
  gtk_box_pack_start (GTK_BOX (hbox253), label375, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label375), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label375), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label375), 10, 0);

  add_systemuser_entry = gtk_entry_new ();
  gtk_widget_set_name (add_systemuser_entry, "add_systemuser_entry");
  gtk_widget_show (add_systemuser_entry);
  gtk_box_pack_start (GTK_BOX (hbox253), add_systemuser_entry, TRUE, TRUE, 0);
  gtk_widget_set_sensitive (add_systemuser_entry, FALSE);
  gtk_editable_set_editable (GTK_EDITABLE (add_systemuser_entry), FALSE);

  label376 = gtk_label_new ("");
  gtk_widget_set_name (label376, "label376");
  gtk_widget_show (label376);
  gtk_box_pack_end (GTK_BOX (hbox253), label376, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label376), GTK_JUSTIFY_LEFT);

  label380 = gtk_label_new (_("This action is necessary, do you want to do it ?"));
  gtk_widget_set_name (label380, "label380");
  gtk_widget_show (label380);
  gtk_box_pack_start (GTK_BOX (vbox64), label380, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label380, -1, 30);
  gtk_label_set_justify (GTK_LABEL (label380), GTK_JUSTIFY_LEFT);

  hbuttonbox14 = gtk_hbutton_box_new ();
  gtk_widget_set_name (hbuttonbox14, "hbuttonbox14");
  gtk_widget_show (hbuttonbox14);
  gtk_box_pack_start (GTK_BOX (vbox64), hbuttonbox14, FALSE, FALSE, 0);
  gtk_widget_set_size_request (hbuttonbox14, -1, 40);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox14), GTK_BUTTONBOX_SPREAD);

  add_systemuser_no_button = gtk_button_new ();
  gtk_widget_set_name (add_systemuser_no_button, "add_systemuser_no_button");
  gtk_widget_show (add_systemuser_no_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox14), add_systemuser_no_button);
  GTK_WIDGET_SET_FLAGS (add_systemuser_no_button, GTK_CAN_DEFAULT);

  alignment51 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment51, "alignment51");
  gtk_widget_show (alignment51);
  gtk_container_add (GTK_CONTAINER (add_systemuser_no_button), alignment51);

  hbox254 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox254, "hbox254");
  gtk_widget_show (hbox254);
  gtk_container_add (GTK_CONTAINER (alignment51), hbox254);

  image51 = gtk_image_new_from_stock ("gtk-cancel", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image51, "image51");
  gtk_widget_show (image51);
  gtk_box_pack_start (GTK_BOX (hbox254), image51, FALSE, FALSE, 0);

  label378 = gtk_label_new_with_mnemonic (_("No"));
  gtk_widget_set_name (label378, "label378");
  gtk_widget_show (label378);
  gtk_box_pack_start (GTK_BOX (hbox254), label378, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label378), GTK_JUSTIFY_LEFT);

  add_systemuser_yes_button = gtk_button_new ();
  gtk_widget_set_name (add_systemuser_yes_button, "add_systemuser_yes_button");
  gtk_widget_show (add_systemuser_yes_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox14), add_systemuser_yes_button);
  GTK_WIDGET_SET_FLAGS (add_systemuser_yes_button, GTK_CAN_DEFAULT);

  alignment52 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment52, "alignment52");
  gtk_widget_show (alignment52);
  gtk_container_add (GTK_CONTAINER (add_systemuser_yes_button), alignment52);

  hbox255 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox255, "hbox255");
  gtk_widget_show (hbox255);
  gtk_container_add (GTK_CONTAINER (alignment52), hbox255);

  image52 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image52, "image52");
  gtk_widget_show (image52);
  gtk_box_pack_start (GTK_BOX (hbox255), image52, FALSE, FALSE, 0);

  label379 = gtk_label_new_with_mnemonic (_("Yes"));
  gtk_widget_set_name (label379, "label379");
  gtk_widget_show (label379);
  gtk_box_pack_start (GTK_BOX (hbox255), label379, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label379), GTK_JUSTIFY_LEFT);

  g_signal_connect ((gpointer) add_systemuser_question_window, "map",
                    G_CALLBACK (on_add_systemuser_question_window_map),
                    NULL);
  g_signal_connect_swapped ((gpointer) add_systemuser_no_button, "clicked",
                            G_CALLBACK (gtk_widget_destroy),
                            GTK_OBJECT (add_systemuser_question_window));
  g_signal_connect ((gpointer) add_systemuser_yes_button, "clicked",
                    G_CALLBACK (on_add_systemuser_yes_button_clicked),
                    NULL);

  GLADE_HOOKUP_OBJECT_NO_REF (add_systemuser_question_window, add_systemuser_question_window, "add_systemuser_question_window");
  GLADE_HOOKUP_OBJECT (add_systemuser_question_window, add_systemuser_entry, "add_systemuser_entry");
  GLADE_HOOKUP_OBJECT (add_systemuser_question_window, add_systemuser_no_button, "add_systemuser_no_button");
  GLADE_HOOKUP_OBJECT (add_systemuser_question_window, add_systemuser_yes_button, "add_systemuser_yes_button");

  return add_systemuser_question_window;
}
