Version for gpsdrive-2.x

Since version 1.29 GpsDrive supports SQL database support.

Supported databases (September 2003): MySQL 

Compiling:
----------
There is no MySQL needed for compiling, the needed library
libmysqlclient.so.10 will be loaded at runtime, if found.

Running and first initialization:
---------------------------------
If you have not already done, install the mysql server package for
your distribution.

o Start the server, mostly with: /etc/init.d/mysql start

o To create a initial database use to included SQL file 'create.sql'.
  Make sure, that the user  have enough permissions to create this table
  and grant the permissions! 

  mysql < create.sql
  (add username and login options if needed)
  i.e.:
  mysql -u root -p <create.sql

  If you have no password for root (this is the case if you newly
  installed mysql) so use this command:

  mysql -u root <create.sql

  You may change the string gast@localhost to gast@'%' if you want to
  use the database from other hosts.


Update:
-------
If you have already the database and you update GpsDrive, make sure
your table structure is the same like in create.sql.

Managing the SQL server:
------------------------

A good tool is mysqlcc, download it from:

http://www.mysql.com/downloads/gui-mycc.html

Security:
---------
GpsDrive uses the username 'gast' and the password 'gast' as default
to access the table 'waypoints' in the database 'geoinfo'. If you want to
change this in the SQL database, so change this in GpsDrive also. For
this, edit the file $HOME/.gpsdrive/gpsdriverc (dbuser,dbpass).

Be aware that the MySQL password for this database is stored in
cleartext in gpsdriverc!!!


Importing existing waypoint files:
----------------------------------
I also provided the script 'wp2sql', which creates the .sql input file
from gpsdrive waypointfiles. 

Change it for your needs first!!!!

Then do 

mysql -u gast -pgast <wp.sql

You can also import ASCII files with the 'mysqlimport' program.

=======================================================================
IMPORTANT:

Select the 'Use SQL' button to use the SQL generated waypoints.

=======================================================================

Waypoint types:
---------------

You can define freely your waypoint type names. But there are special
names, which results in special icons display in GpsDrive:

WLAN	     : open WLAN accesspoint
WLAN-WEP     : crypted WLAN accesspoint
Rest	     : a restaurant
McDonalds    : a kind of restaurant
BurgerKing   : another kind of restaurant
Hotel	     : A hotel
Shop	     : Shop
Monu	     : Monument, touristic attraction
Speedtrap    : Speedtrap (Radar), gives warning if this is in front of
	       you
Nightclub    : Pssst...
Airport	     : Airport
Golf	     : Golf course
Gasstation   : Gasstation
Cafe	     : coffee bar
Geocache     : Geocache point

The names are case insensitive.

You can also use your own icons, see man page for details.

Backing up and restoring your database
--------------------------------------
Sven added the two shell scripts gpssql_backup.sh and gpssql_restore.sh for
very simple use. Just read the comments within those scripts for usage
information.



Editing your waypoints:
-----------------------

You can either use "mysqlcc", "phpmyadmin" or OpenOffice to edit the waypoints.

Here is a little HowTo from Charles Curley <charlescurley@charlescurley.com>

One of the really nice things about OpenOffice.org
(http://OpenOffice.org/) is that you can use databases as data sources
for documents and spreadsheets, rather like MS Access and MS Office. I
just set up the GpsDrive waypoints MySQL database as a data source,
and thought I'd annotate how I did it -- if for no other reason than
so I have a note on how to do it.

I did it on Fedora Core Linux. This should work on other Linux disties
as well.

First, you get John McCreesh's "OpenOffice.org 1.0, ODBC, and MySQL
'How-to'" (http://www.unixodbc.org/doc/OOoMySQL9.pdf), read it through
page 7, then and do exactly what the man says, step by step. His
instructions are for Red Hat 9, and I had no problems. His
instructions are for OpenOffice.org 1.0, but I had no problems on
OpenOffice.org 1.1.

I used exactly his [MySQL] stanza in /etc/odbcinst.ini. For odbc.ini,
I made two changes. First, I used ~/.odbc.ini instead of /etc/odbc.ini
for tighter security. Second, I used a customized stanza for the
geoinfo database:

[geoinfo]
Trace    = Off
TraceFile= stderr
Driver   = MySQL
SERVER   = localhost
Database = geoinfo
USER     = gast
PASSWORD = gast
PORT     = 3306

To test the ODBC connection to MySQL, you run isql like so:

isql <dbname> <user> <password>
isql geoinfo gast gast

and in isql, run:

select * on waypoints

The only other change is that in the ODBC tab of the Data Source
Administration window, check "password required" and enter a user name
of "gast".

The result is a nice GUI tool for editing one's waypoints.
