/* gpsk31  - PSK31 for Linux with a GTK+ Interface
 * Copyright (C) 2000 Luc Langehegermann, LX2GT
 * Copyright (C) 2005 Joop Stakenborg, PG4I
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 */

/* Here are all the onctions, we need to setup the main Screen */

#include <gtk/gtk.h>
#include <stdio.h>
#include "main_screen.h"
#include "callback.h"
#include "misc.h"
#include "globals.h"
#include "menu.h"
#include "phasescope.h"
#include "support.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/stat.h>
#include <time.h>
#include <unistd.h>

#define EVENT_METHOD(i, x) GTK_WIDGET_GET_CLASS(i)->x

struct statusbar statusbar;
struct main_screen main_screen;
float max_value = 0;
int scrolled = 0;
/*
 * These functions are called, to take our 2 pixmaps fresh ////////////////
 */

static gint
configure_event_phase_scope (GtkWidget * widget, GdkEventConfigure * event)
{
  if (main_screen.phase_scope)
    gdk_pixmap_unref (main_screen.phase_scope);
  main_screen.phase_scope = gdk_pixmap_new (widget->window,
					    widget->allocation.width,
					    widget->allocation.height, -1);

  gdk_draw_rectangle (main_screen.phase_scope,
		      widget->style->black_gc, TRUE, 0, 0,
		      widget->allocation.width, widget->allocation.height);
  draw_arc ();
  return TRUE;
}


static gint
expose_event_phase_scope (GtkWidget * widget, GdkEventExpose * event)
{
  gdk_draw_pixmap (widget->window,
		   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		   main_screen.phase_scope,
		   event->area.x, event->area.y,
		   event->area.x, event->area.y,
		   event->area.width, event->area.height);
  return TRUE;
}



static gint
configure_event_spectrum (GtkWidget * widget, GdkEventConfigure * event)
{
  if (main_screen.spectrum)
    gdk_pixmap_unref (main_screen.spectrum);
  main_screen.spectrum = gdk_pixmap_new (widget->window,
					 widget->allocation.width,
					 widget->allocation.height, -1);
  gdk_draw_rectangle (main_screen.spectrum,
		      widget->style->black_gc, TRUE, 0, 0,
		      widget->allocation.width, widget->allocation.height);

  return TRUE;
}


static gint
expose_event_spectrum (GtkWidget * widget, GdkEventExpose * event)
{
  gdk_draw_pixmap (widget->window,
		   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		   main_screen.spectrum,
		   event->area.x, event->area.y,
		   event->area.x, event->area.y,
		   event->area.width, event->area.height);
  return FALSE;
}

/*
 * This function builds the main screen.
 */

int
setup_screen ()
{
  main_screen.phase_scope = NULL;	/* Initialize our 2 drawing areas */
  main_screen.spectrum = NULL;
  int i;
  gchar *tip;

  GdkPixbuf *pixbuf;
  GtkWidget *label;
  GtkWidget *statusbar_dummy;
  GtkWidget *box;
  GtkWidget *box1;
  GtkWidget *box2;
  GtkWidget *box3;
  GtkWidget *box4;
  GtkWidget *box5;
  GtkWidget *box6;
  GtkWidget *box7;
  GtkWidget *box8;
  GtkWidget *hbox;
  GtkWidget *hbox2;
  GtkWidget *rxframe, *txframe;
  GtkWidget *optbox, *optframe;
  GtkWidget *scrollwindow;
  GtkWidget *txscrollwindow;
  GtkWidget *statusbar_box;
  GtkTextBuffer *buffer;
  PangoFontDescription *font;

  GtkWidget *tx_button;
  GtkWidget *rx_button;
  GtkWidget *clear_button;
  GtkWidget *area;
  GtkWidget *hrule;
  GtkWidget *table;

  GtkWidget *frame;
  GtkWidget *scale;
  GtkAdjustment *rx_adj;
  GtkAdjustment *tx_adj;

  GtkTooltips *tooltips;

  main_screen.window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  pixbuf = create_pixbuf ("gpsk31.png");
  if (pixbuf)
    {
      gtk_window_set_icon (GTK_WINDOW (main_screen.window), pixbuf);
      g_object_unref (pixbuf);
    }
  hbox = gtk_hbox_new (FALSE, 0);
  hbox2 = gtk_hbox_new (FALSE, 0);
  box = gtk_vbox_new (FALSE, 2);
  box1 = gtk_hbox_new (FALSE, 2);
  box2 = gtk_vbox_new (TRUE, 5);
  box3 = gtk_vbox_new (TRUE, 5);
  box4 = gtk_vbox_new (TRUE, 5);
  box5 = gtk_vbox_new (TRUE, 5);
  box6 = gtk_vbox_new (TRUE, 5);
  box7 = gtk_vbox_new (TRUE, 5);
  box8 = gtk_hbox_new (TRUE, 0);
  statusbar_box = gtk_hbox_new (FALSE, 0);

  gtk_container_add (GTK_CONTAINER (main_screen.window), box);
  gtk_container_set_border_width (GTK_CONTAINER (main_screen.window), 1);
  gtk_window_set_title (GTK_WINDOW (main_screen.window),
			"GPSK31 - Version "VERSION); 
  gtk_widget_set_usize (GTK_WIDGET (main_screen.window), 0, 450);

  init_menu ();			// create the menu widget
  gtk_box_pack_start (GTK_BOX (box), main_screen.menu, FALSE, FALSE, 0);


  rxframe = gtk_frame_new ("RX window");

  scrollwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrollwindow),
    GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
  main_screen.rxwindow = gtk_text_view_new ();
  GTK_WIDGET_UNSET_FLAGS (main_screen.rxwindow, GTK_CAN_FOCUS);
  gtk_widget_set_usize (main_screen.rxwindow, 0, 140);
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (main_screen.rxwindow), GTK_WRAP_WORD);
  gtk_container_add (GTK_CONTAINER (scrollwindow), main_screen.rxwindow);

  /* rx colors and font */
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (main_screen.rxwindow));
  gtk_text_buffer_create_tag (buffer, "rx_window_color_tx",
    "foreground", ini_settings.rx_window_color_tx, NULL);
  gtk_text_buffer_create_tag (buffer, "rx_window_color_rx",
    "foreground", ini_settings.rx_window_color_rx, NULL);
  font = pango_font_description_from_string (ini_settings.rx_window_font);
  gtk_widget_modify_font (main_screen.rxwindow, font);
  pango_font_description_free(font);

  txframe = gtk_frame_new ("TX window");

  txscrollwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (txscrollwindow),
    GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
  main_screen.txwindow = gtk_text_view_new ();
//  GTK_WIDGET_UNSET_FLAGS (main_screen.txwindow, GTK_CAN_FOCUS);
  gtk_widget_set_usize (main_screen.txwindow, 0, 70);
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (main_screen.txwindow), GTK_WRAP_WORD);
  gtk_container_add (GTK_CONTAINER (txscrollwindow), main_screen.txwindow);

  /* tx colors and font */
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (main_screen.txwindow));
  gtk_text_buffer_create_tag (buffer, "tx_window_color",
    "foreground", ini_settings.tx_window_color, NULL);
  font = pango_font_description_from_string (ini_settings.tx_window_font);
  gtk_widget_modify_font (main_screen.txwindow, font);
  pango_font_description_free(font);

  main_screen.phase_drawing = gtk_drawing_area_new ();
  gtk_drawing_area_size
    (GTK_DRAWING_AREA (main_screen.phase_drawing), 100, 100);
  main_screen.spectrum_drawing = gtk_drawing_area_new ();
  gtk_drawing_area_size
    (GTK_DRAWING_AREA (main_screen.spectrum_drawing), 200, 100);

    /* Create a table for placing the ruler and the drawing area */
    table = gtk_table_new( 3, 2, FALSE );
    area = main_screen.spectrum_drawing;
    
    gtk_table_attach( 
		    GTK_TABLE(table), main_screen.spectrum_drawing, 
		    1, 2, 0, 1, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 
		    (GtkAttachOptions) GTK_FILL, 0, 0);
   
    gtk_widget_set_events( main_screen.spectrum_drawing, 
		    GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK );

    /* The horizontal ruler goes on top. As the mouse moves across the
     * drawing area, a motion_notify_event is passed to the
     * appropriate event handler for the ruler. */
    hrule = gtk_hruler_new();
    gtk_ruler_set_metric( GTK_RULER(hrule), GTK_PIXELS );
    gtk_ruler_set_range( GTK_RULER(hrule), 600, 1400, 0, 100 );

	g_signal_connect_swapped (G_OBJECT (area), "motion_notify_event",
           G_CALLBACK (EVENT_METHOD (hrule, motion_notify_event)),
           G_OBJECT (hrule));

    gtk_table_attach( GTK_TABLE(table), hrule, 1, 2, 1, 2,
              (GtkAttachOptions) (GTK_EXPAND|GTK_SHRINK|GTK_FILL),
		      (GtkAttachOptions) GTK_FILL, 0, 0 );
    
  gtk_box_pack_start (GTK_BOX (box), rxframe, TRUE, TRUE, 2);
  gtk_container_add (GTK_CONTAINER (rxframe), hbox);

  gtk_box_pack_start (GTK_BOX (box), box8, FALSE, TRUE, 5);

  gtk_box_pack_start (GTK_BOX (box), txframe, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (txframe), hbox2);

  /* Build the 8 buttons */
  tooltips = gtk_tooltips_new ();
  for (i=0;i<=7;i++) {
    main_screen.f_button[i] = gtk_button_new_with_label (" ");
    gtk_box_pack_start (GTK_BOX (box8), main_screen.f_button[i], TRUE, TRUE, 1);
    GTK_WIDGET_UNSET_FLAGS (main_screen.f_button[i], GTK_CAN_FOCUS);
    gtk_signal_connect (GTK_OBJECT (main_screen.f_button[i]), "clicked",
      (GtkSignalFunc) macro_processor, (gpointer *) (GINT_TO_POINTER (i)));
    tip = g_strdup_printf ("[F%d]", i+1);
    gtk_tooltips_set_tip (tooltips, main_screen.f_button[i], tip, NULL);
    g_free (tip);
  }

  gtk_box_pack_start (GTK_BOX (hbox), scrollwindow, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox2), txscrollwindow, TRUE, TRUE, 0);
  
  gtk_box_pack_start (GTK_BOX (box), box1, FALSE, TRUE, 0);
  gtk_box_pack_start
    (GTK_BOX (box1), main_screen.phase_drawing, FALSE, FALSE, 0);

  main_screen.dcd_adj = (GtkAdjustment *) gtk_adjustment_new (-6.0, -99, 2, 1, 3, 1);
  scale = gtk_vscrollbar_new (GTK_ADJUSTMENT (main_screen.dcd_adj));
  GTK_WIDGET_UNSET_FLAGS (scale, GTK_CAN_FOCUS);

  gtk_box_pack_start (GTK_BOX (box1), scale, FALSE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (box1), table, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (box1), box2, FALSE, TRUE, 1);

  tx_button = gtk_button_new_with_label ("Transmit (F11)");
  GTK_WIDGET_UNSET_FLAGS (tx_button, GTK_CAN_FOCUS);
  gtk_box_pack_start (GTK_BOX (box2), tx_button, TRUE, TRUE, 1);
  rx_button = gtk_button_new_with_label ("Receive (F12)");
  GTK_WIDGET_UNSET_FLAGS (rx_button, GTK_CAN_FOCUS);
  gtk_box_pack_start (GTK_BOX (box2), rx_button, TRUE, TRUE, 1);
  clear_button = gtk_button_new_with_label ("A_bort Transmit");
  gtk_button_set_use_underline (GTK_BUTTON(clear_button), TRUE);
  GTK_WIDGET_UNSET_FLAGS (clear_button, GTK_CAN_FOCUS);
  gtk_box_pack_start (GTK_BOX (box2), clear_button, TRUE, TRUE, 1);

  frame = gtk_frame_new ("Mode");
  gtk_box_pack_start (GTK_BOX (box1), frame, FALSE, TRUE, 2);
  gtk_container_add (GTK_CONTAINER (frame), box4);

  label = gtk_label_new ("QPSK");
  gtk_label_set_pattern (GTK_LABEL (label), "_");
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.8);
  main_screen.mode_qpsk = gtk_check_button_new ();
  gtk_container_add (GTK_CONTAINER (main_screen.mode_qpsk), label);
  GTK_WIDGET_UNSET_FLAGS (main_screen.mode_qpsk, GTK_CAN_FOCUS);

  gtk_box_pack_start (GTK_BOX (box4), main_screen.mode_qpsk, FALSE, FALSE, 0);

  label = gtk_label_new ("CW ID");
  gtk_label_set_pattern (GTK_LABEL (label), "_");
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.8);
  main_screen.cwid = gtk_check_button_new ();
  gtk_container_add (GTK_CONTAINER (main_screen.cwid), label);
  GTK_WIDGET_UNSET_FLAGS (main_screen.cwid, GTK_CAN_FOCUS);
  gtk_box_pack_start (GTK_BOX (box4), main_screen.cwid, FALSE, FALSE, 0);

  frame = gtk_frame_new ("RX-Freq");

  gtk_box_pack_start (GTK_BOX (box1), frame, FALSE, TRUE, 2);
  gtk_container_add (GTK_CONTAINER (frame), box5);

  rx_adj = (GtkAdjustment *) gtk_adjustment_new (1000, 100, 5000, 1, 1, 0);
  main_screen.rx_freq = gtk_spin_button_new (rx_adj, 1, 1);

  gtk_box_pack_start (GTK_BOX (box5), main_screen.rx_freq, FALSE, FALSE, 0);

  label = gtk_label_new ("AFC");
  gtk_label_set_pattern (GTK_LABEL (label), "_");
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.8);
  main_screen.afc = gtk_check_button_new ();
  gtk_container_add (GTK_CONTAINER (main_screen.afc), label);

  GTK_WIDGET_UNSET_FLAGS (main_screen.afc, GTK_CAN_FOCUS);
  gtk_box_pack_start (GTK_BOX (box5), main_screen.afc, TRUE, FALSE, 0);

  frame = gtk_frame_new ("TX-Freq");

  gtk_box_pack_start (GTK_BOX (box1), frame, FALSE, TRUE, 2);
  gtk_container_add (GTK_CONTAINER (frame), box6);


  tx_adj = (GtkAdjustment *) gtk_adjustment_new (1000, 100, 5000, 1, 1, 0);
  main_screen.tx_freq = gtk_spin_button_new (tx_adj, 1, 1);
  gtk_box_pack_start (GTK_BOX (box6), main_screen.tx_freq, FALSE, FALSE, 0);

  label = gtk_label_new ("NET");
  gtk_label_set_pattern (GTK_LABEL (label), "_");
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.8);
  main_screen.net = gtk_check_button_new ();
  gtk_container_add (GTK_CONTAINER (main_screen.net), label);

  optframe = gtk_frame_new ("Options");
  gtk_box_pack_start (GTK_BOX (box1), optframe, FALSE, TRUE, 2);
  optbox = gtk_vbox_new (TRUE, 2);
  gtk_container_add (GTK_CONTAINER (optframe), optbox);
  label = gtk_label_new ("Auto TX");
  gtk_label_set_pattern (GTK_LABEL (label), "_");
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.8);
  main_screen.mode_autotx = gtk_check_button_new ();
  gtk_container_add (GTK_CONTAINER (main_screen.mode_autotx), label);
  GTK_WIDGET_UNSET_FLAGS (main_screen.mode_autotx, GTK_CAN_FOCUS);
  gtk_box_pack_start (GTK_BOX (optbox), main_screen.mode_autotx, FALSE, FALSE, 0);

  GTK_WIDGET_UNSET_FLAGS (main_screen.net, GTK_CAN_FOCUS);
  gtk_box_pack_start (GTK_BOX (box6), main_screen.net, FALSE, FALSE, 0);

  gtk_box_pack_start (GTK_BOX (box), statusbar_box, FALSE, FALSE, 0);

  statusbar.logged = gtk_statusbar_new ();
  gtk_widget_set_usize (GTK_WIDGET (statusbar.logged), 200, 0);
  gtk_box_pack_start
    (GTK_BOX (statusbar_box), statusbar.logged, FALSE, FALSE, 1);

  statusbar.mode = gtk_statusbar_new ();
  gtk_statusbar_push (GTK_STATUSBAR (statusbar.mode), 1, "BPSK");
  gtk_widget_set_usize (GTK_WIDGET (statusbar.mode), 100, 0);
  gtk_box_pack_start
    (GTK_BOX (statusbar_box), statusbar.mode, FALSE, FALSE, 1);

  statusbar.txstate = gtk_statusbar_new ();

  gtk_statusbar_push (GTK_STATUSBAR (statusbar.txstate), 1, "RX");
  gtk_widget_set_usize (GTK_WIDGET (statusbar.txstate), 100, 0);
  gtk_box_pack_start
    (GTK_BOX (statusbar_box), statusbar.txstate, FALSE, FALSE, 1);

  statusbar_dummy = gtk_statusbar_new ();
  gtk_box_pack_start (GTK_BOX (statusbar_box), statusbar_dummy, TRUE, TRUE, 1);

  statusbar.time = gtk_statusbar_new ();
  gtk_widget_set_usize (GTK_WIDGET (statusbar.time), 200, 0);
  gtk_box_pack_end (GTK_BOX (statusbar_box), statusbar.time, FALSE, FALSE, 1);

/////// Set the state for startup of our Buttons
////////////////////////////////////////////////
  gtk_widget_grab_focus (GTK_WIDGET (main_screen.txwindow));

/////////////////////////////////////////////////////////////////////////////////////
////////// And now our signals //////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
  gtk_signal_connect (GTK_OBJECT (main_screen.phase_drawing), "expose_event",
		      (GtkSignalFunc) expose_event_phase_scope, NULL);

  gtk_signal_connect (GTK_OBJECT (main_screen.phase_drawing), "configure_event",
		      (GtkSignalFunc) configure_event_phase_scope, NULL);

  gtk_widget_set_events (main_screen.phase_drawing, GDK_EXPOSURE_MASK);

  gtk_signal_connect (GTK_OBJECT (main_screen.spectrum_drawing),
      "expose_event", (GtkSignalFunc) expose_event_spectrum, NULL);

  gtk_signal_connect (GTK_OBJECT (main_screen.spectrum_drawing),
      "configure_event", (GtkSignalFunc) configure_event_spectrum, NULL);

  gtk_widget_set_events (main_screen.window, GDK_KEY_RELEASE_MASK);

  gtk_signal_connect (GTK_OBJECT (main_screen.txwindow), "key_press_event",
		      (GtkSignalFunc) key_input, NULL);

  gtk_signal_connect (GTK_OBJECT (main_screen.txwindow), "key_release_event",
		      (GtkSignalFunc) key_released, NULL);

  gtk_widget_set_events (main_screen.spectrum_drawing, GDK_BUTTON_PRESS_MASK
    | GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK);

  gtk_signal_connect (GTK_OBJECT (main_screen.spectrum_drawing),
	      "button_press_event", (GtkSignalFunc) spectrum_motion_event, NULL);

  gtk_signal_connect (GTK_OBJECT (main_screen.dcd_adj), "value_changed",
	      (GtkSignalFunc) dcd_level_changed, NULL);

  gtk_signal_connect (GTK_OBJECT (rx_adj), "value_changed",
	      (GtkSignalFunc) rx_freq_changed, (gpointer) main_screen.rx_freq);

  gtk_signal_connect (GTK_OBJECT (tx_adj), "value_changed",
	      (GtkSignalFunc) tx_freq_changed, (gpointer) main_screen.tx_freq);

  gtk_signal_connect (GTK_OBJECT (main_screen.afc), "toggled",
		      (GtkSignalFunc) afc_toggled, NULL);

  gtk_signal_connect (GTK_OBJECT (main_screen.net), "toggled",
		      (GtkSignalFunc) net_toggled, NULL);

  gtk_signal_connect (GTK_OBJECT (main_screen.cwid), "toggled",
		      (GtkSignalFunc) cwid_toggled, NULL);

  gtk_signal_connect (GTK_OBJECT (main_screen.mode_qpsk), "toggled",
		      (GtkSignalFunc) qpsk_toggled, NULL);

  gtk_signal_connect (GTK_OBJECT (clear_button), "clicked",
		      (GtkSignalFunc) tx_clear_pressed, NULL);

  gtk_signal_connect (GTK_OBJECT (tx_button), "clicked",
		      (GtkSignalFunc) tx_button_pressed, NULL);

  gtk_signal_connect (GTK_OBJECT (rx_button), "clicked",
		      (GtkSignalFunc) rx_button_pressed, NULL);
  gtk_widget_show_all (main_screen.window);
  return (0);
}
