/* 
 * gpsk31  - PSK31 for Linux with a GTK+ Interface
 * 
 * Copyright (C) 2000 Luc Langehegermann, LX2GT
 * Copyright (C) 2005,2006,2007,2008 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * The main author can be reached at pg4i@amsat.org or by smail-mail:
 * Joop Stakenborg, Bramengaarde 24, 3992KG Houten, The Netherlands.
 * 
 */

/*
 * log.c - functions to log the data to xlog, mostly taken from gmfsk
 *
 */

#include <gtk/gtk.h>
#include <string.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <errno.h>
#include <time.h>

#include "log.h"
#include "globals.h"
#include "menu.h"

#define LOG_MVERSION    "1"
#define LOG_MKEY        1238
#define LOG_MTYPE       88
#define LOG_MSEPARATOR  1

#define LOG_MSG_LEN     1024

typedef struct {
        long mtype;
        char mtext[LOG_MSG_LEN];
} msgtype;

static msgtype msgbuf;
time_t starttime = 0;

static void log_msg_reset(void)
{
	msgbuf.mtext[0] = 0;
}

static void log_msg_append(const gchar *type, const gchar *data)
{
	gchar *entry;

	entry = g_strdup_printf("%s:%s%c", type, data, LOG_MSEPARATOR);

	if (strlen(msgbuf.mtext) + strlen(entry) + 1 > LOG_MSG_LEN) {
		g_warning("log message too long, entry dropped: %s\n", entry);
		g_free(entry);
		return;
	}

	strcat(msgbuf.mtext, entry);
	g_free(entry);
}

static int log_msg_send(void)
{
	gint msqid, len;

	if ((msqid = msgget(LOG_MKEY, 0666 | IPC_CREAT)) == -1) {
		g_print("msgget: %s\n", strerror(errno));
		return -1;
	}

	msgbuf.mtype = LOG_MTYPE;

	/* allow for the NUL */
	len = strlen(msgbuf.mtext) + 1;

	if (msgsnd(msqid, &msgbuf, len, IPC_NOWAIT) < 0) {
		g_print("msgsnd: %m\n");
		return -1;
	}

#if 0
	g_print("msg sent: (%02ld) '%s'\n", msgbuf.mtype, msgbuf.mtext);
#endif

	return 0;
}

void qsodata_log(void)
{
	char date[32], stime[32], etime[32], *message;
	const char *mode;
	struct tm *tm;
	time_t t;

	tm = gmtime (&starttime);
	strftime (date, sizeof(date), "%d %b %Y", tm);
	strftime (stime, sizeof(stime), "%H%M", tm);

	time (&t);
	tm = gmtime (&t);
	strftime (etime, sizeof(etime), "%H%M", tm);

	mode = trx_get_mode_name();

	/* freq field empty & shall xlog fill in frequency */
	if (ini_settings.xlog_auto_freq)  {
	   if (g_ascii_strcasecmp (qsodata.freq, "") == 0) {
	      strcpy(qsodata.freq, "HAMLIB");
	   }
	}

	log_msg_reset();
	log_msg_append("program", "gpsk31 v" VERSION);
	log_msg_append("version", LOG_MVERSION);
	log_msg_append("date", date);
	log_msg_append("time", stime);
	log_msg_append("endtime", etime);
	log_msg_append("call", qsodata.call);
	log_msg_append("mhz", qsodata.freq);
	log_msg_append("mode", mode);
	log_msg_append("tx", qsodata.rst_s);
	log_msg_append("rx", qsodata.rst_r);
	log_msg_append("name", qsodata.name);
	log_msg_append("qth", qsodata.qth);
	log_msg_append("notes", qsodata.notes);
	message = g_strdup_printf ("%s logged", qsodata.call);
    gtk_statusbar_pop (GTK_STATUSBAR (statusbar.logged), 1);
    gtk_statusbar_push (GTK_STATUSBAR (statusbar.logged), 1, message);
    g_free (message);
	log_msg_send();
}
