#
#  gpsman --- GPS Manager: a manager for GPS receiver data
#
#  Copyright (c) 2001 Miguel Filgueiras (mig@ncc.up.pt) / Universidade do Porto
#
#    This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
#
#      You should have received a copy of the GNU General Public License
#      along with this program.
#
#  File: gpsinfo.tcl
#  Last change:  10 June 2001
#
# Includes contributions by Brian Baulch (baulchb@onthenet.com.au)
#  marked "BSB contribution"


proc DisableGPS {} {
    # change interface appearance when detecting that the receiver went offline
    global RcW RcMenu GPSState GPSLabel COLOUR TXT RECTYPES SYMBOLIMAGE

    set GPSState offline ; set GPSLabel $TXT(offline)
    $RcW.frgps.bs.state configure -fg $COLOUR(offline)
    $RcW.frgps.bs.off configure -state disabled
    $RcMenu entryconfigure 4 -image $SYMBOLIMAGE(diamond_red)
    foreach ix "5 6 7" {
	$RcMenu entryconfigure $ix -state disabled
    }
    foreach i $RECTYPES {
	$RcW.frget.frget2.get$i configure -state disabled
	# BSB contribution: no IC put button
	if { "$i" != "IC" } {
	    $RcW.frput.put$i configure -state disabled
	}
    }
    return
}

proc EnableGPS {} {
    # change interface appearance when detecting that the receiver went on-line
    global RcW RcMenu GPSState GPSLabel COLOUR ListInds TXT RECTYPES MYGPS \
	    SYMBOLIMAGE

    set GPSState online ; set GPSLabel $TXT(online)
    $RcW.frgps.bs.state configure -fg $COLOUR(online)
    $RcW.frgps.bs.off configure -state normal
    $RcMenu entryconfigure 4 -image $SYMBOLIMAGE(diamond_green)
    foreach ix "5 6 7" {
	$RcMenu entryconfigure $ix -state normal
    }
    if { "$ListInds(GR)" != "" } {
	# assume GR is last in $RECTYPES
	$RcMenu.gm entryconfigure last -state normal
    } else { $RcMenu.gm entryconfigure last -state disabled }
    set ix 0
    foreach i $RECTYPES {
	if { "$i" != "GR" || "$ListInds(GR)" != "" } {
	    $RcW.frget.frget2.get$i configure -state normal
	}
	# based on BSB contribution: no IC put button
	if { "$i" != "IC" } {
	    if { "$ListInds($i)" != "" } {
		$RcW.frput.put$i configure -state normal
		$RcMenu.ptm entryconfigure $ix -state normal
	    } else { $RcMenu.ptm entryconfigure $ix -state disabled }
	} else { incr ix -1 }
	incr ix
    }
    InitGPS
    return
}

proc CheckGPS {} {
    # check connectivity to receiver
    global GPSState GPSLabel COLOUR MESS TXT

    SetCursor . watch
    if { "$GPSState" == "offline" } {
	GPSConnection EnableGPS
    } else {
	GPSConnection [list GMMessage $MESS(GPSok)] DisableGPS
    }
    set GPSLabel $TXT($GPSState)
    ResetCursor .
    return
}

proc TurnOff {} {
    global GPSState COLOUR

    GPSOff
    DisableGPS
    return
}

proc PutOnGPS {how wh} {
    # put data into receiver
    #  $how in {all, select}, $wh in $RECTYPES
    global ListInds RECTYPES MESS TXT

    switch $how {
	all {
	    set ixs $ListInds($wh)
	}
	select {
	    if { "[set ixs [ChooseItems $wh]]" == "" } {
		return
	    }
	}
    }
    switch $wh {
	GR {
	    if { "$how" == "all" } {
		set whs $RECTYPES
	    } else {
		set ts ""
		foreach k $RECTYPES { lappend ts $TXT(name$k) }
		set whs [GMChooseFrom many $MESS(putwhat) 6 $ts $RECTYPES]
	    }
	    if { [set i [lsearch -exact $whs GR]] != -1 } {
		set whs [lreplace $whs $i $i]
		set r 1
	    } else { set r 0 }
	    foreach wh $whs {
		if { "[set l [GRsElements $ixs $r $wh]]" != "" } {
		    PutItemsOnGPS $wh $l
		}
	    }
	}
	default {
	    PutItemsOnGPS $wh $ixs
	}
    }
    return
}

proc PutItemsOnGPS {wh ixs} {
    # put items of kind $wh (in $RECTYPES except GR) on receiver
    #  $ixs is list of indices
    global MAX MESS TXT

    if { [llength $ixs] > $MAX($wh) } {
	GMMessage [format $MESS(toomany) $TXT(name$wh) $MAX($wh)]
	return
    }
    PutGPS $wh $ixs
    return
}

proc GetFromGPS {wh} {
    # get data from receiver
    #  $wh in $RECTYPES
    # if $wh==GR, select item types (in $RECTYPES except TR) to get
    global RECTYPES
    # BSB contribution
    global MYGPS

    if { "$wh" == "GR" } {
	# based on BSB contribution: do not get ICs
	if { $MYGPS != "Lowrance" } {
	    set not "TR"
	} else { set not "IC TR" }
	InputToGR $RECTYPES $not Ignore GetGPSIn Ignore receiver
    } else {
	GetGPS $wh
    }
    return
}

