#
#  gpsman --- GPS Manager: a manager for GPS receiver data
#
# Copyright (c) 1998-2009 Miguel Filgueiras mig@ncc.up.pt Universidade do Porto
#
#    This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
#
#      You should have received a copy of the GNU General Public License
#      along with this program.
#
#  File: langit.tcl
#  Last change:  22 December 2009
#  Italian language file by Alessandro Palmas (alpalmas@tin.it)
#  last input from him inserted:  22 December 2009
#

# file langengl.tcl is consulted first; no need for duplicating entries here

# only 3 chars long names; check also ALLMONTH in file i18n-utf8.tcl
set MONTHNAMES "Gen Feb Mar Apr Mag Giu Lug Ago Set Ott Nov Dic"

set DLUNIT(KM,dist) km
set DLUNIT(KM,subdist) m
set DLUNIT(KM,speed) km/h
set DLUNIT(KM,area) kmq
set DLUNIT(NAUTMILE,dist) mn
set DLUNIT(NAUTMILE,subdist) ft
set DLUNIT(NAUTMILE,speed) knot
set DLUNIT(NAUTMILE,area) mnq
set DLUNIT(STATMILE,dist) "st ml"
set DLUNIT(STATMILE,subdist) ft
set DLUNIT(STATMILE,speed) mph

set DLUNIT(M,dist) $DLUNIT(KM,subdist)
set DLUNIT(FT,dist) $DLUNIT(STATMILE,subdist)

set DTUNIT $DLUNIT($DISTUNIT,dist)
set SPUNIT $DLUNIT($DISTUNIT,speed)
set ALUNIT $DLUNIT($ALTUNIT,dist)

set MESS(RTcomp) "#\tWP\t\t$DTUNIT\tdeg\t$ALUNIT"
set MESS(TRcomp) "#\t\t\t\t$ALUNIT\t$DTUNIT\t$DTUNIT\th:m:s\t$SPUNIT\tdeg"
set MESS(WPNearest) "WP\t\t$DTUNIT\tdeg"

array set MESS {
    badscale   "Valore non corretto per scala mappa"
    oktoexit   "Ok per uscire (i dati non salvati verranno persi)"
    okclrmap   "Ok per cancellare la mappa"
    namelgth   "I nomi non debbono superare i %d caratteri"
    cmmtlgth   "I commenti non debbono superare i %d caratteri"
    namevoid   "Il nome non pu essere lasciato in bianco"
    baddate   "Data non corretta; linea"
    badhdg   "inizio non corretto %s: deve essre %s o +/-"
    badcoord   "Valore o formato delle coordinate non corretto: \"%s\" deve essere %s"
    outofrng   "Il numero eccede i limiti"
    UTMZN   "deve essere una lettera compresa tra A..H, J..N, o P..Z"
    badstrg "Carattere(i) non corretto(i)"
    strgvoid   "La stringa non pu essere vuota"
    nan   "\"%s\" Non  un numero"
    written   "Scritto da"
    undefWP   "La rotta %s ha WP non definiti; non salvata/esportata"
    bigRT   "Rotta %s > num. max; non esportata"
    unkndatum   "Datum sconosciuto"
    badcommdWP   "Comando scorretto caricando i WPs; linea"
    notabsWP   "Definizione WP scorretta; no tabs, linea"
    undefinedWP   "Riferimento a WP ignoto: %s"
    nofieldsWP   "WP scorretto, pochi campi; linea"
    excfieldsWP  "WP scorretto, troppi campi; linea"
    badWPsRT   "RT con lista WP scorretta; linea"
    toomuchWPs   "Attenzione: pi di %d WPs in RT"
    badcommdTP   "Comando scorretto caricando TPs; linea"
    badTP   "Punto scorretto in TR; linea"
    badTPsTR   "TR con lista trackpoints scorretta; linea"
    noheader   "Il file non inizia con header"
    loaderr   "Errore caricando dal file; linea"
    unkncommd   "Comando sconosciuto caricando dal file; linea"
    noformat   "Il file non inizia con Format line"
    badformat   "Format line scorretta"
    badRT   "Definizione RT  scorretta; linea"
    badRTargs   "Argomenti RT scorretti; linea"
    badTR   "Definizione TR scorretta; linea"
    fileact   "%s file %s?"
    filexists   "Il file esiste!"
    GPSok   "Connessione ok"
    toomany   "troppi %s (> %d)"
    cantfgt   "Non posso cancellare %s: appartiene ad un oggetto mappato"
    cantfgted   "Non posso cancellare %s: viene editato"
    cantmapRTunkn   "Rotta non mappata; mancano info per WP"
    cantmapRTed   "Rotta non mappata; WP viene editato"
    cantrun   "Cannot run"
    inprogr   "Operazione gi in corso"
    cantread   "non posso leggere il file ausiliario"
    cantwrtopt   "non posso scrivere il file di preferenze"
    voidRT   "La rotta non contiene waypoints"
    activeRT   "La rotta 0  la rotta attiva; continuo?"
    voidTR   "La traccia  non contiene punti"
    idinuse   "Identificatore gi in uso"
    cantunmap   "Non Posso eliminare dalla mappa %s: appartiene ad oggetto mappato"
    askrevert   "Ripristino i dati iniziali?"
    askforget   "Cancello questo %s?"
    notimpl   "Non implementato"
    forgetall   "Cancello tutti gli oggetti nella lista %s?"
    counted   "Ci sono %d %s definiti"
    notlisted   "Oggetto non in lista"
    wrgval   "valore scorretto per"
    voidGR   "Il gruppo non contiene componenti"
    initselfGR   "Il gruppo contiene s stesso tramite"
    GRelout   "Comando per componente fuori definizione GR; linea"
    badGRels   "Gruppo con lista componenti scorretta ; linea"
    badcommdGRel   "Comando scorretto caricando componenti GR; linea"
    notypeforGRel   "Componente privo di tipo; linea"
    badGRel   "Definizione componente scorretta; linea"
    check   "Controllo connessione"
    toomanyerr   "Troppi errori; esco..."
    getWP   "Ricevo WPoints"
    getRT   "Ricevo Rotte"
    getTR   "Ricevo Tracce"
    getLAP  "Ricezione giri in corso"
    getAL   "Ricezione almanacco in corso"
    putWP   "Invio WPoints"
    putRT   "Invio Rotte"
    putTR   "Invio Tracce"
    fillbuffWP  "Carico WP buffer"
    fillbuffRT  "Carico RT buffer"
    noACKNAK  "Ricevuto pachetto dati mentre aspettavo ACK/NAK; controllare la connessione con il GPS"
    badserial "Non riesco ad aprire il dispositivo %s"
    nodata    "Non ci sono %s nel ricevitore"
    badimage "File immagine scorretto"
    mapadjust "Posizionare i WP sulla mappa; click su Ok quando si ha finito"
    duplicate "%s gi selezionato"
    clrcurrmap "Cancellare la mappa corrente?"
    mbkbaddatum "Map Datum assente o sconosciuto"
    mbkbadscale "La scala NON deve essere negativa"
    mbkbadat "Argomenti scorretti"
    edityourrisk "Editate a vostro rischio e pericolo!"
    okclrbkmap   "Ok per cancellare la mappa di sfondo"
    okclrbkim    "Ok per cancellare immagine a"
    goingdown "Preferenze salvate; si prega di riavviare"
    putwhat "Quali tipi di oggetti inviare?"
    readwhat "Quali tipi di oggetti leggere?"
    noWPinx "Troppi WP per il ricevitore"
    noICinx "Troppi IC per il ricevitore"
    getIC "Carico le icone"
    serial1 "Header Preamble scorretto"
    serial2 "Ricevuto Comando scorretto"
    checksum1 "Header Checksum scorretto"
    checksum2 "Data Checksum error"
    receiver "Non connesso al dispositivo!"
    importonly1 "Posso importare solo un tipo di dati"
    exportonly1 "Posso esportare solo un tipo di dati"
    outdatedprefs "File di preferenze vecchio; controllarlo al pi presto"
    mustchoose1type "Almeno 1 tipo di oggetti deve essere selezionato"
    nosuchitems "Nessun oggetto corrisponde alla descrizione"
    resultsin "Risultati della ricerca tra i gruppi"
    badWP "WP non dato o indefinito"
    badangle "L\'angolo deve essere >0 e <360 gradi"
    georefhow  "metodo di Geo-referenziazione"
    cantsolve  "Non posso risolvere le equazioni"
    oldfilefmt "File con vecchio formato; salvare con il nuovo formato!"
    notUTMproj "Info per UTM salvate; proceed with projection set to"
    projchg    "Confermare i paratmetri di proiezione"
    badparam "Valore scorretto per %s"
    connectedto "Connesso a %s"
    recnotsuppd "Modello ricevitore non supportato"
    gotprots "Ricevute definizioni dei protocolli"
    badprots "Definizioni dei protocolli scorrette"
    defprots "Uso la tabella dei protocolli"
    nohidden "Scarto dati nascosti?"
    windowdestr "La finestra  stata distrutta!"
    badhidden "Formato scorretto per valore nascosto"
    replname "Sostituire \"%s\" con un nome che abbia al pi %d dei seguenti caratteri: %s"
    badalt "Valore scorretto per altitudine"
    baddistunit "Unit non corretta per scala mappa in file di preferenze"
    badattr "Nome di attributo non corretto"
    badfield "Coppia attributo=valore non corretta"
    missattrs "Attributo/i mancante/i"
    badSYMBOLcode "Codice simbolo non corretto"
    badDISPOPTcode "Codice modo visualizzazione WP non corretto"
    badplatform "I/O seriale non supportato su questa piattaforma"
    badProjargs "Argomento proiezione errato"
    badTransfargs "Argomenti trasformazione errati"
    mbkbadproj "Proiezione cartogr. errata"
    mbkbadtransf "Trasf. cartogr. errata"
    unknProj "Proiezione cartogr. non supportata"
    unknTransf "Trasf. cartogr. non supportata"
    transfcantscale "La trasf. scelta non accetta scalamento"
    badRS "Tratto di rotta oltre limiti RT; linea"
    badWPsRSs "Tratto di rotta precedente primo WP o successivo all'ultimo WP; linea"
    cantchkprot "Controllo connessione impossibile con il protocollo corrente"
    badgridzone "Zona griglia non valida"
    outofgrid "Posizione fuori griglia"
    mustconn1st "Controllare prima la connessione con il ricevitore"
    rltmnotsupp "Registrazione in Tempo Reale non supportata dal protocollo del ricevitore"
    timeoffnotint "La differenza oraria deve essere un intero o terminare in .5"
    createdir "Creare la directory %s e ripartire"
    oktomkdir "Confermi la creazione della directory %s?"
    projnameabbr "Si diano un nome esteso ed un nome breve alla nuova proiezione"
    abbrevinuse "Nome breve gi in uso"
    nameinuse "Nome gi in uso"
    projinuse "Proiezione correntemente in uso; i cambiamenti verranno ignorati"
    gridneedsdatum "Definizione di reticolo per %s errata; datum non fornito"
    badgriddatum "Il datum per il reticolo %s deve essere %s"
    cantchggriddatum "Questo reticolo necessita del datum %s"
    gridinuse "Il reticolo non pu essere cancellata perch usata da %s; continuare?"
    gridinusenochg "Questo reticolo  usato da %s; nessun cambiamento eseguito"
    cantwrtprgr "Non posso scrivere il file delle proiezioni dell'utente"
    missingdata "Dati insufficienti"
    cantwrtdtel "non posso scrivere il file dei datum definiti dall'utente"
    movingWP "Posizionare %s cliccando con il tasto sinistro\nAbbandonare cliccando con il tasto destro"
    needs1wp "La Rotta deve avere almeno un WP"
    emptypos "La posizione presenta uno o pi campi vuoti"
    cantwrtsstate "Non posso scrivere il file di salvataggio dello stato: %s"
    cantrdsstate "Non posso leggere il file di salvataggio dello stato: %s"
    corruptsstate "File di salvataggio dello stato corrotto: %s"
    editrisk "Modificate a vostro rischio!"
    savestate "Salvo lo stato corrente?"
    delsstate "Cancello tutti i file di salvataggio dello stato?"
    badmapinfo "File di parametri mappa errato"
    badMHloc "Localizzatore Maidenhead errato"
    areais "L'area del poligono (non autointersecante)  %.3f%s"
    areatoosmall "Area troppo piccola (<0.001 kmq)"
    projarea "Calcolo area di proiezione"
    selfintsct "WP ripetuti: RT non si deve autointersecare"
    badinvmdist "Errore di approssimazione nell'inversione della distanza dal meridiano"
    badinvproj "Errore di approssimazione invertendo la proiezione %s"
    negdlatlong "L'escursione lat/long non deve essere negativa"
    allundef "I WP non sono definiti nel GR"
    badfloats "Le conversioni in virgola mobile non funzionano correttamente; siete sicuri di volervi connettere?"
    noprintcmd "Comando di stampa non selezionato; selezionarne uno nelle opzioni"
    cantexecasroot "GPSMan non pu essere eseguito da root"
    badargtofunc "Argomenti non corretti per la funzione %s"
    redefproj "La proiezione %s definita dall'utente sovrascrive una proiezione predefinita con lo stesso nome breve; Per cortesia cambiate la vostra definizione"
    badattr "Nome di campo opzionale %s sconosciuto: %s"
    badattrval "valore del capo opzionale %s errato: %s"
    couldntcd "tentativo di andare nella directory %s fallito"
    shpext "Extensione %si non corretta; cwva bene usare .shp, .shx, .dbf?"
    shpcntopen "Non riesco a creare/aprire  file Shapefile"
    shpcntcrtfs "Non riesco a creare i campi Shapefile .dbf"
    shpcntwrtfs "Non riesco a scrivere i campi Shapefile .dbf"
    shpoutmem "Memoria insufficiente!"
    shpemptyfile "File vuoto"
    shpwrongfile "Tipo di file non valido"
    shplessdim "La dimensione nel file  inferiore a quanto richiesto; continuo?"
    shpbadWPinRT "%d WP con coordinate errate ignorato nella RT %s"
    badGTMvers "Versione file GTrackMaker non accettabile"
    badGTMfile "Stringa iniziale errata per file GTrackMaker"
    badGTMcounts "Contatore/i negativi nel file GTrackMaker"
    badGTMlat "Latitudine fuori intervallo nel file GTrackMaker"
    badGTMlong "Longitudine fuori intervallo nel file GTrackMaker"
    badGTMdatum "Datum errato nel file GTrackMaker"
    unobscmap "Errore, probabilmente perch c' una finestra/icona sulla mappa; ritentare dopo attesa?"
    cantwrtimg "Errore nella scrittura dell'immagine su file in formato %s"
    TRsimplres "TR risultanti dalla semplificazione creati sotto il nome %s"
    cantsaveRTid "%d RT non salvata/e: identificatore non numerico"
    cantsaveTRid "%d TR non salvata/e: identificatore non numerico"
    badtrvconf "Configuratione corrotta; ripartire con una vuota"
    drvsimoff "simulatore di guida: non ancora partito!"
    needWP "Simulatore di guida: prego voler caricare o definire alcuni WP"
    chgrecprot "Prego cambiare il protocollo del ricevitore"
    clrtrvlog "Cancellare il log del viaggio?"
    frgetGRcs "Cancellare il gruppo e tutti i suoi elementi ?!"
    nmeainuse "Log in tempo reale o altro file NMEA in acquisizione"
    badfile "Errore leggendo da file"
    RTnoWPname "WP in RT indicato dal solo nome non pi supportato"
    distlarge "Distanza eccessiva!"
    timeconsmg "Oprazione che richiede tempo: continuare?"
    badtimeval "Valore tempo non valido"
    badLAP "LAP non valido; linea"
    lapncnsdrd "LAP ignorato"
    undefinedTR   "TR sconosciuta"
    emptymenu "Men vuoto; continuo?"
    cantwrtsymenu "Non posso scrivere il file del men dei simboli"
    abbrevhasspaces "I nomi corti non debbono contenere spazi"
    needNpoints "Fornire almeno %s punti"
    twotimeoffsets "Differenti offset tempo nel file"
    notimeoffset "Nessun offset tempo nel file; presunto 0"
    baddateas "Data erronea: %s"
    unknownenc "Codifica carattere %s sconosciuta"
    chgbaudto "Provo a cambiare baud rate a %s; attendere prego ..."
    baudchgfailed "Non riesco a cambiare baud rate"
    busytrylater "Altra operazione in corso; prego riprovare pi tardi"
    obssplit "Risultato della suddivisione: %s chiamato \"%s\""
    loginto "Login %s"
    samelgth "Le due stringhe debbono avere lo stesso numero di caratteri"
    rschkargs "La regsub chiamante ritorna errore; controllare i parametri"
    emptyrmeth "Il metodo di rinomina non pu esser nullo"
    cantwrtdefs "Impossibile scrivere il file di definizioni dell'utente"
    xcantbey "%s non pu essere %s"
    mustselftfam "Una famiglia di caratteri (font) deve essere scelta"
    badpluginwhere "Parametro  plug-in \"where\" errato; deve essere una lista di triple"
    badpluginparam  "Parametri plug-in errati: lista di NAME EXPR, NAME inizia con _"
    badpluginparamexec "Durante l'esecuzione del plug-in %s, incontrato parametro errato: %s"
    pluginfailed "Plug-in %s fallisce con messaggio: %s"
    canwrtaux "Impossibile scrivere file ausiliario"
}

set TXT(RTcompflds) "# WP {$DTUNIT} deg {$ALUNIT} stage label"
set TXT(TRcompflds) \
    "TP {} {} {} {$ALUNIT} {$DTUNIT} {$DTUNIT} h:m:s {$SPUNIT} deg"
set TXT(starttoend) "Start: to end %s $DTUNIT;"
set TXT(startmax) "max %s $DTUNIT;"
set TXT(WPnearflds) "WP {$DTUNIT} deg"
set TXT(within) "Within (${DTUNIT}s)"
set TXT(between) "Between (${DTUNIT}s)"

array set TXT {
    GMtit   "GPS Manager - versione"
    exit   Exit
    map   Mappa
    load   Carica
    loadfrm   "Carica da"
    save   Salva
    saveels "Salva componenti"
    saveto   "Salva su"
    clear   Cancella
    clearall   "Cancella Tutto"
    newWP   "Nuovo WP"
    newRT   "Nuovo RT"
    newTR   "Nuova TR"
    newGR   "Nuovo GR"
    import   Importa
    importfrm   "Importa da"
    export   Esporta
    exportels "Esporta componenti"
    exportto   "Esporta su"
    count   Conta
    trueN   "Nord Vero geografico"
    automagn   "Auto Magnetic"
    usrdef   "User Defined"
    nameWP   WPoint
    nameRT   Rotta
    nameTR   Traccia
    nameGR   Gruppo
    nameMap   Mappa
    nameRTComp   "Calcolo rotta"
    nameTRComp   "Calcolo traccia"
    GPSrec   "Ricevitore GPS"
    turnoff   "spegni"
    get   Scarica
    put   Invia
    all   Tutto
    select   Select
    selection   Selezione
    options   Opzioni
    message   Messaggio
    cancel   Annulla
    file   File
    ovwrt   Sovrascrivi
    app   Accoda
    online   online
    offline   offline
    check   prova
    create   Crea 
    revert   Ripristina
    colour   colore
    grey   grigio
    mono   mono
    portr   ritratto
    landsc   panorama
    legend   Legenda
    incscale   "Includi scala"
    more   Ancora
    name   Nome
    created   Creato
    cmmt   Commento
    withWP  "Con questo WP:"
    displ   "Mostra su mappa"
    startRT "Inizio RT"
    route   Rotta
    number   Numero
    insb   "Inserisci prima"
    insa   "Inserisci dopo"
    del   Cancella
    repl   "Sostituisci con"
    invRT   "Inverti RT"
    comp   Calcola
    RTcomp   "Calcola rotta"
    savecomp "Salva il calcolo"
    totdst   "Distanza totale"
    tottime   "Tempo complessivo"
    track   Traccia
    chophd   "Taglia la testa"
    choptl   "Taglia la coda"
    incb   "Includi Prima"
    date   Data
    newdate   "Nuova data per il prossimo punto"
    endprTR   "Fine della traccia precedente"
    begnxt   "Inizio della successiva"
    date1st   "Date for 1st point of next"
    TRcomp   "Track Computation"
    avgsp   "Velocit media"
    maxsp   "Velocit max"
    minsp   "Velocit min"
    lat   Lat
    long   Long
    ze   ZE
    zn   ZN
    eastng   Easting
    nrthng   Northing
    zone   Zona
    change   Cambia
    forget   Cancella
    others   Altri
    optLANG   Lingua
    optISOLATIN1   "Lettere accentate"
    optDELETE   "DEL cancella ultimo carattere"
    optMWINDOWSCONF  "Finestra principale"
    opt_GPSRecConf   "Parametri del ricevitore"
    optGPSREC   "Modello GPS"
    opt_Interf "Interfaccia utente"
    optNAMELENGTH   "Max lungh nomi"
    optINTERVAL "Intervallo di campionamento"
    optCOMMENTLENGTH   "Max lungh commento"
    optMAXWPOINTS   "Max # WPoints"
    optMAXROUTES   "Max # Rotte"
    optMAXWPINROUTE   "Max # WPs in Rotta"
    optMAXTPOINTS   "Max # Trackpoints"
    optCREATIONDATE   "Ric con data di creazione"
    optNOLOWERCASE   "Ric privo di lettere minuscole"
    optDEFAULTSYMBOL "Simbolo di default per WP"
    opt_Data "Dati"
    optEQNAMEDATA "Dati con lo stesso nome"
    optKEEPHIDDEN "Memorizza dati nascosti"
    optDatum   Datum
    optTimeOffset   "Offset temporale"
    optACCFORMULAE "Accurate formulae"
    optASKPROJPARAMS "Conferma parametri proiezione"
    optBalloonHelp "Balloon help"
    opt_Formats   "Unit e formati"
    optDISTUNIT   "Distanza"
    KM    km
    optPositionFormat   "Formato posizione"
    optDateFormat   "Formato data"
    opt_Geom   "Geometria finestre"
    optMAPWIDTH   "Largh mappa"
    optMAPHEIGHT   "Altezza mappa"
    optMAPSCLENGTH   "Lungh scala mappa"
    optMAPSCALE   "Scala mappa"
    optMAXMENUITEMS   "Max # menu items"
    optLPOSX   "Finestra liste x-pos"
    optLPOSY   "Finestra liste y-pos"
    optMPOSX   "Finestra mappa x-pos"
    optMPOSY   "Finestra mappa y-pos"
    optRPOSX   "Finestra ric x-pos"
    optRPOSY   "Finestra ric y-pos"
    optEPOSX   "Finestra errore x-pos"
    optEPOSY   "Finestra errore y-pos"
    optDPOSX   "Dialogo x-pos"
    optDPOSY   "Dialogo y-pos"
    optDPOSRTMAP "Offset RT/mappa dialogo"
    optLISTWIDTH   "Largh liste"
    optLISTHEIGHT   "Alt liste"
    optCOLOUR   Colori
    optCOLOUR,fg   "Primo piano"
    optCOLOUR,bg   Sfondo
    optCOLOUR,messbg     "Errore - sfondo"
    optCOLOUR,confbg     "Conferma - sfondo"
    optCOLOUR,selbg      "Selezione - sfondo"
    optCOLOUR,dialbg     "Input - sfondo"
    optCOLOUR,offline    "Ricevitore offline"
    optCOLOUR,online     "Ricevitore online"
    optCOLOUR,check      "Checkbutton selezionato"
    optMAPCOLOUR,mapsel     "Oggetto mappa selezionato"
    optMAPCOLOUR,WP         "Waypoints su mappa"
    optMAPCOLOUR,RT         "Rotte su mappa"
    optMAPCOLOUR,mkRT       "Rotte definite su mappa"
    optMAPCOLOUR,TR         "Tracce su mappa"
    optMAPCOLOUR,TP         "Punti tracce su mappa"
    optMAPCOLOUR,mapleg     "Legenda mappe"
    optMAPCOLOUR,anim       "Animazione su mappa"
    optMAPCOLOUR,emptygrid  "Immagine vuota"
    optMAPCOLOUR,fullgrid   "Immagine esistente"
    opt_Files "Dispositivi e file"
    optDEFSPORT "Device"
    optPERMS   "Permessi file"
    optPAPERSIZE "Formato carta"
    red   Rosso
    green   Verde
    blue   Blu
    owner   Owner
    permgroup   Group
    others   Others
    fread   Read
    fwrite   Write
    fexec   Exec
    mainwd   "Finestra principale"
    distazim   "Distanza e azimut"
    nearestWPs   "WP pi vicini"
    fromto   "Da %s a %s"
    degrees   gradi
    nameWPDistBear   "dist e azimut"
    nameWPNearest   "WP pi vicini"
    inrect   "Nel rettangolo"
    forthisWP   "per questo WP"
    formappedWPs   "per i WP su mappa"
    group   Gruppo
    element   Componente
    insert   Inserisci
    joinGR   "Unisci Gruppi"
    TRtoRT   "Conversione da TR a RT"
    TRRTnpoints   "N. punti da conservare"
    TRTRdispl   "Mostra TR ora"
    WP   WP
    RT   RT
    TR   TR
    GR   GR
    commrec   "Comunicazione con il ricevitore"
    abort   Abort
    ACKs   ACKs
    NAKs   NAKs
    packets   pacchetti
    unnamed   "(sconosciuto)"
    fromTR    "Da TR: %s"
    mapload "Geo-referenziare immagine"
    loadmback Carica
    savemback "Salva geo-ref info"
    chgmback Cambia
    clearmback Cancella
    backgrnd Sfondo
    nameMapBkInfo "Info sfondo"
    mpbkchg "Cambia sfondo"
    mpbkgrcs "Posizione rif. alla griglia"
    nameImage Immagine
    symbol Simbolo
    SYCATgeneral "Uso generale"
    SYCATland Terra
    SYCATwater Acque
    SYCATaviation Aviazione
    SY1st_aid "Primo Soccorso"
    SYWP_buoy_white "Boa, Bianca"
    SYWP_dot "WP"
    SYairport "Aeroporto"
    SYamusement_park "Parco Divertimenti"
    SYanchor "Ancora"
    SYavn_danger "Pericolo (avn)"
    SYball "Palla"
    SYbeach "Spiaggia"
    SYbell "Campana"
    SYboat "Barca"
    SYboat_ramp "Scalandrone"
    SYborder "Confine"
    SYbridge "Ponte"
    SYbuilding "Edificio"
    SYbuoy_amber "Boa, giallo ambra"
    SYbuoy_black "Boa, nera"
    SYbuoy_blue "Boa, blu"
    SYbuoy_green "Boa, verde"
    SYbuoy_green_red "Boa, verde-rossa"
    SYbuoy_green_white "Boa, verde-bianca"
    SYbuoy_orange "Boa, arancione"
    SYbuoy_red "Boa, rossa"
    SYbuoy_red_green "Boa, rosso-verde"
    SYbuoy_red_white "Boa, rosso-bianca"
    SYbuoy_violet "Boa, viola"
    SYbuoy_white "Boa, bianca"
    SYbuoy_white_green "Boa, bianco-verde"
    SYbuoy_white_red "Boa, bianco-rossa"
    SYcamping "Campeggio"
    SYcapitol_city "Citt, stella"
    SYcar "Auto"
    SYcar_rental "Noleggio auto"
    SYcar_repair "Auto officina"
    SYcasino "Casin"
    SYcastle "Castello"
    SYcemetery "Cimitero"
    SYchapel "Cappella"
    SYchurch "Chiesa"
    SYcircle_x "X cerchiata"
    SYcivil "Installazione civile"
    SYcrossing "Passerella"
    SYdam "Diga"
    SYdanger "Pericolo"
    SYdeer "Selvaggina"
    SYdiamond_green "Rombo, verde"
    SYdiamond_red "Rombo, rosso"
    SYdiver_down_1 "Punto immersione 1"
    SYdiver_down_2 "Punto immersione 2"
    SYdollar "Dollaro"
    SYdot "Punto"
    SYdrinking_water "Acqua Potabile"
    SYduck "Anatra"
    SYelevation "Rilievo"
    SYexit_no_serv "Uscita, senza servizi"
    SYexit "Uscita"
    SYfactory "Fabbrica"
    SYfish "Pesce"
    SYfitness "Fitness"
    SYflag "Bandiera"
    SYfreeway "Superstrada"
    SYfuel "Carburante"
    SYfuel_store "Carburante & negozio"
    SYgeo_name_land "Nome geografico, terra"
    SYgeo_name_man "Nome geografico, umano"
    SYgeo_name_water "Nome geografico, acqua"
    SYglider "Aliante"
    SYheliport "Eliporto"
    SYhorn "Corno"
    SYhouse "Casa"
    SYice_skating "Pattinaggio su ghiaccio"
    SYinfo "Info"
    SYintersection "Intersezione"
    SYis_highway "Strada di grande comunicazione"
    SYknife_fork "Cibo"
    SYladder "Scala"
    SYlanding "Atterraggio"
    SYlarge_city "Citt, grande"
    SYlarge_exit_ns "Uscita senza serv, grande"
    SYlarge_ramp_int "Rampa accesso, grande"
    SYlevee "Argine"
    SYlight "Faro"
    SYlodging "Alloggio"
    SYmany_fish "Banco di Pesci"
    SYmany_tracks "Molte impronte"
    SYmedium_city "Citt, media"
    SYmile_marker "Pietra Miliare"
    SYmilitary "Installazione militare"
    SYmine "Miniera"
    SYMOB "Uomo in mare!"
    SYmonument "Monumento"
    SYmountains "Monti"
    SYmovie "Cinema"
    SYmug "Bar"
    SYmuseum "Museo"
    SYntl_highway "Statale"
    SYnull "(trasparente)"
    SYnull_2 "(vuoto)"
    SYoil_field "Torre di estrazione"
    SYparachute "Paracadute"
    SYpark "Parco"
    SYparking "Parcheggio"
    SYpharmacy "Farmacia"
    SYphone "Telefono"
    SYpicnic "Picnic"
    SYpolice "Polizia"
    SYpost_office "Ufficio postale"
    SYprivate "Campo privato"
    SYradio_beacon "Radiofaro"
    SYramp_int "Rampa di accesso"
    SYrestrooms "WC"
    SYscenic "Panorama"
    SYschool "Scuola"
    SYseaplane "Idroscalo"
    SYshopping_cart "Centro commerciale"
    SYshort_tower "Torre, piccola"
    SYshowers "Docce"
    SYskiing "Sci d\'acqua"
    SYskull "Teschio"
    SYsmall_city "Citt, piccola"
    SYsnow_skiing "Sci"
    SYsoft_field "Soft field"
    SYsquare_green "Quadrato, verde"
    SYsquare_red "Quadrato, rosso"
    SYst_highway "Provinciale"
    SYstadium "Stadio"
    SYstore "Negozio"
    SYstreet_int "incrocio"
    SYsummit "Cima"
    SYswimming "Nuoto"
    SYtake_off "Decollo"
    SYtall_tower "Torre, alta"
    SYtheater Teatro
    SYtoll "Dogana, pedaggio"
    SYtow_truck "Carro attrezzi"
    SYtracks Impronte
    SYtrail_head "Inizio sentiero"
    SYtree "Albero"
    SYtruck_stop "Autoporto"
    SYtunnel "Tunnel"
    SYultralight "Ultraleggero"
    SYus_highway "Strada internazionale"
    SYweight_station "Stadera pubblica"
    SYwreck "Relitto"
    psvisible "Solo la parte visibile"
    DISPsymbol "Solo simbolo"
    DISPs_name "S & nome"
    DISPs_comment "S & commento"
    DISPname "Solo nome"
    DISPcomment "Solo commento"
    dispopt Mostra
    mapitems "Mostra oggetti sulla mappa"
    nameIC Icona
    prod Prodotto
    protcl "Protocollo"
    WPperRT "Waypoints per Route"
    about "Circa GPSMan..."
    contrib "Con il contributo di"
    errorsto "Riportare gli errori a:"
    obsTRToRT "WPs creati con conversione da TR a RT"
    nameLists "Liste"
    nameData "dati"
    MWCmap "Mappa"
    MWClists "Liste"
    MWCsingle "Finestra singola"
    search "Ricerca"
    rmrk "NB"
    closeto "Vicino a"
    with "Con"
    srchres "TROVATO"
    where "Dove"
    what "Cosa"
    list "lista"
    distance "Distanza"
    fromWP "dal Waypont"
    fromPos "dalla posizione"
    azimuth "puntamento-azimut"
    any "ogni"
    another "Altro"
    srchdd1 "Cerco su"
    srchdd2Data "tutti gli oggetti"
    srchdd2GR "Gruppo(i)"
    from "da"
    started "a partire da"
    transf  "Coord Trasf"
    TRNSFAffine    "Affine"
    TRNSFAffineConf  "Aff Conforme"
    TRNSFNoRot      "Conf No Rot"
    projection "Proiezione"
    lat0  "Lat del centro"
    long0 "Long del centro"
    k0 "Fattore di Scala a CM"
    PRJTM "Transversa di Mercatore"
    rename "Usare nuovo nome"
    oname "Nome originale"
    never "Mai"
    ask "Chiedi"
    always "Sempre"
    stage "Stage"
    label "Etichetta"
    alt "Altitudine"
    optALTUNIT "Altitudine"
    locate "Locate"
    animation  Animazione
    fast Rapido
    slow Lento
    start Inizio
    pause Pausa
    speed Velocit
    centred "centrato"
    state Stato
    animinit "inizio/fine"
    animon "attivata"
    animpause "pausa"
    animabort "interrompi"
    dolog "Registra"
    getlog "Ricevi log"
    hide "Nascondi"
    show "Mostra"
    posfixerror "Errore"
    restar "Riparti"
    mkTR "Elabora TR"
    namePVTData "Dati registrati"
    dontaskagain "Stop richieste"
    simul "simulatore"
    WPCapac "Massimo numero WP"
    ICCapac "Massimo numero icone"
    RTCapac "Massimo numero rotte"
    TRCapac "Massimo numero tracce"
    ICGraph "Simboli icone"
    loadgrels "Carica componenti"
    importgrels "Importa componenti"
    notinGR "non presenti nel (sotto)gruppo"
    onlyinGR "presenti nel (sotto)gruppo"
    NAUTMILE "miglio marino"
    STATMILE "miglio terrestre"
    opening "Apertura"
    suggested "suggerita"
    optCOLOUR,ballbg "Fumetto sfondo"
    optCOLOUR,ballfg "Fumetto primo piano"
    optMAPCOLOUR "Colori mappa"
    optDEFAULTDISPOPT "Modo default visual. WP"
    PRJTM "Trasversa di Mercatore"
    PRJCMP "Mappa militare Portoghese"
    PRJBNG "Griglia Nazionale Britannica"
    PRJBWI "Indie Occidentali Britanniche"
    PRJITM "Trasversa di Mercatore - Irlandese"
    PRJGKK "Reticolo Tedesco"
    mkavgWP "Elabora WP med."
    move Sposta
    define Definire
    open Apri
    defs "Definizioni"
    baseproj "Proiezione base"
    abbrev "Nome breve"
    grid Reticolo
    use Usare
    unit Unit
    feasting "Falsa origine Est"
    fnorthing "Falsa origine Nord"
    bounds Limiti
    fixeddatum "datum fissato"
    lat1  "Lat 1 parallelo"
    lat2  "Lat 2 parallelo"
    latF  "Lat falsa origine"
    longF "Long falsa origine"
    PRJKKJP "Reticolo base finlandese"
    PRJKKJY "Reticolo finlandese uniforme"
    PRJSEG "Reticolo svedese"
    elevation Profilo
    userdefs "Definizioni utente"
    actual "reale"
    atprevwp "Al WP precedente"
    here "Qui"
    chglstrs "Modifica il tratto precedente"
    chgnxtrs "Modifica il tratto successivo"
    contnend "Aggiungi alla fine"
    edmap "Modifica sulla mappa"
    prevwp "WP precedente"
    firstwp "Primo WP"
    chgpfrmt "Cammbia formato posizione"
    changegroupsymbol "Cambia simbolo"
    closemenu "Chiudi men"
    ellpsd "Ellissoide"
    inca  "Includi dopo"
    invert "Inverti"
    opt_MapGeom "Geometria mappa"
    PRJLCC1 "Conica Conf di Lambert 1"
    PRJLCC2 "Conica Conf di Lambert 2"
    recwindow "Finestra del ricevitore"
    restart "Riparti"
    rtimelogintv "Intervallo di acquisizione"
    usewps "Usa i WPs"
    optSAVESTATE "Salva lo stato prima di uscire"
    optDELSTATE "Cancella i files dopo aver ripristinato lo stato"
    nameMapInfo "settaggi mappa"
    no No
    PRJAPOLY "Policonica Americana"
    computations Calcolo
    comparea "Calcolo area"
    cluster Dintorni
    centre  Centro
    mkclusters "Costruisci dintorni"
    quadr Quadrangolo
    dlat "Escursione di latitudine"
    dlong "Escursione di longitudine"
    collcntr "Ricerco centri..."
    compclstr "Calcolo dintorni..."
    crtgclstrgrs "Creo gruppi..."
    PRJStereogr "Stereografica"
    PRJTWG "Griglia di Taiwan"
    chgdatum "Cambia datum"
    optPRINTCMD "Comando di stampa"
    print Stampa
    prevctr "Centro precedente"
    PRJSOM "Obliqua di Mercatore - Svizzera"
    PRJLV03 "Griglia svizzera LV03"
    PRJIcG "Griglia islandese"
    PRJRDG "Griglia Olandese"
    printopt "Opzioni di stampa"
    numberid "Num/Id"
    hiddendata "Dati protetti"
    YYYY/MM/DD  YYYY/MM/DD
    cwpsdef "Punti di taratura da definire ora:"
    nextTP "Prossimo TP"
    generate Generare
    optSERIALBAUD "Baud Rate"
    optDEFTRTWIDTH "Larghezza linee RT"
    optDEFTTRWIDTH "Larghezza linee TR"
    width Larghezza
    TRtoTR   "Semplificazione TR"
    TRlinedispl   "Mostra il risultato adesso"
    obsTRsimpl "TR risultante da semplificazione"
    simplTRto "Semplifica in"
    exstglog "Log esistente"
    contnsly "Continuamente"
    animate "anima"
    animabbrev "anim."
    noanabbr "no anim."
    zelev "Scala rilievo"
    xyelev "Ingrandimento piano orizz."
    notext "no testo"
    view "Mostra"
    sideview "Profilo"
    persptv "Prospettiva"
    SYgeocache "Geocache"
    SYgeocache_fnd "Geocache trovata"
    optMAPCOLOUR,trvtrk "Freccia TRK"
    optMAPCOLOUR,trvtrn "Frecce TRN"
    optMAPCOLOUR,trvcts "Freccia CTS"
    optMAPCOLOUR,trvcts2 "Seconda freccia CTS"
    optMAPCOLOUR,trvvel_z "Freccia Su/gi"
    optMAPCOLOUR,trvwrnimportant "Avviso importante (nav)"
    optMAPCOLOUR,trvwrnnormal "Avviso (nav)"
    optMAPCOLOUR,trvwrninfo "Informazione (nav)"
    travel Viaggio
    notravel "Stop navigazione"
    travdisplay "Configura schermata"
    travchgdisplay "Vai alla schermata %s"
    travdsetup "Configurare schermata viaggio"
    navMOB "MOB: Uomo In Mare! (Man Over Board)"
    startnav "Navigare"
    navWP "Vai a WP"
    goback "Torna indietro"
    follow "Segui %s"
    exactly "esattamente"
    fromnrst "Dal pi vicino"
    inrvrs "al contrario"
    forgetgoal "Dimentica la meta"
    suspend "Sospendi"
    resume "Riprendi"
    TRVfix "Fix"
    TRVhour "Tempo"
    TRVspeed "Velocita"
    TRVpos "Pos"
    TRValt "Alt"
    TRVtrk "TRK"
    TRVnxtWP "A"
    TRVprvWP "Da"
    TRVete "ETE"
    TRVeta "ETA"
    TRVvmg "VMG"
    TRVxtk "XTK"
    TRVcts "CTS"
    TRVtrn "TRN"
    TRVvel_z "V speed"
    TRVtrkcts "TRK, CTS"
    TRVdist "Dist"
    TRVc_trkcts "Frecce TRK/CTS"
    TRVc_trn "Frecce TRN"
    TRVc_vel_z "Freccia su/gi"
    add "Aggiungi"
    addlabelled "Aggingi con nome"
    remove "Rimuovi"
    mindist "Distanza minima per arrivo"
    chginggoal "Cambia e vai alla prossima meta"
    chggoalhlp "Quando cambiare dalla\nmeta attuale alla prossima\nseguendo una RT/TR"
    soon presto
    late tardi
    warnings "Avvertimenti"
    dowarn "Emetti avvertimenti"
    warnconf "Configura avvertimenti"
    priority Priorit
    high alta
    medium media
    low bassa
    warnprox "Distanza dal WP <"
    warnanchor "Distanza dal WP >"
    warnspeed "Velocit >"
    warntrn "TRN (abs)>"
    warnvspeed "Velocit verticale"
    warnxtk "XTK (abs)>"
    fntsize "Dimensione caratteri"
    trvhlpbox "Usare il tasto destro del mouse per\nriordinare gli elementi sottostanti"
    trvhlpbxs "Usare il tasto destro del mouse per\nriordinare gli elementi della lista"
    trvwarrv "Stiamo per arrivare a %s!"
    trvwleave "Stiamo lasciando %s!"
    trvwspeed "Velocit > %s!"
    trvwtrn "TRN > %s!"
    trvwvspeed "Velocit vert. non entro [%s,%s]!"
    trvwxtk "XTK > %s!"
    trvwnolog "Real-time logging NON attivo!"
    trvwnopos "Posizione precedente non disponibile"
    trvwuwps "RT ha WP non definiti"
    trvwchg "Ora andiamo verso %s"
    TP TP
    drivesim "simulatore di guida"
    startfrom "Parti da..."
    outofctrl "Fuori controllo!"
    right Destra
    left Sinistra
    straight Dritto
    rthlpdsim "Tasti frecce: sterza, accelera, decelera\nBarra spaziatrice: dritto"
    chggoal "Vai alla prossima meta"
    Ghidden_class Classe
    Ghidden_subclass Sottoclasse
    Ghidden_lnk_ident "Ident. tratto"
    Ghidden_colour Colore
    Ghidden_attrs Attributi
    Ghidden_depth Profondit
    Ghidden_state Stato
    Ghidden_country Regione
    Ghidden_facility "Installazione"
    Ghidden_city Citt
    Ghidden_addr Indirizzo
    Ghidden_int_road "Intersezione stradale"
    Ghidden_dtyp "Mostra opt+type"
    Ghidden_ete "ETE"
    Ghidden_display "Mostrare?"
    Ghidden_yes S
    Ghidden_no No
    Ghidden_user "Utente"
    Ghidden_user_symbol "Utente (solo simbolo)"
    Ghidden_non_user "Non utente"
    Ghidden_avn_airport "Aeroporto"
    Ghidden_avn_inters "Intersezione Avn"
    Ghidden_avn_NDB "NDB"
    Ghidden_avn_VOR VOR
    Ghidden_avn_airp_rway "Soglia pista rollaggio"
    Ghidden_avn_airp_int "Intersezione aeroportuale"
    Ghidden_avn_airp_NDB "Aeroporto NDB"
    Ghidden_map_pt "Punto mappa"
    Ghidden_map_area "Area mappa"
    Ghidden_map_int "Intersezione mappa"
    Ghidden_map_addr "Indirizzo mappa"
    Ghidden_map_line "Linea mappa"
    Ghidden_locked "Protetto"
    Ghidden_default Default
    Ghidden_black Nero
    Ghidden_white Bianco
    Ghidden_red Rosso
    Ghidden_dark_red "Rosso scuro"
    Ghidden_green Verde
    Ghidden_dark_green "Verde scuro"
    Ghidden_blue Blu
    Ghidden_dark_blue "Blu scuro"
    Ghidden_yellow Giallo
    Ghidden_dark_yellow "Giallo scuro"
    Ghidden_magenta Magenta
    Ghidden_dark_magenta "Magenta scuro"
    Ghidden_cyan Ciano
    Ghidden_dark_cyan "Ciano scuro"
    Ghidden_light_gray "Grigio chiaro"
    Ghidden_dark_gray "Grigio scuro"
    Ghidden_line Linea
    Ghidden_link Tratto
    Ghidden_net Rete
    Ghidden_direct Diretto
    forgetGRcs "Rimuovi GR&Els"
    renres "RINOMINATO"
    PRJBMN "Griglia Austriaca BMN"
    PRJCTR "Carta Tecnica Reg (I)"
    optDEFMAPPROJ "Proiezione Mappa"
    optDEFMAPPFRMT "Coordinate mappa"
    optMapGuideVersion "Versione MapGuide"
    undo Annulla
    UTMzone zona
    tfwfile  "file TFW"
    ok Ok
    GRA   "Gradi centesimali"
    newWPatdb "Nuovo WP a..."
    PRJLamb93 "Lambert 93"
    PRJLambNTFe "NTF IIet"
    PRJLambNTF "NTF"
    NTFzone zona
    opinprogr "Operazione in esecuzione"
    working "In funzione"
    aborted "Abortito!"
    errwarn "Errore/avviso(i)!"
    SYbiker "Ciclista"
    SYbox_blue "Scatola blu"
    SYbox_green "Scatola verde"
    SYbox_red "Scatola rossa"
    SYflag_pin_blue "Bandierina blu"
    SYflag_pin_green "Bandierina verde"
    SYflag_pin_red "Bandierina rossa"
    SYhouse_2 "Casa 2"
    SYpin_blue "Spillo blu"
    SYpin_green "Spillo verde"
    SYpin_red "Spillo rosso"
    ozimapfile "file Ozi Map"
    info "Informazione"
    climbrate "Velocit ascensionale"
    BGAfeature "Funzionalit"
    BGAfindblty "Identificabile semplicamente"
    BGAairact   "Attivit aerea"
    optUSESLOWOPWINDOW "Finestra per il controllo di operazioni lente"
    optDEFTRECPROTOCOL "Protocollo di default"
    optLNSREACT "LN mappate rispondono al mouse"
    syhlpbx "Usare il tasto destro del mouse per\nriordinare gli elementi della lista"
    optDEFMAPPFDATUM "Datum delle coordinate della mappa"
    mkgrp "Crea Gruppo"
    dispitems "Oggetti visibili"
    hiditems "Oggetti nascosti"
    optAutoNumRts "Numerare automaticamente le RT in uscita"
    Ghidden_transparent Transparente
    Ghidden_temp Temperatura
    Ghidden_time "Time stamp"
    Ghidden_cat Categoria
    SYopen_24hr "Aperto 24 ore"
    SYfhs_facility "Attrezzature FHS"
    SYbot_cond "Condizioni del fondo"
    SYtide_pred_stn "Stazione previsione marea/correnti"
    SYanchor_prohib "Divieto d'ancoraggio"
    SYbeacon "Segno"
    SYcoast_guard "Guardia Costiera"
    SYreef "Secca"
    SYweedbed "Banco d'alghe"
    SYdropoff "Ingresso"
    SYdock "Dock"
    SYmarina "Porticciolo"
    SYbait_tackle "Esche ed attrezzatura da pesca"
    SYstump "Ceppo"
    SYcntct_smiley "Smiley"
    SYcntct_ball_cap "Berretto da baseball"
    SYcntct_big_ears "Grande orecchio"
    SYcntct_spike "Punta"
    SYcntct_goatee "Pizzetto"
    SYcntct_afro "Cespuglio"
    SYcntct_dreads "Treccine"
    SYcntct_female1 "Femminile 1"
    SYcntct_female2 "Femminile 2"
    SYcntct_female3 "Femminile 3"
    SYcntct_ranger "Ranger"
    SYcntct_kung_fu "Kung fu"
    SYcntct_sumo "Sumo"
    SYcntct_pirate "Pirata"
    SYcntct_biker "Ciclista"
    SYcntct_alien "Alieno"
    SYcntct_bug "Insetto"
    SYcntct_cat "Gatto"
    SYcntct_dog "Cane"
    SYcntct_pig "Maiale"
    SYhydrant "Idrante Antincendio"
    SYcircle_blue "Cerchio blu"
    SYcircle_green "Cerchio verde"
    SYcircle_red "Cerchio rosso"
    SYdiamond_blue "Rombo blu"
    SYoval_blue "Ovale blu"
    SYoval_green "Ovale verde"
    SYoval_red "Ovale rosso"
    SYrect_blue "Cubo blu"
    SYrect_green "Cubo verde"
    SYrect_red "Cubo rosso"
    SYsquare_blue "Quadrato blu"
    SYtriangle_blue "Triangolo blu"
    SYtriangle_green "Triangolo verde"
    SYtriangle_red "Triangolo rosso"
    SYletter_a_blue "A blu"
    SYletter_a_green "A verde"
    SYletter_a_red "A rosso"
    SYletter_b_blue "B blu"
    SYletter_b_green "B verde"
    SYletter_b_red "B rosso"
    SYletter_c_blue "C blu"
    SYletter_c_green "C verde"
    SYletter_c_red "C rosso"
    SYletter_d_blue "D blu"
    SYletter_d_green "D verde"
    SYletter_d_red "D rosso"
    SYnumber_0_blue "0 blu"
    SYnumber_0_green "0 verde"
    SYnumber_0_red "0 rosso"
    SYnumber_1_blue "1 blu"
    SYnumber_1_green "1 verde"
    SYnumber_1_red "1 rosso"
    SYnumber_2_blue "2 blu"
    SYnumber_2_green "2 verde"
    SYnumber_2_red "2 rosso"
    SYnumber_3_blue "3 blu"
    SYnumber_3_green "3 verde"
    SYnumber_3_red "3 rosso"
    SYnumber_4_blue "4 blu"
    SYnumber_4_green "4 verde"
    SYnumber_4_red "4 rosso"
    SYnumber_5_blue "5 blu"
    SYnumber_5_green "5 verde"
    SYnumber_5_red "5 rosso"
    SYnumber_6_blue "6 blu"
    SYnumber_6_green "6 verde"
    SYnumber_6_red "6 rosso"
    SYnumber_7_blue "7 blu"
    SYnumber_7_green "7 verde"
    SYnumber_7_red "7 rosso"
    SYnumber_8_blue "8 blu"
    SYnumber_8_green "8 verde"
    SYnumber_8_red "8 rosso"
    SYnumber_9_blue "9 blu"
    SYnumber_9_green "9 verde"
    SYnumber_9_red "9 rosso"
    numberfrom0 "Poni contatore a 1"
    items "Oggetti"
    syusrmenu "Men utente simboli"
    cfgsymenu "Configura men utente simboli"
    insmnb   "Inserisci sub-men prima"
    insmna   "Inserisci sub-men dopo"
    opensbmn "Apri sub-men"
    clssbmn  "Chiudi sub-men"
    optSUPPORTLAPS "Supporto giri"
    LAP  GIRO
    nameLAP "Giro"
    duration "Tempo"
    calrs "Calorie"
    fromfile "da file"
    fromdef "da definizione"
    mbaktoload "Sfondo da caricare"
    none "nessuno"
    opt_Fonts "Font"
    optICONSIZE "Dimensioni icone"
    optTRNUMBERINTVL "Mostra info TP su mappa ad ogni"
    optTRINFO "Info TP da mostrare" 
    nameInfo "Informazioni"
    nameAL "Almanacco"
    alm_svid "id satellite"
    alm_week "settimana"
    alm_datatime "tempo rif. dati"
    alm_clockc1 "coeff corr clock s"
    alm_clockc2 "coeff corr clock s/s"
    alm_ecc "eccentricit"
    alm_mnanom "anomalia media"
    alm_argprgee "arg. perigeo"
    alm_rightasc "ascensione retta"
    alm_rtrightasc "var. asc. retta"
    alm_inclin "inclinazione"
    alm_health "salute"
    lstsqs "Minimi Quadrati"
    lstsqsfile "file Min Quadrati"
    totdstng   "Distanza totale, senza separazioni"
    tottimeng  "Tempo totale, senza separazioni"
    SYcross "Mirino"
    SYcross_3p "Mirino 3p"
    mapfitWPs "Mostra WP usati per minimi quadrati"
    showfitinfo "Mostra info sui minimi quadrati"
    xtcoord "xt"
    ytcoord "yt"
    delta   "d"
    residual "rt"
    rmsxydev "rms(deviazioni x,y)"
    resstderr "errore std residuo"
    chgdev "Cambia dispositivo"
    maxalt "Altitudine massima"
    minalt "Altitudine minima"
    alt_cumul "Altezza cumulativa di salita"
    alt_cumuld "Discesa cumulativa"
    optSHOWFILEITEMS "Mostra di default sulla mappa gli oggetti leti da file"
    vertgridlines "Linee Vert Griglia"
    convert  "Converti"
    split    "Dividi"
    bysel  "per punti selezionati"
    byseg  "per segmenti"
    openits "Apri %s"
    uname "Nome utente"
    pword "Password"
    remember "Ricordare"
    wptotwitter "Inviare WP a Twitter"
    wptotwitternb "Inviare posizione WP, datum, altitudine, nome e commento a 
Twitter con etichetta #GPSMan #waypoint"
    exportTFW "Esportare file TWF"
    nametfwfile "File TFW"
    PRJEOV  EOV
    chgname "Cambiare nome"
    clicktoedit "Click per editare"
    renamethod "Metodo per rinomina"
    operators "Operatori"
    keep1st "tenere il primo carattere"
    keep1st_hlp "Tenere il primo carattere\nulteriori operazioni sui rimanenti"
    reset "reset"
    reset_hlp "Ripartenza con il nome iniziale ignorando i cambiamenti effettuati"
    case "cambiare maiuscolo/minuscolo"
    case_hlp "Tutte le lettere in maiuscolo/minuscolo"
    maxlgth "lungh max"
    maxlgth_hlp "Caratteri correnti tagliati al numero dato"
    inslt "inserire a sinistra"
    inslt_hlp "Inserire la stringa a sinistra prima del carattere corrente"
    insrt "inserire a destra" 
    insrt_hlp "Inserire la stringa a sinistra alla fine"
    replc "sostituire"
    replc_hlp " i caratteri della prima stringa verranno sostituiti\ndai corrispondenti nella seconda"
    delany "cancellare"
    delany_hlp "Tutti i caratteri nella stringa data verranno cancellati dal nome"
    rsub "re. sostituzione"
    rsub_hlp "Fornire espressione regolare e specifiche di sostituzione\nsi veda il manuale per dettagli"
    accifnew "accettare se nuovo"
    accifnew_hlp "Accettare il risultato se il nome non  in uso"
    guntilnew "aggiungere in coda numero sino a trovare nuovo"
    guntilnew_hlp "Tentare con tutti i valori possibili del numero sino a che si trovi un nome non in uso" 
    ndigits "Numero di cifre"
    gennames "Generazione nomi in corso..."
    rentest_hlp "Testare il metodo corrente su un nome dato"
    renmove_hlp "Usare il bottone destro per riordinare le linee"
    tolower "a minuscolo" 
    toupper "a maiuscolo"
    applyto "Applicare a"
    forall "per tutti"
    failed "fallito"
    selfont "Selezione font"
    default  "Default"
    size "Dimensione"
    units "Unit"
    points "punti"
    pixels "pixel"
    weight "peso"
    normal "normale"
    bold "grassetto"
    slant   "inclinazione"
    roman "romano"
    italic "italico"
    underline "Sottolineato"
    overstrike "Cancellato"
    optDEFAULTFONT "Default font"
    optFIXEDFONT "Font fixed"
    optMAPFONT "Font mappa"
    optTRAVELFONT "Font viaggio"
    optPLOTFONT "Font plot/graph"
    plugin  "Plug-in"
    unavailif  "Non disponibile se"
    tclcode  "Codice Tcl"
}

    # the following definitions must be coherent with $TXT
array set INVTXT {
    DMS   DMS
    DMM   DMM
    DDD   DDD
    {Gradi centesimali}  GRA
    UTM/UPS   UTM/UPS
    WP   WP
    RT   RT
    TR   TR
    GIRO LAP
    GR   GR
}

