#!/usr/bin/perl -w
use strict;
use Time::HiRes;
use Getopt::Std;
use network::CsaFileSession;

my %options;
getopts("s:d:k",\%options);

my $dir = $options{d} || ".";
my $id = $options{s} || 0;
my $keep_alive = $options{k} || 0;

my $session = new CsaFileSession($dir, $id);

print STDERR "wait for $dir/$id\n";
my $sleep_count = 0;
while (1) {
  if (my $message = $session->try_read()) {
    print $message."\n";
    print STDERR "wait for $dir/".$session->id()."\n";
  } else {
    Time::HiRes::usleep(50*1000);
    $sleep_count += 50;
    if ($keep_alive && $sleep_count >= 60*1000) {
      print "\n";
      $sleep_count = 0;
    }
  }
}
