/* extract.cc
 */
#include "osl/record/kisen.h"
#include "osl/applyMove.h"
#include <boost/scoped_ptr.hpp>
#include <iostream>
#include <fstream>
#include <cstdlib>
#include <unistd.h>

/**
 * @file
 * ɸϤɤ߹ ID  ζ̤.
 * 0 ʤ̤μʤμؤ塥
 * evalrecord μƱ
 */
using namespace osl;

void usage(const char *prog)
{
  using namespace std;
  cerr << "Usage: " << prog << " [-o output-filename] [-c] -k kisenFilename < record-id-move-index\n"
       << "-c\t change turn\n"
       << endl;
  exit(1);
}

bool change_turn = false;
std::ostream *os = 0;
void processRecord(SimpleState& state, 
		   const osl::vector<Move>& moves, unsigned int index)
{
  assert(index <= moves.size());
  for (size_t i=0; i<moves.size(); i++)
  {
    ApplyMoveOfTurn::doMove(state, moves[i]);
    if (i == index)
      break;
  }
  if (change_turn)
    state.changeTurn();
  (*os) << state;
}

void processId(KisenFile& kisenFile,
	       size_t record_id, size_t move_id)
{
  SimpleState state(HIRATE);
  const osl::vector<Move> moves=kisenFile.getMoves(record_id);
  processRecord(state, moves, move_id);
}

int main(int argc, char **argv)
{
  const char *program_name = argv[0];
  bool error_flag = false;
  const char *kisenFilename = 0;
  os = &std::cout;
  boost::scoped_ptr<std::ofstream> output_file;

  extern char *optarg;
  extern int optind;
  char c;
  while ((c = getopt(argc, argv, "ck:o:vh")) != EOF)
  {
    switch(c)
    {
    case 'c':	change_turn = true;
      break;
    case 'k':	kisenFilename = optarg;
      break;
    case 'o':	output_file.reset(new std::ofstream(optarg));
      os = output_file.get();
      break;
    default:	error_flag = true;
    }
  }
  argc -= optind;
  argv += optind;

  if (error_flag || (! kisenFilename))
    usage(program_name);

  KisenFile kisenFile(kisenFilename);
  size_t record_id, move_id;
  if (argc)
  {
    while (argc >= 2)
    {
      record_id = atoi(argv[0]);
      move_id = atoi(argv[1]);
      argc -= 2;
      argv += 2;
      processId(kisenFile, record_id, move_id);
    }
  }
  else
  {
    while (std::cin >> record_id >> move_id)
    {
      processId(kisenFile, record_id, move_id);
    }
  }
  
}


/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
