#ifndef _POS2IMG_H
#define _POS2IMG_H

#include "osl/ptype.h"
#include "osl/state/simpleState.h"
#include <Magick++.h> 
#include <boost/scoped_ptr.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/filesystem.hpp>
#include <string>

namespace bf = boost::filesystem;
using namespace osl;

typedef boost::shared_ptr<Magick::Image> ImagePtr;

/**
 * PieceImage represents an image of a piece.
 */
class PieceImage
{
private:
  const double dpi; /// dot per inch
  const double cell_width;
  const double cell_height;
  const double scale; /// ratio: cell_width to cell_hight
public:
  explicit PieceImage(const double cell_width, const double scale)
    : dpi(72.0), cell_width(cell_width), scale(scale), cell_height(cell_width*scale) {}
  ImagePtr image(const PtypeO& ptypeO) const;
  ImagePtr image(const std::string& s) const;
};

/**
 * BoardImage reprensets an image of a board.
 */
class BoardImage
{
private:
  const SimpleState state;
  double scale; /// ratio of width to height
  double image_width;
  double image_height;
  double board_origin_x;
  double board_origin_y;
  double board_width;
  double board_hegiht;
  double cell_width;
  double cell_height;
  boost::scoped_ptr<Magick::Image> image;
public:
  explicit BoardImage(const SimpleState& state)
    : state(state) 
  {
    scale          = 1.1; // width-height ratio of the board
    image_width    = 297.0;
    image_height   = image_width*scale;
    board_origin_x = image_width*0.2;
    board_origin_y = board_origin_x*scale;
    board_width    = image_width - board_origin_x*2.0;
    board_hegiht   = board_width*scale;
    cell_width     = board_width/9.0;
    cell_height    = cell_width*scale;
  }
  /** BLACK̎̕Ԃ */
  std::string blackStand() const;
  /** WHITE̎̕Ԃ */
  std::string whiteStand() const;
  /** iɁjՖʂ̉摜`悷 */
  void draw();
  /** drawꂽՖʂ̉摜t@CɏBdraw()ĂяoƁB */
  void write(const std::string& file_name) const;
};

class ProcessBoard
{
private:
  const bf::path dir;
public:
  ProcessBoard(const bf::path& dir)
    : dir(dir) {}
  std::string generate(const std::string& board_id) const;
  std::string eliminateSfen(const std::string& sfen) const;
  bool isOld(const bf::path& file) const;
  bool isPossibleSfenCharacters(const std::string& sfen) const;
};


/** ̊\LԂ  */
std::string kanji(const PtypeO& ptypeO);
/** Ԃi̐Ȃǂŗpj */
std::string kanjiNumber(const int n);
std::string processBoard(const std::string& board_id, 
                         const bf::path& dir);

#endif /* _POS2IMG_H */
