#!/usr/bin/ruby

require '../gen-rb/ShogiGraphic'
require 'thrift/transport/socket'
require 'thrift/protocol/tbinaryprotocol'

require "test/unit"

class TestUsi < Test::Unit::TestCase
  def setup
    @transport = Thrift::BufferedTransport.new(Thrift::Socket.new('localhost', 9090))
    @client    = ShogiGraphic::Client.new(Thrift::BinaryProtocol.new(@transport))
    @transport.open
  end

  def teardown
    @transport.close
  end

  def test_usi2png
    ret = @client.usi2png("lnsgkgsnl_1r5b1_ppppppppp_9_9_9_PPPPPPPPP_1B5R1_LNSGKGSNL.b.-")
    assert_equal "lnsgkgsnl_1r5b1_ppppppppp_9_9_9_PPPPPPPPP_1B5R1_LNSGKGSNL.b.-.png", ret
  end

  def test_usi2png_error
    ret = @client.usi2png("should be error")
    assert_equal "", ret
  end
end
