#ifndef _CHECKMATE_VIEWER_H
#define _CHECKMATE_VIEWER_H
#include "boardAndListTabChild.h"
#include "moveTree.h"

#include "osl/state/numEffectState.h"
#include "osl/checkmate/dualDfpn.h"
#include "osl/checkmate/dfpn.h"

#include <boost/scoped_ptr.hpp>

class CheckMoveItem;
class MoveCountTip;

class CheckMoveViewer : public MoveTree
{
  Q_OBJECT
public:
  CheckMoveViewer(QWidget *parent = 0, const char *name = 0);
  ~CheckMoveViewer();
  bool analyze(const osl::state::NumEffectState &state, int node_limit,
	       bool change_turn);
  const osl::state::NumEffectState initialState() const { return initial_state; }
  const osl::checkmate::DfpnTable& getTable() const { return *table; }
private slots:
  void showRecord();
  void showMoves();
  void showMovesInKanji();
protected:
  void showRecord(const osl::checkmate::DfpnRecord& record);
  void showContextMenu(Q3PopupMenu *);
private:
  enum check_state
  {
    CHECKMATE = 0,
    NO_CHECKMATE,
    NO_CHECKMATE_LOOP,
    UNKNOWN
  };

  check_state analyze(const osl::state::NumEffectState &state, int table_size,
		      int node_limit, bool change_turn);

  typedef osl::checkmate::DualDfpn searcher_t;
  boost::scoped_ptr<searcher_t> searcher;
  osl::state::NumEffectState initial_state;
  const osl::checkmate::DfpnTable *table; // acquaintance
#if QT_VERSION <= 0x040000
  MoveCountTip *tip;
#endif
};

class CheckmateViewer : public BoardAndListTabChild
{
public:
  CheckmateViewer(QWidget *parent = 0, const char *name = 0);
  bool analyze(const osl::state::NumEffectState &state, int node_limit,
	       bool change_turn=false);
};
#endif // _CHECKMATE_VIEWER_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
