#ifndef _NTESUKI_VIEWER_H
#define _NTESUKI_VIEWER_H
#include "boardAndListTabChild.h"
#include "moveTree.h"

#include "osl/ntesuki/ntesukiTable.h"
#include "osl/ntesuki/ntesukiSearcher.h"

class NtesukiMoveItem;
class NtesukiTip;

class NtesukiMoveViewer : public MoveTree
{
  Q_OBJECT

public:
  NtesukiMoveViewer(QWidget *parent = 0, const char *name = 0);
  ~NtesukiMoveViewer();
  bool analyze(const osl::state::SimpleState &state);
  int node_limit, read_limit, ntesuki_limit;
  typedef osl::ntesuki::NtesukiSearcher searcher_t;
  typedef osl::ntesuki::NtesukiMoveGenerator movegen_t;


public slots:
#if QT_VERSION >= 0x040000
 void expandNode(Q3ListViewItem *item);
#else
 void expandNode(QListViewItem *item);
#endif

  void setState(osl::state::SimpleState *s)
  {
    state = s;
  }
private:
  searcher_t *searcher;
  
  void addItem(NtesukiMoveItem *parent);
#if QT_VERSION < 0x040000
  NtesukiTip *tip;
#endif
  const osl::ntesuki::NtesukiTable* table;
  osl::state::SimpleState *state;
  movegen_t *mg;
};

class NtesukiViewer : public BoardAndListTabChild
{
public:
  NtesukiViewer(QWidget *parent = 0, const char *name = 0);
  bool analyze(const osl::state::SimpleState &state);
};
#endif // _NTESUKI_VIEWER_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
