/*
 *  greyscale.c 
 *
 *  Copyright (c) 2005 Giansalvo Gusinu <giansalvo at gusinu.net>
 *  Copyright (C) 1999 Cory Lueninghoener (cluenin1@bigred.unl.edu)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 */

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <pthread.h>
#include <linux/types.h> 
#include <gtk/gtk.h>
#include <linux/videodev.h>
#include <png.h>

#include "gqcam.h"
#include "frontend.h"
#include "greyscale.h"



void create_controls_greyscale(struct Camera *camera) 
{
  GtkWidget *tmp0, *tmp; /* temporary pointer used to create the widgets */    
  /*
  GtkWidget *outerbox;
  GtkWidget *innerbox;
  GtkWidget *scalebox;
  GtkWidget *sizedepthbox;
  GtkWidget *frame;
  GtkObject *adjbrightness;
  GtkWidget *scalebrightness;
  GtkObject *adjwhite;
  GtkWidget *scalewhite;
  GtkObject *adjcontrast;
  GtkWidget *scalecontrast;
  */

  /* Create new outerbox */
  camera->controltop = gtk_hbox_new (FALSE, 0);

  /* Create scalebox */
  camera->controls.scalebox = gtk_vbox_new (FALSE, 2);
  gtk_widget_set_usize (GTK_WIDGET(camera->controls.scalebox), 240, 150);
  gtk_box_pack_start( GTK_BOX (camera->controltop), camera->controls.scalebox, 1, 1, 0);
  gtk_widget_show (camera->controls.scalebox);

  /* Create Brightness Scale */
  camera->controls.frame = gtk_frame_new("Brightness");
  gtk_box_pack_start( GTK_BOX (camera->controls.scalebox), camera->controls.frame, 1, 1, 0);
  gtk_widget_show (camera->controls.frame);

  camera->controls.adjbrightness = gtk_adjustment_new(camera->vid_pic.brightness/256, 0, 255, 1, 10, 1);
  camera->controls.scalebrightness = gtk_hscale_new(GTK_ADJUSTMENT(camera->controls.adjbrightness));

  gtk_signal_connect (GTK_OBJECT (camera->controls.adjbrightness), "value_changed",
	 	      GTK_SIGNAL_FUNC (setbrightness), camera);

  gtk_scale_set_digits(GTK_SCALE(camera->controls.scalebrightness), 0);
  gtk_container_add (GTK_CONTAINER (camera->controls.frame), camera->controls.scalebrightness);
  gtk_widget_show (camera->controls.scalebrightness);
  
  /* Create White Balance Scale */
  camera->controls.frame = gtk_frame_new("White Balance");
  gtk_box_pack_start( GTK_BOX (camera->controls.scalebox), camera->controls.frame, 1, 1, 0);
  gtk_widget_show (camera->controls.frame);
  camera->controls.adjwhite = gtk_adjustment_new(camera->vid_pic.whiteness/256, 0, 255, 1, 10, 1);
  camera->controls.scalewhite = gtk_hscale_new(GTK_ADJUSTMENT(camera->controls.adjwhite));

  gtk_signal_connect (GTK_OBJECT (camera->controls.adjwhite), "value_changed",
	 	      GTK_SIGNAL_FUNC (setwhite), camera);

  gtk_scale_set_digits(GTK_SCALE(camera->controls.scalewhite), 0);
  gtk_container_add (GTK_CONTAINER (camera->controls.frame), camera->controls.scalewhite);
  gtk_widget_show (camera->controls.scalewhite);

  /* Create Contrast Scale */
  camera->controls.frame = gtk_frame_new("Contrast");
  gtk_box_pack_start( GTK_BOX (camera->controls.scalebox), camera->controls.frame, 1, 1, 0);
  gtk_widget_show (camera->controls.frame);

  camera->controls.adjcontrast = gtk_adjustment_new( camera->vid_pic.contrast/256, 0, 255, 1, 10, 1);
  camera->controls.scalecontrast = gtk_hscale_new(GTK_ADJUSTMENT(camera->controls.adjcontrast));

  gtk_signal_connect (GTK_OBJECT (camera->controls.adjcontrast), "value_changed",
		      GTK_SIGNAL_FUNC (setcontrast), camera);

  gtk_scale_set_digits(GTK_SCALE(camera->controls.scalecontrast), 0);
  gtk_container_add (GTK_CONTAINER (camera->controls.frame), camera->controls.scalecontrast);
  gtk_widget_show (camera->controls.scalecontrast);

  /* Create sizedepthbox */
  camera->controls.sizedepthbox = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start( GTK_BOX (camera->controltop), camera->controls.sizedepthbox, 1, 1, 0);
  gtk_widget_show (camera->controls.sizedepthbox);

  /************************************************/
  /* Size box with radio button Full/Half/Quarter */
  /************************************************/
  camera->controls.frame = gtk_frame_new("Size");
  gtk_box_pack_start( GTK_BOX (camera->controls.sizedepthbox), camera->controls.frame, 1, 1, 0);
  gtk_widget_show (camera->controls.frame);

  camera->controls.innerbox = gtk_vbox_new (TRUE, 0);
  gtk_container_add (GTK_CONTAINER (camera->controls.frame), camera->controls.innerbox);
  gtk_widget_show (camera->controls.innerbox);

  /* Full */
  tmp0 = gtk_radio_button_new_with_label (NULL, "Full");
  gtk_box_pack_start(GTK_BOX(camera->controls.innerbox), tmp0, TRUE, TRUE, 0);
  if (camera->vid_win.width == camera->vid_caps.maxwidth)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tmp0), TRUE);
  gtk_signal_connect(GTK_OBJECT(tmp0), "pressed", GTK_SIGNAL_FUNC(setsizefull), camera);
  gtk_widget_show(tmp0);
  
  //  camera->controls.radiogroup = gtk_radio_button_group(GTK_RADIO_BUTTON(tmp));

  /* Half */
  tmp = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(tmp0)), "Half");
  gtk_box_pack_start(GTK_BOX(camera->controls.innerbox), tmp, TRUE, TRUE, 0);
  if (camera->vid_win.width == (camera->vid_caps.maxwidth)/2)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tmp), TRUE);
  gtk_signal_connect(GTK_OBJECT(tmp), "pressed", GTK_SIGNAL_FUNC(setsizehalf), camera);
  gtk_widget_show (tmp);

  /* Quarter */
  tmp = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(tmp0)), "Quarter");
  gtk_box_pack_start(GTK_BOX(camera->controls.innerbox), tmp, TRUE, TRUE, 0);
  if (camera->vid_win.width == (camera->vid_caps.maxwidth)/4)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tmp), TRUE);
  gtk_signal_connect(GTK_OBJECT(tmp), "pressed", GTK_SIGNAL_FUNC(setsizequarter), camera);
  gtk_widget_show(tmp);

  /* ...and this is the depth */
  camera->controls.frame = gtk_frame_new("Depth");
  gtk_box_pack_start( GTK_BOX (camera->controls.sizedepthbox), camera->controls.frame, 1, 1, 0);
  gtk_widget_show (camera->controls.frame);

  camera->controls.innerbox = gtk_vbox_new (TRUE, 0);
  gtk_container_add (GTK_CONTAINER (camera->controls.frame), camera->controls.innerbox);
  gtk_widget_show (camera->controls.innerbox);

  /*WARNING! code modified, but NOT tested (replaced "camera->controls.radiobutton" with "tmp") */

  /* 4 bpp */
  tmp0 = gtk_radio_button_new_with_label (NULL, "4 bpp");
  gtk_box_pack_start (GTK_BOX (camera->controls.innerbox), tmp0, TRUE, TRUE, 0);
  if (camera->vid_pic.depth == 4)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(tmp0), TRUE);
  gtk_signal_connect(GTK_OBJECT(tmp0), "pressed", GTK_SIGNAL_FUNC(setdepth4), camera);
  gtk_widget_show (tmp0);

  /* create the radiogroup */
  //  camera->controls.radiogroup = gtk_radio_button_group(GTK_RADIO_BUTTON(tmp0));
  
  /* 6 bpp */
  tmp = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(tmp0)), "6 bpp");
  gtk_box_pack_start(GTK_BOX(camera->controls.innerbox), tmp, TRUE, TRUE, 0);
  if (camera->vid_pic.depth == 6)
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tmp), TRUE);
  gtk_signal_connect(GTK_OBJECT(tmp), "pressed", GTK_SIGNAL_FUNC(setdepth6), camera);

  gtk_widget_show(tmp);

  gtk_widget_show(camera->controltop);
}
