/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_SQLite_CONNECTION_H)
#define __INC_SQLite_CONNECTION_H


#include "driver.h"

#include <sqlite.h>

#include "gql++/connection.h"

namespace GQL
{

class ResultSet;

namespace SQLite
{

class SQLiteDatabaseMetaData;

class SQLiteConnection : public Connection
{
  public:
    SQLiteConnection(const std::map<std::string, std::string>& props,
                     const std::string& db,
                     const std::string& url,
                     SQLiteDriver *driver);
    virtual ~SQLiteConnection();

    // Methods inherited from Connection
    virtual Statement *create_statement();
    virtual PreparedStatement *prepare_statement(const std::string& sql);
    virtual CallableStatement *prepare_call(const std::string& sql);

    virtual void commit();
    virtual bool get_auto_commit() const { return auto_commit_; }
    virtual void set_auto_commit(bool auto_commit = true);
    virtual void rollback();
    virtual std::string get_catalog() const;
    
    virtual std::string native_sql(const std::string& sql) const;
    
    virtual DatabaseMetaData *get_meta_data();

    virtual void set_read_only(bool read_only = true) {
      read_only_ = read_only;
    }
    virtual bool is_read_only() const {
      return read_only_;
    }
    
    virtual SQLObject *create_object();
    
    // Additional methods
    ResultSet *exec_sql(const std::string& sql);
    sqlite *sqlite_connection() { return conn_; }
  private:
    SQLiteDriver *driver_;
    sqlite *conn_;
    std::string url_;
    std::string database_;
    bool read_only_;
    bool auto_commit_;
    SQLiteDatabaseMetaData *metadata_;
};


}
}

#endif
