#include <ctype.h>
#include <algorithm>

#include <sigc++/bind.h>

#include "database-metadata.h"

#include "gql++/mod-result-set.h"

namespace GQL
{

namespace SQLite
{


using namespace std;

namespace
{

//
// Various Utilities
//

char *table_types[][2] =
{
  { "TABLE", 		"(type='table')" },
  { "INDEX",		"(type='index')" },
  { NULL,		NULL }
};

}


ResultSet *SQLiteDatabaseMetaData::get_tables(
        const string& catalog,
        const string& schema_pattern,
        const string& table_name_pattern,
        const vector<string>& types)
{
  string query;
  ResultSet *r;
  ModResultSet *result;
  bool first, sys_table = false;
  SQLObject *str_obj = conn_->create_object();
  vector<string>::size_type j;
  
  query = ("SELECT name, type FROM sqlite_master WHERE name LIKE '" + 
           table_name_pattern + "' AND (");
  
  first = true;
  for (vector<string>::size_type i = 0; i < types.size(); i++)
  {
    if (types[i] == "SYSTEM TABLE")
    {
      sys_table = true;
      continue;
    }
    for (j = 0; table_types[j][0]; j++)
      if (types[i] == table_types[j][0])
        break;

    if (table_types[j][0] == NULL) // if we got an unknown type
      continue;
    
    if (!first)
      query.append(" OR ");
    query.append(table_types[j][1]);
    first = false;
  }
  if (first)
    query.append("0 = 1");
  
  query.append(") ORDER BY name");

  r = conn_->exec_sql(query);

  result = manage(new ModResultSet(conn_, 5));
  
  while (r->next())
  {
    string *tuple[5];

    tuple[0] = 0;
    tuple[1] = 0;
    
    // Name
    r->get(0, str_obj);
    tuple[2] = str_obj->is_null() ? 0 : new string(str_obj->to_string());

    tuple[3] = new string(r->get(1, str_obj)->to_string()); // Type
    std::transform(tuple[3]->begin(), tuple[3]->end(), tuple[3]->begin(),
                   (int (*)(int))&toupper);
    
    // Remarks
    tuple[4] = 0;
    
    result->append(tuple);
  }
  if (sys_table)
  {
    char *tuple[5];
    
    tuple[0] = tuple[1] = 0;
    tuple[2] = "sqlite_master";
    tuple[3] = tuple[4] = 0;
    
    result->append(tuple);
  }
  
  delete r;
  delete str_obj;
  
  return result;
}

ResultSet *SQLiteDatabaseMetaData::get_columns(
        const std::string& catalog,
        const std::string& schema_pattern,
        const std::string& table_name_pattern,
        const std::string& column_name_pattern)
{
  ModResultSet *result = manage(new ModResultSet(conn_, 9));
  string query;
  ResultSet *r;
  SQLObject *obj = conn_->create_object();
  
  query = ("SELECT name FROM sqlite_master WHERE type = 'table'"
           " AND name LIKE '"
           + table_name_pattern + "'");
  r = conn_->exec_sql(query);
  
  while (r->next())
  {
    ResultSet *r1;
    
    r->get(0, obj);
    if (obj->is_null())
      continue;
    
    string name = obj->to_string();
    r1 = conn_->exec_sql("PRAGMA table_info(" + name + ")");
    
    while (r1->next())
    {
      string *tuple[9];

      tuple[0] = 0; // table catalog
      tuple[1] = 0; // table schema
    
      // Table name
      tuple[2] = new string(name);
    
      tuple[3] = new string(r1->get(1, obj)->to_string()); // column name
      tuple[4] = new string(r1->get(2, obj)->to_string()); // data type

      // nullable
      r1->get(3, obj);
      if (!obj->is_null() && obj->to_int() != 0) // means "NOT NULL"
        tuple[5] = new string("0");
      else
        tuple[5] = new string("1");
      
      tuple[6] = 0; // remarks
      
      // column default
      r1->get(4, obj);
      tuple[7] = obj->is_null() ? 0 : new string(obj->to_string());

      tuple[8] = new string(r1->get(0, obj)->to_string()); // ordinal position

      result->append(tuple);
    }
    delete r1;
  }
  delete r;
  delete obj;

  return result;
}

ResultSet *SQLiteDatabaseMetaData::get_xrefs(const string& primary_table,
                                             const string& foreign_table)
{
  ResultSet *result = manage(new ModResultSet(conn_, 14));

  // FIXME: Implement

  return result;
}

}

}
