/*
 * Copyright 2010 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gradle.build.docs.dsl.docbook

import org.gradle.build.docs.dsl.model.ClassMetaData
import org.gradle.build.docs.dsl.model.MethodMetaData
import org.w3c.dom.Element

class MethodDoc {
    private final String id
    private final MethodMetaData metaData
    private final List<Element> comment

    MethodDoc(MethodMetaData metaData, List<Element> comment) {
        this(metaData.ownerClass, metaData, comment)
    }

    MethodDoc(ClassMetaData referringClass, MethodMetaData metaData, List<Element> comment) {
        this.metaData = metaData
        id = "$referringClass.className:$metaData.overrideSignature"
        this.comment = comment
    }

    MethodDoc forClass(ClassMetaData c) {
        return new MethodDoc(c, metaData, comment)
    }

    String getId() {
        return id
    }

    String getName() {
        return metaData.name
    }

    MethodMetaData getMetaData() {
        return metaData
    }

    Element getDescription() {
        return comment.find { it.nodeName == 'para' }
    }
    
    List<Element> getComment() {
        return comment
    }
}
