% GRADLE(1) gradle 2.5-3 | Gradle Command Line Manual
% Gradle Depvelopers
% 08 July 2015

# NAME

gradle - A powerful build system for the JVM

# SYNOPSIS

**gradle** [_option..._] [_task..._]

**./gradlew** [_option..._] [_task..._]

# OPTIONS

## General options

-?, -h, --help
:   Shows a help message.

-a, --no-rebuild
:   Do not rebuild project dependencies.

--all
:   Shows additional detail in the task listing. See Section 11.6.2 of Gradle User Guide, "Listing tasks".

-b, --build-file
:   Specifies the build file. See Section 11.5 of Gradle User Guide, "Selecting which build to execute".

-c, --settings-file
:   Specifies the settings file.

--console
:   Specifies which type of console output to generate.

Set to **plain** to generate plain text only. This option disables all color and other rich output in the console output.

Set to **auto** (the default) to enable color and other rich output in the console output when the build process is attached to a console, or to generate plain text only when not attached to a console.

Set to **rich** to enable color and other rich output in the console output, regardless of whether the build process is not attached to a console. When not attached to a console, the build output will use ANSI control characters to generate the rich output.

--continue
:   Continues task execution after a task failure.

--configure-on-demand (incubating)
:   Only relevant projects are configured in this build run. This means faster builds for large multi-projects. See Section 56.1.1.1 of Gradle User Guide, "Configuration on demand".

-D, --system-prop
:   Sets a system property of the JVM, for example **-Dmyprop=myvalue**. See Section 14.2 of Gradle User Guide, "Gradle properties and system properties".

-d, --debug
:   Log in debug mode (includes normal stacktrace). See Chapter 18 of Gradle User Guide, "Logging".

-g, --gradle-user-home
:   Specifies the Gradle user home directory. The default is the **.gradle** directory in the user's home directory.

--gui
:   Launches the Gradle GUI. See Chapter 12 of Gradle User Guide, "Using the Gradle Graphical User Interface".

-I, --init-script
:   Specifies an initialization script. See Chapter 60 of Gradle User Guide, "Initialization Scripts".

-i, --info
:   Set log level to info. See Chapter 18 of Gradle User Guide, "Logging".

-m, --dry-run
:   Runs the build with all task actions disabled. See Section 11.7 of Gradle User Guide, "Dry Run".

--offline
:   Specifies that the build should operate without accessing network resources. See Section 50.9.2 of Gradle User Guide, "Command line options to override caching".

-P, --project-prop
:   Sets a project property of the root project, for example **-Pmyprop=myvalue**. See Section 14.2 of Gradle User Guide, "Gradle properties and system properties".

-p, --project-dir
:   Specifies the start directory for Gradle. Defaults to current directory. See Section 11.5 of Gradle User Guide, "Selecting which build to execute".

--parallel (incubating)
:   Build projects in parallel. Gradle will attempt to determine the optimal number of executor threads to use. This option should only be used with decoupled projects (see Section 56.9 of Gradle User Guide, "Decoupled Projects").

--max-workers (incubating)
:   Sets the maximum number of workers that Gradle may use. For example **--max-workers=3**. The default is the number of processors. This option replaces **--parallel-threads** when used in conjunction with **--parallel**.

--profile
:   Profiles build execution time and generates a report in the **buildDir/reports/profile** directory. See Section 11.6.7 of Gradle User Guide, "Profiling a build".

--project-cache-dir
:   Specifies the project-specific cache directory. Default value is **.gradle** in the root project directory. See Section 14.6 of Gradle User Guide, "Caching".

-q, --quiet
:   Log errors only. See Chapter 18 of Gradle User Guide, "Logging".

--recompile-scripts
:   Specifies that cached build scripts are skipped and forced to be recompiled. See Section 14.6 of Gradle User Guide, "Caching".

--refresh-dependencies
:   Refresh the state of dependencies. See Section 50.9.2 of Gradle User Guide, "Command line options to override caching".

--rerun-tasks
:   Specifies that any task optimization is ignored.

-S, --full-stacktrace
:   Print out the full (very verbose) stacktrace for any exceptions. See Chapter 18 of Gradle User Guide, "Logging".

-s, --stacktrace
:   Print out the stacktrace also for user exceptions (e.g. compile error). See Chapter 18 of Gradle User Guide, "Logging".

-t, --continuous (incubating)
:   Enables continuous building - Gradle will automatically re-run when changes are detected.

-u, --no-search-upwards
:   Don't search in parent directories for a **settings.gradle** file.

-v, --version
:   Prints version info.

-x, --exclude-task
:   Specifies a task to be excluded from execution. See Section 11.2 of Gradle User Guide, "Excluding tasks".

The above information is printed to the console when you execute **gradle -h**.

## Deprecated options

--no-color
:   Do not use color in the console output. This option has been replaced by the **--console** plain option.

--parallel-threads
:   Build projects in parallel, using the specified number of executor threads. For example **--parallel-threads=3**. This option should only be used with decoupled projects (see Section 57.9 of Gradle User Guide, "Decoupled Projects"). This option has been replaced by **--max-workers**.

## Daemon options

The Chapter 18 of Gradle User Guide, "The Gradle Daemon" contains more information about the daemon. For example it includes information how to turn on the daemon by default so that you can avoid using **--daemon** all the time.

--daemon
:   Uses the Gradle daemon to run the build. Starts the daemon if not running or existing daemon busy. Chapter 18 of Gradle User Guide, "The Gradle Daemon" contains more detailed information when new daemon processes are started.

--foreground
:   Starts the Gradle daemon in the foreground. Useful for debugging or troubleshooting because you can easily monitor the build execution.

--no-daemon
:   Do not use the Gradle daemon to run the build. Useful occasionally if you have configured Gradle to always run with the daemon by default.

--stop
:   Stops the Gradle daemon if it is running. You can only stop daemons that were started with the Gradle version you use when running **--stop**.

# SYSTEM PROPERTIES

The following system properties are available for the **gradle** command. Note that command-line options take precedence over system properties.

gradle.user.home
:   Specifies the Gradle user home directory.

The Section 20.1 of Gradle User Guide, “Configuring the build environment via gradle.properties” contains specific information about Gradle configuration available via system properties.

# ENVIRONMENT

The following environment variables are available for the **gradle** command. Note that command-line options and system properties take precedence over environment variables.

GRADLE_OPTS
:   Specifies command-line arguments to use to start the JVM. This can be useful for setting the system properties to use for running Gradle. For example you could set **GRADLE_OPTS="-Dorg.gradle.daemon=true"** to use the Gradle daemon without needing to use the **--daemon** option every time you run Gradle. Section 20.1 of Gradle User Guide, “Configuring the build environment via gradle.properties” contains more information about ways of configuring the daemon without using environmental variables, e.g. in more maintainable and explicit way.

GRADLE_USER_HOME
:   Specifies the Gradle user home directory (which defaults to **USER_HOME/.gradle** if not set).

JAVA_HOME
:   Specifies the JDK installation directory to use.

# SEE ALSO

https://docs.gradle.org/current/userguide/userguide.html
