# -*- coding: utf-8 -*-
#
# Gramps - a GTK+/GNOME based genealogy program
#
# Copyright (C) 2003-2004  Donald N. Allingham
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# $Id: rel_fr.py,v 1.1.2.3 2004/10/21 04:16:26 rshura Exp $

#-------------------------------------------------------------------------
#
# GRAMPS modules
#
#-------------------------------------------------------------------------

import RelLib
from Relationship import apply_filter as getallancestors

#-------------------------------------------------------------------------
#
#
#
#-------------------------------------------------------------------------

_level_name = [ "", "premier", "deuxième", "troisième", "quatrième", "cinquième", "sixième",
                "septième", "huitième", "neuvième", "dicième", "onzième", "douzième",
                "treizième", "quatorzième", "quinzième", "seizième",
                "dix-septième", "dix-huitième", "dix_neuvième", "vingtième", ]

_parents_level = [ "", "parents", "grand-parents", "arrières grand-parents",
                   "trisaïeux", ]

_father_level = [ "", "le père", "le grand-père", "l'arrière grand-père", "le trisaïeul", ]

_mother_level = [ "", "la mère", "la grand-mère", "l'arrière grand-mère", "la trisaïeule", ]

_son_level = [ "", "le fils", "le petits-fils", "l'arrière petit-fils", ]

_daughter_level = [ "", "la fille", "la petite-fille", "l'arrière petite-fille", ]

_sister_level = [ "", "la soeur", "la tante", "la grande-tante", "l'arrière grande-tante", ]

_brother_level = [ "", "le frère", "l'oncle", "le grand-oncle", "l'arrière grand-oncle", ]

_nephew_level = [ "", "le neveu", "le petit-neveu", "l'arrière petit-neveu", ]

_niece_level = [ "", "la nièce", "la petite-nièce", "l'arrière petite-nièce", ]

#-------------------------------------------------------------------------
#
#
#
#-------------------------------------------------------------------------
def apply_filter(person,index,plist,pmap):
    if person == None:
        return
    plist.append(person)
    pmap[person.getId()] = index
    
    family = person.getMainParents()
    if family != None:
        apply_filter(family.getFather(),index+1,plist,pmap)
        apply_filter(family.getMother(),index+1,plist,pmap)

def get_male_cousin(level):
    return "cousin au %s degré" % (_level_name[level])

def get_female_cousin(level):
    return "cousine au %s degré" % (_level_name[level])

def get_parents(level):
    if level>len(_parents_level)-1:
        return "ancêtres lointains"
    else:
        return _parents_level[level]

def get_father(level):
    if level>len(_father_level)-1:
        return "ancêtre lointain"
    else:
        return _father_level[level]

def get_son(level):
    if level>len(_son_level)-1:
        return "descendant lointain"
    else:
        return _son_level[level]

def get_mother(level):
    if level>len(_mother_level)-1:
        return "ancêtre lointaine"
    else:
        return _mother_level[level]

def get_daughter(level):
    if level>len(_daughter_level)-1:
        return "descendante lointaine"
    else:
        return _daughter_level[level]

def get_aunt(level):
    if level>len(_sister_level)-1:
        return "ancêtre lointaine"
    else:
        return _sister_level[level]

def get_uncle(level):
    if level>len(_brother_level)-1:
        return "ancêtre lointain"
    else:
        return _brother_level[level]

def get_nephew(level):
    if level>len(_nephew_level)-1:
        return "descendant lointain"
    else:
        return _nephew_level[level]

def get_niece(level):
    if level>len(_niece_level)-1:
        return "descendant lointaine"
    else:
        return _niece_level[level]

def is_spouse(orig,other):
    for f in orig.getFamilyList():
        if other == f.getFather() or other == f.getMother():
            return 1
    return 0

def get_relationship(orig_person,other_person):
    """
    returns a string representing the relationshp between the two people,
    along with a list of common ancestors (typically father,mother) 
    """
    firstMap = {}
    firstList = []
    secondMap = {}
    secondList = []
    common = []
    rank = 9999999

    if orig_person == None:
        return ("undefined",[])

    if orig_person == other_person:
        return ('', [])
    if is_spouse(orig_person,other_person):
        if other_person.getGender() == RelLib.Person.male:
            return ("le mari",[])
        else:
            return ("la femme",[])

    try:
        apply_filter(orig_person,0,firstList,firstMap)
        apply_filter(other_person,0,secondList,secondMap)
    except RuntimeError,msg:
        return ("Boucle détectée dans la relation",None)
    
    for person in firstList:
        if person in secondList:
            new_rank = firstMap[person.getId()]
            if new_rank < rank:
                rank = new_rank
                common = [ person ]
            elif new_rank == rank:
                common.append(person)

    firstRel = -1
    secondRel = -1

    length = len(common)
    
    if length == 1:
        person = common[0]
        secondRel = firstMap[person.getId()]
        firstRel = secondMap[person.getId()]
    elif length == 2:
        p1 = common[0]
        secondRel = firstMap[p1.getId()]
        firstRel = secondMap[p1.getId()]
    elif length > 2:
        person = common[0]
        secondRel = firstMap[person.getId()]
        firstRel = secondMap[person.getId()]

    if firstRel == -1:
        return ("",[])
    elif firstRel == 0:
        if secondRel == 0:
            return ('',common)
        elif other_person.getGender() == RelLib.Person.male:
            return (get_father(secondRel),common)
        else:
            return (get_mother(secondRel),common)
    elif secondRel == 0:
        if other_person.getGender() == RelLib.Person.male:
            return (get_son(firstRel),common)
        else:
            return (get_daughter(firstRel),common)
    elif firstRel == 1:
        if other_person.getGender() == RelLib.Person.male:
            return (get_uncle(secondRel),common)
        else:
            return (get_aunt(secondRel),common)
    elif secondRel == 1:
        if other_person.getGender() == RelLib.Person.male:
            return (get_nephew(firstRel-1),common)
        else:
            return (get_niece(firstRel-1),common)
    elif firstRel == 2 and secondRel == 2:
        if other_person.getGender() == RelLib.Person.male:
            return ('le cousin germain',common)
        else:
            return ('la cousine germaine',common)
    elif firstRel == 3 and secondRel == 2:
        if other_person.getGender() == RelLib.Person.male:
            return ('le neveu à la mode de Bretagne',common)
        else:
            return ('la nièce à la mode de Bretagne',common)
    elif firstRel == 2 and secondRel == 3:
        if other_person.getGender() == RelLib.Person.male:
            return ('l\'oncle à la mode de Bretagne',common)
        else:
            return ('la tante à la mode de Bretagne',common)
    else:
        if other_person.getGender() == RelLib.Person.male:
            if firstRel+secondRel>len(_level_name)-1:
                return (get_male_cousin(firstRel+secondRel),common)
	    else:
               return ('le cousin lointain',common)
        else:
            if firstRel+secondRel>len(_level_name)-1:
                return (get_female_cousin(firstRel+secondRel),common)
	    else:
               return ('la cousine lointaine',common)

def get_grandparents_string(orig_person,other_person):
    """
    returns a string representing the relationshp between the two people,
    along with a list of common ancestors (typically father,mother) 
    """
    firstMap = {}
    firstList = []
    secondMap = {}
    secondList = []
    common = []
    rank = 9999999

    if orig_person == None:
        return ("undefined",[])

    if orig_person == other_person:
        return ('', [])

    apply_filter(orig_person,0,firstList,firstMap)
    apply_filter(other_person,0,secondList,secondMap)
    
    for person in firstList:
        if person in secondList:
            new_rank = firstMap[person.getId()]
            if new_rank < rank:
                rank = new_rank
                common = [ person ]
            elif new_rank == rank:
                common.append(person)

    firstRel = -1
    secondRel = -1

    length = len(common)
    
    if length == 1:
        person = common[0]
        secondRel = firstMap[person.getId()]
        firstRel = secondMap[person.getId()]
    elif length == 2:
        p1 = common[0]
        secondRel = firstMap[p1.getId()]
        firstRel = secondMap[p1.getId()]
    elif length > 2:
        person = common[0]
        secondRel = firstMap[person.getId()]
        firstRel = secondMap[person.getId()]

    if firstRel == 0:
        if secondRel == 0:
            return ('',common)
        else:
            return (get_parents(secondRel),common)
    else:
        return None

#-------------------------------------------------------------------------
#
# Register this function with the Plugins system 
#
#-------------------------------------------------------------------------
from Plugins import register_relcalc, register_parents

register_relcalc(get_relationship,
    ["fr","FR","fr_FR","francais","Francais","fr_FR.UTF8","fr_FR@euro","fr_FR.UTF8@euro",
            "french","French", "fr_FR.UTF-8", "fr_FR.utf-8", "fr_FR.utf8"])

register_parents(get_grandparents_string,
    ["fr","FR","fr_FR","francais","Francais","fr_FR.UTF8","fr_FR@euro","fr_FR.UTF8@euro",
            "french","French", "fr_FR.UTF-8", "fr_FR.utf-8", "fr_FR.utf8"])
