#
# Gramps - a GTK+/GNOME based genealogy program
#
# Copyright (C) 2004  Greg Kuperberg
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# $Id: accent.py,v 1.2 2004/08/19 03:33:11 rshura Exp $

def deaccent(s):
    if not isinstance(s,unicode): return s
    return ''.join([deaccentdata.get(c,'?') for c in s])

deaccentdata = {
    # 7-bit ASCII non-printable
    u'\u0000':'\x00', u'\u0001':'\x01', u'\u0002':'\x02', u'\u0003':'\x03',
    u'\u0004':'\x04', u'\u0005':'\x05', u'\u0006':'\x06', u'\u0007':'\x07',
    u'\u0008':'\x08', u'\u0009':'\x09', u'\u000a':'\x0a', u'\u000b':'\x0b',
    u'\u000c':'\x0c', u'\u000d':'\x0d', u'\u000e':'\x0e', u'\u000f':'\x0f',
    u'\u0010':'\x10', u'\u0011':'\x11', u'\u0012':'\x12', u'\u0013':'\x13',
    u'\u0014':'\x14', u'\u0015':'\x15', u'\u0016':'\x16', u'\u0017':'\x17',
    u'\u0018':'\x18', u'\u0019':'\x19', u'\u001a':'\x1a', u'\u001b':'\x1b',
    u'\u001c':'\x1c', u'\u001d':'\x1d', u'\u001e':'\x1e', u'\u001f':'\x1f',

    # 7-bit ASCII printable and delete
    u'\u0020': ' ', u'\u0021': '!', u'\u0022': '"', u'\u0023': '#',
    u'\u0024': '$', u'\u0025': '%', u'\u0026': '&', u'\u0027': "'",
    u'\u0028': '(', u'\u0029': ')', u'\u002a': '*', u'\u002b': '+',
    u'\u002c': ',', u'\u002d': '-', u'\u002e': '.', u'\u002f': '/',
    u'\u0030': '0', u'\u0031': '1', u'\u0032': '2', u'\u0033': '3',
    u'\u0034': '4', u'\u0035': '5', u'\u0036': '6', u'\u0037': '7',
    u'\u0038': '8', u'\u0039': '9', u'\u003a': ':', u'\u003b': ';',
    u'\u003c': '<', u'\u003d': '=', u'\u003e': '>', u'\u003f': '?',
    u'\u0040': '@', u'\u0041': 'A', u'\u0042': 'B', u'\u0043': 'C',
    u'\u0044': 'D', u'\u0045': 'E', u'\u0046': 'F', u'\u0047': 'G',
    u'\u0048': 'H', u'\u0049': 'I', u'\u004a': 'J', u'\u004b': 'K',
    u'\u004c': 'L', u'\u004d': 'M', u'\u004e': 'N', u'\u004f': 'O',
    u'\u0050': 'P', u'\u0051': 'Q', u'\u0052': 'R', u'\u0053': 'S',
    u'\u0054': 'T', u'\u0055': 'U', u'\u0056': 'V', u'\u0057': 'W',
    u'\u0058': 'X', u'\u0059': 'Y', u'\u005a': 'Z', u'\u005b': '[',
    u'\u005c':'\\', u'\u005d': ']', u'\u005e': '^', u'\u005f': '_',
    u'\u0060': '`', u'\u0061': 'a', u'\u0062': 'b', u'\u0063': 'c',
    u'\u0064': 'd', u'\u0065': 'e', u'\u0066': 'f', u'\u0067': 'g',
    u'\u0068': 'h', u'\u0069': 'i', u'\u006a': 'j', u'\u006b': 'k',
    u'\u006c': 'l', u'\u006d': 'm', u'\u006e': 'n', u'\u006f': 'o',
    u'\u0070': 'p', u'\u0071': 'q', u'\u0072': 'r', u'\u0073': 's',
    u'\u0074': 't', u'\u0075': 'u', u'\u0076': 'v', u'\u0077': 'w',
    u'\u0078': 'x', u'\u0079': 'y', u'\u007a': 'z', u'\u007b': '{',
    u'\u007c': '|', u'\u007d': '}', u'\u007e': '~', u'\u007f':'\x7f',
    
    # Latin letters and extensions
    u'\u00c0': 'A', u'\u00c1': 'A', u'\u00c2': 'A', u'\u00c3': 'A',
    u'\u00c4': 'A', u'\u00c5': 'A', u'\u00c6':'Ae', u'\u00c7': 'C',
    u'\u00c8': 'E', u'\u00c9': 'E', u'\u00ca': 'E', u'\u00cb': 'E',
    u'\u00cc': 'I', u'\u00cd': 'I', u'\u00ce': 'I', u'\u00cf': 'I',
    u'\u00d0':'Dh', u'\u00d1': 'N', u'\u00d2': 'O', u'\u00d3': 'O',
    u'\u00d4': 'O', u'\u00d5': 'O', u'\u00d6': 'O', u'\u00d8': 'O',
    u'\u00d9': 'U', u'\u00da': 'U', u'\u00db': 'U', u'\u00dc': 'U',
    u'\u00dd': 'Y', u'\u00de':'Th', u'\u00df':'ss', u'\u00e0': 'a',
    u'\u00e1': 'a', u'\u00e2': 'a', u'\u00e3': 'a', u'\u00e4': 'a',
    u'\u00e5': 'a', u'\u00e6':'ae', u'\u00e7': 'c', u'\u00e8': 'e',
    u'\u00e9': 'e', u'\u00ea': 'e', u'\u00eb': 'e', u'\u00ec': 'i',
    u'\u00ed': 'i', u'\u00ee': 'i', u'\u00ef': 'i', u'\u00f0':'dh',
    u'\u00f1': 'n', u'\u00f2': 'o', u'\u00f3': 'o', u'\u00f4': 'o',
    u'\u00f5': 'o', u'\u00f6': 'o', u'\u00f8': 'o', u'\u00f9': 'u',
    u'\u00fa': 'u', u'\u00fb': 'u', u'\u00fc': 'u', u'\u00fd': 'y',
    u'\u00fe':'th', u'\u00ff': 'y', u'\u0100': 'A', u'\u0101': 'a',
    u'\u0102': 'A', u'\u0103': 'a', u'\u0104': 'A', u'\u0105': 'a',
    u'\u0106': 'C', u'\u0107': 'c', u'\u0108': 'C', u'\u0109': 'c',
    u'\u010a': 'C', u'\u010b': 'c', u'\u010c': 'C', u'\u010d': 'c',
    u'\u010e': 'D', u'\u010f': 'd', u'\u0110': 'D', u'\u0111': 'd',
    u'\u0112': 'E', u'\u0113': 'e', u'\u0114': 'E', u'\u0115': 'e',
    u'\u0116': 'E', u'\u0117': 'e', u'\u0118': 'E', u'\u0119': 'e',
    u'\u011a': 'E', u'\u011b': 'e', u'\u011c': 'G', u'\u011d': 'g',
    u'\u011e': 'G', u'\u011f': 'g', u'\u0120': 'G', u'\u0121': 'g',
    u'\u0122': 'G', u'\u0123': 'g', u'\u0124': 'H', u'\u0125': 'h',
    u'\u0126': 'H', u'\u0127': 'h', u'\u0128': 'I', u'\u0129': 'i',
    u'\u012a': 'I', u'\u012b': 'i', u'\u012c': 'I', u'\u012d': 'i',
    u'\u012e': 'I', u'\u012f': 'i', u'\u0130': 'I', u'\u0131': 'i',
    u'\u0132':'Ij', u'\u0133':'ij', u'\u0134': 'J', u'\u0135': 'j',
    u'\u0136': 'K', u'\u0137': 'k', u'\u0138': 'k', u'\u0139': 'L',
    u'\u013a': 'l', u'\u013b': 'L', u'\u013c': 'l', u'\u013d': 'L',
    u'\u013e': 'l', u'\u013f': 'L', u'\u0140': 'l', u'\u0141': 'L',
    u'\u0142': 'l', u'\u0143': 'N', u'\u0144': 'n', u'\u0145': 'N',
    u'\u0146': 'n', u'\u0147': 'N', u'\u0148': 'n', u'\u0149': 'n',
    u'\u014a':'Ng', u'\u014b':'ng', u'\u014c': 'O', u'\u014d': 'o',
    u'\u014e': 'O', u'\u014f': 'o', u'\u0150': 'O', u'\u0151': 'o',
    u'\u0152':'Oe', u'\u0153':'oe', u'\u0154': 'R', u'\u0155': 'r',
    u'\u0156': 'R', u'\u0157': 'r', u'\u0158': 'R', u'\u0159': 'r',
    u'\u015a': 'S', u'\u015b': 's', u'\u015c': 'S', u'\u015d': 's',
    u'\u015e': 'S', u'\u015f': 's', u'\u0160': 'S', u'\u0161': 's',
    u'\u0162': 'T', u'\u0163': 't', u'\u0164': 'T', u'\u0165': 't',
    u'\u0166': 'T', u'\u0167': 't', u'\u0168': 'U', u'\u0169': 'u',
    u'\u016a': 'U', u'\u016b': 'u', u'\u016c': 'U', u'\u016d': 'u',
    u'\u016e': 'U', u'\u016f': 'u', u'\u0170': 'U', u'\u0171': 'u',
    u'\u0172': 'U', u'\u0173': 'u', u'\u0174': 'W', u'\u0175': 'w',
    u'\u0176': 'Y', u'\u0177': 'y', u'\u0178': 'Y', u'\u0179': 'Z',
    u'\u017a': 'z', u'\u017b': 'Z', u'\u017c': 'z', u'\u017d': 'Z',
    u'\u017e': 'z', u'\u017f': 's', u'\u0180': 'b', u'\u0181': 'B',
    u'\u0182': 'B', u'\u0183': 'b', u'\u0187': 'C', u'\u0188': 'c',
    u'\u0189': 'D', u'\u018a': 'D', u'\u018b': 'D', u'\u018c': 'd',
    u'\u0191': 'F', u'\u0192': 'f', u'\u0193': 'G', u'\u0195':'hv',
    u'\u0197': 'I', u'\u0198': 'K', u'\u0199': 'k', u'\u019a': 'l',
    u'\u019d': 'N', u'\u019e': 'n', u'\u019f': 'O', u'\u01a0': 'O',
    u'\u01a1': 'o', u'\u01a2':'Oi', u'\u01a3':'oi', u'\u01a4': 'P',
    u'\u01a5': 'p', u'\u01ab': 't', u'\u01ac': 'T', u'\u01ad': 't',
    u'\u01ae': 'T', u'\u01af': 'U', u'\u01b0': 'u', u'\u01b2': 'V',
    u'\u01b3': 'Y', u'\u01b4': 'y', u'\u01b5': 'Z', u'\u01b6': 'z',
    u'\u01c4':'Dz', u'\u01c5': 'D', u'\u01c6':'dz', u'\u01c7':'Lj',
    u'\u01c8': 'L', u'\u01c9':'lj', u'\u01ca':'Nj', u'\u01cb': 'N',
    u'\u01cc':'nj', u'\u01cd': 'A', u'\u01ce': 'a', u'\u01cf': 'I',
    u'\u01d0': 'i', u'\u01d1': 'O', u'\u01d2': 'o', u'\u01d3': 'U',
    u'\u01d4': 'u', u'\u01d5': 'U', u'\u01d6': 'u', u'\u01d7': 'U',
    u'\u01d8': 'u', u'\u01d9': 'U', u'\u01da': 'u', u'\u01db': 'U',
    u'\u01dc': 'u', u'\u01de': 'A', u'\u01df': 'a', u'\u01e0': 'A',
    u'\u01e1': 'a', u'\u01e2':'Ae', u'\u01e3':'ae', u'\u01e4': 'G',
    u'\u01e5': 'g', u'\u01e6': 'G', u'\u01e7': 'g', u'\u01e8': 'K',
    u'\u01e9': 'k', u'\u01ea': 'O', u'\u01eb': 'o', u'\u01ec': 'O',
    u'\u01ed': 'o', u'\u01f0': 'j', u'\u01f1':'Dz', u'\u01f2': 'D',
    u'\u01f3':'dz', u'\u01f4': 'G', u'\u01f5': 'g', u'\u01f8': 'N',
    u'\u01f9': 'n', u'\u01fa': 'A', u'\u01fb': 'a', u'\u01fc':'Ae',
    u'\u01fd':'ae', u'\u01fe': 'O', u'\u01ff': 'o', u'\u0200': 'A',
    u'\u0201': 'a', u'\u0202': 'A', u'\u0203': 'a', u'\u0204': 'E',
    u'\u0205': 'e', u'\u0206': 'E', u'\u0207': 'e', u'\u0208': 'I',
    u'\u0209': 'i', u'\u020a': 'I', u'\u020b': 'i', u'\u020c': 'O',
    u'\u020d': 'o', u'\u020e': 'O', u'\u020f': 'o', u'\u0210': 'R',
    u'\u0211': 'r', u'\u0212': 'R', u'\u0213': 'r', u'\u0214': 'U',
    u'\u0215': 'u', u'\u0216': 'U', u'\u0217': 'u', u'\u0218': 'S',
    u'\u0219': 's', u'\u021a': 'T', u'\u021b': 't', u'\u021e': 'H',
    u'\u021f': 'h', u'\u0220': 'N', u'\u0221': 'd', u'\u0222':'Ou',
    u'\u0223':'ou', u'\u0224': 'Z', u'\u0225': 'z', u'\u0226': 'A',
    u'\u0227': 'a', u'\u0228': 'E', u'\u0229': 'e', u'\u022a': 'O',
    u'\u022b': 'o', u'\u022c': 'O', u'\u022d': 'o', u'\u022e': 'O',
    u'\u022f': 'o', u'\u0230': 'O', u'\u0231': 'o', u'\u0232': 'Y',
    u'\u0233': 'y', u'\u0234': 'l', u'\u0235': 'n', u'\u0236': 't',
    u'\u1e00': 'A', u'\u1e01': 'a', u'\u1e02': 'B', u'\u1e03': 'b',
    u'\u1e04': 'B', u'\u1e05': 'b', u'\u1e06': 'B', u'\u1e07': 'b',
    u'\u1e08': 'C', u'\u1e09': 'c', u'\u1e0a': 'D', u'\u1e0b': 'd',
    u'\u1e0c': 'D', u'\u1e0d': 'd', u'\u1e0e': 'D', u'\u1e0f': 'd',
    u'\u1e10': 'D', u'\u1e11': 'd', u'\u1e12': 'D', u'\u1e13': 'd',
    u'\u1e14': 'E', u'\u1e15': 'e', u'\u1e16': 'E', u'\u1e17': 'e',
    u'\u1e18': 'E', u'\u1e19': 'e', u'\u1e1a': 'E', u'\u1e1b': 'e',
    u'\u1e1c': 'E', u'\u1e1d': 'e', u'\u1e1e': 'F', u'\u1e1f': 'f',
    u'\u1e20': 'G', u'\u1e21': 'g', u'\u1e22': 'H', u'\u1e23': 'h',
    u'\u1e24': 'H', u'\u1e25': 'h', u'\u1e26': 'H', u'\u1e27': 'h',
    u'\u1e28': 'H', u'\u1e29': 'h', u'\u1e2a': 'H', u'\u1e2b': 'h',
    u'\u1e2c': 'I', u'\u1e2d': 'i', u'\u1e2e': 'I', u'\u1e2f': 'i',
    u'\u1e30': 'K', u'\u1e31': 'k', u'\u1e32': 'K', u'\u1e33': 'k',
    u'\u1e34': 'K', u'\u1e35': 'k', u'\u1e36': 'L', u'\u1e37': 'l',
    u'\u1e38': 'L', u'\u1e39': 'l', u'\u1e3a': 'L', u'\u1e3b': 'l',
    u'\u1e3c': 'L', u'\u1e3d': 'l', u'\u1e3e': 'M', u'\u1e3f': 'm',
    u'\u1e40': 'M', u'\u1e41': 'm', u'\u1e42': 'M', u'\u1e43': 'm',
    u'\u1e44': 'N', u'\u1e45': 'n', u'\u1e46': 'N', u'\u1e47': 'n',
    u'\u1e48': 'N', u'\u1e49': 'n', u'\u1e4a': 'N', u'\u1e4b': 'n',
    u'\u1e4c': 'O', u'\u1e4d': 'o', u'\u1e4e': 'O', u'\u1e4f': 'o',
    u'\u1e50': 'O', u'\u1e51': 'o', u'\u1e52': 'O', u'\u1e53': 'o',
    u'\u1e54': 'P', u'\u1e55': 'p', u'\u1e56': 'P', u'\u1e57': 'p',
    u'\u1e58': 'R', u'\u1e59': 'r', u'\u1e5a': 'R', u'\u1e5b': 'r',
    u'\u1e5c': 'R', u'\u1e5d': 'r', u'\u1e5e': 'R', u'\u1e5f': 'r',
    u'\u1e60': 'S', u'\u1e61': 's', u'\u1e62': 'S', u'\u1e63': 's',
    u'\u1e64': 'S', u'\u1e65': 's', u'\u1e66': 'S', u'\u1e67': 's',
    u'\u1e68': 'S', u'\u1e69': 's', u'\u1e6a': 'T', u'\u1e6b': 't',
    u'\u1e6c': 'T', u'\u1e6d': 't', u'\u1e6e': 'T', u'\u1e6f': 't',
    u'\u1e70': 'T', u'\u1e71': 't', u'\u1e72': 'U', u'\u1e73': 'u',
    u'\u1e74': 'U', u'\u1e75': 'u', u'\u1e76': 'U', u'\u1e77': 'u',
    u'\u1e78': 'U', u'\u1e79': 'u', u'\u1e7a': 'U', u'\u1e7b': 'u',
    u'\u1e7c': 'V', u'\u1e7d': 'v', u'\u1e7e': 'V', u'\u1e7f': 'v',
    u'\u1e80': 'W', u'\u1e81': 'w', u'\u1e82': 'W', u'\u1e83': 'w',
    u'\u1e84': 'W', u'\u1e85': 'w', u'\u1e86': 'W', u'\u1e87': 'w',
    u'\u1e88': 'W', u'\u1e89': 'w', u'\u1e8a': 'X', u'\u1e8b': 'x',
    u'\u1e8c': 'X', u'\u1e8d': 'x', u'\u1e8e': 'Y', u'\u1e8f': 'y',
    u'\u1e90': 'Z', u'\u1e91': 'z', u'\u1e92': 'Z', u'\u1e93': 'z',
    u'\u1e94': 'Z', u'\u1e95': 'z', u'\u1e96': 'h', u'\u1e97': 't',
    u'\u1e98': 'w', u'\u1e99': 'y', u'\u1e9a': 'a', u'\u1e9b': 's',
    u'\u1ea0': 'A', u'\u1ea1': 'a', u'\u1ea2': 'A', u'\u1ea3': 'a',
    u'\u1ea4': 'A', u'\u1ea5': 'a', u'\u1ea6': 'A', u'\u1ea7': 'a',
    u'\u1ea8': 'A', u'\u1ea9': 'a', u'\u1eaa': 'A', u'\u1eab': 'a',
    u'\u1eac': 'A', u'\u1ead': 'a', u'\u1eae': 'A', u'\u1eaf': 'a',
    u'\u1eb0': 'A', u'\u1eb1': 'a', u'\u1eb2': 'A', u'\u1eb3': 'a',
    u'\u1eb4': 'A', u'\u1eb5': 'a', u'\u1eb6': 'A', u'\u1eb7': 'a',
    u'\u1eb8': 'E', u'\u1eb9': 'e', u'\u1eba': 'E', u'\u1ebb': 'e',
    u'\u1ebc': 'E', u'\u1ebd': 'e', u'\u1ebe': 'E', u'\u1ebf': 'e',
    u'\u1ec0': 'E', u'\u1ec1': 'e', u'\u1ec2': 'E', u'\u1ec3': 'e',
    u'\u1ec4': 'E', u'\u1ec5': 'e', u'\u1ec6': 'E', u'\u1ec7': 'e',
    u'\u1ec8': 'I', u'\u1ec9': 'i', u'\u1eca': 'I', u'\u1ecb': 'i',
    u'\u1ecc': 'O', u'\u1ecd': 'o', u'\u1ece': 'O', u'\u1ecf': 'o',
    u'\u1ed0': 'O', u'\u1ed1': 'o', u'\u1ed2': 'O', u'\u1ed3': 'o',
    u'\u1ed4': 'O', u'\u1ed5': 'o', u'\u1ed6': 'O', u'\u1ed7': 'o',
    u'\u1ed8': 'O', u'\u1ed9': 'o', u'\u1eda': 'O', u'\u1edb': 'o',
    u'\u1edc': 'O', u'\u1edd': 'o', u'\u1ede': 'O', u'\u1edf': 'o',
    u'\u1ee0': 'O', u'\u1ee1': 'o', u'\u1ee2': 'O', u'\u1ee3': 'o',
    u'\u1ee4': 'U', u'\u1ee5': 'u', u'\u1ee6': 'U', u'\u1ee7': 'u',
    u'\u1ee8': 'U', u'\u1ee9': 'u', u'\u1eea': 'U', u'\u1eeb': 'u',
    u'\u1eec': 'U', u'\u1eed': 'u', u'\u1eee': 'U', u'\u1eef': 'u',
    u'\u1ef0': 'U', u'\u1ef1': 'u', u'\u1ef2': 'Y', u'\u1ef3': 'y',
    u'\u1ef4': 'Y', u'\u1ef5': 'y', u'\u1ef6': 'Y', u'\u1ef7': 'y',
    u'\u1ef8': 'Y', u'\u1ef9': 'y',
    
    # Greek letters
    u'\u0386':'Alpha',   u'\u0388':'Epsilon', u'\u0389':'Eta',
    u'\u038a':'Iota',    u'\u038c':'Omicron', u'\u038e':'Upsilon',
    u'\u038f':'Omega',   u'\u0390':'iota',    u'\u0391':'Alpha',
    u'\u0392':'Beta',    u'\u0393':'Gamma',   u'\u0394':'Delta',
    u'\u0395':'Epsilon', u'\u0396':'Zeta',    u'\u0397':'Eta',
    u'\u0398':'Theta',   u'\u0399':'Iota',    u'\u039a':'Kappa',
    u'\u039b':'Lambda',  u'\u039c':'Mu',      u'\u039d':'Nu',
    u'\u039e':'Xi',      u'\u039f':'Omicron', u'\u03a0':'Pi',
    u'\u03a1':'Rho',     u'\u03a3':'Sigma',   u'\u03a4':'Tau',
    u'\u03a5':'Upsilon', u'\u03a6':'Phi',     u'\u03a7':'Chi',
    u'\u03a8':'Psi',     u'\u03a9':'Omega',   u'\u03aa':'Iota',
    u'\u03ab':'Upsilon', u'\u03ac':'alpha',   u'\u03ad':'epsilon',
    u'\u03ae':'eta',     u'\u03af':'iota',    u'\u03b0':'upsilon',
    u'\u03b1':'alpha',   u'\u03b2':'beta',    u'\u03b3':'gamma',
    u'\u03b4':'delta',   u'\u03b5':'epsilon', u'\u03b6':'zeta',
    u'\u03b7':'eta',     u'\u03b8':'theta',   u'\u03b9':'iota',
    u'\u03ba':'kappa',   u'\u03bb':'lambda',  u'\u03bc':'mu',
    u'\u03bd':'nu',      u'\u03be':'xi',      u'\u03bf':'omicron',
    u'\u03c0':'pi',      u'\u03c1':'rho',     u'\u03c2':'varsigma',
    u'\u03c3':'sigma',   u'\u03c4':'tau',     u'\u03c5':'upsilon',
    u'\u03c6':'varphi',  u'\u03c7':'chi',     u'\u03c8':'psi',
    u'\u03c9':'omega',   u'\u03ca':'iota',    u'\u03cb':'upsilon',
    u'\u03cc':'omicron', u'\u03cd':'upsilon', u'\u03ce':'omega',
    u'\u03d0':'beta',    u'\u03d1':'theta',   u'\u03d2':'Upsilon',
    u'\u03d3':'Upsilon', u'\u03d4':'Upsilon', u'\u03d5':'phi',
    u'\u03d6':'pi',      u'\u03d8':'Koppa',   u'\u03d9':'koppa',
    u'\u03da':'Stigma',  u'\u03db':'stigma',  u'\u03dc':'Digamma',
    u'\u03dd':'digamma', u'\u03de':'Koppa',   u'\u03df':'koppa',
    u'\u03e0':'Sampi',   u'\u03e1':'sampi',   u'\u03f0':'kappa',
    u'\u03f1':'rho',     u'\u03f2':'sigma',   u'\u03f3':'yot',
    u'\u03f4':'Theta',   u'\u03f5':'epsilon', u'\u03f6':'epsilon',
    u'\u03f7':'Sho',     u'\u03f8':'sho',     u'\u03f9':'Sigma',
    u'\u03fa':'San',     u'\u03fb':'san',
    
    # Hebrew letters
    u'\u05d0':'aleph',   u'\u05d1':'beth',    u'\u05d2':'gimel',
    u'\u05d3':'daleth',  u'\u05d4':'he',      u'\u05d5':'vav',
    u'\u05d6':'zayin',   u'\u05d7':'heth',    u'\u05d8':'teth',
    u'\u05d9':'yod',     u'\u05da':'kaf',     u'\u05db':'kaf',
    u'\u05dc':'lamed',   u'\u05dd':'mem',     u'\u05de':'mem',
    u'\u05df':'nun',     u'\u05e0':'nun',     u'\u05e1':'samekh',
    u'\u05e2':'ayin',    u'\u05e3':'pe',      u'\u05e4':'pe',
    u'\u05e5':'tsadi',   u'\u05e6':'tsadi',
}

def sort_by_accent(a,b):
    return cmp(deaccent(a),deaccent(b))
