// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: Granule.cpp,v 1.23 2005/11/22 02:28:30 vlg Exp $
//------------------------------------------------------------------------------
//                            Granule.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2004-2005 by Vladislav Grinchenko 
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Wed Dec 31 23:18:34 2003
//
//------------------------------------------------------------------------------

#ifdef HAVE_CONFIG_H
#   include "config.h"
#endif

#include <iostream>
#include <fstream>
#include <unistd.h>				// access(2)
#include <stdlib.h>				// system(3)

#include <glibmm/ustring.h>
#include <gtkmm/main.h>

#include <assa/CommonUtils.h>
#include <assa/Logger.h>
#include <assa/SigAction.h>
#include <assa/IniFile.h>

#include "Granule-main.h"
#include "Granule.h"
#include "Config.h"
#include "MainWindow.h"

// Static declarations

ASSA_DECL_SINGLETON(Granule);
static const int TIMEOUT = 500;

template <> xmlExternalEntityLoader Granule::m_default_entity_loader = 0;

/*******************************************************************************
                          Member Functions
*******************************************************************************/
Granule::
Granule () :
	m_timeout      (0.01),
	m_kit          (NULL),
	m_main_window  (NULL),
	m_secs_in_day  (86400),
	m_secs_in_week (604800)
{
    add_opt ('g', "gtk-options",  &m_gtk_options );
	add_opt (0,   "secs-in-day",  &m_secs_in_day );
	add_opt (0,   "secs-in-week", &m_secs_in_week);

    // ---Configuration---
    rm_opt ('n', "instance"     );
    rm_opt ('p', "port"         );

    // ---Process bookkeeping---
    rm_opt ('b', "daemon"       );
    rm_opt ('l', "pidfile"      );
    rm_opt ('L', "ommit-pidfile");

	m_ommit_pidfile = "yes";	// don't lock up on PID 

    /* By defauil disable all debugging
     */
    /* m_mask = GRAPP | DECK | GUITRACE | ASSA::ERROR; */
	m_mask = 0;

    m_log_file = "granule.log";
}

/**
 * Description: 
 *
 *  Read configuration from [options] secion of the configuration
 *  file, ~/.granule, and populate command-line options. 
 *  They might be overwritten by command-line arguments supplied with argv_.
 *  Call GenServer::init() to start initialization.
 *
 *  If the application configuration file, ~/.granule,
 *  is missing, copy the default from $GRAPPDATADIR.
 *  Gtkmm hasn't been initialized yet.
 */
void 
Granule::
init (int* argc_, char* argv_[], const char* help_info_)
{
	string defaultrc (GRAPPDATADIR);
	defaultrc += "/granule";
	string rcfile (ASSA::Utils::strenv ("~/.granule"));

	ASSA::IniFile cfg (rcfile);
	std::string v;

	if (::access (rcfile.c_str (), R_OK) < 0) {
		if (::access (defaultrc.c_str (), R_OK) == 0) {
			string cmd ("cp -p ");
			cmd += defaultrc + " " + rcfile;
			if (::system (cmd.c_str ()) < 0) {
				goto done;
			}
		}
		else {
			goto done;
		}
	}

	if (cfg.load () == 0) {
		parse_config_file (cfg);
	}

 done:

	ASSA::GenServer::init (argc_, argv_, help_info_);

	/*
	  TRACE    = 0x00001
	  APP      = 0x00002 (GRAPP)
	  USR1     = 0x00004 (GUITRACE)
	  USR2     = 0x00008 (DECK)
	  USR3     = 0x00010
	  ALL_APPS = 0x0001F
	  ERROR    = 0x00020
	  FORK     = 0x40000
	*/

	if (m_log_level >= 0) {
		switch (m_log_level) {
		case 6:	m_mask = ALL;     break;    // Log message flood!
		case 5:	m_mask = 0x3F;    break;    // ALL_APPS+ERRORS
		case 4: m_mask = 0x40026;	break;    // +FORK
		case 3: m_mask = 0x26;    break;    // GRAPP+GUITRACE+ERRORS
		case 2: m_mask = 0x25;    break;    // TRACE+GUITRACE+ERRORS
		case 1:	m_mask = 0x22;    break;    // GRAPP+ERRORS
		case 0:	default: m_mask = 0x0;
		}
	}

	LOGGER->enable_groups (m_mask);

	/** Install my own entity loader. This will let me redefine
		DTD URLs and support backward compatability.
	 */
	m_default_entity_loader = xmlGetExternalEntityLoader();
	xmlSetExternalEntityLoader (my_xml_entity_loader);

	/** Initialize XML parser
	 */
	xmlInitParser ();
	xmlIndentTreeOutput = 1;
}

Granule::
~Granule ()
{
    trace_with_mask("Granule::~Granule",GUITRACE);

	/** Cleanup XML parser
	 */
	xmlCleanupParser ();

	/** First, disconnect from the timer callback.
		Failing to do so causes core dumps on exit from libsigc-2.0's
		sigc::trackable::remove_destroy_notify_callback ().
	*/
	m_tconn.disconnect ();
    delete m_main_window;
}

void
Granule::
dump_package_envs ()
{
	DL((APP,"\n= Environment variables set by Autoconfig: =\n"
		"\n"
		"\tGRAPPDATADIR..: \"%s\"\n"
		"\tGRAPPXMLDIR...: \"%s\"\n"
		"\tDATADIR.......: \"%s\"\n"
		"\tLOCALEDIR.....: \"%s\"\n"
		"\tPACKAGE.......: \"%s\"\n"
		"\tVERSION.......: \"%s\"\n"
		"\n",
		GRAPPDATADIR, GRAPPXMLDIR, DATADIR, LOCALEDIR, PACKAGE, VERSION));
}

/* Rewrite the url of the granule dtds to local files so we can
 * use the local dtds.
 * 
 * Look for /etc/xml for backwards compatibility with old files.
 */
xmlParserInputPtr
Granule::
my_xml_entity_loader (const char* url_, 
					  const char* id_,
					  xmlParserCtxtPtr ctxt_)
{
    trace_with_mask("Granule::my_xml_entity_loader",GUITRACE);

    xmlParserInputPtr ret;

	if (url_) {
		DL ((GRAPP,"URL = \"%s\"\n", url_));
	}

	if (id_) {
		DL ((GRAPP,"ID  = \"%s\"\n",  id_));
	}

    if (strcmp (url_, "/etc/xml/granule/granule.dtd") == 0 ||
		strcmp (url_, "http://granule.sourceforge.net/granule.dtd") == 0) 
	{
		url_ = GRAPPXMLDIR "/granule.dtd";
    } 
	else if (strcmp (url_, "/etc/xml/granule/cardfile.dtd") == 0 ||
			 strcmp (url_, "http://granule.sourceforge.net/cardfile.dtd") == 0)
	{
        url_ = GRAPPXMLDIR "/cardfile.dtd";
    }

	DL ((GRAPP,"Substituted URL: \"%s\"\n", url_));
    
    return m_default_entity_loader (url_, id_, ctxt_);
}

void
Granule::
init_service ()
{
    trace_with_mask("Granule::init_service",GUITRACE);

    ASSA::Log::disable_timestamp ();
    int gtk_argc = 0;
    char** gtk_argv = NULL;

	DL((ALL,"gtk_options = \"%s\"\n",     m_gtk_options.c_str ()));
	DL((ALL,"log_stdout  = %s\n",         m_log_stdout.c_str ()));
	DL((ALL,"log_file    = \"%s\"\n",     m_log_file.c_str ()));
	DL((ALL,"log_size    = %d\n",         m_log_size));
	DL((ALL,"log_level   = \"%d\"\n",     m_log_level));
	DL((ALL,"mask        = 0x%X\n",       m_mask));

	/**
	 * Block SIGCHLD for a moment
	 */
	ASSA::SigAction old_chld_act;
	struct sigaction* sa;
	old_chld_act.retrieve_action (SIGCHLD);
	sa = old_chld_act;
	
	/**
	 * ATTENTION:
	 *    Passing --g-fatal-warnings would kill Granule BEFORE
	 *    the first Gtk+ critical warning is written to stdout. 
     *    If you want to examine warnings, don't use this option.
	 */
    m_gtk_options = "granule " + m_gtk_options;
    CmdLineOpts::str_to_argv (m_gtk_options, gtk_argc, gtk_argv);

	DL ((ALL,"Cmd line args (%d):\n", gtk_argc));
	DL ((ALL,"-----------------------------\n"));
	for (int i=0; i<gtk_argc; i++) {
		DL ((ALL,"[%2d] = \"%s\"\n", i, gtk_argv[i]));
	}
	DL ((ALL,"-----------------------------\n"));

    m_kit = new Gtk::Main (&gtk_argc, &gtk_argv);

    CmdLineOpts::free_argv (gtk_argv);

	/** I suspect one of the Gnome libraries changes action of
	 *  SIGCHLD signal. Reset it to SIG_IGN.
	 */
	ASSA::SigAction ignore (SIG_IGN);
	ignore.register_action (SIGCHLD, &old_chld_act);

    /** Load history from ~/.granule configuration file
	 */
    CONFIG->load_config (m_secs_in_day, m_secs_in_week);

	/** Put up the main window on the screen.
	 */
    m_main_window = new MainWindow;
	m_main_window->init ();

    /** Mine (original) - core dumps on exit.
	 */
	sigc::slot0<bool> tslot = sigc::mem_fun (*this, &Granule::timer_cb);
    m_tconn = Glib::signal_timeout().connect (tslot, TIMEOUT);

	dump_package_envs ();
    DL((ASSA::APP,"Service has been initialized\n"));
}

void
Granule::
process_events ()
{
    trace_with_mask("Granule::process_events",GUITRACE);

    m_kit->run (*m_main_window);
	REACTOR->stopReactor ();

    DL((ASSA::APP,"Service stopped!\n"));
/*	gtk_exit (0); */
}

/*******************************************************************************
 * Static utilities
 ******************************************************************************/
gchar* 
Granule::
strip_pango_markup (const char* src_)
{
	PangoAttrList* attrs;
	gchar* result;
	pango_parse_markup (src_, -1, 0, &attrs, &result, NULL, NULL);
	g_free (attrs);
	return result;
}

bool
Granule::
check_markup (const Glib::ustring& str_)
{
	PangoAttrList* attrs = NULL;
	gchar* ptext = NULL;
	gboolean ret = FALSE;

	ret = pango_parse_markup (str_.c_str (), -1, 0, &attrs, &ptext, NULL, NULL);
	g_free (attrs);
	g_free (ptext);
	return ret;
}

void
Granule::
remove_common_prefixes (gchar*& src_)
{
	static const gchar* prefixes [] = { "to ", "a ", "an ", NULL };
	
	for (int i = 0; prefixes [i]; i++) {
		if (g_str_has_prefix (src_, prefixes [i])) {
			src_ = src_ + strlen (prefixes [i]);
		}
	}
}

xmlChar*
Granule::
get_node_by_xpath (xmlDocPtr parser_, const char* xpath_)
{
	xmlXPathContextPtr context = NULL;
	xmlXPathObjectPtr  result = NULL;
	xmlNodeSet* nodeset = NULL;
	xmlChar* keyword = NULL;

	context = xmlXPathNewContext (parser_);
	if (context == NULL) {
		DL ((ASSA::ERROR,"Failed to create context.\n"));
		goto done;
	}
	
	result = xmlXPathEval (BAD_CAST xpath_, context);

	if (xmlXPathNodeSetIsEmpty (result->nodesetval)) {

		DL ((ASSA::ERROR,"Empty nodeset for xpath \"%s\"\n", xpath_));
		goto done;
	}
	nodeset = result->nodesetval;

	/** We expect only one node
	 */
//	for (int i = 0; i < nodeset->nodeNr; i++) {
	keyword = xmlNodeListGetString (parser_, 
									nodeset->nodeTab[0]->xmlChildrenNode, 
									1);
//	}

  done:
	if (result) {
		xmlXPathFreeObject (result);
	}
	if (context) {
		xmlXPathFreeContext (context);
	}

	return keyword;
}
