// -*- c++ -*-
//------------------------------------------------------------------------------
// $Id: EditControls.h,v 1.3 2006/02/27 01:15:20 vlg Exp $
//------------------------------------------------------------------------------
//                            EditControls.h
//------------------------------------------------------------------------------
//  Copyright (c) 2005,2006 by Vladislav Grinchenko 
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Nov 13 2005
//
//------------------------------------------------------------------------------
#ifndef EDIT_CONTROLS_H
#define EDIT_CONTROLS_H

#include <gtkmm/box.h>
#include <gtkmm/textview.h>
#include <gtkmm/box.h>
#include <gdkmm/pixbuf.h>
#include <gtkmm/image.h>
#include <gtkmm/clipboard.h>

using sigc::bind;
using sigc::mem_fun;

#include <vector>
#include <string>

using std::vector;
using std::string;

/** EditControls is a collection of markup edit buttons
	that are embedded in CardView for quick editing
	the text in the input fields.
*/
class EditControls :  public Gtk::HBox
{
public:
	EditControls (Glib::RefPtr<Gtk::TextBuffer> tb_ref_);

	void on_focus_changed (Gtk::TextView* text_view_);
	void on_clipboard_text_received (const Glib::ustring& text_);

private:
	void on_edit_button_clicked (const string& action_);

	void remove_tags (Glib::RefPtr<Gtk::TextBuffer::Mark> begin_mark_,
					  Glib::RefPtr<Gtk::TextBuffer::Mark> end_mark_);

	static gunichar
	display_unichar_at (Gtk::TextBuffer::iterator iter_)
	{
		gunichar c;
		return ((c = iter_.get_char ()) ? c : ' ');
	}

private:
	typedef std::pair<string, Gtk::Image*> icon_t;
	typedef vector<icon_t> icon_list_t;

	icon_list_t m_icon_list;
	Glib::RefPtr<Gtk::TextBuffer> m_textbuf;
};

#endif /* EDIT_CONTROLS_H */
