// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: Granule.h,v 1.21 2006/03/19 15:39:44 vlg Exp $
//------------------------------------------------------------------------------
//                            Granule.h
//------------------------------------------------------------------------------
//  Copyright (c) 2004,2005 by Vladislav Grinchenko 
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Wed Dec 31 23:18:34 2003
//
//------------------------------------------------------------------------------
#ifndef Granule_H
#define Granule_H

#ifdef HAVE_CONFIG_H
#    include "config.h"
#endif

#include <libxml/parser.h>
#include <libxml/xmlIO.h>

#include <string>
using std::string;
#include <stack>

#include <gtkmm.h>

#ifdef IS_HILDON
#include <hildon-widgetsmm/app.h>
#endif

#include <assa/GenServer.h>
#include <assa/Singleton.h>
#include <assa/TimeVal.h>

#include "DeckManager.h"

class MainWindow;

#ifdef IS_HILDON
class Hildon::App;
#endif

class Granule :
    public virtual sigc::trackable,
    public ASSA::GenServer,
    public ASSA::Singleton<Granule>
{
public:
    Granule ();
    ~Granule ();

	virtual void init (int* argc_, char* argv_[], const char* help_);

    virtual void init_service   ();
    virtual void process_events ();
	virtual void fatal_signal_hook ();

    bool timer_cb ();
	bool dump_cardboxes_enabled () const { return (m_dump_cardboxes == "yes"); }

	MainWindow*  get_main_window () { return m_main_window; }

#ifdef IS_HILDON
	Hildon::App* get_hildon_app () { return m_hildon_app; }
#endif

	/** Overload XML parser default entity loader.
	 */
    static xmlParserInputPtr 
	my_xml_entity_loader (const char*      url_, 
						  const char*      id_, 
						  xmlParserCtxtPtr ctxt_);

#ifdef IS_HILDON
	void register_appview   (Hildon::AppView* view_, bool start_ = false);
	void unregister_appview (Hildon::AppView* view_);
#endif

public: // Common utilities used everywhere
	static gchar*   strip_pango_markup     (const char* src_);
	static void     remove_common_prefixes (gchar*& src_);
	static Glib::ustring trim_multiline (const Glib::ustring& text_);

	/** Search DOM XML parser tree for the first element that
		matches the xpath_.
	*/
	static xmlChar* get_node_by_xpath (xmlDocPtr parser_, const char* xpath_);

	/** Validate pango markup
		@return true on success; false if entry is invalid
	*/
	static bool check_markup (const Glib::ustring& str_);

private:
	void dump_package_envs ();

private:
	ASSA::TimeVal    m_timeout;

	/** Options */
    std::string      m_gtk_options;
	int              m_secs_in_day;
	int              m_secs_in_week;
	std::string      m_dump_cardboxes;

    Gtk::Main*       m_kit;
    MainWindow*      m_main_window;
	sigc::connection m_tconn;

    static xmlExternalEntityLoader m_default_entity_loader;

#ifdef IS_HILDON
	Hildon::App*     m_hildon_app;
	std::stack<Hildon::AppView*> m_appview_stack;
#endif	
};

/* Useful definitions */

#define GRANULE    Granule::get_instance()

#define REACTOR    GRANULE->get_reactor()
#define MAINWIN    GRANULE->get_main_window()
#define DECKMGR    MAINWIN->get_deck_manager()
#define DECKLIST   MAINWIN->get_deck_list()
#define CARDBOX    MAINWIN->get_cardbox()
#define TOPMENUBAR MAINWIN->get_top_menubar()

#ifdef IS_HILDON
#  define HILDONAPPWIN GRANULE->get_hildon_app()
#endif

/**
 * Run Reactor's event loop.
 */
inline bool
Granule::
timer_cb ()
{
	ASSA::TimeVal tv (m_timeout);
    REACTOR->waitForEvents (&tv);
    return true;
}


#endif // Granule_H

