// -*- c++ -*-
//------------------------------------------------------------------------------
// $Id: PrefWindow.cpp,v 1.9 2006/03/19 15:39:44 vlg Exp $
//------------------------------------------------------------------------------
//                            PrefWindow.h
//------------------------------------------------------------------------------
//  Copyright (c) 2004,2006 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Sun May 30 21:09:23 EDT 2004
//
//------------------------------------------------------------------------------

#include "Config.h"
#include "PrefWindow.h"

PrefWindow::
PrefWindow (Gtk::Widget& parent_) :
    MyPropertyBox      ("Preferences"),
	m_general_pref     (*this),
	m_scheduling_pref  (*this),
	m_sound_pref       (*this),
	m_geometry_pref    (*this),
	m_ignore_callbacks (true),
	m_changed          (false)
{
    trace_with_mask("PrefWindow::PrefWindow",GUITRACE);

#ifdef IS_HILDON
	set_size_request (672, -1);
#else
	set_transient_for (dynamic_cast<Gtk::Window&>(parent_));
#endif

	/** Show all
	 */
	m_general_pref.show_all ();
	m_scheduling_pref.show_all ();
	m_sound_pref.show_all ();
	m_geometry_pref.show_all ();
	
	/** Pack all
	 */
	append_page (m_general_pref,    "General");
	append_page (m_scheduling_pref, "Scheduling");
	append_page (m_sound_pref,      "Sound");
	append_page (m_geometry_pref,   "Geometry");
}

bool
PrefWindow::
run ()
{
    trace_with_mask("PrefWindow::run",GUITRACE);

	m_ignore_callbacks = true;	
    m_changed = false;
	DL ((GRAPP,"m_changed set to false\n"));

	/** Fill values of all pages with fresh values from Config
	 */
	m_general_pref.load_from_config ();
	m_scheduling_pref.load_from_config ();
	m_sound_pref.load_from_config ();
	m_geometry_pref.load_from_config ();
	
	m_ignore_callbacks = false;
	m_apply_button->set_sensitive (false);
    show ();

#ifdef IS_HILDON
	GRANULE->register_appview (this);
	Gtk::Main::run (*HILDONAPPWIN);
#else
    Gtk::Main::run ();
#endif

	DL ((GRAPP,"m_changed = %s\n", (m_changed ? "true":"false")));
    return m_changed;
}

void 
PrefWindow::
apply_impl ()
{
    trace_with_mask("PrefWindow::apply_impl",GUITRACE);

	m_general_pref.save_to_config ();
	m_scheduling_pref.save_to_config ();
	m_sound_pref.save_to_config ();
	m_geometry_pref.save_to_config ();
}
