// -*- c++ -*-
// generated by glade--
//------------------------------------------------------------------------------
// $Id: SoundPrefs.cpp,v 1.5 2006/02/10 03:26:05 vlg Exp $
//------------------------------------------------------------------------------
//                            SoundPref.h
//------------------------------------------------------------------------------
//  Copyright (c) 2004 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Sun May 30 21:09:23 EDT 2004
//
//------------------------------------------------------------------------------
#include <gtkmm/label.h>
#include <gtkmm/stock.h>
#include <gtkmm/filechooserdialog.h>

#include "Granule-main.h"
#include "Config.h"
#include "SoundPrefs.h"
#include "PrefWindow.h"

SoundPrefs::
SoundPrefs (PrefWindow& pwin_) :
	VBox(false, 0),
	m_pref_window (pwin_)
{
	trace_with_mask("SoundPrefs::SoundPrefs",GUITRACE);

	m_sound_player = Gtk::manage(new Gtk::Entry());
   
	Gtk::Label *snd_player_lbl = Gtk::manage(new Gtk::Label("Sound Player: "));
	Gtk::Label *snd_args_lbl = Gtk::manage(new Gtk::Label("Sound Cmd Args:"));
	m_snd_args = Gtk::manage(new Gtk::Entry());
	
	Gtk::Label *snd_path_lbl = Gtk::manage(new Gtk::Label("Default Sound Path"));
	m_snd_path = Gtk::manage(new Gtk::Entry());
	m_browse_button = Gtk::manage(new Gtk::Button("Browse ..."));
   
	Gtk::HBox *snd_path_hbox = Gtk::manage(new Gtk::HBox(false, 0));
	m_table = Gtk::manage(new Gtk::Table(2, 2, false));

	m_sound_player->set_flags(Gtk::CAN_FOCUS);
	m_sound_player->set_visibility(true);
	m_sound_player->set_editable(true);
	m_sound_player->set_max_length(0);
	m_sound_player->set_text(CONFIG->get_snd_player_cmd ());
	m_sound_player->set_has_frame(true);
	m_sound_player->set_activates_default(false);

	snd_player_lbl->set_alignment(0,0.5);
	snd_player_lbl->set_padding(0,0);
	snd_player_lbl->set_justify(Gtk::JUSTIFY_RIGHT);
	snd_player_lbl->set_line_wrap(false);
	snd_player_lbl->set_use_markup(false);
	snd_player_lbl->set_selectable(false);

	snd_args_lbl->set_alignment(0,0.5);
	snd_args_lbl->set_padding(0,0);
	snd_args_lbl->set_justify(Gtk::JUSTIFY_LEFT);
	snd_args_lbl->set_line_wrap(false);
	snd_args_lbl->set_use_markup(false);
	snd_args_lbl->set_selectable(false);

	m_snd_args->set_flags(Gtk::CAN_FOCUS);
	m_snd_args->set_visibility(true);
	m_snd_args->set_editable(true);
	m_snd_args->set_max_length(0);
	m_snd_args->set_text(CONFIG->get_snd_player_args ());
	m_snd_args->set_has_frame(true);
	m_snd_args->set_activates_default(false);

	snd_path_lbl->set_alignment(0,0.5);
	snd_path_lbl->set_padding(0,0);
	snd_path_lbl->set_justify(Gtk::JUSTIFY_LEFT);
	snd_path_lbl->set_line_wrap(false);
	snd_path_lbl->set_use_markup(false);
	snd_path_lbl->set_selectable(false);

	m_snd_path->set_flags(Gtk::CAN_FOCUS);
	m_snd_path->set_visibility(true);
	m_snd_path->set_editable(true);
	m_snd_path->set_max_length(0);
	m_snd_path->set_text(CONFIG->get_snd_archive_path ());
	m_snd_path->set_has_frame(true);
	m_snd_path->set_activates_default(false);

	m_browse_button->set_flags(Gtk::CAN_FOCUS);
	m_browse_button->set_relief(Gtk::RELIEF_NORMAL);

	snd_path_hbox->pack_start(*m_snd_path, Gtk::PACK_EXPAND_WIDGET, 2);
	snd_path_hbox->pack_start(*m_browse_button, Gtk::PACK_SHRINK, 0);

	m_table->set_border_width(6);
	m_table->set_row_spacings(5);
	m_table->set_col_spacings(6);
	m_table->attach(*m_sound_player, 1, 2, 0, 1, 
					Gtk::EXPAND|Gtk::FILL, Gtk::AttachOptions(), 0, 0);
	m_table->attach(*snd_player_lbl, 0, 1, 0, 1, 
					Gtk::FILL, Gtk::FILL, 0, 0);
	m_table->attach(*snd_args_lbl, 0, 1, 1, 2, 
					Gtk::FILL, Gtk::FILL, 0, 0);
	m_table->attach(*m_snd_args, 1, 2, 1, 2, 
					Gtk::EXPAND|Gtk::FILL, Gtk::AttachOptions(), 0, 0);
	m_table->attach(*snd_path_lbl, 0, 1, 2, 3, 
					Gtk::FILL, Gtk::AttachOptions(), 0, 0);
	m_table->attach(*snd_path_hbox, 1, 2, 2, 3, 
					Gtk::FILL, Gtk::FILL, 0, 0);

	m_sound_player->signal_changed().connect (
		sigc::mem_fun (m_pref_window, &PrefWindow::changed_cb));
	m_snd_args->signal_changed().connect (
		sigc::mem_fun (m_pref_window, &PrefWindow::changed_cb));
	m_snd_path->signal_changed().connect (
		sigc::mem_fun (m_pref_window, &PrefWindow::changed_cb));

	m_browse_button->signal_clicked ().connect (
		sigc::mem_fun (*this, &SoundPrefs::on_browse_clicked));

	set_border_width(18);
	m_table->show_all ();
	pack_start(*m_table);
}

void
SoundPrefs::
changed_cb () 
{
	m_pref_window.changed ();
}

void
SoundPrefs::
load_from_config ()
{
	trace_with_mask("SoundPrefs::load_from_config",GUITRACE);

	m_sound_player  ->set_text (CONFIG->get_snd_player_cmd   ());
	m_snd_args      ->set_text (CONFIG->get_snd_player_args  ());
	m_snd_path      ->set_text (CONFIG->get_snd_archive_path ());
}

void
SoundPrefs::
save_to_config ()
{
	trace_with_mask("SoundPrefs::save_to_config",GUITRACE);

	CONFIG->set_snd_player_cmd   (m_sound_player  ->get_text ());
	CONFIG->set_snd_player_args  (m_snd_args      ->get_text ());
	CONFIG->set_snd_archive_path (m_snd_path->get_text ());
}

void
SoundPrefs::
on_browse_clicked ()
{
	trace_with_mask("SoundPrefs::on_browse_clicked",GUITRACE);

	Gtk::FileChooserDialog f ("Select Sound Dictionary",
							  Gtk::FILE_CHOOSER_ACTION_SELECT_FOLDER);
#ifndef IS_HILDON
    f.set_transient_for (m_pref_window);
#endif
	f.add_button (Gtk::Stock::CANCEL, Gtk::RESPONSE_CANCEL);
	f.add_button ("Select",           Gtk::RESPONSE_OK);

	const char* snd_path = CONFIG->get_snd_archive_path ();
	if (snd_path && strlen (snd_path)) {
		f.set_current_folder (snd_path);
	}
	else {
		f.set_current_folder (CONFIG->get_filesel_path ());
	}
	f.set_local_only ();

    if (f.run () == Gtk::RESPONSE_OK) {
        m_snd_path->set_text (Glib::filename_from_utf8 (f.get_filename ()));
    }
}

