// -*- c++ -*-
// generated by glade--
//------------------------------------------------------------------------------
// $Id: AboutGRAPP.cpp,v 1.9 2006/08/30 12:22:35 vlg Exp $
//------------------------------------------------------------------------------
//                            AboutGRAPP.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2004,2006 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Sun May 30 21:09:23 EDT 2004
//
//------------------------------------------------------------------------------

#include <gtkmm/image.h>
#include <gtkmm/label.h>
#include <gtkmm/alignment.h>

#ifdef HAVE_CONFIG_H
#    include "config.h"
#endif

#include "AboutGRAPP.h"

AboutGRAPP::
AboutGRAPP () :
	m_url ("http://granule.sourceforge.net/")
{
#if defined (WIN32)
	m_icon_path = "granule.ico";
#else
	m_icon_path = (DATDIR "/pixmaps/granule.png");
#endif

	Gtk::Label* label;

	Gtk::Alignment* align = manage (new Gtk::Alignment (0.5, 0.2, 0, 0));
	get_vbox ()->pack_start (*align);
	align->set_border_width (20);

	Gtk::VBox* contents = manage (new Gtk::VBox (false, 20));
	align->add (*contents);

	/** HBox holds Icon image and package name
	 */
	Gtk::HBox* hbox = manage (new Gtk::HBox (false, 3));
	
	Gtk::Image* icon = manage (new Gtk::Image (m_icon_path));
	hbox->pack_start (*icon, Gtk::PACK_SHRINK, 2);
	icon->set_alignment (1.0, 0.5);

	label = manage (new Gtk::Label);
	hbox->pack_start (*label, Gtk::PACK_SHRINK, 2);
	label->set_markup ("<span size=\"x-large\" weight=\"heavy\">" PACKAGE
					   " " VERSION " </span>\n" + m_url);

	contents->pack_start (*hbox);

	/** Label is the rest of it
	 */
	Glib::ustring info_msg ("\nThe Flashcard Program.\n");
	info_msg += "Copyright (C) 2004-2006 Vladislav Grinchenko\n";
	label = manage (new Gtk::Label (info_msg));

	contents->pack_start (*label);

	/** Add <Close> button
	 */
	Gtk::Button* close_b = manage (new Gtk::Button ("Close"));
	Gtk::Box* action_box = get_action_area ();
	if (action_box) {
		action_box->pack_start (*close_b);
	}
	close_b->signal_clicked ().connect (
		sigc::mem_fun (*this, &AboutGRAPP::on_close_clicked));

	show_all_children ();
}



	
