# This file is part of the graph-includes package
#
# (c) 2005 Yann Dirson <ydirson@altern.org>
# Distributed under version 2 of the GNU GPL.

package graphincludes::project::uniqueincludes;
use strict;
use warnings;

use base qw(graphincludes::project::default);

use graphincludes::params;

sub filelabel {
  my $self = shift;
  my ($file) = @_;
  $file =~ s/^$self->{PFXSTRIP}// if defined $self->{PFXSTRIP};
  $file =~ s!(?:.*/)?([^/]*)\.[^./]*$!$1!;
  return $file;
}

sub getdeps {
  my $self = shift;
  my %deps;

  while (<>) {
    if (m!^\s*#\s*include\s*[<"](?:.*/)?([^/]+)(\.[^.]+)[>"]!) {
      my $dstfile = $1;
      if (grep { $self->filelabel($_) eq $dstfile } @{$self->{FILES}}) {
	push (@{$deps{$self->{NODEIDS}->{$self->filelabel($ARGV)}}},
	      $self->{NODEIDS}->{$self->filelabel($dstfile)});
      } else {
	print STDERR "ERROR: unknown file $dstfile referenced by $ARGV\n"
	  if $graphincludes::params::verbose >= 2;
      }
    }
  }
  return \%deps;
}

1;
