/*
* 21/08/2004 - 19:29
*
* GraphMonkey - mono based graphing calculator
* Copyright (C) 2004 Bellabes Lounis
* nolius@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

using System;
using Gtk;
using Pango;

class Ecran_Form : DrawingArea
{
	Pango.Layout layout;
	public string equation;
	public string equation2;
	public string equation3;
        
        
	public float x_min;
	public float x_max;
	public float y_min;
	public float y_max;
	public float graduation;
		
	//for color
	public Gdk.GC gc_red;
	public Gdk.GC gc_green;
	public Gdk.GC gc_blue;
	public Gdk.GC gc_a;
	public Gdk.GC gc_black;
	
	// pour la sauvegarde des resultats
	public bool first_draw = true;
	
	float[] tab_result1_x = new float[501];
	float[] tab_result1_y = new float[501];
	
	float[] tab_result2_x = new float[501];
	float[] tab_result2_y = new float[501];
	
	float[] tab_result3_x = new float[501];
	float[] tab_result3_y = new float[501];
	

 /*
	static void Main ()
	{
		Application.Init ();
		new LayoutSample ();
		Application.Run ();
	}
 */
 
	public Ecran_Form (string equation1, string equation21, string equation31, float x_min1, float x_max1, float y_min1, float y_max1, float graduation1)
	{
		Gtk.Window win = new Gtk.Window ("Screen");
		//win.Resizable = false;
                
		//Gdk.GC gc = new Gdk.GC (win);
		//Gdk.Color red_color = new Gdk.Color (0xff, 0, 0);
		//gc.Foreground = red_color;                                                                                     
                                                                                                                                                       
		win.SetDefaultSize (501, 501);
		  
		this.ExposeEvent += OnExposed;
                    
		win.Add (this);
		win.ShowAll ();
                   
		this.equation = equation1;
		this.equation2 = equation21; 
		this.equation3 = equation31;  
		this.x_min = x_min1;
		this.x_max = x_max1;
		this.y_min = y_min1;
		this.y_max = y_max1;
		this.graduation = graduation1;
                
                
                
	}
 
	void OnExposed (object o, ExposeEventArgs args)
	{
        	
		// color
		gc_red = new Gdk.GC (this.GdkWindow);
		gc_green = new Gdk.GC (this.GdkWindow);
		gc_blue = new Gdk.GC (this.GdkWindow);
		gc_a = new Gdk.GC (this.GdkWindow);
		gc_black = new Gdk.GC (this.GdkWindow);
		Gdk.Color red_color = new Gdk.Color (0xff, 0, 0);
		Gdk.Color green_color = new Gdk.Color (0 , 0xff, 0);
		Gdk.Color blue_color = new Gdk.Color (0 , 0, 0xff);
		Gdk.Color black_color = new Gdk.Color (0 , 0, 0);
		Gdk.Color a_color = new Gdk.Color (0xff, 0, 0xff);
		Gdk.Colormap colormap = Gdk.Colormap.System;     
		Gdk.Color[] tab_color = new Gdk.Color[100];
		tab_color[0] = red_color;
		tab_color[1] = green_color;
		tab_color[2] = blue_color;
		tab_color[3] = a_color;
		tab_color[4] = black_color;
		bool[] tab_bool = new bool[100];
		colormap.AllocColors(tab_color, 5, true, true, tab_bool);
		gc_red.Foreground = tab_color[0];
		gc_green.Foreground = tab_color[1];
		gc_blue.Foreground = tab_color[2];
		gc_a.Foreground = tab_color[3];
		gc_black.Foreground = tab_color[4];
		
		Gdk.Rectangle rec_screen = new Gdk.Rectangle(0, 500, 0, 500);
		
            
		//Gtk.StateType a = new Gtk.StateType();
		//this.Style.SetForegroundGC(a, gc_blue);
            
                   
		trace_axe();
		
		if(first_draw){
			trace_equation();
			first_draw = false;
		}
		else{
			trace_equation2();
		}
		
	}
 
 
	void trace_axe()
	{
 		// ecran noir		
 		this.GdkWindow.DrawRectangle(gc_black, true, -10, -10, 520, 520);

 		this.GdkWindow.DrawLine(gc_blue, (int) trans_x(x_min), (int) trans_y(0f), (int) trans_x(x_max), (int) trans_y(0f));
		this.GdkWindow.DrawLine(gc_blue, (int) trans_x(0f), (int) trans_y(y_min), (int) trans_x(0f), (int) trans_y(y_max));
 		
            
		// graduation sur x
			//0 au max				
		for(float i2=trans_x(0f); i2<=trans_x(x_max); i2=i2+ graduation*500/(x_max - x_min) ){
			this.GdkWindow.DrawLine(gc_blue, (int) i2, (int) trans_y(0f), (int) i2, (int) (trans_y(0f)-5) ); //vertical
		}
			//0 au min
		for(float i2=trans_x(0f); i2>=trans_x(x_min); i2=i2-graduation*500/(x_max - x_min) ){
			this.GdkWindow.DrawLine(gc_blue, (int) i2, (int) trans_y(0f), (int) i2, (int) (trans_y(0f)-5) ); //vertical
		}					
				
		// graduation sur y
			//0 au max
		for(float i2=trans_y(0f); i2<=trans_y(y_min); i2=i2+graduation*500/(y_max - y_min) ){
			this.GdkWindow.DrawLine(gc_blue, (int) trans_x(0f), (int) i2, (int) (trans_x(0f)+5), (int) i2); //vertical
		}
			//0 au max	
		for(float i2=trans_y(0f); i2>=trans_y(y_max); i2=i2-graduation*500/(y_max - y_min) ){
			this.GdkWindow.DrawLine(gc_blue, (int) trans_x(0f), (int) i2, (int) (trans_x(0f)+5),(int) i2); //vertical
		}		                
                 		
 		
 	}
 		
	void trace_equation()
	{
 		
		Gdk.GC gc_eq;
 				
		for(int i_eq=0; i_eq <3; i_eq++){
 			
			operation op = new operation(equation);
 			gc_eq = gc_red;
 				 	
			if(i_eq==1){
				op = new operation(equation2);				
				gc_eq = gc_a;
			}
			else if(i_eq==2){
				op = new operation(equation3);
				gc_eq = gc_green;
			}
 				
			op.corrige();
			//op.decouper();

			try{
				//operation op = new operation(equation);
				//float res=op.calculer(1);
 			
				float xc_1 = x_min;
				float yc_1 = op.calculer(x_min);			
				float xc_2;
				float yc_2;
												
				float pitch=(x_max-x_min)/500;
				float x_1;
				float y_1;
				float x_2;
				float y_2;
				
				// sauvegarde des résultats
				int i_save = 0;
				if(i_eq ==0){
					tab_result1_x[i_save] = trans_x(xc_1);
					tab_result1_y[i_save] = trans_y(yc_1);
				}
				else if(i_eq ==1){
					tab_result2_x[i_save] = trans_x(xc_1);
					tab_result2_y[i_save] = trans_y(yc_1);
				}
				else if(i_eq ==2){
					tab_result3_x[i_save] = trans_x(xc_1);
					tab_result3_y[i_save] = trans_y(yc_1);
				}
											
												
				for(float i_graph=x_min; i_graph<=x_max; i_graph=i_graph+pitch){
					xc_2 = xc_1+pitch;
					yc_2 = op.calculer(xc_2);
															
					// transformation dans mon repere
					x_1 = trans_x(xc_1);
					y_1 = trans_y(yc_1);
					x_2 = trans_x(xc_2);
					y_2 = trans_y(yc_2);
					
					
					// sauvegarde des résultats
					i_save++;
				if(i_eq ==0){
					tab_result1_x[i_save] = x_2;
					tab_result1_y[i_save] = y_2;
				}
				else if(i_eq ==1){
					tab_result2_x[i_save] = x_2;
					tab_result2_y[i_save] = y_2;
				}
				else if(i_eq ==2){
					tab_result3_x[i_save] = x_2;
					tab_result3_y[i_save] = y_2;
				}
								
					double yc_1_verif = (double) yc_1;
					double yc_2_verif = (double) yc_2;
					if(!Double.IsNaN(yc_1_verif) && !Double.IsNaN(yc_2_verif)){
					
						if((yc_1>y_min && yc_1<y_max) || (yc_2>y_min && yc_2<y_max)){	
							this.GdkWindow.DrawLine(gc_eq, (int) x_1, (int) y_1, (int) x_2, (int) y_2);
						}
					
					}
															
					// on passe au point suivant
					xc_1=xc_2;
					yc_1=yc_2;
					
				}
			}	
			catch(Exception ex)
			{
					
			} 
				
		}		
 		
	}
	
	void trace_equation2()
	{
	
		for(int i =0; i<500; i++){

				double yc_1_verif = (double) tab_result1_y[i];
				double yc_2_verif = (double) tab_result1_y[i+1];
				if(!Double.IsNaN(yc_1_verif) && !Double.IsNaN(yc_2_verif)){
					
					if((yc_1_verif>0 && yc_1_verif<500) || (yc_2_verif>0 && yc_2_verif<500)){	
						this.GdkWindow.DrawLine(gc_red, (int) tab_result1_x[i], (int) tab_result1_y[i], (int) tab_result1_x[i+1], (int) tab_result1_y[i+1]);
					}
				}
		}
		
		for(int i =0; i<500; i++){

				double yc_1_verif = (double) tab_result2_y[i];
				double yc_2_verif = (double) tab_result2_y[i+1];
				if(!Double.IsNaN(yc_1_verif) && !Double.IsNaN(yc_2_verif)){
					
					if((yc_1_verif>0 && yc_1_verif<500) || (yc_2_verif>0 && yc_2_verif<500)){	
						this.GdkWindow.DrawLine(gc_a, (int) tab_result2_x[i], (int) tab_result2_y[i], (int) tab_result2_x[i+1], (int) tab_result2_y[i+1]);
					}
					
				}
		}
		
		for(int i =0; i<500; i++){
		
				double yc_1_verif = (double) tab_result3_y[i];
				double yc_2_verif = (double) tab_result3_y[i+1];
				if(!Double.IsNaN(yc_1_verif) && !Double.IsNaN(yc_2_verif)){
					
					if((yc_1_verif>0 && yc_1_verif<500) || (yc_2_verif>0 && yc_2_verif<500)){	
						this.GdkWindow.DrawLine(gc_green, (int) tab_result3_x[i], (int) tab_result3_y[i], (int) tab_result3_x[i+1], (int) tab_result3_y[i+1]);
					}
					
				}
		}
		
	}
 		
 
 
	// pour la transformation sur x
	float trans_x(float x){
		
		return (500/(x_max - x_min) * (x - x_min) );
			
	}
		
	// pour la transformation sur y
	float trans_y(float y){
			
		return ( -500/(y_max - y_min) * (y - y_max) );
			
	}
 		
 				
 		

	
}
