static char rcsid[]="$Header: /home/grass/grassrepository/grass/src/mapdev/v.reclass/cmd/parse.c,v 1.2 2002/01/22 04:51:16 glynn Exp $";
#include <string.h>
#include "rule.h"
#include "local_proto.h"

static char *cur;
static int state;

static int scan_value (CELL *v)
{
    int sign;

    sign = 1;
    if (*cur == '-')
    {
	sign = -1;
	cur++;
    }
    if (*cur < '0' || *cur > '9')
	return 0;

    *v = *cur++ - '0' ;
    while (*cur >= '0'  && *cur <= '9')
	*v = *v * 10 + *cur++ - '0';
    *v *= sign;
    switch (*cur)
    {
    case 0:
    case ' ':
    case '\t':
    case '\n':
    case '=':
		return 1;
    default:
		return 0;
    }
}

int parse (char *line, RULE **rules, RULE **tail, struct Categories *cats)
{
    char *label;
    char *save;
    CELL v;
    CELL lo[100], hi[100], new;
    int count;
    int i;

    cur = line;
    state = 0;
    count = 0;
    label = "";

    while (*cur == ' ' || *cur == '\t' || *cur == '\n')
	cur++;
    while (*cur)
    {
	while (*cur == ' ' || *cur == '\t' || *cur == '\n')
	    cur++;
 
	switch (state)
	{
	case 0:
	    save = cur ;
            if(!strncmp(cur, "help", 4)) /* help text */
	    {
                fprintf (stdout, "Enter a rule in one of these formats:\n");
                fprintf (stdout, "1 3 5      = 1   poor quality\n");
                fprintf (stdout, "1 thru 10  = 1\n");
                fprintf (stdout, "20 thru 50 = 2   medium quality\n");
                state = 0;
                cur += 4;
                continue;
            }
	    if (!scan_value(&v))
		return -1;
	    state = 1;
	    cur = save;
	    continue;
	case 1:
	    if (*cur == '=')
	    {
		cur++;
		state = 4;
		continue;
	    }
	    if (!scan_value (&v))
		return -1;
	    lo[count] = hi[count] = v;
	    count++;
	    state = 2;
	    continue;
	case 2:
	    state = 1;
	    if (strncmp (cur, "thru", 4) != 0)
		continue;
	    cur += 4;
	    if (*cur != ' ' && *cur != '\t')
		return -1;
	    state = 3;
	    continue;
	case 3:
	    if (!scan_value (&v))
		return -1;
	    if(lo[count-1] > v)
	    {
		hi[count-1] = lo[count-1];
		lo[count-1] = v;
	    }
	    else
		hi[count-1] = v;
	
	    state = 1;
	    continue;
	case 4:
	    if (!scan_value (&v))
		return -1;
	    new = v;
	    state = 5;
	    continue;
	case 5:
	    label = cur;
	    cur = "";	/* force break from while */
	}
    }
    if (state > 0 && state < 5)
	return -1;
    
    for (i = 0; i < count; i++)
    {
	add_rule (tail, lo[i], hi[i], new);
	if (*rules == NULL)
	    *rules = *tail;
	if (*label)
	    G_set_cat (new, label, cats);
    }
    return count;
}
