#define MAIN
#include "gis.h"
#include "raster.h"
#include "display.h"
#include "Vect.h"
#include "Vect.h"
#include "local_proto.h"


int 
main (int argc, char **argv)
{
  struct GModule *module;
  struct Flag *once, *interactive;
  struct Option *opt1, *opt2;
  char *name, *mapset;
  struct Map_info Map;
  struct Categories Cats;
  int level;

  /* Initialize the GIS calls */
  G_gisinit (argv[0]);

  module = G_define_module();
  module->description =
	"Query the category contents of a (binary) vector map layer "
	"at user-selected locations.";
  
  once = G_define_flag ();
  once->key = '1';
  once->description = "Identify just one location";

  interactive = G_define_flag ();
  interactive->key = 'i';
  interactive->description = "Interactive";

  opt1 = G_define_option ();
  opt1->key = "map";
  opt1->type = TYPE_STRING;
  opt1->required = YES;
  opt1->gisprompt = "old,dig,vector";
  opt1->description = "Name of existing vector map";

  opt2 = G_define_option();
  opt2->key = "east_north";
  opt2->type = TYPE_DOUBLE;
  opt2->key_desc = "east,north";
  opt2->multiple = YES;
  opt2->required = NO;
  opt2->description = "Coordinates for query";

  if (G_parser (argc, argv))
    exit (1);

  name = opt1->answer;

  /* Look at maps given on command line */

  mapset = openvect (name);
  if (mapset == NULL)
  {
    fprintf (stderr, "Unable to open %s\n", name);
    exit (1);
  }

  if (interactive->answer)
  {
	R_open_driver ();
	D_setup (0);
  }

  level = Vect_open_old (&Map, name, mapset);
  if (level < 0)
    G_fatal_error ("Can't open vector file");
  ;
  if (level < 2)
    G_fatal_error ("You must first run v.support on vector file");

  if (G_read_vector_cats (name, mapset, &Cats) < 0)
    Cats.num = -1;

  what (opt2->answers, interactive->answer, once->answer, &Map, &Cats);

  if (interactive->answer)  
      R_close_driver ();

  Vect_close (&Map);

  exit (0);
}
