#include <string.h>
#include <stdlib.h>
#include "gis.h"
#include "dlg.h"
#include "graphics.h"
#include "parms.h"
#include "vector.h"
#include "misc.h"
#include "fullwindow.h"
#include "colormode.h"
#include "Paintlib.h"
#include "local_proto.h"

#define MARGIN 2

int map (
    struct Cell_head *window   /* current window */
)
{
    struct Cell_stats statf;
    int next_raster_row;
    int rasrow = 0;
    unsigned char *rasptr;

    char *date;

    int extra_lines;       /* number of raster lines needed
			    * to paint vector info at end of map
			    */
    void *rast; /* buffer for reading cell file */
    CELL *cell; /* buffer for reading cell file */
    void *cptr=NULL;
    void *olcell1;      /* buffers for reading outline cell file        */
    void *olcell2;
    RASTER_MAP_TYPE map_type, outl_map_type;
    int raster_size, outl_raster_size;
    void *tr,*bl=NULL, *br;
    CELL *maskcell;     /* buffer for reading MASK file */

    int prows, pcols;
    int max;		/* max number of printer pixels	*/
    int pixels;
    int npix;		/* # of pixels remaining in panel */
    int row;
    int col;
    int scol;
    int count;

    unsigned char black;    /* black catagory number      */
    unsigned char white;    /* white catagory number      */
    int npanels;  /* number of panels in map    */
    int panel;    /* current panel being printed */
    int i;
    unsigned char *red=NULL, *blu=NULL, *grn=NULL, *set=NULL;
    short *red_carry_below = 0;	/* color carryovers */
    short *grn_carry_below = 0;
    short *blu_carry_below = 0;
    short red_carry_right = 0;
    short grn_carry_right = 0;
    short blu_carry_right = 0;


/************************ begin *****************************/

    outl_map_type = map_type = parms.map_type;
    outl_raster_size = raster_size = G_raster_size(map_type);

/* get date */

    date = G_date();

/* build color tables needed for spreading the color around */
    build_color_tables();
    if (colormode == COLORMODE_DITHER)
	build_dither_tables();

/* Determine max number of pixels
 * allow for a border at left and right edges of panels
 */

    Pnpixels (&prows, &pcols);
    init_graphics (pcols);

    max = pcols;
    max -= MARGIN;

    if (parms.cellfd >= 0)
    {
	red = (unsigned char *)G_malloc (pcols);
	grn = (unsigned char *)G_malloc (pcols);
	blu = (unsigned char *)G_malloc (pcols);
	set = (unsigned char *)G_malloc (pcols);
	if (colormode == COLORMODE_DIFFUSION)
	{
	    red_carry_below = (short *)G_malloc (pcols * sizeof (short));
	    grn_carry_below = (short *)G_malloc (pcols * sizeof (short));
	    blu_carry_below = (short *)G_malloc (pcols * sizeof (short));
	}
    }


    white = WHITE;
    black = BLACK;

    cell = NULL ;
    olcell1 = NULL ;
    olcell2 = NULL ;
    maskcell = NULL ;
    rast = NULL;

/*
 * adjust the window based on the scale
 */

    if (prows)
	unscaled (window, prows-MARGIN, max);
    else
	scale (window, max+MARGIN, MARGIN, parms.scaletext);

    G_set_window (window);
    fullwindow.ns_res = window->ns_res;
    fullwindow.ew_res = window->ew_res;
    fullwindow.rows   = window->rows;
    fullwindow.cols   = window->cols;

/* determine how many panels this map will require */

    npanels = (fullwindow.cols + max - 1) / max;

/*
 * determine the number of raster rows for the vector lines in the legend
 * the lines will drawn at the same width as in the map (plus lines of white
 * before and after)
 */
    extra_lines = 2;
    if (prows == 0)
    {
	for (i=0; i < vector.count; i++)
	    extra_lines += vector_info_lines(i);
    }

/* initialize the stats */
    G_init_cell_stats (&statf);
    if (parms.cellfd >= 0 && parms.need_stats)
    {
       if (verbose) fprintf (stderr, "Gathering map stats ...");
       getcats();
       G_set_quant_rules(parms.cellfd, &(parms.pcats.q));
       cell = G_allocate_cell_buf();
       for (row =0 ; row < fullwindow.rows; row++)
       {
	   if (verbose) G_percent (row, fullwindow.rows, 2);
	   G_get_c_raster_row (parms.cellfd, cell, row);
	   G_update_cell_stats (cell, fullwindow.cols, &statf);
       }
       if (verbose) G_percent (row, fullwindow.rows, 2);
    }

/* begin! */

    G_setup_plot ((double) 0.0,
		  (double) fullwindow.rows,
		  (double) 0.0,
		  (double) fullwindow.cols,
		  move_abs, cont_abs);

/* print each panel */

    npix = fullwindow.cols;
    scol = 0;
    for (panel = 1; panel <= npanels; panel++)
    {
	if (parms.endpanel > 0 && panel > parms.endpanel)
	    break;
	if (verbose > 1)
	    fprintf (stdout,"PAINT: panel %d (of %d)\n", panel, npanels);

/* compute number of pixels in this panel */

	pixels = npix > max ? max : npix;

/* adjust the east of the window for the number of cols */
	window->cols = pixels;
	window->east = window->west + window->ew_res * pixels;

	if (parms.startpanel > 0 && panel < parms.startpanel)
	    goto nextpanel;
	G_set_window (window);
	if (G_window_cols() != pixels) fprintf (stderr, "OOPS: window cols changed!!\n");

	if (cell)
	    free (cell);
	cell = G_allocate_cell_buf ();
	if (maskcell)
	    free (maskcell);
        rast = G_allocate_raster_buf(map_type);
	maskcell = G_allocate_cell_buf ();

	if (parms.outlinefd >= 0)
	{
	    if (olcell1)
		free (olcell1);
	    if (olcell2)
		free (olcell2);
            olcell1 = G_allocate_raster_buf (outl_map_type);
	    olcell2 = G_allocate_raster_buf (outl_map_type);
	    G_get_raster_row (parms.outlinefd, olcell1, 0, outl_map_type);
	}
	if (parms.cellfd >= 0)
	{
	    if (colormode == COLORMODE_DIFFUSION)
	    {
		G_zero (red_carry_below, window->cols * sizeof (short)); 
		G_zero (grn_carry_below, window->cols * sizeof (short)); 
		G_zero (blu_carry_below, window->cols * sizeof (short)); 
	    }
	}

/* put printer in raster mode, define picture */

	Pflush () ;
	Praster ();
	Ppictsize (fullwindow.rows+extra_lines, pixels+MARGIN);
	Pflush () ;

/* one white line to start */
	if (prows == 0)
	{
	    Prle_begin();
	    Prle (white, pixels+MARGIN);
	    Prle_end();
	    Pflush ();
	}

/* some title info */

	if (prows == 0)
	{
	    Palpha ();
	    header (panel, npanels, date);
	    title (parms.celltitle);
	    Praster ();
	    Pflush () ;
	}

/* print top border */

	Prle_begin();
	Prle (black, pixels+MARGIN);
	Prle_end();

/* print each row of the map */

	next_raster_row = -1;
	for (row = 0; row < fullwindow.rows; row++)
	{
	    if (colormode == COLORMODE_DIFFUSION)
	    {
		red_carry_right = 0;
		grn_carry_right = 0;
		blu_carry_right = 0;
	    }

	    if (row >= next_raster_row)	/* must clear raster area */
	    {
		next_raster_row = set_graphics (window, row, scol);

		do_labels (0) ;
		do_vectors (0);
		do_plfile (0);

		mask_vectors (maskcell);

		do_grid();
		do_vectors (1);
		do_plfile (1);
		do_sites();
		if (parms.grid_numbers > 0)
		    do_grid_numbers (panel);
		do_labels (1);

		rasrow = 0 ;
	    }
	    rasptr = graphics.raster[rasrow++] ;

	    if (parms.cellfd >= 0)
	    {
		G_get_raster_row (parms.cellfd, cptr = rast, row, map_type);
		G_lookup_raster_colors(rast, red, grn, blu, set, pixels, &parms.pcolr, map_type);
		if (colormode == COLORMODE_DITHER)
		{
		    red_dither (red, row, /*scol*/ 0, pixels);
		    grn_dither (grn, row, /*scol*/ 0, pixels);
		    blu_dither (blu, row, /*scol*/ 0, pixels);
		}
	    }
	    if (parms.outlinefd >= 0)
	    {
		void *temp;

		temp = olcell1;
		olcell1 = olcell2;
		olcell2 = temp;
		G_get_raster_row (parms.outlinefd, olcell1, row, outl_map_type);
	    }

	    Prle_begin ();
	    Prle (black, 1);	/* left border */

	    col = scol;
	    for (count = 0; count < pixels; count++)
	    {
		unsigned char c;
		unsigned char ras;
		int n,r,g,b;

		c = white;
		if (parms.cellfd >= 0)
		{
		    r = red[count];
		    g = grn[count];
		    b = blu[count];
		    if (colormode == COLORMODE_DIFFUSION)
		    {
			r += red_carry_right + red_carry_below[count];
			g += grn_carry_right + grn_carry_below[count];
			b += blu_carry_right + blu_carry_below[count];
			red_carry_below[count] = red_carry_right = red_carryover(r)/2;
			grn_carry_below[count] = grn_carry_right = grn_carryover(g)/2;
			blu_carry_below[count] = blu_carry_right = blu_carryover(b)/2;
		    }

                    if(map_type == CELL_TYPE)
		    {
		       n = lookup_from_pattern(*((CELL *)cptr),row,col++) ;
		       cptr = G_incr_void_ptr(cptr, raster_size);
                    }
		    else
		       n = -1;
		    if (n < 0)
			n = printer_color_number (r,g,b);
		    c = n;
		}
		if ((ras = *rasptr++))
		    c = ras - 1;
		else if (parms.outlinefd >= 0)
		{
		    if(count)
		    bl = G_incr_void_ptr(olcell2, (count-1) * outl_raster_size);
		    br = G_incr_void_ptr(olcell2, count * outl_raster_size);
		    tr = G_incr_void_ptr(olcell1, count * outl_raster_size);
		    if( G_raster_cmp(tr, br, outl_map_type) != 0)
			c = parms.outline_color;
                    else if(count && G_raster_cmp(bl, br, outl_map_type) != 0)
			c = parms.outline_color;
		}
		Prle (c, 1);
	    }

	    Prle (black, 1);	/* right border */

	    Prle_end () ;
	}

/* print bottom border */

	Prle_begin();
	Prle (black, pixels+MARGIN);
	Prle_end();

/* trailer info */

	if (prows == 0)
	{
	    Pflush () ;
	    Palpha  ();
	    trailer (window, parms.grid, parms.scaletext);

	    vector_info (pixels+MARGIN);

	    Praster ();
	    Pflush () ;
	}

/* a trailing white line */
	if (prows == 0)
	{
	    Prle_begin();
	    Prle (white, pixels+MARGIN);
	    Prle_end();
	}

nextpanel:
	npix -= pixels;
	scol += pixels;
	window->west = window->east;
	Pflush () ;
    }

/* if unscaled, skip what follows */
    if (prows)
    {
	if (verbose > 1)
	    fprintf (stdout,"PAINT: complete\n");
	return 1;
    }

/* do the color table */

    if (parms.with_colortable)
    {
	if (verbose > 1)
	    fprintf (stdout,"PAINT: printing color table\n");
	ctable (&parms.pcats, &parms.pcolr, &statf);
    }

/* comments */
    if (parms.commentfile != NULL)
    {
	FILE *fd;
	char line[1024];

	if (verbose > 1)
	    fprintf (stdout,"PAINT: printing comments\n");

	Palpha ();

	if ((fd = fopen (parms.commentfile, "r")))
	{
	    *line = 0;
	    for (i = 0; i < 100; i++)
		strcat (line,"-");
	    Ptext (line);
	    while (G_getl (line, sizeof line, fd))
		Ptext (line);
	    for (i = 0; i < 5; i++)
		Ptext ("");
	    fclose (fd);
	}
	else
	    error ("comment file","","can't open");
    }
    if (verbose > 1)
	fprintf (stdout,"PAINT: complete\n");

    return 0;
}

static int dump (struct Cell_head *window)
{
    struct Cell_head cur;

    fprintf (stdout,"window----------------\n");
    G__write_Cell_head (stdout, window, 0);
    fprintf (stdout,"cur-------------------\n");
    G_get_set_window (&cur);
    G__write_Cell_head (stdout, &cur, 0);

    return 0;
}
