/* matos.h
 * Copyright (C) 2005 Sylvain Cresto <scresto@gmail.com>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */

#ifndef _G_MATOS_H
#define _G_MATOS_H

extern GSList *Glistdrives;
extern void append_this_drive(Tdriveinfo *Adrive);
extern void free_this_drive(Tdriveinfo *Adrive);
extern void free_drives(gboolean Aremovemanu);
extern void matos_insert_or_update_drive(gchar *Adev, gchar *Amarque, gchar *Amodel, gchar *Aquoi, Tsearchdrive *Adrivedesc);
extern void matos_get_current_matos(gboolean *Areadcd, gboolean *Awritecdr, gboolean *Awritecdrw, gboolean *Areaddvd, gboolean *Awritedvd);
extern Tdriveinfo *find_drive(gchar *Aident);
extern gint get_maxspeed(int Anum);
extern gboolean burn_data(Tgrave *Ag, GError **Aerror);
extern gboolean burn_dvddata(Tgrave *Ag, GError **Aerror);
extern gboolean burn_audio(Tgrave *Ag, GError **Aerror);
extern gboolean burn_copy(Tgrave *Ag, GError **Aerror);
extern gboolean deltempdir(gchar *Ldirpath);
extern void put_devicelabel(Tdriveinfo *Adrive, gchar *Abuf, gint Asizemax);
extern gboolean encours_callback(gpointer Adata);
extern gboolean waiting_for_user(gint Atitle, Tgrave *Ag, GSList *Arequiscd1, gint *Adetectcd1, Tdriveinfo *Ldriveident1);
extern gboolean matos_is_an_iso(Tgrave *Ag, gchar *Aname);
extern Tdriveinfo *matos_get_drive_info(Tgrave *Ag, gchar *Aname);
extern gchar *matos_get_device(Tdriveinfo *Adrive);
extern GSList *manage_mediarequis(GSList *Acurlist, ...);
extern gboolean matos_umount_device(Tdriveinfo *Adrive, GError **Aerror);
extern gboolean matos_maj_drive_info(Tdriveinfo *Adrive, gchar *Adev, GError **Aerror);

#endif

/*
 * vim:et:ts=8:sts=2:sw=2
 */
