/* audio.c
 * Copyright (C) 2004, 2005 Sylvain Cresto <scresto@gmail.com>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */

#include "graveman.h"

gboolean GsupportMp3 = FALSE;
gboolean GsupportOgg = FALSE;
gboolean GsupportFlac = FALSE;

void clear_list_audio(Tgrave *Ag)
{
  GtkTreeView *Lliste = GTK_TREE_VIEW(sc_grave_get_widget(Ag, "LISTEAUDIO"));
  GtkTreeModel *Ltreemodel = gtk_tree_view_get_model(Lliste);
  GtkProgressBar *Lcontenance = GTK_PROGRESS_BAR(sc_grave_get_widget(Ag, "audiolenbar"));
  guint32 *Laudiolen = (guint32 *)sc_grave_get_data(Ag, "audiolen");
  guint32 *Laudiomaxlen = (guint32 *)sc_grave_get_data(Ag, "audiomaxlen");
  (*Laudiolen) = 0;

  gtk_list_store_clear(GTK_LIST_STORE(Ltreemodel));
  gtk_tree_view_columns_autosize(Lliste); 
  switch_pbar_status(Lcontenance, *Laudiomaxlen, *Laudiolen, PB_UPDATE_AUDIO);
}

/* appele pour chaque entree de la liste */
gboolean foreachtracks(GtkTreeModel *Amodel, GtkTreePath *Apath, GtkTreeIter *Aiter, gpointer Adata)
{
  Tgrave *Lg = (Tgrave *) Adata;
  GtkLabel *LTitle = GTK_LABEL(sc_grave_get_data(Lg, "gravetitle"));
  gchar *Ltmpdir = (gchar *) sc_grave_get_data(Lg, "tmpdir");
  gint *Ldone = (gint *) sc_grave_get_data(Lg, "done");  
  gint *Lcont = (gint *) sc_grave_get_data(Lg, "cont");
  GError **Lerreur = (GError **) sc_grave_get_data(Lg, "gerror");  
  
  gboolean Lreturn = FALSE;
  gchar *Lutf8, *Lvers, *Lfichierlcl, *Lfichierutf8, *Lficname;
/*  gchar *Lext; */
  
  *Lcont = 2;
  
  gtk_tree_model_get(Amodel, Aiter, 4, &Lfichierutf8, 5, &Lfichierlcl, -1);
/*  Lext = strrchr(Lfichierlcl, '.');
  g_assert(Lext);
  
  Lext++;*/

  Lficname = strrchr(Lfichierlcl, '/');
  if (Lficname) { Lficname++; } else { Lficname = Lfichierlcl; };

  /* mise a jour label */
  Lutf8 = g_strdup_printf(_("Conversion in progress... %s"), Lfichierutf8);
  gtk_label_set_text(LTitle, Lutf8);
  g_free(Lutf8);

  Lvers = g_strdup_printf("%s/piste_%d.cdr", Ltmpdir, (*Ldone)++);
  
  /* conversion pistes audio en piste cdr pour la gravure */ 
#ifdef ENABLE_FLAC
  if (GsupportFlac && sc_str_has_casesuffix(Lfichierlcl, FLAC)) {
    Lreturn = (FlacToWav(Lg, Lfichierlcl, Lvers, Lerreur) == TRUE ? FALSE : TRUE);
  } else {
#endif  
    Lreturn = (SoundToCdr(Lg, Lfichierlcl, Lvers, Lerreur) == TRUE ? FALSE : TRUE);
#ifdef ENABLE_FLAC
  }
#endif  

  g_free(Lvers);  
  g_free(Lfichierlcl); g_free(Lfichierutf8);

  return Lreturn;
}

gchar *make_audio_fileslist(gint Anbrfiles)
{
  gint i;
  gchar Lunfile[50];
  gchar *Lreturn = NULL;
  gint Lsize = 20 * Anbrfiles;

  Lreturn = (gchar *) g_malloc0(Lsize);
  g_assert(Lreturn);
  if (!Lreturn) return NULL;
  
  for (i=0; i < Anbrfiles; i++) {
    g_snprintf(Lunfile, sizeof(Lunfile)-1, "piste_%d.cdr ", i);
    strncat(Lreturn, Lunfile, Lsize-1);
  }

  return Lreturn;
}
  
gboolean preparetrack(Tgrave *Ag, GError **Aerror) {
  gchar *Ltmpdir = (gchar *)sc_grave_get_data(Ag, "tmpdir");
  gboolean *Labort = (gboolean *)sc_grave_get_data(Ag, "gabort");
  gint *Lcont = (gint *)sc_grave_get_data(Ag, "cont");
  GtkTreeModel *Ltreemodel = gtk_tree_view_get_model(GTK_TREE_VIEW(sc_grave_get_widget(Ag, "LISTEAUDIO")));
  GtkProgressBar *Lprogressbar2 = GTK_PROGRESS_BAR(sc_grave_get_data(Ag, "pb_step"));
  g_assert(GTK_IS_TREE_MODEL(Ltreemodel));

  g_snprintf(Ltmpdir, MAXPATHLEN -1, "%s/%s", conf_get_string_def("tmpdir", "/tmp"), "gravemanXXXXXX");

  if (!mkdtemp(Ltmpdir)) {
    g_set_error(Aerror, G_FILE_ERROR, g_file_error_from_errno(errno), "%s %s: %s",
      _("Cannot create directory"), Ltmpdir, g_strerror(errno));
    *Ltmpdir = 0;
    return FALSE;
  }


  *Lcont = 2;
  g_timeout_add(500, encours_callback, Ag);

  /* conversion de chaques fichiers */
  gtk_tree_model_foreach(Ltreemodel, foreachtracks, Ag);

  /* on attend la fin du timeout */
  *Lcont = 1;
  while (*Lcont > 0) gtk_main_iteration(); 

  gtk_progress_bar_set_fraction(Lprogressbar2, 0);
  gtk_progress_bar_set_text(GTK_PROGRESS_BAR(Lprogressbar2), "0%");

  if (*Labort==TRUE) return FALSE;
  if ((GError *)*Aerror) {
    deltempdir(Ltmpdir);
    *Ltmpdir = 0;
    return FALSE;
  }

  return TRUE;
}

/*
 * vim:et:ts=8:sts=2:sw=2
 */
