/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 

#ifndef __GRDCINITDIALG_H__
#define __GRDCINITDIALG_H__

G_BEGIN_DECLS

#define GRDC_TYPE_INIT_DIALOG               (grdc_init_dialog_get_type ())
#define GRDC_INIT_DIALOG(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRDC_TYPE_INIT_DIALOG, GrdcInitDialog))
#define GRDC_INIT_DIALOG_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GRDC_TYPE_INIT_DIALOG, GrdcInitDialogClass))
#define GRDC_IS_INIT_DIALOG(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRDC_TYPE_INIT_DIALOG))
#define GRDC_IS_INIT_DIALOG_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), GRDC_TYPE_INIT_DIALOG))
#define GRDC_INIT_DIALOG_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GRDC_TYPE_INIT_DIALOG, GrdcInitDialogClass))

enum
{
    GRDC_INIT_MODE_CONNECTING,
    GRDC_INIT_MODE_AUTHPWD
};

typedef struct _GrdcInitDialog
{
    GtkDialog dialog;

    GtkWidget *dialog_content;

    gint mode;

    gchar *title;
    gchar *password;
    gboolean save_password;
} GrdcInitDialog;

typedef struct _GrdcInitDialogClass
{
    GtkDialogClass parent_class;
} GrdcInitDialogClass;

GType grdc_init_dialog_get_type (void) G_GNUC_CONST;

GtkWidget* grdc_init_dialog_new (GtkWindow *parent, const gchar *title_format, ...);
/* Run a password authentication. Return GTK_RESPONSE_OK or GTK_RESPONSE_CANCEL. Caller is blocked. */
gint grdc_init_dialog_authpwd (GrdcInitDialog *dialog);

G_END_DECLS

#endif  /* __GRDCINITDIALG_H__  */

