/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include "grdcpref.h"

const gchar *default_resolutions = "640x480,800x600,1024x768,1152x864,1280x960,1400x1050";

gchar *grdc_pref_file;

GrdcPref grdc_pref;

void
grdc_pref_init (void)
{
    GKeyFile *gkeyfile;

    grdc_pref_file = g_strdup_printf ("%s/.grdc/grdc.pref", g_get_home_dir ());
    gkeyfile = g_key_file_new ();
    g_key_file_load_from_file (gkeyfile, grdc_pref_file, G_KEY_FILE_NONE, NULL);

    if (g_key_file_has_key (gkeyfile, "grdc_pref", "separated_process", NULL))
        grdc_pref.separated_process = g_key_file_get_boolean (gkeyfile, "grdc_pref", "separated_process", NULL);
    else
        grdc_pref.separated_process = FALSE;

    if (g_key_file_has_key (gkeyfile, "grdc_pref", "save_view_mode", NULL))
        grdc_pref.save_view_mode = g_key_file_get_boolean (gkeyfile, "grdc_pref", "save_view_mode", NULL);
    else
        grdc_pref.save_view_mode = TRUE;

    if (g_key_file_has_key (gkeyfile, "grdc_pref", "groups", NULL))
        grdc_pref.groups = g_key_file_get_string (gkeyfile, "grdc_pref", "groups", NULL);
    else
        grdc_pref.groups = NULL;

    if (g_key_file_has_key (gkeyfile, "grdc_pref", "hide_toolbar", NULL))
        grdc_pref.hide_toolbar = g_key_file_get_boolean (gkeyfile, "grdc_pref", "hide_toolbar", NULL);
    else
        grdc_pref.hide_toolbar = FALSE;

    if (g_key_file_has_key (gkeyfile, "grdc_pref", "hide_statusbar", NULL))
        grdc_pref.hide_statusbar = g_key_file_get_boolean (gkeyfile, "grdc_pref", "hide_statusbar", NULL);
    else
        grdc_pref.hide_statusbar = FALSE;

    if (g_key_file_has_key (gkeyfile, "grdc_pref", "small_toolbutton", NULL))
        grdc_pref.small_toolbutton = g_key_file_get_boolean (gkeyfile, "grdc_pref", "small_toolbutton", NULL);
    else
        grdc_pref.small_toolbutton = FALSE;

    if (g_key_file_has_key (gkeyfile, "grdc_pref", "resolutions", NULL))
        grdc_pref.resolutions = g_key_file_get_string (gkeyfile, "grdc_pref", "resolutions", NULL);
    else
        grdc_pref.resolutions = g_strdup (default_resolutions);

    g_key_file_free (gkeyfile);
}

void
grdc_pref_save (void)
{
    GKeyFile *gkeyfile;
    gchar *content;
    gsize length;

    gkeyfile = g_key_file_new ();

    g_key_file_load_from_file (gkeyfile, grdc_pref_file, G_KEY_FILE_NONE, NULL);

    g_key_file_set_boolean (gkeyfile, "grdc_pref", "separated_process", grdc_pref.separated_process);
    g_key_file_set_boolean (gkeyfile, "grdc_pref", "save_view_mode", grdc_pref.save_view_mode);
    g_key_file_set_string (gkeyfile, "grdc_pref", "groups", grdc_pref.groups);
    g_key_file_set_boolean (gkeyfile, "grdc_pref", "hide_toolbar", grdc_pref.hide_toolbar);
    g_key_file_set_boolean (gkeyfile, "grdc_pref", "hide_statusbar", grdc_pref.hide_statusbar);
    g_key_file_set_boolean (gkeyfile, "grdc_pref", "small_toolbutton", grdc_pref.small_toolbutton);
    g_key_file_set_string (gkeyfile, "grdc_pref", "resolutions", grdc_pref.resolutions);

    content = g_key_file_to_data (gkeyfile, &length, NULL);
    g_file_set_contents (grdc_pref_file, content, length, NULL);

    g_key_file_free (gkeyfile);
    g_free (content);
}

