/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include <string.h>
#include "grdcpublic.h"

const gchar *colordepth_list[] =
{
    "8", N_("256 Colors"),
    "15", N_("High Color (15 bit)"),
    "16", N_("High Color (16 bit)"),
    "24", N_("True Color (24 bit)"),
    NULL
};

const gchar *quality_list[] =
{
    "0", N_("Poor (Fastest)"),
    "1", N_("Medium"),
    "2", N_("Good"),
    "9", N_("Best (Slowest)"),
    NULL
};

GtkWidget*
grdc_public_create_combo_text (const gchar **item_list, const gchar *def)
{
    gint i;
    GtkWidget *combo;

    combo = gtk_combo_box_new_text ();
    for (i = 0; item_list[i]; i++)
    {
        gtk_combo_box_append_text (GTK_COMBO_BOX (combo), item_list[i]);
        if (g_strcmp0 (item_list[i], def) == 0)
        {
            gtk_combo_box_set_active (GTK_COMBO_BOX (combo), i);
        }
    }
    return combo;
}

GtkWidget*
grdc_public_create_combo_text_d (const gchar *text, const gchar *def, const gchar *empty_choice)
{
    GtkWidget *combo;
    GtkListStore *store;
    GtkCellRenderer *text_renderer;

    store = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
    combo = gtk_combo_box_new_with_model (GTK_TREE_MODEL(store)); 

    text_renderer = gtk_cell_renderer_text_new (); 
    gtk_cell_layout_pack_end (GTK_CELL_LAYOUT(combo), text_renderer, TRUE); 
    gtk_cell_layout_add_attribute (GTK_CELL_LAYOUT(combo), text_renderer, "text", 1);

    grdc_public_load_combo_text_d (combo, text, def, empty_choice);

    return combo;
}

void
grdc_public_load_combo_text_d (GtkWidget *combo, const gchar *text, const gchar *def, const gchar *empty_choice)
{
    GtkListStore *store;
    GtkTreeIter iter;
    gint i;
    gchar *buf, *ptr1, *ptr2;

    store = GTK_LIST_STORE (gtk_combo_box_get_model (GTK_COMBO_BOX (combo)));
    gtk_list_store_clear (store);

    i = 0;

    if (empty_choice)
    {
        gtk_list_store_append (store, &iter); 
        gtk_list_store_set (store, &iter, 0, "", 1, empty_choice, -1);
        gtk_combo_box_set_active (GTK_COMBO_BOX (combo), i);
        i++;
    }

    buf = g_strdup (text);
    ptr1 = buf;
    while (ptr1 && *ptr1 != '\0')
    {
        ptr2 = strchr (ptr1, STRING_DELIMITOR);
        if (ptr2) *ptr2++ = '\0';

        gtk_list_store_append (store, &iter); 
        gtk_list_store_set (store, &iter, 0, ptr1, 1, ptr1, -1);

        if (g_strcmp0 (ptr1, def) == 0)
        {
            gtk_combo_box_set_active (GTK_COMBO_BOX (combo), i);
        }

        i++;
        ptr1 = ptr2;
    }

    g_free (buf);
}

GtkWidget*
grdc_public_create_combo_map (const gchar **key_value_list, const gchar *def)
{
    int i;
    GtkWidget *combo;
    GtkListStore *store; 
    GtkTreeIter iter; 
    GtkCellRenderer *text_renderer;

    store = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
    combo = gtk_combo_box_new_with_model (GTK_TREE_MODEL(store)); 

    text_renderer = gtk_cell_renderer_text_new (); 
    gtk_cell_layout_pack_end (GTK_CELL_LAYOUT(combo), text_renderer, TRUE); 
    gtk_cell_layout_add_attribute (GTK_CELL_LAYOUT(combo), text_renderer, "text", 1);

    for (i = 0; key_value_list[i]; i += 2)
    {
        gtk_list_store_append (store, &iter); 
        gtk_list_store_set (store, &iter, 0, key_value_list[i], 1, _(key_value_list[i + 1]), -1);
        if (g_strcmp0 (key_value_list[i], def) == 0)
        {
            gtk_combo_box_set_active (GTK_COMBO_BOX (combo), i / 2);
        }
    }
    return combo;
}

void
grdc_public_popup_position (GtkMenu *menu, gint *x, gint *y, gboolean *push_in, gpointer user_data)
{
    GtkWidget *widget;
    gint tx, ty;

    widget = GTK_WIDGET (user_data);
    if (widget->window == NULL)
    {
        *x = 0; *y = 0; *push_in = TRUE; return;
    }
    gdk_window_get_origin (widget->window, &tx, &ty);
    if (GTK_WIDGET_NO_WINDOW (widget))
    {
        tx += widget->allocation.x;
        ty += widget->allocation.y;
    }

    *x = tx;
    *y = ty + widget->allocation.height - 1;
    *push_in = TRUE;
}

