/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 

#ifndef __GRDCCHAINBUTTON_H__
#define __GRDCCHAINBUTTON_H__

G_BEGIN_DECLS

#define GRDC_TYPE_CHAIN_BUTTON               (grdc_chain_button_get_type ())
#define GRDC_CHAIN_BUTTON(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRDC_TYPE_CHAIN_BUTTON, GrdcChainButton))
#define GRDC_CHAIN_BUTTON_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GRDC_TYPE_CHAIN_BUTTON, GrdcChainButtonClass))
#define GRDC_IS_CHAIN_BUTTON(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRDC_TYPE_CHAIN_BUTTON))
#define GRDC_IS_CHAIN_BUTTON_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), GRDC_TYPE_CHAIN_BUTTON))
#define GRDC_CHAIN_BUTTON_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GRDC_TYPE_CHAIN_BUTTON, GrdcChainButtonClass))

typedef struct _GrdcChainButton
{
    GtkTable table;

    gboolean chained;
    GtkWidget *chain_image;
} GrdcChainButton;

typedef struct _GrdcChainButtonClass
{
    GtkTableClass parent_class;

    void (* chain_toggled) (GrdcChainButton *cb);
} GrdcChainButtonClass;

GType grdc_chain_button_get_type (void) G_GNUC_CONST;

GtkWidget* grdc_chain_button_new (void);

void grdc_chain_button_set (GrdcChainButton *cb, gboolean chained);

G_END_DECLS

#endif  /* __GRDCCHAINBUTTON_H__  */

