/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 

#ifndef __GRDCPLUG_H__
#define __GRDCPLUG_H__

#include "grdcinitdialog.h"
#include "grdcfile.h"
#include "grdcssh.h"

G_BEGIN_DECLS

#define GRDC_TYPE_PLUG                  (grdc_plug_get_type ())
#define GRDC_PLUG(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRDC_TYPE_PLUG, GrdcPlug))
#define GRDC_PLUG_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GRDC_TYPE_PLUG, GrdcPlugClass))
#define GRDC_IS_PLUG(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRDC_TYPE_PLUG))
#define GRDC_IS_PLUG_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GRDC_TYPE_PLUG))
#define GRDC_PLUG_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GRDC_TYPE_PLUG, GrdcPlugClass))

#define MAX_ERROR_LENGTH 1000

typedef enum
{
    GRDC_PLUG_FEATURE_PREF,
    GRDC_PLUG_FEATURE_PREF_COLORDEPTH,
    GRDC_PLUG_FEATURE_PREF_QUALITY,
    GRDC_PLUG_FEATURE_PREF_VIEWONLY,
    GRDC_PLUG_FEATURE_PREF_DISABLESERVERINPUT,
    GRDC_PLUG_FEATURE_TOOL,
    GRDC_PLUG_FEATURE_TOOL_CHAT,
    GRDC_PLUG_FEATURE_TOOL_SFTP,
    GRDC_PLUG_FEATURE_TOOL_SSHTERM,
    GRDC_PLUG_FEATURE_UNFOCUS,
    GRDC_PLUG_FEATURE_SCALE
} GrdcPlugFeature;

typedef struct _GrdcPlug
{
    GtkEventBox event_box;

    GtkWidget *init_dialog;

    GrdcFile *grdc_file;

    gint width;
    gint height;
    gboolean scale;

    gboolean has_error;
    gchar error_message[MAX_ERROR_LENGTH + 1];
    GrdcSSHTunnel *ssh_tunnel;

    GtkWidget *sftp_window;

    gboolean closed;
} GrdcPlug;

typedef struct _GrdcPlugClass
{
    GtkEventBoxClass parent_class;

    void (* connect) (GrdcPlug *gp);
    void (* disconnect) (GrdcPlug *gp);
    void (* desktop_resize) (GrdcPlug *gp);

    /* "Virtual" functions have to be implemented in sub-classes */
    gboolean (* open_connection) (GrdcPlug *gp);
    gboolean (* close_connection) (GrdcPlug *gp);
    const gpointer (* query_feature) (GrdcPlug *gp, GrdcPlugFeature feature);
    void (* call_feature) (GrdcPlug *gp, GrdcPlugFeature feature, const gpointer data);
} GrdcPlugClass;

GType grdc_plug_get_type (void) G_GNUC_CONST;

gboolean grdc_plug_open_connection (GrdcPlug *gp, GtkWindow *parent, GrdcFile *grdcfile);
gboolean grdc_plug_close_connection (GrdcPlug *gp);
const gpointer grdc_plug_query_feature (GrdcPlug *gp, GrdcPlugFeature feature);
void grdc_plug_call_feature (GrdcPlug *gp, GrdcPlugFeature feature, const gpointer data);
/* Provide thread-safe way to emit signals */
void grdc_plug_emit_signal (GrdcPlug *gp, const gchar *signal);
/* Start a SSH tunnel if it's enabled. Returns a newly allocated string indicating:
 * 1. The actual destination (host:port) if SSH tunnel is disable
 * 2. The tunnel local destination (127.0.0.1:port) if SSH tunnel is enabled
 */
gchar* grdc_plug_start_tunnel (GrdcPlug *gp, gint default_port);

G_END_DECLS

#endif  /* __GRDCPLUG_H__  */

