/* gretl - The Gnu Regression, Econometrics and Time-series Library
 * Copyright (C) 1999-2000 Ramu Ramanathan and Allin Cottrell
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this software; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* texprint.h for gretl */

/* functions follow */

int tex_print_equation (const MODEL *pmod, const DATAINFO *pdinfo, 
			const int standalone, PRN *prn);

int tex_print_model (MODEL *pmod, const DATAINFO *pdinfo, 
		     const int standalone, PRN *prn);

int tex_print_coeff (const DATAINFO *pdinfo, const MODEL *pmod, 
		      int c, PRN *prn);

int tabprint (MODEL *pmod, const DATAINFO *pdinfo,
	      char *texfile, gretlopt oflag);

int eqnprint (MODEL *pmod, const DATAINFO *pdinfo,
	      char *texfile, gretlopt oflag);

char *tex_escape (char *targ, const char *src);

void tex_dcolumn_double (double xx, char *numstr);

void set_gretl_tex_preamble (void);

void gretl_tex_preamble (PRN *prn, int ams);



