@new-style gretl.hlp

# add Contrastes "Aadir variables"

Las variables elegidas se aaden al modelo anterior y se estima el nuevo
modelo. Si se aade ms de una variable, se mostrar el estadstico F para
las variable aadidas (Slo para el mtodo MCO) y su valor p. Un valor p
inferior a 0.05 indica que los coeficientes son conjuntamente significativos
al nivel del 5 por ciento.

Instruccin de guin: add

# adf Contrastes "Contraste aumentado de Dickey-Fuller"

Esta instruccin nrequiere un orden de retardos entero.

Calcula los estadsticos para dos contrastes de Dickey-Fuller. En cada caso
la hiptesis nula es que la variable seleccionada presenta una raz
unitaria. El primero es un estadstico t basado en el modelo

  (1 - L)x(t) = m + gx(t-1) + e(t)

La hiptesis nula es que g = 0. En el segundo contraste (aumentado) se
realiza la estimacin de una regresin no retringida (cuyos regresores son
una constante, una tendencia temporal, el primer retardo de la variable y
"orden" retardos de la primera diferencia) y una versin restringida
(quitando la tendencia temporal y el primer retardo). El estadstico de
contraste es

  F(2, T-k) = [(ESSr - ESSu)/2] / [ESSu/(T - k)]

donde T es el tamao de la muestra, k el nmero de parmetros del modelo no
restringido, y los subndices u y r denotan el modelo no restringido y el
restringido respectivamente. Hay que sealar que los valores crticos para
estos estadsticos no son los habituales; se muestra el valor p cuando es
posible determinarlo.

Instruccin de guin: adf

# ar Estimacin "Estimacin autorregresiva"

Computa las estimaciones de los parmetros usando el procedimiento iterativo
generalizado de Cochrane-Orcutt (ver Seccin 9.5 del libro de Ramanathan).
Las iteraciones terminan cuando dos sumas de cuadrados residuales sucesivas
no difieren en ms del 0.005 por ciento o despus de 20 iteraciones.

La "lista de retardos AR" especifica la estructura de la perturbacin. Por
ejemplo, la entrada "1 3 4" corresponde al proceso:

  u(t) = rho1*u(t-1) + rho3*u(t-3) + rho4*u(t-4)

Instruccin de guin: ar

# arch Contrastes "Contraste ARCH"

Estainstruccin requiere un nmero de retardos entero.

Contrasta la existencia de ARCH (Autoregressive Conditional
Heteroskedasticity -- Heterocedasticidad condicional autorregresiva) del
orden especificado, en el modelo. Si el estadstico de contraste LM tiene un
valor p inferior a 0.10, entonces tambin se realiza la estimacin del
modelo ARCH. Si la prediccin de la varianza de cualquier observacin, en la
regresin auxiliar, no es positiva entonces se usa en su lugar el
correspondiente residuo al cuadrado. Despus se realiza una estimacin por
mnimos cuadrados ponderados sobre el modelo original.

Ver tambin "garch".

Instruccin de guin: arch

# arma Estimacin "Modelo ARMA"

Cuando se elige desde el men de Variable, estima un modelo ARMA
(Autoregressive, Moving Average). Cuando se elige desde el men de Modelo
("ARMAX"), estima un modelo ARMAX, es decir, con regresores exgenos
adicionales.

Por defecto se usa la funcin "nativa" ARMA de gretl; en el caso de un
modelo ARMA univariante se puede usar X-12-ARIMA en su lugar (si est
instalado el paquete X-12-ARIMA para gretl).

El algoritmo ARMA nativo de gretl ha sido, en su mayor parte, creado por
Riccardo "Jack" Lucchetti. Utiliza un procedimiento de mxima verosimilitud
condicional, implementado por medio de la estimacin por mnimos cuadrados
iterativos de la regresin del producto externo del gradiente (OPG, outer
product of the gradient regression). Ver el manual de gretl para entender la
lgica de este procedimiento. Los coeficientes AR (y los de cualquier
regresor adicional) se inicializan por medio de la estimacin por MCO de un
AR, y los coeficientes MA se inicializan asignndoles valor cero.

El valor del coeficiente AIC para los modelos ARMA se calcula de acuerdo con
la definicin usada en el programa X-12-ARIMA, es decir

  AIC = -2L + 2k

donde L es la log-verosimilitud y k es el nmero total de parmetros
estimados. La "frecuencia" que se presenta asociada a las races AR y MA es
el valor lambda que soluciona

  z = r * exp(i*2*pi*lambda)

donde z es la raz en cuestin y r es su mdulo.

Instruccin de guin: arma

# boxplot Grficos "Grficos de caja"

Estos grficos (debidos a Tukey y Chambers) muestran la distribucin de una
variable. La caja central recoge el 50 por ciento intermedio de los datos,
es decir, est acotada por el primero y tercer cuartiles. Las "patillas" se
extienden hasta los valores mnimo y mximo. Se dibuja una lnea a lo largo
de la caja en el lugar de la mediana.

En el caso de grficos de caja recortados, el recorte muestra los lmites de
un intervalo de aproximadamente el 90 por ciento de confianza para la
mediana. Este intervalo se obtienen por el mtodo bootstrap.

Despus de cada variable especificada en la instruccin boxplot, se puede
aadir una expresin booleana entre parntesis para limitar la muestra para
la variable en cuestin. Debe de insertarse un espacio entre el nombre o
nmero de la variable y la expresin. Supongamos que usted tiene valores de
los salarios de hombres y mujeres, y tiene una variable ficticia SEXO con
valor 1 para los hombres y 0 para las mujeres. En este caso usted puede
dibujar grficos de caja comparativos usando la siguiente lnea en el cuadro
de dilogo de los grficos de caja:

	salary (GENDER=1) salary (GENDER=0)

Algunos detalles de los grficos de caja de gretl pueden controlarse por
medio de un fichero (de texto plano) llamado .boxplotrc. Para ms detalles
sobre esto ver el manual de gretl.

Instruccin de guin: boxplot

# chow Contrastes "Contraste de Chow"

Esta instruccin requiere un nmero de observaciones (o fecha, en el caso de
datos con fechas).

Primero debe ejecutarse una regresin por MCO. Crea una variable ficticia
que es igual a 1 desde el punto de corte especificado en obs hasta el final
de la muestra y 0 en el resto. Tambin crea los trminos de interaccin
entre esta variable ficticia y las variables independientes originales. Se
ejecuta una regresin aumentada incluyendo estos trminos y se calcula un
estadstico F, tomando la regresin aumentada como 'no restringida' y la
original como 'restringida'. Este estadstico es adecuado para contrastar la
hiptesis nula de que no hay cambio estructural en el punto de ruptura
indicado.

Instruccin de guin: chow

# coeffsum Contrastes "Suma de coeficientes"

Esta instruccin requiere una lista de variables, que se elige a partir del
conjunto de variables independientes de un modelo dado.

Calcula la suma de los coeficientes de las variables de la lista
especificada. Presenta la suma junto con su desviacin tpica y el valor p
para la hiptesis nula de que la suma es cero.

Hay que sealar la diferencia entre esta instruccin y "omit", que contrasta
la hiptesis nula de que los coeficientes de un subconjunto de variables
independientes son todos iguales a cero zero.

Instruccin de guin: coeffsum

# coint Contrastes "Contraste de cointegracin de Engle-Granger"

Contraste de cointegracin de Engle-Granger. Esta instruccin realiza los
contrastes de Dickey-Fuller aumentados de la hiptesis nula de que cada una
de las variables de la lista tiene una raz unitaria, usando el orden de
retardos dado. Se estima la ecuacin cointegrante y se realiza un contraste
ADF sobre los residuos de esta regresin. Tambin se presenta el estadstico
de Durbin-Watson para la regresin cointegrante. Hay que sealar que ninguno
de estos estadsticos de contraste puede compararse con las tablas
estadsticas usuales.

Instruccin de guin: coint

# coint2 Contrastes "Contraste de cointegracin de Johansen"

Realiza el contraste de la traza de Johansen para contrastar cointegracin
entre las variables de la lista para el orden dado. Los valores crticos se
computan por medio de la aproximacin gamma de J. Doornik (Doornik, 1998).
Para detalles sobre este contraste ver el libro de Hamilton, Time Series
Analysis (1994), Captulo 20.

Se presenta aqu la siguiente tabla como gua para la interpretacin de los
resultados ofrecidos por el contraste, para el caso de 3 variables. H0
denota la hiptesis nula, H1 la hiptesis alternativa y c el nmero de
relaciones cointegrantes.

            Rango   Contraste de la traza     Contraste Lmax 
                          H0     H1              H0     H1
             ---------------------------------------------------
              0          c = 0  c = 3          c = 0  c = 1
              1          c = 1  c = 3          c = 1  c = 2
              2          c = 2  c = 3          c = 2  c = 3
             ---------------------------------------------------

Instruccin de guin: coint2

# compact Conjunto de datos "Compactar datos"

Cuando usted aade a un conjunto de datos una serie que es de una frecuencia
mayor, es necesario "compactar" la nueva serie. Por ejemplo, ser necesario
compactar una serie mensual para encajarla en un conjunto de datos
trimestral.

Adems, es posible que alguna vez usted desee compactar un conjunto de datos
completo para transformarlo en datos de frecuencia ms baja (por ejemplo,
antes de aadir al conjunto de datos una variable de frecuencia inferior).

Gretl ofrece cuatro opciones de compactado:

  Promediar: el valor que se escribe en el conjunto de datos ser la media
  aritmtica de los valores relevantes de la serie. Por ejemplo, el valor
  poara el primer trimestre de 1990 ser la media de los valores de Enero,
  Febrero y Marzo de 1990.

  Sumar: el valor que se escribe en el conjunto de datos ser la suma de los
  valores de frecuencia mayor relevantes. Por ejemplo, el valor del primer
  trimestre ser la suma de los valores de Enero, Febrero y Marzo.

  Asignar valores de final del periodo: el valor que se escribe en el
  conjunto de datos es el ltimo valor relevante de los datos de frecuencia
  mayor. Por ejemplo, el valor del primer trimestre de 1990 sera el valor
  de Marzo de 1990.

  Asignar valores de inicio del periodo: el valor escrito en el conjunto de
  datos es el primer valor relevante de los datos de frecuencia mayor. Por
  ejemplo, al primer trimestre de 1990 se le asignara el valor de Enero de
  1990.

Cuando se compacta un conjunto de datos completo, la eleccin que usted
efecta en esta caja de dilogo establece el mtodo por defecto. Pero si
usted ha establecido un mtodo de compactado para una variable individual
(elemento de men "Variable/Editar atributos") se usa ese mtodo en lugar
del mtodo por defecto. Si ya est establecido el mtodo de compactado para
todas las variables, no se presenta aqu la eleccin de un mtodo de
compactado por defecto.

# corc Estimacin "Procedimiento de Cochrane-Orcutt"

Computa estimaciones de los parmetros usando el procedimiento iterativo de
Cochrane-Orcutt (ver Seccin 9.4 del libro de Ramanathan). Las iteraciones
finalizan cuando dos estimaciones sucesivas del coeficiente de
autocorrelacin no difieren en ms de 0,001 o despus de 20 iteraciones.

Instruccin de guin: corc

# corrgm Estadstica "Correlograma"

Presenta los valores de la funcin de autocorrelacin para la variable
especificada (por nombre o por nmero). Ver Ramanathan, Seccin 11.7. Es por
tanto rho(u(t), u(t-s)) donde ut es la t-sima observacin de la variable u
y s es el nmero de retardos.

Tambin se presentan las autocorrelaciones parciales, siendo stas los
coeficientes una vez descontado el efecto de los dems retardos
intervinientes. Esta instruccin tambin representa el correlograma y
muestra el estadstico Q de Box-Pierce para el contraste de la hiptesis
nula de que la serie es "ruido blanco". Este se distribuye asintticamente
como una chi-cuadrado con grados de libertad igual al nmero de retardos
utilizados.

Si se especifica un valor para retardo_max entonces el tamao del
correlograma se limita como mximo a ese nmero de retardos, en los dems
casos se determina automticamente.

Instruccin de guin: corrgm

# cusum Contrastes "Contraste CUSUM"

Debe realizarse despus de la estimacin de un modelo por MCO. Realiza el
contraste CUSUM de estabilidad de los parmetros. Se obtiene una serie de
errores de predicin (escalados) un perodo hacia adelante al ejecutar una
serie de regresiones: la primera regresin utiliza las primeras k
observaciones y se usa para generar una prediccin de la variable
dependiente en la observacin k + 1; la segunda utiliza las primeras k + 1
observaciones y genera una prediccin para la observacin k + 2, y as
sucesivamente (donde k es el nmero de parmetros en el modelo original). Se
muestra y se representa graicamente la suma acumulada de los errores de
prediccin escalados. La hiptesis nula de estabilidad en los parmetros se
rechaza al nivel de significacin del 5 por ciento si la suma acumulada se
sale de la banda de 95 por ciento de confianza.

Tambin se presenta el estadstico t de Harvey-Collier para contrastar la
hiptesis nula de estabilidad de los parmetros. Para ms detalles ver
Captulo 7 del libro de Greene Econometric Analysis.

Instruccin de guin: cusum

# dialog Estimacin "Caja de dilogo de Modelo"

Para seleccionar la variable dependiente, marque una variable en la lista de
la izquierda y presione el botn "Elegir->" que apunta a la zona de
definicin de la variable dependiente. Si usted marca el cuadrado "Seleccin
por defecto", la variable indicada ser preseleccionada como variable
dependiente cuando se vuelva a abrir de nuevo la caja de dilogo de Modelo.
Atajo: haga doble click sobre una variable de la izquierda para
seleccionarla como variable dependiente y establcerla as por defecto.

Para seleccionar las variables independientes mrquelas a la izquierda y
presione el botn "Aadir->" (o haga click con el botn derecho del ratn).
Usted puede marcar varias variables contguas manteniendo pulsado el botn
izquierdo del ratn y desplazndolo. Puede marcar un grupo de variables no
contguas haciendo click sobre ellas al mismo tiempo que pulsa la tecla
Ctrl.

# export Conjunto de datos "Exportar datos"

Se pueden exportar los datos en formato CSV (Comma-Separated Values): estos
datos pueden abrirse desde programas de hoja de clculos y muchos otros
programas de aplicaciones.

Tambin se pueden exportar los datos en los formatos nativos de GNU R o GNU
octave. Para ms informacin sobre estos programas (que ambos soportan
anlisis estadsticos avanzados) vea por favor sus respectivos sitios web,
http://www.r-project.org/ y http://www.octave.org/

# factorized Grficos "Grfico con factor de separacin"

Esta orden requiere la seleccin de tres variables, de las cuales la ltima
debe ser una variable ficticia (con valores 1 o 0). La variable Y se
representa con respecto a la variable X, con los puntos de datos coloreados
de manera diferente dependiendo del valor de la tercera variable.

Ejemplo: suponga que tenemos datos sobre salarios y nivel de educacin para
una muestra de varias personas, tambin tenemos una variable ficticia con
valor 1 para los hombres y 0 para las mujeres (como en el fichero de
Ramanathan data7-2). Un grfico "con factor de separacin" de SALARIO con
respecto a EDUCACION usando la variable ficticia SEXO como factor, mostrar
los puntos de datos para los hombres de un color y los de las mujeres de
otro (con una leyenda para poder identificarlos).

# fcasterr Prediccin "Predicciones con intervalos de confianza"

Despus de estimar un modelo por medio de MCO usted puede usar esta
instruccin para mostrar los valores ajustados para el rango de
observaciones determinado, las desviaciones tpicas de estos valores
ajustados y los intervalos de confianza del 95 por ciento.

Las desviaciones tpicas se calculan de la forma descrita en el Captulo 6
del libro de Wooldridge Introductory Econometrics. Estas tienen en cuenta
dos fuentes de variabilidad: la asociada al valor esperado de la variable
dependiente condicionado a los valores dados de las variables
independientes, y la varianza de los residuos de la regresin.

Instruccin de guin: fcasterr

# garch Estimacin "Modelo GARCH"

Estima un modelo GARCH (GARCH = Generalized Autoregressive Conditional
Heteroskedasticity), o un modelo univariante o, si se seleccionan variables
independientes, un modelo que incluye stas como variables exgenas. La
ecuacin de la varianza condicional se muestra a continuacin.

  h(t) = sum(i=1 to q) a(i)*u(t-i) +  sum(j=1 to p) b(j)*h(t-j)

El algoritmo GARCH de gretl es bsicamente el de Fiorentini, Calzolari y
Panattoni (1996), y se usa con el amable permiso del profesor Fiorentini.

Con esta instruccin estn disponibles varias variantes de las estimaciones
de la matriz de covarianzas de los coeficientes. Por defecto se usa el
Hessiano a no ser que se marque el cuadrado "Desviaciones tpicas robustas",
en cuyo caso se utiliza la matriz de covarianzas QML (White). Se pueden
especificar otras posibilidades (p.ej. la matriz de informacin, o el
estimador Bollerslev-Wooldridge) usando la instruccin "set".

Instruccin de guin: garch

# genr Conjunto de datos "Generar una variable nueva"

Crea variables nuevas, normalmente como transformaciones de variables ya
existentes. Ver tambin "diff", "logs", "lags", "ldiff", "multiply" y
"square" como atajos.

Los operadores aritmticos soportados son, en orden de precedencia: ^
(exponenciacin); *, / y % (mdulo o resto); + y -.

Los operadores Booleanos disponibles son (de nuevo, en orden de
precedencia): ! (negacin), & (Y lgico), | (O lgico), >, <, =, >= (mayor o
igual que), <= (menor o igual que) y != (distinto que). Se pueden usar
operadores Booleanos para construir variables ficticias: por ejemplo (x >
10) devuelve 1 si x > 10, y 0 en otro caso.

Las funciones se clasifican en:

  Funcione matemticas estndar: abs, cos, exp, int (parte entera), ln
  (logaritmo natural: log es un sinnimo), sin, sqrt.

  Funciones estadsticas: max (valor mximo de una serie), min (mnimo),
  mean (media aritmtica), median, var (varianza) sd (desviacin tpica),
  sst (suma de desviaciones desde la media, al cuadrado), sum, cov
  (covarianza), corr (coeficiente de correlacin), pvalue, sort, cum
  (acumulacin, o suma secuencial), resample (remuestrear una serie con
  reemplazamiento, con el propsito de hacer bootstrap), hpfilt (Filtro de
  Hodrick-Prescott: esta funcin devuelve el "componente cclico" de la
  serie).

  Funciones de series temporales: diff (primera diferencia), ldiff
  (diferencia logartmica, o primera diferencia del logaritmo natural). Para
  generar retardos de una variable x, se usa la sintaxis "x(-N)", donde N
  representa la longitud deseada del retardo; para generar adelantos, se usa
  "x(+N)".

  Funciones de conjunto de datos: misszero (reemplaza los cdigos de
  observacin ausente de una serie dada con ceros); zeromiss (la operacin
  inversa a misszero); nobs (devuelve el nmero de observaciones vlidas de
  una serie de datos determinada), missing (para cada observacin, devuelve
  1 si el argumento tiene una observacin ausente, y 0 en caso contrario);
  ok (el opuesto de missing).

  Nmeros pseudo-aleatorios: uniform, normal.

Todas las funciones de arriba excepto cov, corr, pvalue, uniform y normal
toman como nico argumento o el nombre de una variable (ntese que, en una
frmula "genr", no es posible referirse a las variables por su nmero de ID)
o una expresin que se evala en una variable (p.ej. ln((x1+x2)/2)). cov y
corr requieren dos argumentos, y devuelven respectivamente la covarianza y
el coeficiente de correlacin entre sus argumentos. La funcin pvalue toma
los mismos argumentos que la instruccin "pvalue", pero en este contexto
deben introducirse comas entre los argumentos. Esta funcin devuelve un
valor p a una cola y, en el caso de las distribuciones normal y t, es para
la "cola corta". Con la normal, por ejemplo, tanto 1,96 como -1,96 darn un
resultado de aproximadamente 0,025.

uniform() y normal(), que no toman arguamentos, devuelven series de nmeros
pseudo-aleatorios extrados de la distribucin uniforme (0-1) y normal
estndar respectivamente (ver tambin la instruccin "set", opcin seed). La
series de datos uniformes se generan utilizando el Mersenne Twister; para
series normales se usa el mtodo de Box y Muller (1958), tomando la entrada
del Mersenne Twister.

Adems de los operadores y funciones ya mencionados, hay algunos usos
especiales de "genr":

  "genr time" crea una variable de tendencia temporal (1,2,3,...) llamada
  "time". "genr index" hace lo mismo, excepto que ahora la variable se
  denomina index.

  "genr dummy" crea variables ficticias hasta la periodicidad de los datos.
  P.ej. en el caso de datos trimestrales (periodicidad 4), el programa crea
  dummy_1 = 1 para el primer trimestre y 0 en los dems trimestres, dummy_2
  = 1 para el segundo trimestre y 0 en los dems, y as sucesivamente.

  "genr paneldum" crea un conjunto de variables ficticias especiales para
  ser usadas con un conjunto de datos de panel -- ver "panel".

  Usando "genr" se pueden recuperar los valores de algunas variables
  internas que se definen al ejecutar una regresin, de la siguiente foprma:

  $ess         suma de cuadrados de los residuos
  $rsq         R-cuadrado no corregido
  $T           nmero de observaciones usadas
  $df          grados de libertad
  $trsq        TR-cuadrado (el tamao muestral por el R-cuadrado)
  $sigma       desviacin tpica de los residuos
  $aic         Criterio de informacin de Akaike
  $lnl         logaritmo de la verosimilitud (donde es aplicable)
  coeff(var)   coeficiente estimado para la variable var
  stderr(var)  desviacin tpica estimada para la variable var 
  rho(i)       coeficiente autorregresivo de i-simo orden de los residuos
  vcv(x1,x2)   covarianza entre los coeficientes para las variables nombradas 
               x1 y x2 

Nota: En el programa en lnea de instrucciones, las instrucciones "genr" que
recuperan datos relativos a un modelo siempre hacen referencia al ltimo
modelo estimado. Esto tambin es cierto para el programa en modo GUI, si uno
usa "genr" en la "consola de gretl" o introduce una frmula usando la opcin
"Definir nueva variable" del men de Variable en la ventana principal. Sin
embargo, con el GUI, usted tiene la posibilidad de recuperar datos de
cualquier modelo que actualmente se est mostrando en una ventana (sea o no
el modelo ms reciente). Usted puede hacer esto bajo el men "Datos del
Modelo" de la ventana del modelo.

Las series internas uhat e yhat contienen, respectivamente, los residuos y
los valores ajustados de la ltima regresin.

Tambin estn disponibles dos variables "internas" relacionadas con el
conjunto de datos actual: $nobs contiene el nmero de observaciones del
rango muestral actual (que puede ser o no igual a $T, el nmero de
observaciones usadas al estimar el ltimo modelo), y $pd contiene la
frecuencia o periodicidad de los datos (p.ej 4 para datos trimestrales).

La variable t sirve como ndice de las observaciones. Por ejemplo genr dum =
(t=15) generar una variable ficticia que toma valor 1 para la observacin
15, y 0 en las dems. La variable obs es similar pero ms flexible: usted
puede usarla para extraer observaciones particulares por fecha o nombre. Por
ejemplo, genr d = (obs>1986:4) o genr d = (obs="CA"). La ltima forma
presupone que las observaciones tienen etiquetas; la etiqueta debe ponerse
entre comillas.

Pueden utilizarse valores escalares de una serie en el contexto de una
frmula genr, usando la sintaxis nombre_var[obs]. El valor obs puede darse
por nmero o fecha. Ejemplos: x[5], CPI[1996:01]. Para datos diarios data,
se debe de usar la forma YYYY:MM:DD, p.ej. ibm[1970:01:23].

Se puede modificar una observacin individual de una serie por medio de
genr. Para hacerlo, hay que adjuntar al nombre de la variable en el lado
izquierdo de la frmula, entre corchetes, un nmero de observacin vlido o
una fecha. Por ejemplo, genr x[3] = 30 o genr x[1950:04] = 303.7.

La tabla de abajo da varios ejemplos de utilizaciones de "genr" con notas
explicativas; aqu hay un par de sugerencias sobre variable ficticias:

  Supongamos que x est codificada con los valores 1, 2, o 3 y usted quiere
  tres variables ficticias, d1 = 1 si x = 1, 0 en otro caso, d2 = 1 si x =
  2, y as sucesivamente. Para crearlas, use las instrucciones:

	    genr d1 = (x=1)
	    genr d2 = (x=2)
	    genr d3 = (x=3)

  Para crear z = max(x,y) do

	    genr d = x>y
	    genr z = (x*d)+(y*(1-d))

  Frmula               Comentario
  -------               -------
  y = x1^3              x1 al cubo
  y = ln((x1+x2)/x3)    
  z = x>y               z(t) = 1 si x(t) > y(t), en otro caso 0
  y = x(-2)             x retardada 2 periodos
  y = x(2)              x adelantada 2 periodos
  y = diff(x)           y(t) = x(t) - x(t-1)
  y = ldiff(x)          y(t) = log x(t) - log x(t-1), la tasa de crecimiento 
                        instantnea de x
  y = sort(x)           ordena x en orden creciente y lo guarda en y
  y = -sort(-x)         ordena x en orden decreciente
  y = int(x)            trunca x y guarda su valor entero como y
  y = abs(x)            guarda los valores absolutos de x
  y = sum(x)            suma los valores de x excluyendo los valores ausentes, 
                        con entradas -999
  y = cum(x)            acumulacin: y(t) = la suma desde s=1 hasta s=t de 
                        x(s) 
  aa = $ess             hace aa igual a la suma de cuadrados de los residuos 
                        de la ltima regresin
  x = coeff(sqft)       guarda el coeficiente estimado de la variable sqft de 
                        la ltima regresin
  rho4 = rho(4)         guarda el coeficiente autorregresivo de 4 orden del 
                        ltimo modelo (supone un modelo ar)
  cvx1x2 = vcv(x1, x2)  guarda la covarianza de los coeficientes estimados de 
                        las variables x1 y x2 del ltimo modelo
  foo = uniform()       variable pseudo-aleatoria uniforme en el rango 0-1
  bar = 3 * normal()    variable pseudo-aleatoria normal, mu = 0, sigma = 3
  samp = !missing(x)    = 1 para las observaciones en las que no hay valores 
                        ausentes de x.

Instruccin de guin: genr

# graphing Grficos "Graphing"

Gretl llama a un programa aparte, gnuplot, para generar los grficos.
Gnuplot es un programa con muchas caractersticas y miles de opciones. Gretl
le proporciona acceso directo, por medio de un interfaz grfico, a un
subconjunto de esas opciones e intenta elegir los valores adecuados por
usted; tambin le permite tomar completamente el control sobre el grfico,
si usted lo desea.

Cuando se est mostrando un grfico, usted puede hacer click sobre la
ventana del grfico para que aparezca un men emergente con las siguientes
opciones:

  Guardar como postscript: guarda el grfico en formato postscript
  encapsulado (EPS)

  Guardar como PNG: lo guarda en formato PNG (Portable Network Graphics)

  Guardar a sesin como icono: el grfico aparecer como un icono cuando
  usted seleccione "Vista de iconos" desde el men de sesin

  Zoom: le permite seleccionar un rea dentro del grfico para verla con ms
  detalle

  Imprimir: (slo en el escritorio Gnome de Linux y en MS Windows) le
  permite imprimir el grfico directamente

  Copiar al portapapeles: (slo en MS Windows) le permite pegar el grfico
  en aplicaciones Windows tales como MS Word

  Editar: abre un controlador para el grfico que le permite ajustar varios
  aspectos de su apariencia

  Cerrar: cierra la ventana del grfico

Si Vd. conoce gnuplot y desea tener un control ms detallado sobre la
apariencia de un grfico que el que est disponible por medio del
controlador grfico (opcin "Editar" option), usted tiene dos opciones:

  Una vez que el grfico se ha guardado como un icono de sesin, usted puede
  hacer click con el botn derecho del ratn para que aparezca un nuevo men
  emergente. Una de las opciones aqu es "Editar las instrucciones del
  graficos", lo cual abre una ventana de edicin que contiene las
  instrucciones actuales de gnuplot. Vd. puede editar esas instrucciones y
  guardarlas para un procesado futuro o enviarlas a gnuplot (con el elemento
  de men "Archivo/Enviar a gnuplot" en la ventana de edicin de
  instrucciones de gnuplot).

  Otra manera de guardar las instrucciones del grfico (o guardar el grfico
  representado en formatos distintos de EPS o PNG) es usar el elemento
  "Editar" del men emergente del grfico para invocar al controlador
  grfico, despus hacer click sobre la solapa "Salida a fichero" en el
  controlador. Entonces se le presenta un men con varios formatos en los
  que guardar el grfico.

Para conocer ms sobre gnuplot, ver http://ricardo.ecn.wfu.edu/gnuplot.html
o http://www.gnuplot.info

# graphpag Grficos "Pgina de grficos de Gretl"

La "pgina de grficos" en la ventana de sesin slo funcionar si Vd. tiene
el sistema de proceso de textos LaTeX instalado, y es capaz de generar y ver
una salida postscript.

En la ventana de iconos de sesin, Vd. puede arrastrar hasta ocho grficos
al icono de pgina de grficos. Cuando usted hace doble click sobre la
pgina de grficos (o click con el botn derecho y selecciona "Mostrar"), se
formar una pgina con los grficos elegidos y se abrir con su visualizador
de postscript. Desde all usted podr imprimir la pgina.

Para vaciar la pgina de grficos, pulse con el botn derecho sobre su icono
y seleccione "Vaciar".

En sistemas diferentes de MS Windows, es posible que usted tenga que ajustar
las preferencias de gretl para seleccionar el programa que usa para ver
ficheros postscript. Puede encontrarlas bajo la solapa "Programas" en la
caja de dilogo de preferencias de gretl (bajo el men Archivo en la ventana
principal).

# 3-D Grficos "Grficos tridimensionales"

Este servicio funciona mejor si usted tiene instalado gnuplot 3.8 o
superior. En ese caso Vd. puede manipular el grfico tridimensional con el
ratn (rotarlo y expandir o contraer los ejes).

Al formar un grfico 3-D, ntese que se representar como eje vertical el
eje Z. As que si usted tiene alguna variable dependiente que cree puede
verse influda por dos variables independientes, debera poner la variable
dependiente en el eje Z y las variables independientes sobre los ejes X e Y.

Al contrario que en la mayora de los dems grficos de gretl, los grficos
tridimensionales los controla gnuplot en lugar del propio gretl. As que el
men de edicin de grficos de gretl no est disponible.

# hausman Contrastes "Contraste de Hausman (diagnsticos de panel)"

Este contraste slo est disponible despus de haber estimado un modelo
mediante la instruccin "pooled" (ver tambin "panel" y "setobs"). Contrasta
el modelo simple combinado contra sus alternativas principales, el modelo de
efectos fijos y el modelo de efectos aleatorios.

El modelo de efectos fijos aade una variable ficticia para todas menos una
de las unidades de seccin cruzada, permitiendo al intercepto de la
regresin variar a travs de estas unidades. Se presenta un estadstico F
para el contraste de significacin conjunta de estas variables ficticias. El
modelo de efectos aleatorios descompone la varianza residual en dos partes,
una parte especfica de las unidades de seccin cruzada y la otra especfica
de cada observacin particular. (Este estimador slo puede computarse si el
nmero de unidades de seccin cruzada es mayor que el nmero de parmetros a
estimar.) El estadstico LM de Breusch-Pagan sirve para contrastar la
hiptesis nula (de que el estimador MCO combinado es el adecuado) contra la
alternativa de efectos aleatorios.

El modelo de MCO combinados puede ser rechazado contra ambas alternativas,
el modelo de efectos fijos y el de efectos aleatorios. Si el error
especfico de unidad o grupo est incorrelacionado con las variables
independientes, el estimador de efectos aleatorios es ms eficiente que el
estimador de efectos fijos; en caso contrario el estimador de efectos
aleatorios sera inconsistente y sera preferible el estimador de efectos
fijos. La hiptesis nula para el contraste de Hausman es que el error
especfico de grupo no est tan correlacionado (as que es preferible el
modelo de efectos aleatorios). Un valor p bajo para este contraste es un
sntoma en contra del modelo de efectos aleatorios y a favor del modelo de
efectos fijos.

Instruccin de guin: hausman

# hccm Estimacin "Estimacin HCCM"

Matriz de covarianzas consistente ante heterocedasticidad: esta instruccin
ejecuta una regresin en la que los coeficientes se estiman mediante un
procedimiento MCO estndar, pero las desviaciones tpicas de los
coeficientes estimados se calculan de una manera que es robusta ante
heterocedasticidad, en concreto usando el procedimiento "jackknife" de
MacKinnon-White.

Instruccin de guin: hccm

# hilu Estimacin "Estimacin de Hildreth-Lu"

Calcula estimaciones de los parmetros del modelo especificado usando el
procedimiento de bsqueda de Hildreth-Lu search procedure (refinado mediante
el procedimiento CORC). Este procedimiento est diseado para corregir las
estimaciones teniendo en cuenta la correlacin serial del trmino de error.
La suma de cuadrados de los residuos del modelo transformado se representa
con respecto al valor de rho desde -0.99 hasta 0.99.

Instruccin de guin: hilu

# hsk Estimacin "Estimaciones corregidas de heterocedasticidad"

Se calcula una regresin por MCO y se guardan los residuos. El logaritmo del
cuadrado de los residuos entonces pasa a ser la variable dependiente en una
regresin auxiliar, en cuyo lado derecho estn las variables independientes
originales ms sus cuadrados. Los valores ajustados en la regresin auxiliar
se usan entonces para construir una serie de ponderaciones y el modelo
original se reestima utilizando mnimos cuadrados ponderados. El resultado
final se presenta en un informe.

La serie de ponderaciones se forma como 1/sqrt(exp(y*)), donde y* denota los
valores ajustados mediante la regresin auxiliar.

Instruccin de guin: hsk

# label Conjunto de datos "Editar los atributos de una variable"

En esta caja de dilogo Vd. puede:

* Renombrar una variable.

* Aadir o editar una descricpcin de la variable: esta aparecer junto al
nombre de la variable en la ventana principal de gretl.

* Aadir o editar el "nombre a mostrar" para la variable. Esta cadena de
caracteres (mximo 19 caracteres) se muestra en lugar del nombre de la
variable cuando la variable se representa en un grfico. As, por ejemplo,
Vd. puede asociar una cadena ms comprensible como "tipo de inters a tres
meses" a una variable que tenga un nombre ms crptico como "t3".

* (En el caso de un conjunto de datos de series temporales) establecer el
mtodo de compactado para la variable. Este mtodo ser el que se use si
usted decide reducir la frecuencia del conjunto de datos, o si usted
actualiza la variable importndola desde una base de datos donde la variable
est a una frecuencia mayor que en su conjunto de datos.

Instruccin de guin: label

# lad Estimacin "Estimacin de mnima desviacin absoluta"

Calcula una regresin que minimiza la suma de las desviaciones absolutas de
los valores observados de la variable dependiente con respecto a los
ajustados. La estimaciones de los coeficientes se derivan usando el
algoritmo simplex de Barrodale-Roberts; se muestra un aviso si la solucin
no es nica. Las desviaciones tpicas se derivan utilizando el procedimiento
bootstrap con 500 extracciones.

Instruccin de guin: lad

# leverage Contrastes "Observations influyentes"

Debe ejecutarse inmediatamente despus de una instruccin "MCO". Calcula el
apalancamiento (h, que debe estar entre 0 y 1) para cada punto de datos de
la muestra sobre la que se estim el ltimo modelo. Presenta el residuo (u)
de cada observacin junto a su apalancamiento y una medida de su influencia
sobre las estimaciones, u*h/(1-h). Los "puntos palanca" para los cuales el
valor de h es mayor que 2k/n (donde k es el nmero de parmetros estimados y
n es el tamao muestral) se marcan con un asterisco. Para ms detalles sobre
los conceptos de apalancamiento e influencia ver Davidson and MacKinnon
(1993, Captulo 2).

Tambin se presentan los valores DFFITS: estos son los "residuos
studentizados" (residuos predichos divididos por sus desviaciones tpicas)
multiplicados por sqrt[h/(1 - h)]. Para ms detalles sobre residuos
studentizados y DFFITS ver el libro de G. S. Maddala, Introduction to
Econometrics, captulo 12; y tambin Belsley, Kuh y Welsch (1980). En
resumen, un "residuo predicho" es la diferencia entre el valor observado de
la variable dependiente en la observacin t y el valor ajustado para la
observacin t obtenido de una regresin en la que se omite esa observacin
(o se aade una variable ficticia con valor 1 slo para la observacin t);
el residuo studentizado se obtiene dividiendo el residuo predicho por su
desviacin tpica.

El icono "+" en la parte de arriba de la ventana del contraste de
apalancamiento abre una caja de dilogo que le permite guardar una o ms de
las variables del contraste al conjunto de datos actual.

Instruccin de guin: leverage

# lmtest Contrastes "Contrastes LM"

Bajo este encabezamiento se agrupan varios contrastes de hiptesis. Lo que
tienen en comn es que el contraste requiere la estimacin de una regresin
auxiliar, en la que la variable dependiente es el residuo de alguna
regresin "original". Las variables del lado derecho inluyen a las de la
regresin original ademas de algunos trminos adicionales. El estadstico de
contraste se calcula como (tamao muestral * R-cuadrado) de la regresin
auxiliar: este se distribuye como una chi-cuadrado con grados de libertad
igual al nmero de trminos adicionales, bajo la hiptesis nula de que los
trminos adicionales no tienen poder explicativo sobre lois residuos. Un
valor "grande" del estadstico (valor p pequeo) sugiere que esa hiptesis
nula debera ser rechazada.

Instruccin de guin: lmtest

# logistic Estimacin "Regresin logstica"

Regresin logstica: desarrolla una regresin MCO utilizando la
transformacin logstica de la variable dependiente,

  log(y/(ymax - y))

La variable dependiente debe ser estrictamente positiva. Si es una fraccin
decimal, entre 0 y 1, por defecto se usa un valor ymax (el mximo asinttico
de la variable dependiente) de 1. Si la variable dependiente es un
porcentaje, entre 0 y 100, por defecto el valor de ymax es 100. Se presenta
una caja de dilogo que le permite especificar un mximo diferente, si usted
lo desea. El valor de ymax proporcionado debe ser mayor que todos los
valores observados de la variable dependiente.

Los valores ajustados y los residuos de la regresin se transforman
automticamente usando

  y = ymax / (1 + exp(-x))

donde x representa o un valor ajustado o un residuo de la regresin MCO
usando la variable dependiente transformada. Los valores que se presentan
son as comparables con los valores originales de la variable dependiente.

Ntese que si la variable dependiente es binaria, en lugar de esto se
debera usar la instruccin "logit".

Instruccin de guin: logistic

# logit Estimacin "Regresin Logit"

Regresin binomial logit. La variable dependiente debera ser una variable
binaria. Se obtienen las estimaciones mximo-verosmiles de los coeficientes
de las variables varindeps por medio del mtodo EM (Expectation-Maximization
method, ver Ruud, 2000, Captulo 27). Como el modelo no es lineal las
pendientes dependen de los valores de las variables independientes: las
poendientes que se presentan se han evaluado en la media de dichas
variables. La hiptesis de que todos los coeficientes, aparte de la
constante, son cero se contrasta mediante el estadstico chi-cuadrado.

Si Vd. desea utilizar logit para el anlisis de proporciones (donde la
variable dependiente, para cada observacin, es la proporcin de casos que
tienen una determinada caracterstica, en lugar de un 1 o un 0 indicando si
la caracterstica est presente o no) no debera usar la instruccin
"logit", sino mejor debera construir la variable logit (p.ej. "genr lgt_p =
log(p/(1 - p))") y usarla como variable dependiente en una regresin MCO.
Ver Ramanathan, Captulo 12.

Instruccin de guin: logit

# markers Conjunto de datos "Aadir marcadores de caja"

Esta orden requiere el nombre de un fichero que contenga los "marcadores de
caja", es decir, pequeas cadenas de caracteres para identificar a las
observaciones individuales del conjunto de datos. Estas cadenas de
caracteres no deberan tener ms de 8 caracteres. El fichero debera
contener un marcador por lnea y debera de haber exactamente tantos
marcadores como observaciones haya en el conjunto de datos. Si se satisfacen
estas condiciones y se encuentra el fichero especificado se aadirn los
marcadores de caja; sern visibles cuando usted elija "Mostrar valores" en
el men de Datos de gretl.

# meantest Contrastes "Diferencia de medias"

Calcula el estadstico t para la hiptesis nula de que las medias
poblacionales de dos variables elegidas son iguales y muestra su valor p. La
instruccin puede invocarse con o sin el supuesto de que las varianzas de
las dos variables son iguales (aunque esto implicar una diferencia en el
estadstico de contraste slo si hay un nmero diferente de valores no
ausentes para las dos variables).

Instruccin de guin: meantest

# missing Conjunto de datos "valores ausentes"

Establece un valor numrico que se interpretar como "ausente" o "no
disponible", o para una serie de datos concreta (en el men de Variable) o
globalmente para el conjunto de datos completo (en el men de Muestra).

Gretl tiene su propio cdigo interno para los valores ausentes, pero a veces
los datos que se importan pueden emplear un cdigo diferente. Por ejemplo,
si una serie particular se codifica de manera que el valor -1 indica "no
disponible", Vd. puede seleccionar "Establecer cdigo de 'valor perdido'"
bajo el men de Variable y escribir el valor "-1" (sin las comillas). Gretl
entonces leer los -1s como valores ausentes.

# modeltab Utilidades "La tabla de modelos"

En la investigacin economtrica es frecuente estimar varios modelos para
una variable dependiente comn -- los modelos pueden ser diferentes respecto
a las variables independientes que incluyen, o quizs respecto al estimador
utilizado. En esta situacin es coveniente presentar los resultados de las
regresiones en forma de tabla, donde cada columna contiene los resultados
para un modelo dado (estimaciones de los coeficientes y desviaciones
tpicas), y cada fila contiene las estimaciones dadas por los diferentes
modelos para una misma variable.

Gretl proporciona un mtodo para construir dicha tabla (y copiarla en texto
plano, LaTeX o formato RTF). H aqu cmo hacerlo:

1. Estimar un modelo que Vd. desea incluir en la tabla y en la ventana del
   modelo, bajo el men Archivo, seleccionar "Guardar a sesin como icono" o
   "Guardar a sesin como icono y cerrar".

2. Repetir el paso 1 para los otros modelos que desee incluir en la tabla
   (hasta un total de seis).

3. Cuando haya acabado de estimar los modelos, abra la vista de iconos de su
   sesin gretl (seleccionando "Vista de iconos " bajo el men de Sesin en
   la ventana principal de gretl, o pulsando sobre el icono de "vista de
   iconos de sesin" en la barra de herramientas de gretl).

4. En la vista de iconos de sesin hay un icono de nombre "Tabla de
   Modelos". Decida qu modelo desea que aparezca en la columna de la
   izquierda en la Tabla de modelos y adalo a la tabla o arrastrando su
   icono al icono de la tabla de modelos o pulsando con el botn derecho del
   ratn sobre el icono del modelo y seleccionando "Aadir a la tabla de
   modelos" en el men que entonces surge.

5. Repetir el paso 4 para los dems modelos que desee incluir en la tabla.
   El segundo modelo elegido aparecer en la segunda columna desde la
   izquierda, y as sucesivamente.

6. Cuando haya acabado de formar la tabla de modelos, puede verla haciendo
   doble click sobre su icono. En el men Editar de la ventana que aparece,
   tiene Vd. la opcin de copiar la tabla al portapapeles en varios formatos
   diferentes.

7. Si el orden de los modelos en la tabla no es el que Vd. deseaba pulse con
   el botn derecho del ratn sobre el icono de la tabla de modelos y elija
   "Vaciar". Despus vuelva al paso 4 anterior e intntelo otra vez.

Instruccin de guin: modeltab

# mpols Estimacin "MCO de precisin Mltiple"

Computa las estimaciones MCO para el modelo especificado, usando aritmtica
de punto flotante con precisin mltiple. Esta instruccin slo est
disponible si gretl se compila con soporte para la biblioteca Gnu de
Precisin Mltiple (GMP).

Instruccin de guin: mpols

# nls Estimacin "Mnimos cuadrados no lineales"

Desarrolla la estimacin por Mnimos Cuadrados No Lineales (NLS) utilizando
una versin modificada del algoritmo de Levenberg-Marquandt. Usted debe
suministrar la especificacin de una funcin; tambin se recomienda que, si
es posible, suministre las expresiones de las derivadas de la funcin con
respecto a cada uno de los parmetros.

Ejemplo: Supongamos que tenemos un conjunto de datos con las variables C e Y
(p.ej. greene11_3.gdt) y deseamos estimar una funcin de consumo no lineal
de la forma

  C = alpha + beta * Y^gamma

Los parmetros alfa, beta y gamma deben aadirse primero al conjunto de
datos y hay que asignarles unos valores iniciales. Esto puede hacerse usando
la instruccin genr o por medio de los mens. Las expresiones "genr" que
corresponda pueden escribirse dentro de la ventana de especificacin de MC
no lineales antes de la especificacin de la funcin.

En la ventana de MC no lineales escribiremos las siguientes lneas:

	C = alfa + beta * Y^gamma
	deriv alfa = 1
	deriv beta = Y^gamma
	deriv gamma = beta * Y^gamma * log(Y)

La primera lnea determina la funcin de regresin y las tres siguientes
lneas proporcionan las derivadas de la funcin con respecto a cada uno de
los parmetros. Si no se proporcionan las lneas "deriv", se computa una
aproximacin numrica al Jacobiano.

Si los parmetros alfa, beta y gamma no se hubieran declarado previamente,
podramos escribir las siguientes lneas justo antes de las que se han
presentado arriba:

	genr alfa = 1
	genr beta = 1
	genr gamma = 1

Para ms detalles sobre la estimacin por MC. no lineales ver el manual de
gretl.

Instruccin de guin: nls

# nulldata Conjunto de datos "Crear un conjunto de datos vaco"

Forma un conjunto de datos "vaco", que contiene slo una constante y una
variable ndice, con periodicidad 1 y el nmero de observaciones
especificado. Esto puede usarse para hacer simulaciones: algunas de las
instrucciones "genr" (p.ej. "genr uniform()", "genr normal()") generan,
desde cero, datos ficticios para rellenar el conjunto de datos. Esta
instruccin puede ser til tambin junto a la instruccin "loop". Ver
tambin la opcin "seed" de la instruccin "set".

Instruccin de guin: nulldata

# ols Estimacin "Mnimos Cuadrados Ordinarios"

Calcula las estimaciones de Mnimos Cuadrados Ordinarios (MCO) para el
modelo especificado.

Adems de las estimaciones de los coeficientes y de las desviaciones
tpicas, el programa tambin presenta los valores p de los estadsticos t (a
dos colas) y F. Un valor p inferior a 0,01 indica significatividad al nivel
del 1 por ciento y se denota mediante ***. ** indica un nivel de
significatividad entre el 1 y 5 por ciento y * indica significatividad entre
el 5 y 10 por ciento. Tambin se presentan algunos estadsticos de seleccin
de modelos (se describen en Ramanathan, Seccin 4.3).

Si se da la opcin --no-df-corr, no se aplica la correccin habitual de
grados de libertad al calcular la estimacin de la varianza de las
perturbaciones (y as tampoco en la estimacin de las desviaciones tpicas
de los estimadores de los parmetros).

La opcin --print-final es aplicable slo en el contexto de un bucle (ver
"loop"). Se encarga de que las regresiones se ejecuten "silenciosamente" en
todas las iteraciones excepto la iteracin final del bucle. Ver el manual de
gretl para ms detalles.

Instruccin de guin: ols

# omit Contrastes "Omisin de variables"

Esta instruccin debe invocarse justo despus de una instruccin de
estimacin. Las variables seleccionadas se omiten del modelo anterior y se
estima el nuevo modelo. Si se omite ms de una variable, se presentar el
estadstico F de Wald para las variables omitidas y su valor p (slo para el
mtodo MCO). Un valor p inferior a 0,05 indica que los coeficientes son
conjuntamente significativos al nivel de significacin del 5 por ciento.

Instruccin de guin: omit

# online Conjunto de datos "Bases de datos de acceso en lnea"

Gretl es capaz de acceder a las bases de datos de la Universidad de Wake
Forest (para que esto funcione, su ordenador debe estar conectado a
internet).

Bajo el men "Archivo, Revisar bases de datos", seleccione el elemento
"sobre servidor". Entonces tendra que aparecer una ventana presentando una
lista de bases de datos en formato gretl disponibles en Wake Forest. (Esto
puede llevar un tiempo, dependiendo de dnde se encuentre usted y de la
velocidad de su conexin a internet.) Junto al nombre de la base de datos y
su pequea descripcin aparecer una columna de "estado local": esto le
indica si usted tiene ya la base de datos instalada localmente (en su disco
duro) y si es as, si est actualizada con la versin del servidor.

Si usted tiene una determinada base de datos instalada localmente y est
actualizada, no hay ninguna ventaja al acceder a ella por medio del
servidor. Pero para una base de datos que no est instalada y actualizada,
es posible que usted desee obtener el listado de las series que contiene:
para ello pulse sobre "Obtener listado de series". Esto abre una nueva
ventana, desde la que Vd. puede ver los valores de una serie determinada,
representar esos valores o importarlos al espacio de trabajo de gretl. Estas
tareas pueden llevarse a cabo usando el men "Series" o por medio del men
emergente que aparece cuando usted pulsa con el botn derecho sobre una
serie determinada. Tambin puede buscar a lo largo del listado la variable
que a Vd. le interese (mediante el elemento "Buscar" del men).

Si Vd. desea un acceso a los datos ms rapido, o si desea acceder a la base
de datos estando su ordenador fuera de lnea (desconectado de internet),
seleccione la lnea que contiene la base de datos que Vd. desea y pulse el
botn "Instalar". esto descargar la base de datos en formato comprimido, lo
descomprimir y lo instalar en su disco duro. A partir de entonces usted
debera encontrarlo bajo el men "Archivo, Revisar bases de datos, nativa
gretl".

# panel Conjunto de datos "Datos de panel"

Aqu hay dos opciones "series temporales apiladas" y "secciones cruzadas
apiladas". Si Vd. quiere utilizar la instruccin "MC combinados" y sus
correspondientes diagnsticos de panel, Gretl debe conocer cmo estn
organizados sus datos.

"Series temporales apiladas" significa que los bloques en el fichero de
datos tienen la estructura de series temporales para cada una de las
unidades de seccin cruzada. Por ejemplo, las primeras 10 filas de datos
podran representar los valores de ciertas variables para el pas A durante
10 periodos, las siguientes 10 filas los valores para el pas B durante los
mismos 10 periodos, y as sucesivamente.

"Seciones cruzadas apiladas" significa que los bloques del fichero de datos
tienen la estructura de secciones cruzadas para cada uno de los periodos
temporales. Por ejemplo, las primeras 6 filas de datos posran representar
los valores de ciertas variables para los pases A, ..., F para el ao 1970,
las 6 siguientes filas, los valores para los mismos pases en el ao 1971, y
as sucesivamente.

Si Vd. guarda su ficherode datos despus de establecer este atributo, esta
informacin se grabar al fichero y as no tendr que introducirla de nuevo.

Hay que sealar que este elemento de men no altera la estructura de su
conjunto de datos de panel, slo fija la interpretacin de esa estructura
por parte de gretl. Si desea convertir un panel de datos que actualmente
est en forma de secciones cruzadas apiladas a la forma de series temporales
apiladas, use el elemento de men "Reestructurar panel".

Instruccin de guin: panel

# pca Estadstica "Anlisis de componentes principales"

Anlisis de componentes principales. Presenta los valores propios de la
matriz de correlacin de las variables de la lista listavar y la proporcin
de la varianza conjunta explicada por cada uno de los componentes. Tambin
presenta los vectores propios correspondientes (o "ponderaciones de los
componentes").

Si se da la opcin --save, los componentes con valorres propios mayores que
1,0 se guardan como variables en el conjunto de datos, con nombres PC1, PC2
y as sucesivamente. Estas variables artificiales se forman como la suma de
(ponderaciones de los componentes) por (Xi estandarizadas), donde Xi denota
la i-sima variable de la lista listavar.

Si se da la opcin --save-all, se guardan todos los componentes de la manera
que se ha descrito arriba.

Instruccin de guin: pca

# pergm Estadsticas "Periodograma"

Calcula y presenta (y si no se ejecuta en modo batch, representa
grficamente) el espectro de la variable especificada. Sin la opcin
--bartlett se ofrece el periodograma muestral; con dicha opcin, se utiliza
una ventana de retardos de Bartlett de longitud 2*sqrt(T) (donde T es el
tamao muestral) para estimar el espectro (ver Captulo 18 del libro de
Greene Econometric Analysis). Cuando se presenta el periodograma muestral,
tambin se proporciona un contraste t sobre integracin fraccional de la
serie ("memoria larga"): la hiptesis nula es que el orden de integracin es
cero.

Instruccin de guin: pergm

# pooled Estimacin "MCO combinados"

Estima un modelo va MCO (ver "ols" para los detalles sobre su sintaxis), y
lo marca como 'combinado' o 'modelo de panel', de manera que se hace
disponible el contraste de "hausman".

Instruccin de guin: pooled

# probit Estimacin "Modelo Probit"

La variable dependiente debera ser una variable binaria. Se obtienen las
estimaciones mximo-verosmiles de los coeficientes de las variables
varindeps por medio de mnimos cuadrados iterativos (el mtodo EM o
Expectation-Maximization). Como el modelo no es lineal las pendientes
dependen de los valores de las variables independientes: las pendientes que
se presentan estn evaluadas en las medias de dichas variables. El
estadstico chi-cuadrado sirve para contrastar la hiptesis nula de que
todos los coeficientes, excepto la constante, son cero.

El anlisis Probit de proporciones no est an implementado en gretl.

Instruccin de guin: probit

# pwe Estimacin "Estimador de Prais-Winsten"

Calcula estimaciones de los parmetros utilizando el procedimiento de
Prais-Winsten, un mtodo de Mnimos cuadrados generalizados factibles que
est diseado para tener en cuenta la autocorrelacin de primer orden del
trmino de error. El procedimiento es iterativo, igual que "corc"; la
diferencia es que mientras el mtodo de Cochrane-Orcutt desperdicia la
primera observacin, el de Prais-Winsten la utiliza. Para ms detalles, ver
por ejemplo el Captulo 13 del libro de Greene Econometric Analysis (2000).

Instruccin de guin: pwe

# reset Contrastes "Ramsey's RESET"

Debe ejecutarse despus de la estimacin de un modelo va MCO. Realiza el
contraste de especificacin de modelos (no linealidad) RESET de Ramsey. Para
ello aade a la regresin el cuadrado y el cubo de los valores ajustados y
calcula el estadstico F para la hiptesis nula de que los parmetros de las
dos variables aadidas son cero.

Instruccin de guin: reset

# restrict Contrastes "Restricciones lineales"

Evala un conjunto de restricciones sobre los parmetros del ltimo modelo
estimado. En modo "guin de instrucciones", el conjunto de restricciones
debe incluirse entre "restrict" y "end restrict", pero en la caja de dilogo
sobre restricciones (en el entorno grfico) pueden omitirse esas lneas.

Cada restriccin del conjunto debe expresarse como una ecuacin, con una
combinacin lineal de los parmetros a la izquierda y un valor numrico a la
derecha del signo igual. Los parmetros se referencian en la forma bN, donde
N representa la posicin en la lista de regresores, comenzando en cero. Por
ejemplo, b1 denota al segundo parmetro de la regresin.

El segundo y siguientes trminos bN de una ecuacin pueden ir
premultiplicados por un nmero, utilizando * para representar la
multiplicacin, por ejemplo 3.5*b4.

He aqu un ejemplo de un conjunto de restricciones:

	restrict
	 b1 = 0
	 b2 - b3 = 0
	 b4 + 2*b5 = 1
	end restrict

Las restricciones se evalan mediante un contraste F de Wald, usando la
matriz de covarianzas de los coeficientes del modelo en cuestin.

Instruccin de guin: restrict

# rmplot Grficos "Grfico Rango-Media"

Grfico Rango-media plot: esta instruccin crea un sencillo grfico para
ayudar a decidir si una serie temporal, y(t), tiene varianza constante o no.
Se toma la muestra completa t=1,...,T y se divide en pequeas submuestras de
tamao arbitrario k. La primera submuestra se forma con y(1),...,y(k), la
segunda con y(k+1), ..., y(2k), y as sucesivamente. Para cada submuetra se
calcula la media muestral y el rango (= el mximo menos el mnimo), y se
forma un grfico con las medias en el eje horizontal y los rangos en el
vertical. As, cada submuestra est representada por un punto en este plano.
Si la varianza de la serie es constante, se espera que los rangos de las
submuestras sean independientes de las medias; si vemos que los puntos se
distribuyen a lo largo de una lnea de creciente, esto sugiere que la
varianza de la serie aumenta con la media; si los puntos siguen una lnea
decreciente esto indica que la varianza disminuye a medida que la media
aumenta.

Adems del grfico, gretl presenta las medias y los rangos de cada
submuestra, el coeficiente para la pendiente en una regresin MCO de los
rangos sobre las medias y el valor p para el contraste de la hiptesis nula
de que dicha pendiente es cero. Si el coeficiente de la pendiente es
significativo, al nivel de significacin del 10 por ciento, se muestra
tambin en el grfico la recta de regresin estimada de los rangos sobre las
medias.

Instruccin de guin: rmplot

# runs Contrastes "Contraste de rachas"

Realiza el contraste "rachas" (no paramtrico) de aleatoriedad de la
variable especificada. Si Vd. desea contrastar la aleatoriedad de las
desviaciones respecto a la mediana, para una variable denominada x1 con
mediana distinta de cero, puede hacer lo siguiente:

	genr signx1 = x1 - median(x1)
	runs signx1

Instruccin de guin: runs

# sampling Conjunto de datos "Establecer el rango muestral"

El men Muestra ofrece varias maneras de seleccionar una submuestra a partir
del conjunto de datos actual.

Si Vd. elige "Muestra/Sample/Definir, a partir de v. ficticia..." se le
indica que seleccione una variable ficticia (indicadora), que debe tener los
valores 0 o 1 para cada observacin. La muestra se restringir entonces a
las observaciones para las cuales la variable ficticia vale 1.

Si Vd. elige "Muestra/Restringir, a partir de criterio..." es necesario que
Vd. proporcione una expresin Booleana (lgica) del mismo tipo que Vd.
usara para definir una variable ficticia. Por ejemplo, la expresin "sqft >
1400" seleccionar slo casos para los que la variable sqft tiene un valor
mayor que 1400. Las condiciones pueden estar concatenadas utilizando para
ello los operadores lgicos "&"(AND) y "|" (OR), y puede aplicarse tambin
la negacin usando "!" (NOT).

El elemento de men "Muestra/Quitar todas las obs. con valores perdidos"
redefine la muestra de manera que se excluyen todas las observaciones para
las cuales faltan los valores de una o ms variables (se dejan slo los
datos completos).

Para seleccionar las observaciones para las cuales una variable particular
no tiene valores ausentes, use "Muestra/Restringir, a partir de criterio..."
e introduzca la condicin Booleana "!missing(nombre_var)" (reemplac
"nombre_var" por el nombre de la variable que Vd. desee usar).

Si las observaciones tienen nombre (marcas de caja), Vd. puede remuestrear
de manera que se excluya una observacin particular, utilizando por ejemplo
"obs!="France"" como condicin Booleana. El nombre de la observacin debe
estar incluido entre comillas.

Al definir una muestra a partir de una variable ficticia, una expresin
Booleana o por el criterio de los valores perdidos, hay que sealar que
cualquier informacin "estructural" en el encabezamiento del fichero de
datos (con respecto a la estructura de series temporales o de panel) se
pierde. Vd. puede reimponerla de nuevo usando el men "Muestra/Establecer
frecuencia, observacin inicial...".

Vase el manual de gretl para ms detalles.

# scatters Grficos "Grficos bivariantes mltiples"

Dibuja un conjunto de grficos por parejas de la variable elegida del eje
"Y" con respecto a cada una de las variables elegidas del eje "X". Revisar
un conjunto de grficos como estos puede ser til al realizar anlisis
exploratorio de datos. El nmero mximo de grficos es seis; cualquier otra
variable extra en la lista de variables del eje X ser ignorada.

Instruccin de guin: scatters

# seed Programacin "Semilla aleatoria"

Requiere como entrada un nmero entero. Establece la semilla para el
generador de nmeros pseudoaleatorios que se utiliza bajo el men Datos,
Aadir variables, Aleatoria normal y Aleatoria uniforme. Por defecto, la
semilla se establece cuando se inicia el programa usando la hora del
sistema. Si Vd. desea obtener secuencias de nmeros pseudoaleatorios
repetibles necesitar determinar la semilla de forma manual.

# setobs Conjunto de datos "Frequencia y observacin inicial"

Esta instruccin se usa para forzar al programa a interpretar el conjunto de
datos actual como series temporales o como panel, cuando los datos se han
ledo como series simples sin fechas. Se necesitan dos parmetros: una
frecuencia entera y una cadena de caracteres para la observacin inicial
(normalmente una fecha). He aqu algunos ejemplos de cdigo vlido:

  4 1990:1      Interpretar los datos como trimestrales, comenzando en 1990, 
                Q1
  12 1978:03    Interpretar los datos como mensuales, comenzando en marzo de 
                1978
  20 1:01       Frequencia 20, empezando en la observacin 1.01 (datos de 
                panel)
  5 1972/01/20  Datos diarios (5 das por semana), comenzando el 20 de enero 
                de 1972
  7 2002/01/20  Datos diarios (7 das por semana), comenzando el 20 de enero 
                de 2002

Instruccin de guin: setobs

# setmiss Conjunto de datos "Cdigo de valor ausente"

Determina un valor numrico que se intepretar como "ausente" o "no
disponible", o para una serie de datos concreta (bajo el men de Variable) o
globalmente para el conjunto de datos completo (bajo el men de Muestra).

Gretl tiene su cpropio cdigo inetrno para manejar valores ausentes, pero a
veces los datos importados emplean un cdigo diferente. Por ejemplo, si una
serie particular est codificada de manera que el valor de -1 indica "no
disponible", Vd. puede seleccionar "Establecer cdigo de 'valor perdido'" en
el men de Variable y escribir all el valor "-1" (sin las comillas).
Entonces gretl leer los -1s como observaciones ausentes.

Instruccin de guin: setmiss

# sim Conjunto de datos "Simulacin"

Simula valores para nombre_var para el rango muestral actual o para el rango
obs_inicial hasta obs_final si se dan estos argumentos. La variable y debe
haber sido definida antes con valores iniciales apropiados. La frmula
utilizada es

  y(t) = a0(t) + a1(t)*y(t-1) + a2(t)*y(t-2) + ...

Los trminos ai(t) pueden ser nmeros constantes o nombres de variables
definidas previamente; esos trminos pueden ir precedidos de un signo menos.

Esta instruccin ya no se recomienda. En su lugar debera de usarse "genr".

Instruccin de guin: sim

# spearman Estadstica "Correlacin por rangos de Spearmans"

Calcula el coeficiente de correlacin por rangos de Spearman para un par de
variables especificado. No es necesario antes ordenar y hacer el ranking de
las variables, la funcin se encarga de ello.

El ranking automtico es de mayor a menor (es decir, el mayor valor de los
datos obtiene rango 1). Si Vd. necesita invertir este ranking cree una nueva
variable que sea el negativo de la primera original. Por ejemplo:

	genr altx = -x
	spearman altx y

Instruccin de guin: spearman

# store Conjunto de datos "Guardar datos"

Guarda el conjunto de datos completo o, si se suministra una lista listavar,
el subconjunto especificado de variables del conjunto de datos actual, al
fichero dado en fichero_de_datos.

Por defecto los datos se guardan en formato gretl "nativo", pero las
distintas opciones permiten guardarlos en varios formatos alternativos. Los
datos CSV (Comma-Separated Values) pueden ser ledos por programas de hoja
de clculos y tambin pueden manipularse mediante un editor de textos. Los
formatos de Octave, R y PcGive estn diseados para el uso con estos
respectivos programas. La compresin mediante Gzip puede ser til para
grandes conjuntos de datos. Ver el manual de gretl para detalles sobre los
distintos formatos.

Hay que sealar que las variables escalares no sern guardadas
automticamente: si Vd. desea guardar escalares debe escribirlas
explcitamente en la lista listavar.

Instruccin de guin: store

# tobit Estimacin "Modelo Tobit"

Estima un modelo Tobit. Este modelo puede ser adecuado cuando la variable
dependiente es una variable "truncada". Por ejemplo, se observan valores
positivos y cero de las compras de bienes duraderos por parte de las
familias, pero no valores negativos. Sin embargo las decisiones sobre tales
compras pueden considerarse como resultados de una disposicin subyacente a
la compra que puede ser negativa en algunos casos. Para detalles ver el
libro de Greene Econometric Analysis, Captulo 20.

Instruccin de guin: tobit

# tsls Estimacin "Mnimos cuadrados en dos etapas"

Esta instruccin necesita la seleccin de dos listas de variables: las
variables independientes del modelo y una lista de "instrumentos". La ltima
recoge las variables exgenas y/o predeterminadas que pueden usarse como
regresores para obtener valores ajustados para las variables endgenas del
lado derecho.

Si alguna de las variables del lado derecho del modelo son exgenas,
deberan estar incluidas en ambas listas.

Instruccin de guin: tsls

# var Estimacin "Autorregresin vectorial"

Este mandato necesita la especificacin de:

  - la variable dependiente de la primera ecuacin del sistema VAR;

  - el orden de retardos, es decir, el nmero de retardos de cada variable
  que deberan incluirse en el sistema;

  - los posibles trminos determinsticos (es decir, la constante, tendencia
  temporal, variables ficticias estacionales, etc); y

  - una lista de variables independientes, cuyos retardos se incluirn en el
  lado derecho de las ecuaciones (nota: no incluir en esta lista variables
  retardadas -- sern aadidas automticamente).

Se ejecutar una regresin por separado para cada variable del sistema. La
salida de cada ecuacin contiene los contrastes F para restricciones cero de
todos los retardos de cada una de las variables, un contraste F para el
mximo retardo, descomposiciones de la varianza de prediccin y funciones
impulso respuesta.

Las descomposiciones de la varianza y las funciones impulso-respuesta se
basan en la descomposicin de Cholesky de la matriz de covarianzas
contempornea, y en este contexto el orden en el que se dan las variables
(estocsticas) es importante. La primera variable de la lista se supone que
es "ms exgena" dentro del periodo.

Instruccin de guin: var

# vartest Contrastes "Diferencia de varianzas"

Calcula el estadstico F para contrastar la hiptesis nula de que las
varianzas poblacionales de las dos variables seleccionadas son iguales y
muestra su valor p.

Instruccin de guin: vartest

# wls Estimacin "Mnimos cuadrados ponderados"

Supongamos que "wtvar" denota la variable seleccionada en la caja "Variable
de ponderaciones". Se ejecuta una regresin por MCO en la que la variable
dependiente es el producto de wtvar por la variable dependiente elegida, y
las variables independientes tambin se multiplican por wtvar. Si wtvar es
una variable ficticia, esto es equivalente a eliminar todas las
observaciones en las que wtvar toma valor cero.

Instruccin de guin: wls
