/*
 * Copyright 2003-2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package gls.annotations.closures

class AnnotationClosureUnqualifiedCallTest extends AnnotationClosureExhaustiveTestSupport {
    Class getAnnotationClass() { AnnWithClassElement }

    Class getAnnotatedClass() { UnqualifiedCall }

    void verify(Class closureClass) {
        def closure = closureClass.newInstance(this, this)
        assert closure.call() == 42
    }

    def answer() { 42 }
}

@AnnWithClassElement(elem = { answer() })
class UnqualifiedCall {
    @AnnWithClassElement(elem = { answer() })
    private aField

    @AnnWithClassElement(elem = { answer() })
    def aProperty

    @AnnWithClassElement(elem = { answer() })
    def aMethod(@AnnWithClassElement(elem = { answer() }) aParam) {
        @AnnWithClassElement(elem = { answer() })
        def aLocal
    }
}