/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * This is a socket class.  It buffers bytes and flushes them in a run
 * loop.  For the actual socket glue, see GrouchSocketBackend.h.
 */

#import <Foundation/NSObject.h>
#import <Foundation/NSException.h>

#include <stddef.h>
#include <time.h>

@class NSRunLoop;
@protocol GrouchSocketBackend, GrouchSocketDelegate;

typedef enum
{
	GrouchSocketEventIn = (1<<0),
	GrouchSocketEventOut = (1<<1),
	GrouchSocketEventError = (1<<2)
} GrouchSocketEvent;

@interface GrouchSocket : NSObject
{
@private
	id<GrouchSocketBackend> fd;
	struct grouchsocket_buffer
	{
		char *buf;
		size_t len, alloc;
	} in, out;
	id<GrouchSocketDelegate> _delegate;
	time_t lastKeepAlive, keepAlive;
}

// May block or throw an exception.
+ (GrouchSocket*)socketForHost:(NSString*)host atPort:(int)port
		 withRunLoop:(NSRunLoop*)loop;
- initForHost:(NSString*)host atPort:(int)port
  withRunLoop:(NSRunLoop*)loop;

- (id<GrouchSocketBackend>)fd;

- init;

- close;
- (void)dealloc;

- delegate;
- (void)setDelegate:delegate;

- (void)writeData:(const void*)buf withLength:(size_t)len;
- (void)getInputBuffer:(void**)buf withLength:(size_t*)len;

- (void)flush;
- (void)forceFlush;

- (void)removeBytesFromInputBuffer:(size_t)l;

- (void)setKeepAlive:(time_t)intreval;

- (GrouchSocketEvent)pollSocketEvents;
- (void)readLoop;
- (void)eventLoop:(GrouchSocketEvent)e;
- (void)eventLoop;
@end

@protocol GrouchSocketDelegate 
- (void)connectionClosed:socket;
- (void)bytesIn:socket atBuffer:(void*)buf withLength:(size_t)len;
- (void)keepAlive:socket;
@end

