/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 */

#import <InfoWindow.h>
#import <String.h>

#import <Grouch/GrouchStringTool.h>

#import <Foundation/NSBundle.h>
#import <Renaissance/Renaissance.h>

@implementation InfoWindow

+ infoWithNick:(NSString*)nick
{
	return [[[InfoWindow new] initWithNick:nick] autorelease];
}

- initWithNick:(NSString*)nick
{
	name = [nick retain];
	return self;
}

- (void)dealloc
{
	[name release];
	[super dealloc];
}

- (void)finishedProfile
{
	if( !window )
	{
		[self createWindow];
		if( output )
		{
			NSTextStorage *text = [output textStorage];
			NSString *str = [GrouchString getString:@"no-profile"];
			if( text )
				[text appendAttributedString:[str attributed]];
		}
	}
}

- (void)createWindow
{
	if( !window )
	{
		[NSBundle loadGSMarkupNamed:@"InfoWindow" owner:self];
		[window orderFront:nil];
		[window makeKeyWindow];
		[window setTitle:[NSString stringWithFormat:@"%@%@",
		 [window title], name]];
		[window release];
		[output release];
	}
}

- (void)profile:(NSString*)str
{
	NSTextStorage *text;
	[self createWindow];
	text = [output textStorage];
	[text beginEditing];
	[text appendAttributedString:[str parseHtml]];
	[text endEditing];
	[output setSelectedRange:NSMakeRange(0,0)];
}

- (void)awayMessage:(NSString*)str
{
	NSTextStorage *text;
	[self createWindow];
	text = [output textStorage];
	[text beginEditing];
	[text insertAttributedString:
	      [[NSString stringWithFormat:@"%@<hr>",str] parseHtml]
	      atIndex:0];
	[text endEditing];
	[output setSelectedRange:NSMakeRange(0,0)];
}

- (BOOL)windowShouldClose:sender
{
	return YES;
}

@end
