/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 */

#import <Oscar/OscarHandlers.h>
#import <Oscar/OscarIncomingSnac.h>
#import <Oscar/OscarTlvList.h>
#import <Oscar/OscarClient.h>
#import <Oscar/OscarEncoding.h>
#import <Oscar/OscarCapHandler.h>
#import <Grouch/GrouchClient.h>
#import <Grouch/GrouchStringTool.h>
#import <Foundation/NSBundle.h>

@interface OscarSnac00040007 : NSObject <OscarSnacHandler>
- (void)handleSnacForClient:(OscarFlap*)flap
	ofFamily:(int)family andType:(int)type
	withFlags:(int)flags andTag:tag
	buffer:(OscarIncomingSnac*)buf;
- (void)channel1:(OscarTlvListIn*)tlvs from:(id<GrouchUser>)user
	onClient:(OscarClient*)cli;
- (void)channel2:(OscarTlvListIn*)tlvs from:(id<GrouchUser>)user
	onClient:(OscarClient*)cli;

- (BOOL)rvous:(int)type cookie:(const void*)cbuf type:(const void*)tbuf
  tlv:(OscarTlvListIn*)tlv from:(id<GrouchUser>)user
  client:(OscarClient*)cli;

- (void)dropMessage:(id<GrouchUser>)user;
@end
@implementation OscarSnac00040007
- (void)handleSnacForClient:(OscarFlap*)flap
	ofFamily:(int)family andType:(int)type
	withFlags:(int)flags andTag:tag
	buffer:(OscarIncomingSnac*)buf
{
	id<GrouchUser> luser;
	OscarClient *cli = [flap client];
	OscarTlvListIn *tlvs;
	NSString *who;
	int channel, warn;

	[buf readInt32];		// Cookie
	[buf readInt32];		// more cookie

	channel = [buf readInt16];
	who = [buf readPascalString];
	warn = [buf readInt16];
	luser = [[cli getUI] getUser:who];

	oscar_process_buddy( warn, [buf readTlvList], luser );
	tlvs = [buf readTLVs];

	switch( channel )
	{
		case 1:
			[self channel1:tlvs from:luser onClient:cli];
			break;
		case 2:
			[self channel2:tlvs from:luser onClient:cli];
			break;
		default:
			[self dropMessage:luser];
	}
}

- (void)channel1:(OscarTlvListIn*)tlvs from:(id<GrouchUser>)user
	onClient:(OscarClient*)cli
{
	OscarIncomingSnac *buf = [tlvs getTLV:0x02];
	if( buf )
	{
		NSString *msg;
		NSStringEncoding enc;
		int charset, sub;
		tlvs = [buf readTLVs];
		buf = [tlvs getTLV:0x0101];
		if( !buf )
			goto drop;
		charset = [buf readInt16];
		sub = [buf readInt16];
		enc = [OscarEncoding getForChannel1:charset withSub:sub];
		msg = [buf readRawStringWithEncoding:enc];

		[user message:msg withFlags:([tlvs getTLV:0x04] ?
		      GrouchMessageAway : 0)];
	}
	else
	{
	drop:
		[self dropMessage:user];
	}
}

- (void)channel2:(OscarTlvListIn*)tlvs from:(id<GrouchUser>)user
	onClient:(OscarClient*)cli
{
	OscarIncomingSnac *buf = [tlvs getTLV:0x05];
	if(buf)
	{
		int type = [buf readInt16];
		char cbuf[OSCAR_MSG_COOKIE_SIZE], tbuf[OSCAR_CAP_SIZE];

		if([buf bytesRemaining] < sizeof(cbuf))
			goto drop;
		memcpy(cbuf, [buf buffer], sizeof(cbuf));
		[buf skipBytes:sizeof(cbuf)];
		if([buf bytesRemaining] < sizeof(tbuf))
			goto drop;
		memcpy(tbuf, [buf buffer], sizeof(tbuf));
		[buf skipBytes:sizeof(tbuf)];

		if([self rvous:type cookie:cbuf type:tbuf tlv:[buf readTLVs]
		    from:user client:cli])
			goto drop;
	}
	else
	{
	drop:
		[self dropMessage:user];
	}
}

- (BOOL)rvous:(int)type cookie:(const void*)cbuf type:(const void*)tbuf
  tlv:(OscarTlvListIn*)tlv from:(id<GrouchUser>)user
  client:(OscarClient*)cli
{
	return [[cli capHandler] handleCapability:tbuf from:user onClient:cli
		type:type cookie:cbuf tlv:tlv message:@""];
}

- (void)dropMessage:(id<GrouchUser>)user
{
	NSString *str = [GrouchString getString:@"drop"
	withBundle:[NSBundle bundleForClass:[self class]]];
	[user message:str withFlags:GrouchMessageError];
}
@end

@implementation OscarMessageHandler
+ get
{
	static id r = nil;
	if( r )
		return r;
	else
		return r = [self new];
}

- init
{
	[super init];
	[super initForFamily:0x04 andVersion:0x01 andDLL:0x0629];
	[self addHandler:[OscarErrorHandler get] forType:0x01];
	[self addHandler:[OscarSnac00040007 new] forType:0x07];	
	return self;
}
@end
