/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Chat rooms.  See also: OscarChatNav.
 */

#import <Oscar/OscarClient.h>
#import <Oscar/OscarFlap.h>
#import <Grouch/GrouchClient.h>
#import <Foundation/NSString.h>

@interface OscarChat : OscarFlap
{
	NSString *name;
	BOOL online;
}

+ chatForHost:(NSString*)host withCredentials:(id<OscarCredentials>)creds
  andClient:(OscarClient*)cli underName:(NSString*)name;
- init;
- (void)dealloc;
- initForHost:(NSString*)host withCredentials:(id<OscarCredentials>)creds
  andClient:(OscarClient*)cli underName:(NSString*)name;

- (NSString*)name;

- (void)sendMessage:(NSString*)msg withFlags:(GrouchMessageFlags)f;

- (void)welcome;
- (void)connectionClosed:sock;

@end
