/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * This class is a client for the Oscar authorization server.
 *
 * Actually, all it does is signs on, gives a password (see OscarCredentials)
 * grabs an auth cookie and shuts up.  You can do other things with the auth
 * server, like change your password, but that's a little too advanced for
 * my tastes.
 */

#import <Oscar/OscarAuth.h>
#import <Oscar/OscarTlvList.h>
#import <Oscar/OscarSnacHandler.h>
#import <Oscar/OscarCredentials.h>
#import <Oscar/OscarClient.h>
#import <Grouch/GrouchStringTool.h>
#import <Foundation/NSRunLoop.h>
#import <Foundation/NSBundle.h>

@interface OscarClient (OscarAuthPrivate)
- (void)nick:(NSString*)str;
@end
@implementation OscarClient (OscarAuthPrivate)
- (void)nick:(NSString*)str
{
	[myNick = str retain];
}
@end

@implementation OscarAuth

+ authForHost:(NSString*)host withCredentials:(id<OscarCredentials>)cred
  andClient:(OscarClient *)cli
{
	id r = [OscarAuth new];
	if( [r initForHost:host withCredentials:cred andClient:cli] )
		return r;
	else
	{
		[r release];
		return nil;
	}
}

- initForHost:(NSString*)host withCredentials:(id<OscarCredentials>)cred
  andClient:(OscarClient*)cli
{
	static id r = nil;
	if( !r )
		r = [OscarSnacHandler new];
	[OscarDetachedFlapInitializer go:self host:host creds:cred
	 snac:r client:cli loop:[NSRunLoop currentRunLoop] fatal:YES];
	return self;
}

- init
{
	[super init];
	gotCookie = NO;
	return self;
}

- (void)handleSignoffFlap:(OscarTlvListIn*)data
{
	static NSString *dict = @"LoginErrors";
	NSBundle *b = [NSBundle bundleForClass:[self class]];
	OscarIncomingSnac *buf;
	NSString *err = @"bos", *msg;
	OscarClient *cli = [self client];
	OscarAuthCookie *cookie;
	NSString *host;

	// Don't display error message when the connection closes.
	gotCookie = YES;

	if( (buf=[data getTLV:0x08]) )
	{
		err = [NSString stringWithFormat:@"%i", [buf readInt16]];
	error:
		msg = [GrouchString getString:err fromDict:dict withBundle:b];
		if( !msg )
			msg = [GrouchString getString:@"?" fromDict:dict
				withBundle:b];
		msg = [msg createUserString:1,err];
		msg = [[GrouchString getString:@"msg" fromDict:dict
			withBundle:b]
			createUserString:1,[msg createUserString:1,err]];
		[[cli getUI] error:msg fatal:YES];
		return;
	}

	if( !(cookie = [OscarAuthCookie cookieFromTLV:data]) )
		goto error;

	if( !(buf=[data getTLV:0x05]) )
		goto error;

	host = [buf readRawString];

	if( !(buf=[data getTLV:0x01]) )
		goto error;

	[cli nick:[buf readRawString]];
	[cli startBos:host withCookie:cookie];
}

- (void)sendingCookie
{
	OscarClient *cli = [self client];
	[[cli getUI] statusMessage:[GrouchString getString:@"oscar-pass"
	 withBundle:[NSBundle bundleForClass:[self class]]]];
}

- (void)connectionClosed:sock
{
	OscarClient *cli = [self client];
	if( !gotCookie )
	{
		NSString *msg = [GrouchString getString:@"conn-closed"];
		[[cli getUI] error:msg fatal:YES];
	}
	[self release];
}

@end
