#!/bin/sh
# Script to build universal binary on Mac OS X.
# Requires:
# - GNUstep make
#   -with the following added to GNUstep/Library/Makefiles/target.make:
#    ifneq ($(sysroot),)
#      INTERNAL_OBJCFLAGS += -isysroot $(sysroot)
#      INTERNAL_CFLAGS += -isysroot $(sysroot)
#      INTERNAL_LDFLAGS += -isysroot $(sysroot)
#    endif
# - 10.3.9 xcode SDK
# - 10.4u xcode SDK
# - A universal binary for Renaissance.framework
#   - if you are too lazy to build this on your own, a universal version of
#     Renaissance is included with the prebuilt binary of Grouch.app
#    - check Grouch.app/Contents/SharedFrameworks/Renaissance.framework
#   -otherwise, build Renaissance twice:
#    - first: make arch=386 sysroot=/Developer/SDKs/MacOSX10.4u.sdk
#    - then:  make arch=ppc sysroot=/Developer/SDKs/MacOSX10.3.9.sdk
#   - then use lipo to make libRenaissance.dylib into a universal binary
#    - see below in merge() for an example of how to do this.
#   - then you need to put Renaissance.framework into a standard frameworks
#     location.

cleanup() {
  rm -rf Grouch.intel Grouch.app tmp
  make clean > /dev/null
  echo Error 1>&2
  exit 1
}
command() {
  make clean > /dev/null
  echo "$@"
  "$@"
}

rm -rf Grouch.app
command make arch=i386 sysroot=/Developer/SDKs/MacOSX10.4u.sdk || cleanup
mv Source/Grouch.app Grouch.intel
command make arch=ppc sysroot=/Developer/SDKs/MacOSX10.3.9.sdk || cleanup
mv Source/Grouch.app .

merge() {
  lipo -create -output tmp -arch i386 "$1" -arch ppc "$2" && mv tmp "$2"
}

for i in Contents/MacOS/Grouch Contents/SharedFrameworks/libGrouchCore.dylib.0 Contents/Resources/Oscar.bundle/Contents/MacOS/Oscar; do
  merge "Grouch.intel/$i" "Grouch.app/$i" || cleanup
done

rm -rf Grouch.intel tmp
make clean > /dev/null

echo Successfully created universal binary at `pwd`/Grouch.app
