/* GSAMBAD, an easy to use GTK+ frontend for the SAMBA file and print server.
 * Copyright (C) 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/



#include <gtk/gtk.h>
#include "../config.h"
#include "support.h"
#include "gettext.h"
#include "widgets.h"



void show_help()
{
  gchar *help_text; 
  GtkWidget *help_window, *vbox15, *scrolledwindow16;
  GtkWidget *help_textview, *close_help_button;
  GtkWidget *alignment19, *hbox52, *image19, *label109;

  help_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (help_window, "help_window");
  gtk_widget_set_size_request (help_window, 650, 350);
  gtk_window_set_title (GTK_WINDOW (help_window), _("GSAMBAD help"));
  gtk_window_set_position (GTK_WINDOW (help_window), GTK_WIN_POS_CENTER);

  vbox15 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox15, "vbox15");
  gtk_widget_show (vbox15);
  gtk_container_add (GTK_CONTAINER (help_window), vbox15);

  scrolledwindow16 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow16, "scrolledwindow16");
  gtk_widget_show (scrolledwindow16);
  gtk_box_pack_start (GTK_BOX (vbox15), scrolledwindow16, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow16), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  help_textview = gtk_text_view_new ();
  gtk_widget_set_name (help_textview, "help_textview");
  gtk_widget_show (help_textview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow16), help_textview);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (help_textview), FALSE);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (help_textview), FALSE);
  gtk_text_view_set_left_margin (GTK_TEXT_VIEW (help_textview), 30);
  gtk_text_view_set_right_margin (GTK_TEXT_VIEW (help_textview), 10);

  help_text = g_strconcat(

  _("\n\nThis helpfile is currently incomplete.\n\n"),


  _("\nServer settings:\n"),
  _("Change the settings according to how you want it and hit apply.\n"),
  

  _("\nUsers:\n"),
  _("Adding a user can be done by specifying its username, group and other settings and then clicking add.\n"),
  _("After one user has been added this user can serve as a profile for other users, select a\n"),
  _("user in the user list and change its username then click add and both will have the same settings.\n\n"),

  _("Deleting a user can be done by selecting its username in the list and then clicking delete.\n"),
  _("The deleted users username will also be deleted from any shared resource.\n\n"),

  _("Changing a users settings is done by changing the settings and clicking apply.\n"),

  _("When you add a user you can randomize its name and password or use your own.\n"),
  _("You can also select its login shell and where this user should have its home directory.\n"),
  _("If the selected shell is /bin/false, /dev/null or /sbin/nologin the user can only login to this\n"),
  _("server, otherwise that user can login via ssh etc if that server allows this user to do so.\n\n"),


  _("Shares:\n"),
  _("Shares can be added by selecting a directory to share, setting its share settings and clicking add.\n"),
  _("Deleting a share is done by selecting the share to delete and clicking delete.\n"),
  _("Changing share settings can be done by changing its settings and then clicking apply.\n\n"),

  _("Adding users to shares:\n"),
  _("Users can be imported to shares in 12 ways using the 3 import buttons, those ways are:\n"),
  _("Local users or groups, remote domain users or groups into 3 different permission classes.\n"),
  _("The user and group importers will only import the users and groups that arent currently in the specified classes.\n\n"),


  _("Setting up a primary domain called example.org:\n"),
  _("Server settings:\n"),
  _("Change workgroup/domain name to example.org\n"),
  _("Change security level to primary domain and hit apply. This domain is now automatically configured.\n"),
  _("Change or add the samba user root with a different password then the root system user.\n\n"),

  _("Setting up other servers for use with the domain:\n"),
  _("BIND:\n"),
  _("Add a new master domain called example.org using gbindadmin.\n"),
  _("Add a DNS server record that points to this server.\n\n"),

  _("DHCPD:\n"),
  _("The clients needs to be able to resolve this domain name so begin with\n"),
  _("setting up dhcpd with gdhcpd, its DNS servers should only point to this server.\n"),
  _("Set the domain name to example.org\n\n"),

  _("Start SAMBA, DHCPD and BIND.\n\n"),

  _("Joining the domain with MSFT'tm(c)(r) (extreme copyright) clients:\n"),
  _("First disconnect all current connections with: net use * /d\n"),

  _("Select properties for \"this computer\" and write example.org in the domain field\n"),
  _("Hit join domain. Use root as username and the samba root password in the dialog.\n\n"),
    
  _("Joining the domain with Linux or other open source clients:\n"),
  _("net rpc join example.org -S samba24 -U root then supply the samba root password\n"),


  _("Mounting shares:\n"),
  _("If you want to add directories thats not under the users root directory you can do this:\n\n"),
  _("Linux (as of kernel 2.4.0):\n"),
  _("mount --bind /some/directory/to/share /home/bob/make_this_directory_first\n\n"),
  _("Alternatively:\nmount -o bind /var/data /home/bob/mounted_data\n\n"),
  _("*BSD (as of 4.4BSD):\nmount_null /var/data /home/bob/mounted_data\n\n"),
  _("Solaris:\nmount -F lofs /var/data /home/bob/mounted_data\n\n"),


  _("Privileges:\n"),
  _("If you copy or move a file directly into the samba servers directory you may need to\n"),
  _("chown, chgrp or chmod it with 644 and chmod directories to 755 so it can be accessed by the users.\n\n"),
  _("This is one way of chmodding all files recursively in the directory /home/samba:\n"),
  _("find /home/samba -type f -exec chmod 644  -v {} \\;\n\n"),
  _("Public upload directories should have a chmod of 777 and this can be used for /home/samba/upload\n"),
  _("find /home/samba/upload -type d -exec chmod 777  -v {} \\;\n\n\n"),

  _("For more detailed information about the server and its configuration directives visit:\n"),
  _("http://www.samba.org\n"), NULL);


  gtk_text_buffer_set_text (gtk_text_view_get_buffer (GTK_TEXT_VIEW (help_textview)), help_text, -1);

  if( help_text!=NULL )
    g_free(help_text);


  close_help_button = gtk_button_new ();
  gtk_widget_set_name (close_help_button, "close_help_button");
  gtk_widget_show (close_help_button);
  gtk_box_pack_start (GTK_BOX (vbox15), close_help_button, FALSE, FALSE, 0);

  alignment19 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment19, "alignment19");
  gtk_widget_show (alignment19);
  gtk_container_add (GTK_CONTAINER (close_help_button), alignment19);

  hbox52 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox52, "hbox52");
  gtk_widget_show (hbox52);
  gtk_container_add (GTK_CONTAINER (alignment19), hbox52);

  image19 = gtk_image_new_from_stock ("gtk-close", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image19, "image19");
  gtk_widget_show (image19);
  gtk_box_pack_start (GTK_BOX (hbox52), image19, FALSE, FALSE, 0);

  label109 = gtk_label_new_with_mnemonic (_("Close"));
  gtk_widget_set_name (label109, "label109");
  gtk_widget_show (label109);
  gtk_box_pack_start (GTK_BOX (hbox52), label109, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label109), GTK_JUSTIFY_LEFT);

  g_signal_connect_swapped(close_help_button, "clicked",
                           G_CALLBACK (gtk_widget_destroy),
                           GTK_OBJECT (help_window));

  gtk_widget_show_all(help_window);
}
